/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity;

import com.destroystokyo.paper.entity.Pathfinder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;

public class PaperPathfinder
implements Pathfinder {
    private EntityInsentient entity;

    public PaperPathfinder(EntityInsentient entity) {
        this.entity = entity;
    }

    public Mob getEntity() {
        return this.entity.getBukkitMob();
    }

    public void setHandle(EntityInsentient entity) {
        this.entity = entity;
    }

    public void stopPathfinding() {
        this.entity.G().n();
    }

    public boolean hasPath() {
        return this.entity.G().j() != null;
    }

    @Nullable
    public Pathfinder.PathResult getCurrentPath() {
        PathEntity path = this.entity.G().j();
        return path != null ? new PaperPathResult(path) : null;
    }

    @Nullable
    public Pathfinder.PathResult findPath(Location loc) {
        Validate.notNull((Object)loc, (String)"Location can not be null");
        PathEntity path = this.entity.G().a(loc.getX(), loc.getY(), loc.getZ(), 0);
        return path != null ? new PaperPathResult(path) : null;
    }

    @Nullable
    public Pathfinder.PathResult findPath(LivingEntity target) {
        Validate.notNull((Object)target, (String)"Target can not be null");
        PathEntity path = this.entity.G().a((Entity)((CraftLivingEntity)target).getHandle(), 0);
        return path != null ? new PaperPathResult(path) : null;
    }

    public boolean moveTo(@Nonnull Pathfinder.PathResult path, double speed) {
        Validate.notNull((Object)path, (String)"PathResult can not be null");
        PathEntity pathEntity = ((PaperPathResult)path).path;
        return this.entity.G().a(pathEntity, speed);
    }

    public boolean canOpenDoors() {
        return this.entity.G().v.d.e();
    }

    public void setCanOpenDoors(boolean canOpenDoors) {
        this.entity.G().v.d.b(canOpenDoors);
    }

    public boolean canPassDoors() {
        return this.entity.G().v.d.d();
    }

    public void setCanPassDoors(boolean canPassDoors) {
        this.entity.G().v.d.a(canPassDoors);
    }

    public boolean canFloat() {
        return this.entity.G().v.d.f();
    }

    public void setCanFloat(boolean canFloat) {
        this.entity.G().v.d.c(canFloat);
    }

    private Location toLoc(PathPoint point) {
        return new Location((World)this.entity.H.getWorld(), (double)point.a, (double)point.b, (double)point.c);
    }

    public class PaperPathResult
    implements Pathfinder.PathResult {
        private final PathEntity path;

        PaperPathResult(PathEntity path) {
            this.path = path;
        }

        @Nullable
        public Location getFinalPoint() {
            PathPoint point = this.path.d();
            return point != null ? PaperPathfinder.this.toLoc(point) : null;
        }

        public List<Location> getPoints() {
            ArrayList<Location> points = new ArrayList<Location>();
            for (PathPoint point : this.path.a) {
                points.add(PaperPathfinder.this.toLoc(point));
            }
            return points;
        }

        public int getNextPointIndex() {
            return this.path.f();
        }

        @Nullable
        public Location getNextPoint() {
            if (!this.path.hasNext()) {
                return null;
            }
            return PaperPathfinder.this.toLoc(this.path.a.get(this.path.f()));
        }
    }
}

