/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.io;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import com.destroystokyo.paper.io.IOUtil;
import com.destroystokyo.paper.io.PrioritizedTaskQueue;
import com.destroystokyo.paper.io.QueueExecutorThread;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.io.RegionFileIOThread;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.chunk.storage.RegionFile;
import org.slf4j.Logger;

@Deprecated(forRemoval=true)
public final class PaperFileIOThread
extends QueueExecutorThread {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final NBTTagCompound FAILURE_VALUE = new NBTTagCompound();
    private final AtomicLong writeCounter = new AtomicLong();

    private PaperFileIOThread() {
        super(new PrioritizedTaskQueue(), 1000000L);
        this.setName("Paper RegionFile IO Thread");
        this.setPriority(4);
        this.setUncaughtExceptionHandler((unused, thr) -> LOGGER.error("Uncaught exception thrown from IO thread, report this!", thr));
    }

    public void bumpPriority(WorldServer world, int chunkX, int chunkZ, int priority) {
        throw new IllegalStateException("Shouldn't get here, use RegionFileIOThread");
    }

    public NBTTagCompound getPendingWrite(WorldServer world, int chunkX, int chunkZ, boolean poiData) {
        return RegionFileIOThread.getPendingWrite(world, chunkX, chunkZ, poiData ? RegionFileIOThread.RegionFileType.POI_DATA : RegionFileIOThread.RegionFileType.CHUNK_DATA);
    }

    public void setPriority(WorldServer world, int chunkX, int chunkZ, int priority) {
        throw new IllegalStateException("Shouldn't get here, use RegionFileIOThread");
    }

    public void scheduleSave(WorldServer world, int chunkX, int chunkZ, NBTTagCompound poiData, NBTTagCompound chunkData, int priority) throws IllegalArgumentException {
        throw new IllegalStateException("Shouldn't get here, use RegionFileIOThread");
    }

    private void scheduleWrite(ChunkDataController dataController, WorldServer world, int chunkX, int chunkZ, NBTTagCompound data, int priority, long writeCounter) {
        throw new IllegalStateException("Shouldn't get here, use RegionFileIOThread");
    }

    public CompletableFuture<ChunkData> loadChunkDataAsyncFuture(WorldServer world, int chunkX, int chunkZ, int priority, boolean readPoiData, boolean readChunkData, boolean intendingToBlock) {
        CompletableFuture<ChunkData> future = new CompletableFuture<ChunkData>();
        this.loadChunkDataAsync(world, chunkX, chunkZ, priority, future::complete, readPoiData, readChunkData, intendingToBlock);
        return future;
    }

    public void loadChunkDataAsync(WorldServer world, int chunkX, int chunkZ, int priority, Consumer<ChunkData> onComplete, boolean readPoiData, boolean readChunkData, boolean intendingToBlock) {
        if (!PrioritizedTaskQueue.validPriority(priority)) {
            throw new IllegalArgumentException("Invalid priority: " + priority);
        }
        if (!(readPoiData | readChunkData)) {
            throw new IllegalArgumentException("Must read chunk data or poi data");
        }
        ChunkData complete = new ChunkData();
        ArrayList<RegionFileIOThread.RegionFileType> types = new ArrayList<RegionFileIOThread.RegionFileType>();
        if (readPoiData) {
            types.add(RegionFileIOThread.RegionFileType.POI_DATA);
        }
        if (readChunkData) {
            types.add(RegionFileIOThread.RegionFileType.CHUNK_DATA);
        }
        PrioritisedExecutor.Priority newPriority = switch (priority) {
            case 0 -> PrioritisedExecutor.Priority.BLOCKING;
            case 1 -> PrioritisedExecutor.Priority.HIGHEST;
            case 2 -> PrioritisedExecutor.Priority.HIGH;
            case 3 -> PrioritisedExecutor.Priority.NORMAL;
            case 4 -> PrioritisedExecutor.Priority.LOW;
            case 5 -> PrioritisedExecutor.Priority.IDLE;
            default -> throw new IllegalStateException("Legacy priority " + priority + " should be valid");
        };
        Consumer<RegionFileIOThread.RegionFileData> transformComplete = data -> {
            if (readPoiData) {
                complete.poiData = data.getThrowable(RegionFileIOThread.RegionFileType.POI_DATA) != null ? FAILURE_VALUE : data.getData(RegionFileIOThread.RegionFileType.POI_DATA);
            }
            if (readChunkData) {
                complete.chunkData = data.getThrowable(RegionFileIOThread.RegionFileType.CHUNK_DATA) != null ? FAILURE_VALUE : data.getData(RegionFileIOThread.RegionFileType.CHUNK_DATA);
            }
            onComplete.accept(complete);
        };
        RegionFileIOThread.loadChunkData(world, chunkX, chunkZ, transformComplete, intendingToBlock, newPriority, types.toArray(new RegionFileIOThread.RegionFileType[0]));
    }

    private void scheduleRead(ChunkDataController dataController, WorldServer world, int chunkX, int chunkZ, Consumer<NBTTagCompound> onComplete, int priority, boolean intendingToBlock) {
        throw new IllegalStateException("Shouldn't get here, use RegionFileIOThread");
    }

    public ChunkData loadChunkData(WorldServer world, int chunkX, int chunkZ, int priority, boolean readPoiData, boolean readChunkData) {
        return this.loadChunkDataAsyncFuture(world, chunkX, chunkZ, priority, readPoiData, readChunkData, true).join();
    }

    public void runTask(int priority, Runnable runnable) {
        throw new IllegalStateException("Shouldn't get here, use RegionFileIOThread");
    }

    public static final class ChunkData {
        public NBTTagCompound poiData;
        public NBTTagCompound chunkData;

        public ChunkData() {
        }

        public ChunkData(NBTTagCompound poiData, NBTTagCompound chunkData) {
            this.poiData = poiData;
            this.chunkData = chunkData;
        }
    }

    public static final class ChunkDataTask
    extends PrioritizedTaskQueue.PrioritizedTask
    implements Runnable {
        public ChunkDataController.InProgressWrite inProgressWrite;
        public ChunkDataController.InProgressRead inProgressRead;
        private final WorldServer world;
        private final int x;
        private final int z;
        private final ChunkDataController taskController;

        public ChunkDataTask(int priority, WorldServer world, int x2, int z2, ChunkDataController taskController) {
            super(priority);
            this.world = world;
            this.x = x2;
            this.z = z2;
            this.taskController = taskController;
        }

        public String toString() {
            return "Task for world: '" + this.world.getWorld().getName() + "' at " + this.x + "," + this.z + " poi: " + (this.taskController == null) + ", hash: " + this.hashCode();
        }

        void reschedule(int priority) {
            this.queue.lazySet(null);
            this.priority.lazySet(priority);
            Holder.INSTANCE.queueTask(this);
        }

        @Override
        public void run() {
            throw new IllegalStateException("Shouldn't get here, use RegionFileIOThread");
        }

        private /* synthetic */ ChunkDataTask lambda$run$1(long writeCounter, boolean finalFailWrite, Long keyInMap, ChunkDataTask valueInMap) {
            if (valueInMap == null) {
                throw new IllegalStateException("Write completed concurrently, expected this task: " + this.toString() + ", report this!");
            }
            if (valueInMap != this) {
                throw new IllegalStateException("Chunk task mismatch, expected this task: " + this.toString() + ", got: " + valueInMap.toString() + ", report this!");
            }
            if (valueInMap.inProgressWrite.writeCounter == writeCounter) {
                if (finalFailWrite) {
                    valueInMap.inProgressWrite.writeCounter = -1L;
                }
                return null;
            }
            return valueInMap;
        }

        private /* synthetic */ ChunkDataTask lambda$run$0(Long keyInMap, ChunkDataTask valueInMap) {
            if (valueInMap == null) {
                throw new IllegalStateException("Write completed concurrently, expected this task: " + this.toString() + ", report this!");
            }
            if (valueInMap != this) {
                throw new IllegalStateException("Chunk task mismatch, expected this task: " + this.toString() + ", got: " + valueInMap.toString() + ", report this!");
            }
            return valueInMap.inProgressWrite == null ? null : valueInMap;
        }
    }

    public static abstract class ChunkDataController {
        public final ConcurrentHashMap<Long, ChunkDataTask> tasks = new ConcurrentHashMap(64, 0.5f);

        public abstract void writeData(int var1, int var2, NBTTagCompound var3) throws IOException;

        public abstract NBTTagCompound readData(int var1, int var2) throws IOException;

        public abstract <T> T computeForRegionFile(int var1, int var2, Function<RegionFile, T> var3);

        public abstract <T> T computeForRegionFileIfLoaded(int var1, int var2, Function<RegionFile, T> var3);

        public static final class InProgressRead {
            public final CompletableFuture<NBTTagCompound> readFuture = new CompletableFuture();
        }

        public static final class InProgressWrite {
            public long writeCounter;
            public NBTTagCompound data;
        }
    }

    static final class GeneralTask
    extends PrioritizedTaskQueue.PrioritizedTask
    implements Runnable {
        private final Runnable run;

        public GeneralTask(int priority, Runnable run) {
            super(priority);
            this.run = IOUtil.notNull(run, "Task may not be null");
        }

        @Override
        public void run() {
            try {
                this.run.run();
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                LOGGER.error("Failed to execute general task on IO thread " + IOUtil.genericToString(this.run), throwable);
            }
        }
    }

    public static final class Holder {
        public static final PaperFileIOThread INSTANCE = new PaperFileIOThread();
    }
}

