/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk.system.entity;

import com.destroystokyo.paper.util.maplist.EntityList;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.ChunkSystem;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.WorldUtil;
import io.papermc.paper.world.ChunkEntitySlices;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.Visibility;
import net.minecraft.world.phys.AxisAlignedBB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class EntityLookup
implements LevelEntityGetter<Entity> {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    protected static final int REGION_SHIFT = 5;
    protected static final int REGION_MASK = 31;
    protected static final int REGION_SIZE = 32;
    public final WorldServer world;
    private final StampedLock stateLock = new StampedLock();
    protected final Long2ObjectOpenHashMap<ChunkSlicesRegion> regions = new Long2ObjectOpenHashMap(128, 0.5f);
    private final int minSection;
    private final int maxSection;
    private final LevelCallback<Entity> worldCallback;
    private final StampedLock entityByLock = new StampedLock();
    private final Int2ReferenceOpenHashMap<Entity> entityById = new Int2ReferenceOpenHashMap();
    private final Object2ReferenceOpenHashMap<UUID, Entity> entityByUUID = new Object2ReferenceOpenHashMap();
    private final EntityList accessibleEntities = new EntityList();

    public EntityLookup(WorldServer world, LevelCallback<Entity> worldCallback) {
        this.world = world;
        this.minSection = WorldUtil.getMinSection(world);
        this.maxSection = WorldUtil.getMaxSection(world);
        this.worldCallback = worldCallback;
    }

    private static Entity maskNonAccessible(Entity entity) {
        if (entity == null) {
            return null;
        }
        Visibility visibility = EntityLookup.getEntityStatus(entity);
        return visibility.b() ? entity : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Entity get(int id) {
        long attempt = this.entityByLock.tryOptimisticRead();
        if (attempt != 0L) {
            try {
                Entity ret = (Entity)this.entityById.get(id);
                if (this.entityByLock.validate(attempt)) {
                    return EntityLookup.maskNonAccessible(ret);
                }
            }
            catch (Error error) {
                throw error;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.entityByLock.readLock();
        try {
            Entity entity = EntityLookup.maskNonAccessible((Entity)this.entityById.get(id));
            return entity;
        }
        finally {
            this.entityByLock.tryUnlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Entity get(UUID id) {
        long attempt = this.entityByLock.tryOptimisticRead();
        if (attempt != 0L) {
            try {
                Entity ret = (Entity)this.entityByUUID.get((Object)id);
                if (this.entityByLock.validate(attempt)) {
                    return EntityLookup.maskNonAccessible(ret);
                }
            }
            catch (Error error) {
                throw error;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.entityByLock.readLock();
        try {
            Entity entity = EntityLookup.maskNonAccessible((Entity)this.entityByUUID.get((Object)id));
            return entity;
        }
        finally {
            this.entityByLock.tryUnlockRead();
        }
    }

    public boolean hasEntity(UUID uuid) {
        return this.get(uuid) != null;
    }

    public String getDebugInfo() {
        return "count_id:" + this.entityById.size() + ",count_uuid:" + this.entityByUUID.size() + ",region_count:" + this.regions.size();
    }

    @Override
    public Iterable<Entity> a() {
        return new ArrayIterable<Entity>(this.accessibleEntities.getRawData(), 0, this.accessibleEntities.size());
    }

    @Override
    public <U extends Entity> void a(EntityTypeTest<Entity, U> filter, AbortableIterationConsumer<U> action) {
        Entity casted;
        Entity entity;
        Visibility visibility;
        ObjectIterator objectIterator = this.entityById.values().iterator();
        while (!(!objectIterator.hasNext() || (visibility = EntityLookup.getEntityStatus(entity = (Entity)objectIterator.next())).b() && (casted = (Entity)filter.a(entity)) != null && action.accept(casted).a())) {
        }
    }

    @Override
    public void a(AxisAlignedBB box, Consumer<Entity> action) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        this.getEntitiesWithoutDragonParts(null, box, entities, null);
        int len = entities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            action.accept((Entity)entities.get(i2));
        }
    }

    @Override
    public <U extends Entity> void a(EntityTypeTest<Entity, U> filter, AxisAlignedBB box, AbortableIterationConsumer<U> action) {
        Entity casted;
        ArrayList<Entity> entities = new ArrayList<Entity>();
        this.getEntitiesWithoutDragonParts(null, box, entities, null);
        int len = entities.size();
        for (int i2 = 0; !(i2 >= len || (casted = (Entity)filter.a((Entity)entities.get(i2))) != null && action.accept(casted).a()); ++i2) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityStatusChange(Entity entity, ChunkEntitySlices slices, Visibility oldVisibility, Visibility newVisibility, boolean moved, boolean created, boolean destroyed) {
        boolean entityStatusUpdateBefore;
        TickThread.ensureTickThread(entity, "Entity status change must only happen on the main thread");
        if (entity.updatingSectionStatus) {
            LOGGER.error("Cannot recursively update entity chunk status for entity " + entity, new Throwable());
            return;
        }
        boolean bl = entityStatusUpdateBefore = slices == null ? false : slices.startPreventingStatusUpdates();
        if (entityStatusUpdateBefore) {
            LOGGER.error("Cannot update chunk status for entity " + entity + " since entity chunk (" + slices.chunkX + "," + slices.chunkZ + ") is receiving update", new Throwable());
            return;
        }
        try {
            Boolean ticketBlockBefore = this.world.chunkTaskScheduler.chunkHolderManager.blockTicketUpdates();
            try {
                entity.updatingSectionStatus = true;
                try {
                    if (created) {
                        this.worldCallback.g(entity);
                    }
                    if (oldVisibility == newVisibility) {
                        if (moved && newVisibility.b()) {
                            this.worldCallback.a(entity);
                        }
                        return;
                    }
                    if (newVisibility.ordinal() > oldVisibility.ordinal()) {
                        if (!oldVisibility.b() && newVisibility.b()) {
                            this.accessibleEntities.add(entity);
                            this.worldCallback.c(entity);
                        }
                        if (!oldVisibility.a() && newVisibility.a()) {
                            this.worldCallback.e(entity);
                        }
                    } else {
                        if (oldVisibility.a() && !newVisibility.a()) {
                            this.worldCallback.d(entity);
                        }
                        if (oldVisibility.b() && !newVisibility.b()) {
                            this.accessibleEntities.remove(entity);
                            this.worldCallback.b(entity);
                        }
                    }
                    if (moved && newVisibility.b()) {
                        this.worldCallback.a(entity);
                    }
                    if (destroyed) {
                        this.worldCallback.f(entity);
                    }
                }
                finally {
                    entity.updatingSectionStatus = false;
                }
            }
            finally {
                this.world.chunkTaskScheduler.chunkHolderManager.unblockTicketUpdates(ticketBlockBefore);
            }
        }
        finally {
            if (slices != null) {
                slices.stopPreventingStatusUpdates(false);
            }
        }
    }

    public void chunkStatusChange(int x2, int z2, PlayerChunk.State newStatus) {
        this.getChunk(x2, z2).updateStatus(newStatus, this);
    }

    public void addLegacyChunkEntities(List<Entity> entities) {
        int len = entities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            this.addEntity(entities.get(i2), true);
        }
    }

    public void addEntityChunkEntities(List<Entity> entities) {
        int len = entities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            this.addEntity(entities.get(i2), true);
        }
    }

    public void addWorldGenChunkEntities(List<Entity> entities) {
        int len = entities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            this.addEntity(entities.get(i2), false);
        }
    }

    public boolean addNewEntity(Entity entity) {
        return this.addEntity(entity, false);
    }

    public static Visibility getEntityStatus(Entity entity) {
        if (entity.dF()) {
            return Visibility.c;
        }
        PlayerChunk.State entityStatus = entity.chunkStatus;
        return Visibility.a(entityStatus == null ? PlayerChunk.State.a : entityStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addEntity(Entity entity, boolean fromDisk) {
        BlockPosition pos = entity.dg();
        int sectionX = pos.u() >> 4;
        int sectionY = MathHelper.a(pos.v() >> 4, this.minSection, this.maxSection);
        int sectionZ = pos.w() >> 4;
        TickThread.ensureTickThread(this.world, sectionX, sectionZ, "Cannot add entity off-main thread");
        if (entity.dB()) {
            LOGGER.warn("Refusing to add removed entity: " + entity);
            return false;
        }
        if (entity.updatingSectionStatus) {
            LOGGER.warn("Entity " + entity + " is currently prevented from being added/removed to world since it is processing section status updates", new Throwable());
            return false;
        }
        if (fromDisk) {
            ChunkSystem.onEntityPreAdd(this.world, entity);
            if (entity.dB()) {
                return false;
            }
        }
        this.entityByLock.writeLock();
        try {
            if (this.entityById.containsKey(entity.af())) {
                LOGGER.warn("Entity id already exists: " + entity.af() + ", mapped to " + this.entityById.get(entity.af()) + ", can't add " + entity);
                boolean bl = false;
                return bl;
            }
            if (this.entityByUUID.containsKey((Object)entity.cs())) {
                LOGGER.warn("Entity uuid already exists: " + entity.cs() + ", mapped to " + this.entityByUUID.get((Object)entity.cs()) + ", can't add " + entity);
                boolean bl = false;
                return bl;
            }
            this.entityById.put(entity.af(), (Object)entity);
            this.entityByUUID.put((Object)entity.cs(), (Object)entity);
        }
        finally {
            this.entityByLock.tryUnlockWrite();
        }
        entity.sectionX = sectionX;
        entity.sectionY = sectionY;
        entity.sectionZ = sectionZ;
        ChunkEntitySlices slices = this.getOrCreateChunk(sectionX, sectionZ);
        if (!slices.addEntity(entity, sectionY)) {
            LOGGER.warn("Entity " + entity + " added to world '" + this.world.getWorld().getName() + "', but was already contained in entity chunk (" + sectionX + "," + sectionZ + ")");
        }
        entity.a(new EntityCallback(entity));
        this.entityStatusChange(entity, slices, Visibility.a, EntityLookup.getEntityStatus(entity), false, !fromDisk, false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntity(Entity entity) {
        int sectionX = entity.sectionX;
        int sectionY = entity.sectionY;
        int sectionZ = entity.sectionZ;
        TickThread.ensureTickThread(this.world, sectionX, sectionZ, "Cannot remove entity off-main");
        if (!entity.dB()) {
            throw new IllegalStateException("Only call Entity#setRemoved to remove an entity");
        }
        ChunkEntitySlices slices = this.getChunk(sectionX, sectionZ);
        if (slices == null) {
            LOGGER.warn("Cannot remove entity " + entity + " from null entity slices (" + sectionX + "," + sectionZ + ")");
        } else if (!slices.removeEntity(entity, sectionY)) {
            LOGGER.warn("Failed to remove entity " + entity + " from entity slices (" + sectionX + "," + sectionZ + ")");
        }
        entity.sectionZ = Integer.MIN_VALUE;
        entity.sectionY = Integer.MIN_VALUE;
        entity.sectionX = Integer.MIN_VALUE;
        this.entityByLock.writeLock();
        try {
            if (!this.entityById.remove(entity.af(), (Object)entity)) {
                LOGGER.warn("Failed to remove entity " + entity + " by id, current entity mapped: " + this.entityById.get(entity.af()));
            }
            if (!this.entityByUUID.remove((Object)entity.cs(), (Object)entity)) {
                LOGGER.warn("Failed to remove entity " + entity + " by uuid, current entity mapped: " + this.entityByUUID.get((Object)entity.cs()));
            }
        }
        finally {
            this.entityByLock.tryUnlockWrite();
        }
    }

    private ChunkEntitySlices moveEntity(Entity entity) {
        TickThread.ensureTickThread(entity, "Cannot move entity off-main");
        BlockPosition newPos = entity.dg();
        int newSectionX = newPos.u() >> 4;
        int newSectionY = MathHelper.a(newPos.v() >> 4, this.minSection, this.maxSection);
        int newSectionZ = newPos.w() >> 4;
        if (newSectionX == entity.sectionX && newSectionY == entity.sectionY && newSectionZ == entity.sectionZ) {
            return null;
        }
        TickThread.ensureTickThread(this.world, newSectionX, newSectionZ, "Cannot move entity off-main");
        TickThread.ensureTickThread(this.world, entity.sectionX, entity.sectionZ, "Cannot move entity off-main");
        ChunkEntitySlices old = this.getChunk(entity.sectionX, entity.sectionZ);
        ChunkEntitySlices slices = this.getOrCreateChunk(newSectionX, newSectionZ);
        if (!old.removeEntity(entity, entity.sectionY)) {
            LOGGER.warn("Could not remove entity " + entity + " from its old chunk section (" + entity.sectionX + "," + entity.sectionY + "," + entity.sectionZ + ") since it was not contained in the section");
        }
        if (!slices.addEntity(entity, newSectionY)) {
            LOGGER.warn("Could not add entity " + entity + " to its new chunk section (" + newSectionX + "," + newSectionY + "," + newSectionZ + ") as it is already contained in the section");
        }
        entity.sectionX = newSectionX;
        entity.sectionY = newSectionY;
        entity.sectionZ = newSectionZ;
        return slices;
    }

    public void getEntitiesWithoutDragonParts(Entity except, AxisAlignedBB box, List<Entity> into, Predicate<? super Entity> predicate) {
        int minChunkX = MathHelper.a(box.a) - 2 >> 4;
        int minChunkZ = MathHelper.a(box.c) - 2 >> 4;
        int maxChunkX = MathHelper.a(box.d) + 2 >> 4;
        int maxChunkZ = MathHelper.a(box.f) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.a(PlayerChunk.State.b)) continue;
                        chunk.getEntitiesWithoutDragonParts(except, box, into, predicate);
                    }
                }
            }
        }
    }

    public void getEntities(Entity except, AxisAlignedBB box, List<Entity> into, Predicate<? super Entity> predicate) {
        int minChunkX = MathHelper.a(box.a) - 2 >> 4;
        int minChunkZ = MathHelper.a(box.c) - 2 >> 4;
        int maxChunkX = MathHelper.a(box.d) + 2 >> 4;
        int maxChunkZ = MathHelper.a(box.f) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.a(PlayerChunk.State.b)) continue;
                        chunk.getEntities(except, box, into, predicate);
                    }
                }
            }
        }
    }

    public void getHardCollidingEntities(Entity except, AxisAlignedBB box, List<Entity> into, Predicate<? super Entity> predicate) {
        int minChunkX = MathHelper.a(box.a) - 2 >> 4;
        int minChunkZ = MathHelper.a(box.c) - 2 >> 4;
        int maxChunkX = MathHelper.a(box.d) + 2 >> 4;
        int maxChunkZ = MathHelper.a(box.f) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.a(PlayerChunk.State.b)) continue;
                        chunk.getHardCollidingEntities(except, box, into, predicate);
                    }
                }
            }
        }
    }

    public <T extends Entity> void getEntities(EntityTypes<?> type, AxisAlignedBB box, List<? super T> into, Predicate<? super T> predicate) {
        int minChunkX = MathHelper.a(box.a) - 2 >> 4;
        int minChunkZ = MathHelper.a(box.c) - 2 >> 4;
        int maxChunkX = MathHelper.a(box.d) + 2 >> 4;
        int maxChunkZ = MathHelper.a(box.f) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.a(PlayerChunk.State.b)) continue;
                        chunk.getEntities(type, box, into, predicate);
                    }
                }
            }
        }
    }

    public <T extends Entity> void getEntities(Class<? extends T> clazz, Entity except, AxisAlignedBB box, List<? super T> into, Predicate<? super T> predicate) {
        int minChunkX = MathHelper.a(box.a) - 2 >> 4;
        int minChunkZ = MathHelper.a(box.c) - 2 >> 4;
        int maxChunkX = MathHelper.a(box.d) + 2 >> 4;
        int maxChunkZ = MathHelper.a(box.f) + 2 >> 4;
        int minRegionX = minChunkX >> 5;
        int minRegionZ = minChunkZ >> 5;
        int maxRegionX = maxChunkX >> 5;
        int maxRegionZ = maxChunkZ >> 5;
        for (int currRegionZ = minRegionZ; currRegionZ <= maxRegionZ; ++currRegionZ) {
            int minZ = currRegionZ == minRegionZ ? minChunkZ & 0x1F : 0;
            int maxZ = currRegionZ == maxRegionZ ? maxChunkZ & 0x1F : 31;
            for (int currRegionX = minRegionX; currRegionX <= maxRegionX; ++currRegionX) {
                ChunkSlicesRegion region = this.getRegion(currRegionX, currRegionZ);
                if (region == null) continue;
                int minX = currRegionX == minRegionX ? minChunkX & 0x1F : 0;
                int maxX = currRegionX == maxRegionX ? maxChunkX & 0x1F : 31;
                for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                    for (int currX = minX; currX <= maxX; ++currX) {
                        ChunkEntitySlices chunk = region.get(currX | currZ << 5);
                        if (chunk == null || !chunk.status.a(PlayerChunk.State.b)) continue;
                        chunk.getEntities(clazz, except, box, into, predicate);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entitySectionLoad(int chunkX, int chunkZ, ChunkEntitySlices slices) {
        TickThread.ensureTickThread(this.world, chunkX, chunkZ, "Cannot load in entity section off-main");
        EntityLookup entityLookup = this;
        synchronized (entityLookup) {
            ChunkEntitySlices curr = this.getChunk(chunkX, chunkZ);
            if (curr != null) {
                this.removeChunk(chunkX, chunkZ);
                curr.mergeInto(slices);
                this.addChunk(chunkX, chunkZ, slices);
            } else {
                this.addChunk(chunkX, chunkZ, slices);
            }
        }
    }

    public void entitySectionUnload(int chunkX, int chunkZ) {
        TickThread.ensureTickThread(this.world, chunkX, chunkZ, "Cannot unload entity section off-main");
        this.removeChunk(chunkX, chunkZ);
    }

    public ChunkEntitySlices getChunk(int chunkX, int chunkZ) {
        ChunkSlicesRegion region = this.getRegion(chunkX >> 5, chunkZ >> 5);
        if (region == null) {
            return null;
        }
        return region.get(chunkX & 0x1F | (chunkZ & 0x1F) << 5);
    }

    public ChunkEntitySlices getOrCreateChunk(int chunkX, int chunkZ) {
        ChunkEntitySlices ret;
        ChunkSlicesRegion region = this.getRegion(chunkX >> 5, chunkZ >> 5);
        if (region == null || (ret = region.get(chunkX & 0x1F | (chunkZ & 0x1F) << 5)) == null) {
            return this.world.chunkTaskScheduler.chunkHolderManager.getOrCreateEntityChunk(chunkX, chunkZ, true);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkSlicesRegion getRegion(int regionX, int regionZ) {
        long key = CoordinateUtils.getChunkKey(regionX, regionZ);
        long attempt = this.stateLock.tryOptimisticRead();
        if (attempt != 0L) {
            try {
                ChunkSlicesRegion ret = (ChunkSlicesRegion)this.regions.get(key);
                if (this.stateLock.validate(attempt)) {
                    return ret;
                }
            }
            catch (Error error) {
                throw error;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.stateLock.readLock();
        try {
            ChunkSlicesRegion chunkSlicesRegion = (ChunkSlicesRegion)this.regions.get(key);
            return chunkSlicesRegion;
        }
        finally {
            this.stateLock.tryUnlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeChunk(int chunkX, int chunkZ) {
        long key = CoordinateUtils.getChunkKey(chunkX >> 5, chunkZ >> 5);
        int relIndex = chunkX & 0x1F | (chunkZ & 0x1F) << 5;
        ChunkSlicesRegion region = (ChunkSlicesRegion)this.regions.get(key);
        int remaining = region.remove(relIndex);
        if (remaining == 0) {
            this.stateLock.writeLock();
            try {
                this.regions.remove(key);
            }
            finally {
                this.stateLock.tryUnlockWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addChunk(int chunkX, int chunkZ, ChunkEntitySlices slices) {
        long key = CoordinateUtils.getChunkKey(chunkX >> 5, chunkZ >> 5);
        int relIndex = chunkX & 0x1F | (chunkZ & 0x1F) << 5;
        ChunkSlicesRegion region = (ChunkSlicesRegion)this.regions.get(key);
        if (region != null) {
            region.add(relIndex, slices);
        } else {
            region = new ChunkSlicesRegion();
            region.add(relIndex, slices);
            this.stateLock.writeLock();
            try {
                this.regions.put(key, (Object)region);
            }
            finally {
                this.stateLock.tryUnlockWrite();
            }
        }
    }

    static final class ArrayIterable<T>
    implements Iterable<T> {
        private final T[] array;
        private final int off;
        private final int length;

        public ArrayIterable(T[] array, int off, int length) {
            this.array = array;
            this.off = off;
            this.length = length;
            if (length > array.length) {
                throw new IllegalArgumentException("Length must be no greater-than the array length");
            }
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new ArrayIterator<T>(this.array, this.off, this.length);
        }

        static final class ArrayIterator<T>
        implements Iterator<T> {
            private final T[] array;
            private int off;
            private final int length;

            public ArrayIterator(T[] array, int off, int length) {
                this.array = array;
                this.off = off;
                this.length = length;
            }

            @Override
            public boolean hasNext() {
                return this.off < this.length;
            }

            @Override
            public T next() {
                if (this.off >= this.length) {
                    throw new NoSuchElementException();
                }
                return this.array[this.off++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private final class EntityCallback
    implements EntityInLevelCallback {
        public final Entity entity;

        public EntityCallback(Entity entity) {
            this.entity = entity;
        }

        @Override
        public void a() {
            Entity entity = this.entity;
            Visibility oldVisibility = EntityLookup.getEntityStatus(entity);
            ChunkEntitySlices newSlices = EntityLookup.this.moveEntity(this.entity);
            if (newSlices == null) {
                return;
            }
            Visibility newVisibility = EntityLookup.getEntityStatus(entity);
            EntityLookup.this.entityStatusChange(entity, newSlices, oldVisibility, newVisibility, true, false, false);
        }

        @Override
        public void a(Entity.RemovalReason reason) {
            Entity entity = this.entity;
            TickThread.ensureTickThread(entity, "Cannot remove entity off-main");
            Visibility tickingState = EntityLookup.getEntityStatus(entity);
            EntityLookup.this.removeEntity(entity);
            EntityLookup.this.entityStatusChange(entity, null, tickingState, Visibility.a, false, false, reason.a());
            this.entity.a(NoOpCallback.INSTANCE);
        }
    }

    public static final class ChunkSlicesRegion {
        protected final ChunkEntitySlices[] slices = new ChunkEntitySlices[1024];
        protected int sliceCount;

        public ChunkEntitySlices get(int index) {
            return this.slices[index];
        }

        public int remove(int index) {
            ChunkEntitySlices slices = this.slices[index];
            if (slices == null) {
                throw new IllegalStateException();
            }
            this.slices[index] = null;
            return --this.sliceCount;
        }

        public void add(int index, ChunkEntitySlices slices) {
            ChunkEntitySlices curr = this.slices[index];
            if (curr != null) {
                throw new IllegalStateException();
            }
            this.slices[index] = slices;
            ++this.sliceCount;
        }
    }

    private static final class NoOpCallback
    implements EntityInLevelCallback {
        public static final NoOpCallback INSTANCE = new NoOpCallback();

        private NoOpCallback() {
        }

        @Override
        public void a() {
        }

        @Override
        public void a(Entity.RemovalReason reason) {
        }
    }
}

