/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk.system.scheduling;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.map.SWMRLong2ObjectHashTable;
import co.aikar.timings.MinecraftTimings;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.ChunkSystem;
import io.papermc.paper.chunk.system.io.RegionFileIOThread;
import io.papermc.paper.chunk.system.poi.PoiChunk;
import io.papermc.paper.chunk.system.scheduling.ChunkLoadTask;
import io.papermc.paper.chunk.system.scheduling.ChunkProgressionTask;
import io.papermc.paper.chunk.system.scheduling.ChunkTaskScheduler;
import io.papermc.paper.chunk.system.scheduling.NewChunkHolder;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.misc.Delayed8WayDistancePropagator2D;
import io.papermc.paper.world.ChunkEntitySlices;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ArraySetSorted;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.bukkit.plugin.Plugin;
import org.slf4j.Logger;

public final class ChunkHolderManager {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    public static final int FULL_LOADED_TICKET_LEVEL = 33;
    public static final int BLOCK_TICKING_TICKET_LEVEL = 32;
    public static final int ENTITY_TICKING_TICKET_LEVEL = 31;
    public static final int MAX_TICKET_LEVEL = PlayerChunkMap.b;
    private static final long NO_TIMEOUT_MARKER = -1L;
    final ReentrantLock ticketLock = new ReentrantLock();
    private final SWMRLong2ObjectHashTable<NewChunkHolder> chunkHolders = new SWMRLong2ObjectHashTable(16384, 0.25f);
    private final Long2ObjectOpenHashMap<ArraySetSorted<Ticket<?>>> tickets = new Long2ObjectOpenHashMap(8192, 0.25f);
    private final Long2ObjectOpenHashMap<Long2IntOpenHashMap> removeTickToChunkExpireTicketCount = new Long2ObjectOpenHashMap();
    private final WorldServer world;
    private final ChunkTaskScheduler taskScheduler;
    private long currentTick;
    private final ArrayDeque<NewChunkHolder> pendingFullLoadUpdate = new ArrayDeque();
    private final ObjectRBTreeSet<NewChunkHolder> autoSaveQueue = new ObjectRBTreeSet((c1, c2) -> {
        long coord2;
        if (c1 == c2) {
            return 0;
        }
        int saveTickCompare = Long.compare(c1.lastAutoSave, c2.lastAutoSave);
        if (saveTickCompare != 0) {
            return saveTickCompare;
        }
        long coord1 = CoordinateUtils.getChunkKey(c1.chunkX, c1.chunkZ);
        if (coord1 == (coord2 = CoordinateUtils.getChunkKey(c2.chunkX, c2.chunkZ))) {
            throw new IllegalStateException("Duplicate chunkholder in auto save queue");
        }
        return Long.compare(coord1, coord2);
    });
    private long statusUpgradeId;
    protected final Long2IntLinkedOpenHashMap ticketLevelUpdates = new Long2IntLinkedOpenHashMap(){

        protected void rehash(int newN) {
            if (newN < this.n) {
                return;
            }
            super.rehash(newN);
        }
    };
    protected final Delayed8WayDistancePropagator2D ticketLevelPropagator = new Delayed8WayDistancePropagator2D((coordinate, oldLevel, newLevel) -> this.ticketLevelUpdates.putAndMoveToLast(coordinate, ChunkHolderManager.convertBetweenTicketLevels(newLevel)));
    private long entityLoadCounter;
    private long poiLoadCounter;
    final ReferenceLinkedOpenHashSet<NewChunkHolder> unloadQueue = new ReferenceLinkedOpenHashSet();
    private final ThreadLocal<Boolean> BLOCK_TICKET_UPDATES = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final ThreadLocal<List<ChunkProgressionTask>> CURRENT_TICKET_UPDATE_SCHEDULING = new ThreadLocal();

    public ChunkHolderManager(WorldServer world, ChunkTaskScheduler taskScheduler) {
        this.world = world;
        this.taskScheduler = taskScheduler;
    }

    long getNextStatusUpgradeId() {
        return ++this.statusUpgradeId;
    }

    public List<PlayerChunk> getOldChunkHolders() {
        List<NewChunkHolder> holders = this.getChunkHolders();
        ArrayList<PlayerChunk> ret = new ArrayList<PlayerChunk>(holders.size());
        for (NewChunkHolder holder : holders) {
            ret.add(holder.vanillaChunkHolder);
        }
        return ret;
    }

    public List<NewChunkHolder> getChunkHolders() {
        ArrayList<NewChunkHolder> ret = new ArrayList<NewChunkHolder>(this.chunkHolders.size());
        this.chunkHolders.forEachValue(ret::add);
        return ret;
    }

    public int size() {
        return this.chunkHolders.size();
    }

    public void close(boolean save, boolean halt) {
        TickThread.ensureTickThread("Closing world off-main");
        if (halt) {
            LOGGER.info("Waiting 60s for chunk system to halt for world '" + this.world.getWorld().getName() + "'");
            if (!this.taskScheduler.halt(true, TimeUnit.SECONDS.toNanos(60L))) {
                LOGGER.warn("Failed to halt world generation/loading tasks for world '" + this.world.getWorld().getName() + "'");
            } else {
                LOGGER.info("Halted chunk system for world '" + this.world.getWorld().getName() + "'");
            }
        }
        if (save) {
            this.saveAllChunks(true, true, true);
        }
        if (this.world.chunkDataControllerNew.hasTasks() || this.world.entityDataControllerNew.hasTasks() || this.world.poiDataControllerNew.hasTasks()) {
            RegionFileIOThread.flush();
        }
        try {
            this.world.chunkDataControllerNew.getCache().close();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to close chunk regionfile cache for world '" + this.world.getWorld().getName() + "'", (Throwable)ex);
        }
        try {
            this.world.entityDataControllerNew.getCache().close();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to close entity regionfile cache for world '" + this.world.getWorld().getName() + "'", (Throwable)ex);
        }
        try {
            this.world.poiDataControllerNew.getCache().close();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to close poi regionfile cache for world '" + this.world.getWorld().getName() + "'", (Throwable)ex);
        }
    }

    void ensureInAutosave(NewChunkHolder holder) {
        if (!this.autoSaveQueue.contains((Object)holder)) {
            holder.lastAutoSave = MinecraftServer.currentTick;
            this.autoSaveQueue.add((Object)holder);
        }
    }

    public void autoSave() {
        ArrayList<NewChunkHolder> reschedule = new ArrayList<NewChunkHolder>();
        long currentTick = MinecraftServer.currentTickLong;
        long maxSaveTime = currentTick - (long)this.world.paperConfig().chunks.autoSaveInterval.value();
        int autoSaved = 0;
        while (autoSaved < this.world.paperConfig().chunks.maxAutoSaveChunksPerTick && !this.autoSaveQueue.isEmpty()) {
            NewChunkHolder holder = (NewChunkHolder)this.autoSaveQueue.first();
            if (holder.lastAutoSave > maxSaveTime) break;
            this.autoSaveQueue.remove((Object)holder);
            holder.lastAutoSave = currentTick;
            if (holder.save(false, false) != null) {
                ++autoSaved;
            }
            if (!holder.getChunkStatus().a(PlayerChunk.State.b)) continue;
            reschedule.add(holder);
        }
        for (NewChunkHolder holder : reschedule) {
            if (!holder.getChunkStatus().a(PlayerChunk.State.b)) continue;
            this.autoSaveQueue.add((Object)holder);
        }
    }

    public void saveAllChunks(boolean flush, boolean shutdown, boolean logProgress) {
        long start;
        List<NewChunkHolder> holders = this.getChunkHolders();
        if (logProgress) {
            LOGGER.info("Saving all chunkholders for world '" + this.world.getWorld().getName() + "'");
        }
        DecimalFormat format = new DecimalFormat("#0.00");
        int saved = 0;
        long lastLog = start = System.nanoTime();
        boolean needsFlush = false;
        int flushInterval = 50;
        int savedChunk = 0;
        int savedEntity = 0;
        int savedPoi = 0;
        int len = holders.size();
        for (int i2 = 0; i2 < len; ++i2) {
            long currTime;
            NewChunkHolder holder = holders.get(i2);
            try {
                NewChunkHolder.SaveStat saveStat = holder.save(shutdown, false);
                if (saveStat != null) {
                    ++saved;
                    needsFlush = flush;
                    if (saveStat.savedChunk()) {
                        ++savedChunk;
                    }
                    if (saveStat.savedEntityChunk()) {
                        ++savedEntity;
                    }
                    if (saveStat.savedPoiChunk()) {
                        ++savedPoi;
                    }
                }
            }
            catch (ThreadDeath thr) {
                throw thr;
            }
            catch (Throwable thr) {
                LOGGER.error("Failed to save chunk (" + holder.chunkX + "," + holder.chunkZ + ") in world '" + this.world.getWorld().getName() + "'", thr);
            }
            if (needsFlush && saved % 50 == 0) {
                needsFlush = false;
                RegionFileIOThread.partialFlush(25);
            }
            if (!logProgress || (currTime = System.nanoTime()) - lastLog <= TimeUnit.SECONDS.toNanos(10L)) continue;
            lastLog = currTime;
            LOGGER.info("Saved " + saved + " chunks (" + format.format((double)(i2 + 1) / (double)len * 100.0) + "%) in world '" + this.world.getWorld().getName() + "'");
        }
        if (flush) {
            RegionFileIOThread.flush();
            if (this.world.paperConfig().chunks.flushRegionsOnSave) {
                try {
                    this.world.H.a.regionFileCache.a();
                }
                catch (IOException ex) {
                    LOGGER.error("Exception when flushing regions in world {}", (Object)this.world.getWorld().getName(), (Object)ex);
                }
            }
        }
        if (logProgress) {
            LOGGER.info("Saved " + savedChunk + " block chunks, " + savedEntity + " entity chunks, " + savedPoi + " poi chunks in world '" + this.world.getWorld().getName() + "' in " + format.format(1.0E-9 * (double)(System.nanoTime() - start)) + "s");
        }
    }

    public static int convertBetweenTicketLevels(int level) {
        return PlayerChunkMap.b - level + 1;
    }

    public boolean hasTickets() {
        this.ticketLock.lock();
        try {
            boolean bl = !this.tickets.isEmpty();
            return bl;
        }
        finally {
            this.ticketLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTicketDebugString(long coordinate) {
        this.ticketLock.lock();
        try {
            ArraySetSorted tickets = (ArraySetSorted)this.tickets.get(coordinate);
            String string = tickets != null ? ((Ticket)tickets.b()).toString() : "no_ticket";
            return string;
        }
        finally {
            this.ticketLock.unlock();
        }
    }

    public Long2ObjectOpenHashMap<ArraySetSorted<Ticket<?>>> getTicketsCopy() {
        this.ticketLock.lock();
        try {
            Long2ObjectOpenHashMap long2ObjectOpenHashMap = this.tickets.clone();
            return long2ObjectOpenHashMap;
        }
        finally {
            this.ticketLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Plugin> getPluginChunkTickets(int x2, int z2) {
        ImmutableList.Builder ret;
        this.ticketLock.lock();
        try {
            ArraySetSorted tickets = (ArraySetSorted)this.tickets.get(ChunkCoordIntPair.c(x2, z2));
            if (tickets == null) {
                List<Plugin> list = Collections.emptyList();
                return list;
            }
            ret = ImmutableList.builder();
            for (Ticket ticket : tickets) {
                if (ticket.a() != TicketType.PLUGIN_TICKET) continue;
                ret.add((Object)((Plugin)ticket.c));
            }
        }
        finally {
            this.ticketLock.unlock();
        }
        return ret.build();
    }

    protected final int getPropagatedTicketLevel(long coordinate) {
        return ChunkHolderManager.convertBetweenTicketLevels(this.ticketLevelPropagator.getLevel(coordinate));
    }

    protected final void updateTicketLevel(long coordinate, int ticketLevel) {
        if (ticketLevel > PlayerChunkMap.b) {
            this.ticketLevelPropagator.removeSource(coordinate);
        } else {
            this.ticketLevelPropagator.setSource(coordinate, ChunkHolderManager.convertBetweenTicketLevels(ticketLevel));
        }
    }

    private static int getTicketLevelAt(ArraySetSorted<Ticket<?>> tickets) {
        return !tickets.isEmpty() ? tickets.b().b() : MAX_TICKET_LEVEL + 1;
    }

    public <T> boolean addTicketAtLevel(TicketType<T> type, ChunkCoordIntPair chunkPos, int level, T identifier) {
        return this.addTicketAtLevel(type, CoordinateUtils.getChunkKey(chunkPos), level, identifier);
    }

    public <T> boolean addTicketAtLevel(TicketType<T> type, int chunkX, int chunkZ, int level, T identifier) {
        return this.addTicketAtLevel(type, CoordinateUtils.getChunkKey(chunkX, chunkZ), level, identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean addTicketAtLevel(TicketType<T> type, long chunk, int level, T identifier) {
        long removeDelay = Math.max(0L, type.k);
        if (level > MAX_TICKET_LEVEL) {
            return false;
        }
        this.ticketLock.lock();
        try {
            long removeTick = removeDelay == 0L ? -1L : this.currentTick + removeDelay;
            Ticket<T> ticket = new Ticket<T>(type, level, identifier, removeTick);
            ArraySetSorted ticketsAtChunk = (ArraySetSorted)this.tickets.computeIfAbsent(chunk, keyInMap -> ArraySetSorted.a(4));
            int levelBefore = ChunkHolderManager.getTicketLevelAt(ticketsAtChunk);
            Ticket<T> current = ticketsAtChunk.replace(ticket);
            int levelAfter = ChunkHolderManager.getTicketLevelAt(ticketsAtChunk);
            if (current != ticket) {
                long oldRemovalTick = current.removalTick;
                if (removeTick != oldRemovalTick) {
                    Long2IntOpenHashMap removeCounts;
                    int prevCount;
                    if (oldRemovalTick != -1L && (prevCount = (removeCounts = (Long2IntOpenHashMap)this.removeTickToChunkExpireTicketCount.get(oldRemovalTick)).addTo(chunk, -1)) == 1) {
                        removeCounts.remove(chunk);
                        if (removeCounts.isEmpty()) {
                            this.removeTickToChunkExpireTicketCount.remove(oldRemovalTick);
                        }
                    }
                    if (removeTick != -1L) {
                        ((Long2IntOpenHashMap)this.removeTickToChunkExpireTicketCount.computeIfAbsent(removeTick, keyInMap -> new Long2IntOpenHashMap())).addTo(chunk, 1);
                    }
                }
            } else if (removeTick != -1L) {
                ((Long2IntOpenHashMap)this.removeTickToChunkExpireTicketCount.computeIfAbsent(removeTick, keyInMap -> new Long2IntOpenHashMap())).addTo(chunk, 1);
            }
            if (levelBefore != levelAfter) {
                this.updateTicketLevel(chunk, levelAfter);
            }
            boolean bl = current == ticket;
            return bl;
        }
        finally {
            this.ticketLock.unlock();
        }
    }

    public <T> boolean removeTicketAtLevel(TicketType<T> type, ChunkCoordIntPair chunkPos, int level, T identifier) {
        return this.removeTicketAtLevel(type, CoordinateUtils.getChunkKey(chunkPos), level, identifier);
    }

    public <T> boolean removeTicketAtLevel(TicketType<T> type, int chunkX, int chunkZ, int level, T identifier) {
        return this.removeTicketAtLevel(type, CoordinateUtils.getChunkKey(chunkX, chunkZ), level, identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean removeTicketAtLevel(TicketType<T> type, long chunk, int level, T identifier) {
        if (level > MAX_TICKET_LEVEL) {
            return false;
        }
        this.ticketLock.lock();
        try {
            Long2IntOpenHashMap removeCounts;
            int currCount;
            ArraySetSorted ticketsAtChunk = (ArraySetSorted)this.tickets.get(chunk);
            if (ticketsAtChunk == null) {
                boolean bl = false;
                return bl;
            }
            int oldLevel = ChunkHolderManager.getTicketLevelAt(ticketsAtChunk);
            Ticket<T> ticket = ticketsAtChunk.removeAndGet(new Ticket<T>(type, level, identifier, -2L));
            if (ticket == null) {
                boolean bl = false;
                return bl;
            }
            if (ticketsAtChunk.isEmpty()) {
                this.tickets.remove(chunk);
            }
            int newLevel = ChunkHolderManager.getTicketLevelAt(ticketsAtChunk);
            long removeTick = ticket.removalTick;
            if (removeTick != -1L && (currCount = (removeCounts = (Long2IntOpenHashMap)this.removeTickToChunkExpireTicketCount.get(removeTick)).addTo(chunk, -1)) == 1) {
                removeCounts.remove(chunk);
                if (removeCounts.isEmpty()) {
                    this.removeTickToChunkExpireTicketCount.remove(removeTick);
                }
            }
            if (oldLevel != newLevel) {
                this.updateTicketLevel(chunk, newLevel);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.ticketLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, V> void addAndRemoveTickets(long chunk, TicketType<T> addType, int addLevel, T addIdentifier, TicketType<V> removeType, int removeLevel, V removeIdentifier) {
        this.ticketLock.lock();
        try {
            this.addTicketAtLevel(addType, chunk, addLevel, addIdentifier);
            this.removeTicketAtLevel(removeType, chunk, removeLevel, removeIdentifier);
        }
        finally {
            this.ticketLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void removeAllTicketsFor(TicketType<T> ticketType, int ticketLevel, T ticketIdentifier) {
        if (ticketLevel > MAX_TICKET_LEVEL) {
            return;
        }
        this.ticketLock.lock();
        try {
            LongIterator iterator = new LongArrayList((LongCollection)this.tickets.keySet()).longIterator();
            while (iterator.hasNext()) {
                long chunk = iterator.nextLong();
                this.removeTicketAtLevel(ticketType, chunk, ticketLevel, ticketIdentifier);
            }
        }
        finally {
            this.ticketLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        TickThread.ensureTickThread("Cannot tick ticket manager off-main");
        this.ticketLock.lock();
        try {
            long tick = ++this.currentTick;
            Long2IntOpenHashMap toRemove = (Long2IntOpenHashMap)this.removeTickToChunkExpireTicketCount.remove(tick);
            if (toRemove == null) {
                return;
            }
            Predicate<Ticket> expireNow = ticket -> ticket.removalTick == tick;
            LongIterator iterator = toRemove.keySet().longIterator();
            while (iterator.hasNext()) {
                long chunk = iterator.nextLong();
                ArraySetSorted tickets = (ArraySetSorted)this.tickets.get(chunk);
                tickets.removeIf(expireNow);
                if (tickets.isEmpty()) {
                    this.tickets.remove(chunk);
                    this.ticketLevelPropagator.removeSource(chunk);
                    continue;
                }
                this.ticketLevelPropagator.setSource(chunk, ChunkHolderManager.convertBetweenTicketLevels(((Ticket)tickets.b()).b()));
            }
        }
        finally {
            this.ticketLock.unlock();
        }
        this.processTicketUpdates();
    }

    public NewChunkHolder getChunkHolder(int chunkX, int chunkZ) {
        return this.chunkHolders.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    public NewChunkHolder getChunkHolder(long position) {
        return this.chunkHolders.get(position);
    }

    public void raisePriority(int x2, int z2, PrioritisedExecutor.Priority priority) {
        NewChunkHolder chunkHolder = this.getChunkHolder(x2, z2);
        if (chunkHolder != null) {
            chunkHolder.raisePriority(priority);
        }
    }

    public void setPriority(int x2, int z2, PrioritisedExecutor.Priority priority) {
        NewChunkHolder chunkHolder = this.getChunkHolder(x2, z2);
        if (chunkHolder != null) {
            chunkHolder.setPriority(priority);
        }
    }

    public void lowerPriority(int x2, int z2, PrioritisedExecutor.Priority priority) {
        NewChunkHolder chunkHolder = this.getChunkHolder(x2, z2);
        if (chunkHolder != null) {
            chunkHolder.lowerPriority(priority);
        }
    }

    private NewChunkHolder createChunkHolder(long position) {
        NewChunkHolder ret = new NewChunkHolder(this.world, CoordinateUtils.getChunkX(position), CoordinateUtils.getChunkZ(position), this.taskScheduler);
        ChunkSystem.onChunkHolderCreate(this.world, ret.vanillaChunkHolder);
        ret.vanillaChunkHolder.onChunkAdd();
        return ret;
    }

    private NewChunkHolder getOrCreateChunkHolder(int chunkX, int chunkZ) {
        return this.getOrCreateChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    private NewChunkHolder getOrCreateChunkHolder(long position) {
        if (!this.ticketLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Must hold ticket level update lock!");
        }
        if (!this.taskScheduler.schedulingLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Must hold scheduler lock!!");
        }
        NewChunkHolder current = this.chunkHolders.get(position);
        if (current != null) {
            return current;
        }
        current = this.createChunkHolder(position);
        this.chunkHolders.put(position, current);
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkEntitySlices getOrCreateEntityChunk(int chunkX, int chunkZ, boolean transientChunk) {
        Long entityLoadId;
        ChunkEntitySlices ret;
        TickThread.ensureTickThread(this.world, chunkX, chunkZ, "Cannot create entity chunk off-main");
        NewChunkHolder current = this.getChunkHolder(chunkX, chunkZ);
        if (current != null && (ret = current.getEntityChunk()) != null && (transientChunk || !ret.isTransient())) {
            return ret;
        }
        AtomicBoolean isCompleted = new AtomicBoolean();
        Thread waiter = Thread.currentThread();
        NewChunkHolder.GenericDataLoadTaskCallback loadTask = null;
        this.ticketLock.lock();
        try {
            entityLoadId = this.entityLoadCounter++;
            this.addTicketAtLevel(TicketType.ENTITY_LOAD, chunkX, chunkZ, MAX_TICKET_LEVEL, entityLoadId);
            this.taskScheduler.schedulingLock.lock();
            try {
                current = this.getOrCreateChunkHolder(chunkX, chunkZ);
                ret = current.getEntityChunk();
                if (ret != null && (transientChunk || !ret.isTransient())) {
                    this.removeTicketAtLevel(TicketType.ENTITY_LOAD, chunkX, chunkZ, MAX_TICKET_LEVEL, entityLoadId);
                    ChunkEntitySlices chunkEntitySlices = ret;
                    return chunkEntitySlices;
                }
                if (current.isEntityChunkNBTLoaded()) {
                    isCompleted.setPlain(true);
                } else {
                    loadTask = current.getOrLoadEntityData(result -> {
                        if (!transientChunk) {
                            isCompleted.set(true);
                            LockSupport.unpark(waiter);
                        }
                    });
                    ChunkLoadTask.EntityDataLoadTask entityLoad = current.getEntityDataLoadTask();
                    if (entityLoad != null && !transientChunk) {
                        entityLoad.raisePriority(PrioritisedExecutor.Priority.BLOCKING);
                    }
                }
            }
            finally {
                this.taskScheduler.schedulingLock.unlock();
            }
        }
        finally {
            this.ticketLock.unlock();
        }
        if (loadTask != null) {
            loadTask.schedule();
        }
        if (!transientChunk) {
            boolean interrupted = false;
            while (!isCompleted.get()) {
                interrupted |= Thread.interrupted();
                LockSupport.park();
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        ret = current.loadInEntityChunk(transientChunk);
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        this.addAndRemoveTickets(chunkKey, TicketType.h, MAX_TICKET_LEVEL, new ChunkCoordIntPair(chunkX, chunkZ), TicketType.ENTITY_LOAD, MAX_TICKET_LEVEL, entityLoadId);
        return ret;
    }

    public PoiChunk getPoiChunkIfLoaded(int chunkX, int chunkZ, boolean checkLoadInCallback) {
        NewChunkHolder holder = this.getChunkHolder(chunkX, chunkZ);
        if (holder != null) {
            PoiChunk ret = holder.getPoiChunk();
            return ret == null || checkLoadInCallback && !ret.isLoaded() ? null : ret;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoiChunk loadPoiChunk(int chunkX, int chunkZ) {
        Long poiLoadId;
        PoiChunk ret;
        TickThread.ensureTickThread(this.world, chunkX, chunkZ, "Cannot create poi chunk off-main");
        NewChunkHolder current = this.getChunkHolder(chunkX, chunkZ);
        if (current != null && (ret = current.getPoiChunk()) != null) {
            if (!ret.isLoaded()) {
                ret.load();
            }
            return ret;
        }
        AtomicReference completed = new AtomicReference();
        AtomicBoolean isCompleted = new AtomicBoolean();
        Thread waiter = Thread.currentThread();
        NewChunkHolder.GenericDataLoadTaskCallback loadTask = null;
        this.ticketLock.lock();
        try {
            poiLoadId = this.poiLoadCounter++;
            this.addTicketAtLevel(TicketType.POI_LOAD, chunkX, chunkZ, MAX_TICKET_LEVEL, poiLoadId);
            this.taskScheduler.schedulingLock.lock();
            try {
                current = this.getOrCreateChunkHolder(chunkX, chunkZ);
                if (current.isPoiChunkLoaded()) {
                    this.removeTicketAtLevel(TicketType.POI_LOAD, chunkX, chunkZ, MAX_TICKET_LEVEL, poiLoadId);
                    PoiChunk poiChunk = current.getPoiChunk();
                    return poiChunk;
                }
                loadTask = current.getOrLoadPoiData(result -> {
                    completed.setPlain((PoiChunk)result.left());
                    isCompleted.set(true);
                    LockSupport.unpark(waiter);
                });
                ChunkLoadTask.PoiDataLoadTask poiLoad = current.getPoiDataLoadTask();
                if (poiLoad != null) {
                    poiLoad.raisePriority(PrioritisedExecutor.Priority.BLOCKING);
                }
            }
            finally {
                this.taskScheduler.schedulingLock.unlock();
            }
        }
        finally {
            this.ticketLock.unlock();
        }
        if (loadTask != null) {
            loadTask.schedule();
        }
        boolean interrupted = false;
        while (!isCompleted.get()) {
            interrupted |= Thread.interrupted();
            LockSupport.park();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        ret = (PoiChunk)completed.getPlain();
        ret.load();
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        this.addAndRemoveTickets(chunkKey, TicketType.h, MAX_TICKET_LEVEL, new ChunkCoordIntPair(chunkX, chunkZ), TicketType.POI_LOAD, MAX_TICKET_LEVEL, poiLoadId);
        return ret;
    }

    void addChangedStatuses(List<NewChunkHolder> changedFullStatus) {
        if (changedFullStatus.isEmpty()) {
            return;
        }
        if (!TickThread.isTickThread()) {
            this.taskScheduler.scheduleChunkTask(() -> {
                ArrayDeque<NewChunkHolder> pendingFullLoadUpdate = this.pendingFullLoadUpdate;
                int len = changedFullStatus.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    pendingFullLoadUpdate.add((NewChunkHolder)changedFullStatus.get(i2));
                }
                this.processPendingFullUpdate();
            }, PrioritisedExecutor.Priority.HIGHEST);
        } else {
            ArrayDeque<NewChunkHolder> pendingFullLoadUpdate = this.pendingFullLoadUpdate;
            int len = changedFullStatus.size();
            for (int i2 = 0; i2 < len; ++i2) {
                pendingFullLoadUpdate.add(changedFullStatus.get(i2));
            }
        }
    }

    private void removeChunkHolder(NewChunkHolder holder) {
        holder.killed = true;
        holder.vanillaChunkHolder.onChunkRemove();
        this.autoSaveQueue.remove((Object)holder);
        ChunkSystem.onChunkHolderDelete(this.world, holder.vanillaChunkHolder);
        this.chunkHolders.remove(CoordinateUtils.getChunkKey(holder.chunkX, holder.chunkZ));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUnloads() {
        int i2;
        int len;
        ArrayList<NewChunkHolder.UnloadState> unloadQueue;
        TickThread.ensureTickThread("Cannot unload chunks off-main");
        if (this.BLOCK_TICKET_UPDATES.get() == Boolean.TRUE) {
            throw new IllegalStateException("Cannot unload chunks recursively");
        }
        if (this.ticketLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Cannot hold ticket update lock while calling processUnloads");
        }
        if (this.taskScheduler.schedulingLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Cannot hold scheduling lock while calling processUnloads");
        }
        ArrayList<ChunkProgressionTask> scheduleList = new ArrayList<ChunkProgressionTask>();
        this.ticketLock.lock();
        try {
            this.taskScheduler.schedulingLock.lock();
            try {
                if (this.unloadQueue.isEmpty()) {
                    return;
                }
                this.processTicketUpdates(false, false, scheduleList);
                unloadQueue = new ArrayList<NewChunkHolder.UnloadState>((int)((double)this.unloadQueue.size() * 0.05) + 1);
                int unloadCount = Math.max(50, (int)((double)this.unloadQueue.size() * 0.05));
                for (int i3 = 0; i3 < unloadCount && !this.unloadQueue.isEmpty(); ++i3) {
                    NewChunkHolder chunkHolder = (NewChunkHolder)this.unloadQueue.removeFirst();
                    if (chunkHolder.isSafeToUnload() != null) {
                        LOGGER.error("Chunkholder " + chunkHolder + " is not safe to unload but is inside the unload queue?");
                        continue;
                    }
                    NewChunkHolder.UnloadState state = chunkHolder.unloadStage1();
                    if (state == null) {
                        this.removeChunkHolder(chunkHolder);
                        continue;
                    }
                    unloadQueue.add(state);
                }
            }
            finally {
                this.taskScheduler.schedulingLock.unlock();
            }
        }
        finally {
            this.ticketLock.unlock();
        }
        int len2 = scheduleList.size();
        for (int i4 = 0; i4 < len2; ++i4) {
            ((ChunkProgressionTask)scheduleList.get(i4)).schedule();
        }
        ArrayList<NewChunkHolder> toRemove = new ArrayList<NewChunkHolder>(unloadQueue.size());
        Boolean before = this.blockTicketUpdates();
        try {
            len = unloadQueue.size();
            for (i2 = 0; i2 < len; ++i2) {
                NewChunkHolder.UnloadState state = (NewChunkHolder.UnloadState)unloadQueue.get(i2);
                NewChunkHolder holder = state.holder();
                holder.unloadStage2(state);
                toRemove.add(holder);
            }
        }
        finally {
            this.unblockTicketUpdates(before);
        }
        this.ticketLock.lock();
        try {
            this.taskScheduler.schedulingLock.lock();
            try {
                len = toRemove.size();
                for (i2 = 0; i2 < len; ++i2) {
                    NewChunkHolder holder = (NewChunkHolder)toRemove.get(i2);
                    if (holder.unloadStage3()) {
                        this.removeChunkHolder(holder);
                        continue;
                    }
                    this.addTicketAtLevel(TicketType.UNLOAD_COOLDOWN, holder.chunkX, holder.chunkZ, MAX_TICKET_LEVEL, Unit.a);
                }
            }
            finally {
                this.taskScheduler.schedulingLock.unlock();
            }
        }
        finally {
            this.ticketLock.unlock();
        }
    }

    public Boolean blockTicketUpdates() {
        Boolean ret = this.BLOCK_TICKET_UPDATES.get();
        this.BLOCK_TICKET_UPDATES.set(Boolean.TRUE);
        return ret;
    }

    public void unblockTicketUpdates(Boolean before) {
        this.BLOCK_TICKET_UPDATES.set(before);
    }

    public boolean processTicketUpdates() {
        MinecraftTimings.distanceManagerTick.startTiming();
        try {
            boolean bl = this.processTicketUpdates(true, true, null);
            return bl;
        }
        finally {
            MinecraftTimings.distanceManagerTick.stopTiming();
        }
    }

    static List<ChunkProgressionTask> getCurrentTicketUpdateScheduling() {
        return CURRENT_TICKET_UPDATE_SCHEDULING.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processTicketUpdates(boolean checkLocks, boolean processFullUpdates, List<ChunkProgressionTask> scheduledTasks) {
        boolean canProcessScheduling;
        boolean canProcessFullUpdates;
        boolean ret;
        ArrayList<NewChunkHolder> changedFullStatus;
        block23: {
            TickThread.ensureTickThread("Cannot process ticket levels off-main");
            if (this.BLOCK_TICKET_UPDATES.get() == Boolean.TRUE) {
                throw new IllegalStateException("Cannot update ticket level while unloading chunks or updating entity manager");
            }
            if (checkLocks && this.ticketLock.isHeldByCurrentThread()) {
                throw new IllegalStateException("Illegal recursive processTicketUpdates!");
            }
            if (checkLocks && this.taskScheduler.schedulingLock.isHeldByCurrentThread()) {
                throw new IllegalStateException("Cannot update ticket levels from a scheduler context!");
            }
            changedFullStatus = null;
            boolean isTickThread = TickThread.isTickThread();
            ret = false;
            canProcessFullUpdates = processFullUpdates & isTickThread;
            canProcessScheduling = scheduledTasks == null;
            this.ticketLock.lock();
            try {
                NewChunkHolder current;
                boolean levelsUpdated = this.ticketLevelPropagator.propagateUpdates();
                if (!levelsUpdated || this.ticketLevelUpdates.isEmpty()) break block23;
                ret = true;
                ObjectBidirectionalIterator iterator = this.ticketLevelUpdates.long2IntEntrySet().fastIterator();
                while (iterator.hasNext()) {
                    int currentLevel;
                    Long2IntMap.Entry entry = (Long2IntMap.Entry)iterator.next();
                    long key = entry.getLongKey();
                    int newLevel = entry.getIntValue();
                    current = this.chunkHolders.get(key);
                    if (current == null && newLevel > MAX_TICKET_LEVEL) {
                        iterator.remove();
                        continue;
                    }
                    int n2 = currentLevel = current == null ? MAX_TICKET_LEVEL + 1 : current.getCurrentTicketLevel();
                    if (currentLevel == newLevel) {
                        iterator.remove();
                        continue;
                    }
                    if (current == null) {
                        current = this.createChunkHolder(key);
                        this.chunkHolders.put(key, current);
                        current.updateTicketLevel(newLevel);
                        continue;
                    }
                    current.updateTicketLevel(newLevel);
                }
                if (scheduledTasks == null) {
                    scheduledTasks = new ArrayList<ChunkProgressionTask>();
                }
                changedFullStatus = new ArrayList<NewChunkHolder>();
                List<ChunkProgressionTask> prev = CURRENT_TICKET_UPDATE_SCHEDULING.get();
                CURRENT_TICKET_UPDATE_SCHEDULING.set(scheduledTasks);
                try {
                    this.taskScheduler.schedulingLock.lock();
                    try {
                        ObjectBidirectionalIterator iterator2 = this.ticketLevelUpdates.long2IntEntrySet().fastIterator();
                        while (iterator2.hasNext()) {
                            Long2IntMap.Entry entry = (Long2IntMap.Entry)iterator2.next();
                            long key = entry.getLongKey();
                            current = this.chunkHolders.get(key);
                            if (current == null) {
                                throw new IllegalStateException("Expected chunk holder to be created");
                            }
                            current.processTicketLevelUpdate(scheduledTasks, changedFullStatus);
                        }
                    }
                    finally {
                        this.taskScheduler.schedulingLock.unlock();
                    }
                }
                finally {
                    CURRENT_TICKET_UPDATE_SCHEDULING.set(prev);
                }
                this.ticketLevelUpdates.clear();
            }
            finally {
                this.ticketLock.unlock();
            }
        }
        if (changedFullStatus != null) {
            this.addChangedStatuses(changedFullStatus);
        }
        if (canProcessScheduling && scheduledTasks != null) {
            int len = scheduledTasks.size();
            for (int i2 = 0; i2 < len; ++i2) {
                scheduledTasks.get(i2).schedule();
            }
        }
        if (canProcessFullUpdates) {
            ret |= this.processPendingFullUpdate();
        }
        return ret;
    }

    protected final boolean processPendingFullUpdate() {
        NewChunkHolder holder;
        ArrayDeque<NewChunkHolder> pendingFullLoadUpdate = this.pendingFullLoadUpdate;
        boolean ret = false;
        ArrayList<NewChunkHolder> changedFullStatus = new ArrayList<NewChunkHolder>();
        while ((holder = pendingFullLoadUpdate.poll()) != null) {
            ret |= holder.handleFullStatusChange(changedFullStatus);
            if (changedFullStatus.isEmpty()) continue;
            int len = changedFullStatus.size();
            for (int i2 = 0; i2 < len; ++i2) {
                pendingFullLoadUpdate.add((NewChunkHolder)changedFullStatus.get(i2));
            }
            changedFullStatus.clear();
        }
        return ret;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public JsonObject getDebugJsonForWatchdog() {
        block13: {
            try {
                if (!this.ticketLock.tryLock(10L, TimeUnit.SECONDS)) break block13;
                try {
                    if (this.taskScheduler.schedulingLock.tryLock(10L, TimeUnit.SECONDS)) {
                        try {
                            JsonObject jsonObject = this.getDebugJsonNoLock();
                            this.taskScheduler.schedulingLock.unlock();
                            return jsonObject;
                        }
                        catch (Throwable throwable) {
                            this.taskScheduler.schedulingLock.unlock();
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.ticketLock.unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LOGGER.error("Failed to acquire ticket and scheduling lock before timeout for world " + this.world.getWorld().getName());
        Throwable lastException = null;
        for (int count = 0; count < 1000; ++count) {
            try {
                return this.getDebugJsonNoLock();
            }
            catch (ThreadDeath death) {
                throw death;
            }
            catch (Throwable thr) {
                lastException = thr;
                Thread.yield();
                LockSupport.parkNanos(10000L);
                continue;
            }
        }
        LOGGER.error("Failed to retrieve debug json for watchdog thread without locking", lastException);
        return null;
    }

    private JsonObject getDebugJsonNoLock() {
        JsonObject ret = new JsonObject();
        ret.addProperty("current_tick", (Number)this.currentTick);
        JsonArray unloadQueue = new JsonArray();
        ret.add("unload_queue", (JsonElement)unloadQueue);
        for (Object holder : this.unloadQueue) {
            JsonObject coordinate = new JsonObject();
            unloadQueue.add((JsonElement)coordinate);
            coordinate.addProperty("chunkX", (Number)((NewChunkHolder)holder).chunkX);
            coordinate.addProperty("chunkZ", (Number)((NewChunkHolder)holder).chunkZ);
        }
        JsonArray holders = new JsonArray();
        ret.add("chunkholders", (JsonElement)holders);
        for (NewChunkHolder holder : this.getChunkHolders()) {
            holders.add((JsonElement)holder.getDebugJson());
        }
        JsonArray removeTickToChunkExpireTicketCount = new JsonArray();
        ret.add("remove_tick_to_chunk_expire_ticket_count", (JsonElement)removeTickToChunkExpireTicketCount);
        for (Long2ObjectMap.Entry tickEntry : this.removeTickToChunkExpireTicketCount.long2ObjectEntrySet()) {
            long tick = tickEntry.getLongKey();
            Long2IntOpenHashMap coordinateToCount = (Long2IntOpenHashMap)tickEntry.getValue();
            JsonObject tickJson = new JsonObject();
            removeTickToChunkExpireTicketCount.add((JsonElement)tickJson);
            tickJson.addProperty("tick", (Number)tick);
            JsonArray tickEntries = new JsonArray();
            tickJson.add("entries", (JsonElement)tickEntries);
            for (Long2IntMap.Entry entry : coordinateToCount.long2IntEntrySet()) {
                long coordinate = entry.getLongKey();
                int count = entry.getIntValue();
                JsonObject entryJson = new JsonObject();
                tickEntries.add((JsonElement)entryJson);
                entryJson.addProperty("chunkX", (Number)CoordinateUtils.getChunkX(coordinate));
                entryJson.addProperty("chunkZ", (Number)CoordinateUtils.getChunkZ(coordinate));
                entryJson.addProperty("count", (Number)count);
            }
        }
        JsonArray allTicketsJson = new JsonArray();
        ret.add("tickets", (JsonElement)allTicketsJson);
        for (Long2ObjectMap.Entry coordinateTickets : this.tickets.long2ObjectEntrySet()) {
            long coordinate = coordinateTickets.getLongKey();
            ArraySetSorted tickets = (ArraySetSorted)coordinateTickets.getValue();
            JsonObject coordinateJson = new JsonObject();
            allTicketsJson.add((JsonElement)coordinateJson);
            coordinateJson.addProperty("chunkX", (Number)CoordinateUtils.getChunkX(coordinate));
            coordinateJson.addProperty("chunkZ", (Number)CoordinateUtils.getChunkZ(coordinate));
            JsonArray ticketsSerialized = new JsonArray();
            coordinateJson.add("tickets", (JsonElement)ticketsSerialized);
            for (Ticket ticket : tickets) {
                JsonObject ticketSerialized = new JsonObject();
                ticketsSerialized.add((JsonElement)ticketSerialized);
                ticketSerialized.addProperty("type", ticket.a().toString());
                ticketSerialized.addProperty("level", (Number)ticket.b());
                ticketSerialized.addProperty("identifier", Objects.toString(ticket.c));
                ticketSerialized.addProperty("remove_tick", (Number)ticket.removalTick);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject getDebugJson() {
        ArrayList<ChunkProgressionTask> scheduleList = new ArrayList<ChunkProgressionTask>();
        try {
            JsonObject ret;
            this.ticketLock.lock();
            try {
                this.taskScheduler.schedulingLock.lock();
                try {
                    this.processTicketUpdates(false, false, scheduleList);
                    ret = this.getDebugJsonNoLock();
                }
                finally {
                    this.taskScheduler.schedulingLock.unlock();
                }
            }
            finally {
                this.ticketLock.unlock();
            }
            JsonObject jsonObject = ret;
            return jsonObject;
        }
        finally {
            int len = scheduleList.size();
            for (int i2 = 0; i2 < len; ++i2) {
                ((ChunkProgressionTask)scheduleList.get(i2)).schedule();
            }
        }
    }
}

