/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.chunk.system.scheduling;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedThreadPool;
import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedThreadedTaskQueue;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.io.RegionFileIOThread;
import io.papermc.paper.chunk.system.scheduling.ChunkFullTask;
import io.papermc.paper.chunk.system.scheduling.ChunkHolderManager;
import io.papermc.paper.chunk.system.scheduling.ChunkLightTask;
import io.papermc.paper.chunk.system.scheduling.ChunkLoadTask;
import io.papermc.paper.chunk.system.scheduling.ChunkProgressionTask;
import io.papermc.paper.chunk.system.scheduling.ChunkUpgradeGenericStatusTask;
import io.papermc.paper.chunk.system.scheduling.NewChunkHolder;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.TickThread;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import org.bukkit.Bukkit;
import org.slf4j.Logger;

public final class ChunkTaskScheduler {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    static int newChunkSystemIOThreads;
    static int newChunkSystemWorkerThreads;
    static int newChunkSystemGenParallelism;
    static int newChunkSystemLoadParallelism;
    public static PrioritisedThreadPool workerThreads;
    private static boolean initialised;
    public final WorldServer world;
    public final PrioritisedThreadPool workers;
    public final PrioritisedThreadPool.PrioritisedPoolExecutor lightExecutor;
    public final PrioritisedThreadPool.PrioritisedPoolExecutor genExecutor;
    public final PrioritisedThreadPool.PrioritisedPoolExecutor parallelGenExecutor;
    public final PrioritisedThreadPool.PrioritisedPoolExecutor loadExecutor;
    private final PrioritisedThreadedTaskQueue mainThreadExecutor = new PrioritisedThreadedTaskQueue();
    final ReentrantLock schedulingLock = new ReentrantLock();
    public final ChunkHolderManager chunkHolderManager;
    private final AtomicBoolean failedChunkSystem = new AtomicBoolean();
    private final AtomicLong chunkLoadCounter = new AtomicLong();
    public static final ArrayDeque<ChunkInfo> WAITING_CHUNKS;

    public static void init(GlobalConfiguration.ChunkSystem config) {
        boolean useParallelGen;
        if (initialised) {
            return;
        }
        initialised = true;
        newChunkSystemIOThreads = config.ioThreads;
        newChunkSystemWorkerThreads = config.workerThreads;
        newChunkSystemIOThreads = newChunkSystemIOThreads < 0 ? 1 : Math.max(1, newChunkSystemIOThreads);
        int defaultWorkerThreads = Runtime.getRuntime().availableProcessors() / 2;
        defaultWorkerThreads = defaultWorkerThreads <= 4 ? (defaultWorkerThreads <= 3 ? 1 : 2) : (defaultWorkerThreads /= 2);
        defaultWorkerThreads = Integer.getInteger("Paper.WorkerThreadCount", (Integer)defaultWorkerThreads);
        newChunkSystemWorkerThreads = newChunkSystemWorkerThreads < 0 ? defaultWorkerThreads : Math.max(1, newChunkSystemWorkerThreads);
        String newChunkSystemGenParallelism = config.genParallelism;
        if (newChunkSystemGenParallelism.equalsIgnoreCase("default")) {
            newChunkSystemGenParallelism = "true";
        }
        if (newChunkSystemGenParallelism.equalsIgnoreCase("on") || newChunkSystemGenParallelism.equalsIgnoreCase("enabled") || newChunkSystemGenParallelism.equalsIgnoreCase("true")) {
            useParallelGen = true;
        } else if (newChunkSystemGenParallelism.equalsIgnoreCase("off") || newChunkSystemGenParallelism.equalsIgnoreCase("disabled") || newChunkSystemGenParallelism.equalsIgnoreCase("false")) {
            useParallelGen = false;
        } else {
            throw new IllegalStateException("Invalid option for gen-parallelism: must be one of [on, off, enabled, disabled, true, false, default]");
        }
        ChunkTaskScheduler.newChunkSystemGenParallelism = useParallelGen ? newChunkSystemWorkerThreads : 1;
        newChunkSystemLoadParallelism = newChunkSystemWorkerThreads;
        RegionFileIOThread.init(newChunkSystemIOThreads);
        workerThreads = new PrioritisedThreadPool("Paper Chunk System Worker Pool", newChunkSystemWorkerThreads, (thread, id) -> {
            thread.setPriority(3);
            thread.setName("Tuinity Chunk System Worker #" + id);
            thread.setUncaughtExceptionHandler(NewChunkHolder.CHUNKSYSTEM_UNCAUGHT_EXCEPTION_HANDLER);
        }, 20000000L);
        LOGGER.info("Chunk system is using " + newChunkSystemIOThreads + " I/O threads, " + newChunkSystemWorkerThreads + " worker threads, and gen parallelism of " + ChunkTaskScheduler.newChunkSystemGenParallelism + " threads");
    }

    public ChunkTaskScheduler(WorldServer world, PrioritisedThreadPool workers) {
        this.world = world;
        this.workers = workers;
        String worldName = world.getWorld().getName();
        this.lightExecutor = this.genExecutor = workers.createExecutor("Chunk single-threaded generation executor for world '" + worldName + "'", 1);
        this.parallelGenExecutor = newChunkSystemGenParallelism <= 1 ? this.genExecutor : workers.createExecutor("Chunk parallel generation executor for world '" + worldName + "'", newChunkSystemGenParallelism);
        this.loadExecutor = workers.createExecutor("Chunk load executor for world '" + worldName + "'", newChunkSystemLoadParallelism);
        this.chunkHolderManager = new ChunkHolderManager(world, this);
    }

    public static Object stringIfNull(Object obj) {
        return obj == null ? "null" : obj;
    }

    public void unrecoverableChunkSystemFailure(int chunkX, int chunkZ, Map<String, Object> objectsOfInterest, Throwable thr) {
        NewChunkHolder holder = this.chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        LOGGER.error("Chunk system error at chunk (" + chunkX + "," + chunkZ + "), holder: " + holder + ", exception:", new Throwable(thr));
        if (this.failedChunkSystem.getAndSet(true)) {
            return;
        }
        ReportedException reportedException = thr instanceof ReportedException ? (ReportedException)thr : new ReportedException(new CrashReport("Chunk system error", thr));
        CrashReportSystemDetails crashReportCategory = reportedException.a().a("Chunk system details");
        crashReportCategory.a("Chunk coordinate", new ChunkCoordIntPair(chunkX, chunkZ).toString());
        crashReportCategory.a("ChunkHolder", Objects.toString(holder));
        crashReportCategory.a("unrecoverableChunkSystemFailure caller thread", Thread.currentThread().getName());
        crashReportCategory = reportedException.a().a("Chunk System Objects of Interest");
        for (Map.Entry<String, Object> entry : objectsOfInterest.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof Throwable) {
                Throwable thrObject = (Throwable)object;
                crashReportCategory.a(Objects.toString(entry.getKey()), thrObject);
                continue;
            }
            crashReportCategory.a(Objects.toString(entry.getKey()), Objects.toString(entry.getValue()));
        }
        Runnable crash = () -> {
            throw new RuntimeException("Chunk system crash propagated from unrecoverableChunkSystemFailure", reportedException);
        };
        this.scheduleChunkTask(chunkX, chunkZ, crash, PrioritisedExecutor.Priority.BLOCKING);
        MinecraftServer.chunkSystemCrash = new RuntimeException("Chunk system crash propagated from unrecoverableChunkSystemFailure", reportedException);
    }

    public boolean executeMainThreadTask() {
        TickThread.ensureTickThread("Cannot execute main thread task off-main");
        return this.mainThreadExecutor.executeTask();
    }

    public void raisePriority(int x2, int z2, PrioritisedExecutor.Priority priority) {
        this.chunkHolderManager.raisePriority(x2, z2, priority);
    }

    public void setPriority(int x2, int z2, PrioritisedExecutor.Priority priority) {
        this.chunkHolderManager.setPriority(x2, z2, priority);
    }

    public void lowerPriority(int x2, int z2, PrioritisedExecutor.Priority priority) {
        this.chunkHolderManager.lowerPriority(x2, z2, priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTickingState(int chunkX, int chunkZ, PlayerChunk.State toStatus, boolean addTicket, PrioritisedExecutor.Priority priority, Consumer<Chunk> onComplete) {
        Chunk chunk2;
        boolean scheduled;
        if (!TickThread.isTickThread()) {
            this.scheduleChunkTask(chunkX, chunkZ, () -> this.scheduleTickingState(chunkX, chunkZ, toStatus, addTicket, priority, onComplete), priority);
            return;
        }
        if (this.chunkHolderManager.ticketLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Cannot schedule chunk load during ticket level update");
        }
        if (this.schedulingLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Cannot schedule chunk loading recursively");
        }
        if (toStatus == PlayerChunk.State.a) {
            throw new IllegalArgumentException("Cannot wait for INACCESSIBLE status");
        }
        int minLevel = 33 - (toStatus.ordinal() - 1);
        Long chunkReference = addTicket ? Long.valueOf(this.chunkLoadCounter.getAndIncrement()) : null;
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        if (addTicket) {
            this.chunkHolderManager.addTicketAtLevel(TicketType.CHUNK_LOAD, chunkKey, minLevel, chunkReference);
            this.chunkHolderManager.processTicketUpdates();
        }
        Consumer<Chunk> loadCallback = chunk -> {
            try {
                if (onComplete != null) {
                    onComplete.accept((Chunk)chunk);
                }
            }
            finally {
                if (addTicket) {
                    this.chunkHolderManager.addAndRemoveTickets(chunkKey, TicketType.h, minLevel, new ChunkCoordIntPair(chunkKey), TicketType.CHUNK_LOAD, minLevel, chunkReference);
                }
            }
        };
        this.chunkHolderManager.ticketLock.lock();
        try {
            this.schedulingLock.lock();
            try {
                NewChunkHolder chunkHolder = this.chunkHolderManager.getChunkHolder(chunkKey);
                if (chunkHolder == null || chunkHolder.getTicketLevel() > minLevel) {
                    scheduled = false;
                    chunk2 = null;
                } else {
                    PlayerChunk.State currStatus = chunkHolder.getChunkStatus();
                    if (currStatus.a(toStatus)) {
                        scheduled = false;
                        chunk2 = (Chunk)chunkHolder.getCurrentChunk();
                    } else {
                        scheduled = true;
                        chunk2 = null;
                        int radius = toStatus.ordinal() - 1;
                        for (int dz = -radius; dz <= radius; ++dz) {
                            for (int dx = -radius; dx <= radius; ++dx) {
                                NewChunkHolder neighbour;
                                NewChunkHolder newChunkHolder = neighbour = (dx | dz) == 0 ? chunkHolder : this.chunkHolderManager.getChunkHolder(dx + chunkX, dz + chunkZ);
                                if (neighbour == null) continue;
                                neighbour.raisePriority(priority);
                            }
                        }
                        chunkHolder.addFullStatusConsumer(toStatus, loadCallback);
                    }
                }
            }
            finally {
                this.schedulingLock.unlock();
            }
        }
        finally {
            this.chunkHolderManager.ticketLock.unlock();
        }
        if (!scheduled) {
            try {
                loadCallback.accept(chunk2);
            }
            catch (ThreadDeath thr) {
                throw thr;
            }
            catch (Throwable thr) {
                LOGGER.error("Failed to process chunk full status callback", thr);
            }
        }
    }

    public void scheduleChunkLoad(int chunkX, int chunkZ, boolean gen, ChunkStatus toStatus, boolean addTicket, PrioritisedExecutor.Priority priority, Consumer<IChunkAccess> onComplete) {
        if (gen) {
            this.scheduleChunkLoad(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
            return;
        }
        this.scheduleChunkLoad(chunkX, chunkZ, ChunkStatus.c, addTicket, priority, chunk -> {
            if (chunk == null) {
                onComplete.accept(null);
            } else if (chunk.j().b(toStatus)) {
                this.scheduleChunkLoad(chunkX, chunkZ, toStatus, addTicket, priority, onComplete);
            } else {
                onComplete.accept(null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleChunkLoad(int chunkX, int chunkZ, ChunkStatus toStatus, boolean addTicket, PrioritisedExecutor.Priority priority, Consumer<IChunkAccess> onComplete) {
        IChunkAccess chunk2;
        boolean scheduled;
        if (!TickThread.isTickThread()) {
            this.scheduleChunkTask(chunkX, chunkZ, () -> this.scheduleChunkLoad(chunkX, chunkZ, toStatus, addTicket, priority, onComplete), priority);
            return;
        }
        if (this.chunkHolderManager.ticketLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Cannot schedule chunk load during ticket level update");
        }
        if (this.schedulingLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Cannot schedule chunk loading recursively");
        }
        if (toStatus == ChunkStatus.o) {
            this.scheduleTickingState(chunkX, chunkZ, PlayerChunk.State.b, addTicket, priority, onComplete);
            return;
        }
        int minLevel = 33 + ChunkStatus.a(toStatus);
        Long chunkReference = addTicket ? Long.valueOf(this.chunkLoadCounter.getAndIncrement()) : null;
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        if (addTicket) {
            this.chunkHolderManager.addTicketAtLevel(TicketType.CHUNK_LOAD, chunkKey, minLevel, chunkReference);
            this.chunkHolderManager.processTicketUpdates();
        }
        Consumer<IChunkAccess> loadCallback = chunk -> {
            try {
                if (onComplete != null) {
                    onComplete.accept((IChunkAccess)chunk);
                }
            }
            finally {
                if (addTicket) {
                    this.chunkHolderManager.addAndRemoveTickets(chunkKey, TicketType.h, minLevel, new ChunkCoordIntPair(chunkKey), TicketType.CHUNK_LOAD, minLevel, chunkReference);
                }
            }
        };
        ArrayList<ChunkProgressionTask> tasks = new ArrayList<ChunkProgressionTask>();
        this.chunkHolderManager.ticketLock.lock();
        try {
            this.schedulingLock.lock();
            try {
                NewChunkHolder chunkHolder = this.chunkHolderManager.getChunkHolder(chunkKey);
                if (chunkHolder == null || chunkHolder.getTicketLevel() > minLevel) {
                    scheduled = false;
                    chunk2 = null;
                } else {
                    ChunkStatus genStatus = chunkHolder.getCurrentGenStatus();
                    if (genStatus != null && genStatus.b(toStatus)) {
                        scheduled = false;
                        chunk2 = chunkHolder.getCurrentChunk();
                    } else {
                        scheduled = true;
                        chunk2 = null;
                        chunkHolder.raisePriority(priority);
                        if (!chunkHolder.upgradeGenTarget(toStatus)) {
                            this.schedule(chunkX, chunkZ, toStatus, chunkHolder, tasks);
                        }
                        chunkHolder.addStatusConsumer(toStatus, loadCallback);
                    }
                }
            }
            finally {
                this.schedulingLock.unlock();
            }
        }
        finally {
            this.chunkHolderManager.ticketLock.unlock();
        }
        int len = tasks.size();
        for (int i2 = 0; i2 < len; ++i2) {
            ((ChunkProgressionTask)tasks.get(i2)).schedule();
        }
        if (!scheduled) {
            try {
                loadCallback.accept(chunk2);
            }
            catch (ThreadDeath thr) {
                throw thr;
            }
            catch (Throwable thr) {
                LOGGER.error("Failed to process chunk status callback", thr);
            }
        }
    }

    private ChunkProgressionTask createTask(int chunkX, int chunkZ, IChunkAccess chunk, NewChunkHolder chunkHolder, List<IChunkAccess> neighbours, ChunkStatus toStatus, PrioritisedExecutor.Priority initialPriority) {
        if (toStatus == ChunkStatus.c) {
            return new ChunkLoadTask(this, this.world, chunkX, chunkZ, chunkHolder, initialPriority);
        }
        if (toStatus == ChunkStatus.l) {
            return new ChunkLightTask(this, this.world, chunkX, chunkZ, chunk, initialPriority);
        }
        if (toStatus == ChunkStatus.o) {
            return new ChunkFullTask(this, this.world, chunkX, chunkZ, chunkHolder, chunk, initialPriority);
        }
        return new ChunkUpgradeGenericStatusTask(this, this.world, chunkX, chunkZ, chunk, neighbours, toStatus, initialPriority);
    }

    ChunkProgressionTask schedule(int chunkX, int chunkZ, ChunkStatus targetStatus, NewChunkHolder chunkHolder, List<ChunkProgressionTask> allTasks) {
        return this.schedule(chunkX, chunkZ, targetStatus, chunkHolder, allTasks, chunkHolder.getEffectivePriority());
    }

    private ChunkProgressionTask schedule(int chunkX, int chunkZ, ChunkStatus targetStatus, NewChunkHolder chunkHolder, List<ChunkProgressionTask> allTasks, PrioritisedExecutor.Priority minPriority) {
        ArrayList<NewChunkHolder> chunkHolderNeighbours;
        ArrayList<IChunkAccess> neighbours;
        if (!this.schedulingLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Not holding scheduling lock");
        }
        if (chunkHolder.hasGenerationTask()) {
            chunkHolder.upgradeGenTarget(targetStatus);
            return null;
        }
        PrioritisedExecutor.Priority requestedPriority = PrioritisedExecutor.Priority.max(minPriority, chunkHolder.getEffectivePriority());
        ChunkStatus currentGenStatus = chunkHolder.getCurrentGenStatus();
        IChunkAccess chunk = chunkHolder.getCurrentChunk();
        if (currentGenStatus == null) {
            ChunkProgressionTask task = this.createTask(chunkX, chunkZ, chunk, chunkHolder, Collections.emptyList(), ChunkStatus.c, requestedPriority);
            allTasks.add(task);
            ArrayList<NewChunkHolder> chunkHolderNeighbours2 = new ArrayList<NewChunkHolder>(1);
            chunkHolderNeighbours2.add(chunkHolder);
            chunkHolder.setGenerationTarget(targetStatus);
            chunkHolder.setGenerationTask(task, ChunkStatus.c, chunkHolderNeighbours2);
            return task;
        }
        if (currentGenStatus.b(targetStatus)) {
            return null;
        }
        chunkHolder.setGenerationTarget(targetStatus);
        ChunkStatus chunkRealStatus = chunk.j();
        ChunkStatus toStatus = currentGenStatus.getNextStatus();
        int neighbourReadRadius = chunkRealStatus.b(toStatus) ? toStatus.loadRange : toStatus.f();
        boolean unGeneratedNeighbours = false;
        for (int r2 = 1; r2 <= neighbourReadRadius; ++r2) {
            int x2 = -r2;
            int z2 = r2;
            while (x2 <= r2 && z2 > -r2) {
                int radius = Math.max(Math.abs(x2), Math.abs(z2));
                ChunkStatus requiredNeighbourStatus = PlayerChunkMap.a(toStatus, radius);
                unGeneratedNeighbours |= this.checkNeighbour(chunkX + x2, chunkZ + z2, requiredNeighbourStatus, chunkHolder, allTasks, requestedPriority);
                unGeneratedNeighbours |= this.checkNeighbour(chunkX - x2, chunkZ - z2, requiredNeighbourStatus, chunkHolder, allTasks, requestedPriority);
                if (x2 < r2) {
                    ++x2;
                    continue;
                }
                --z2;
            }
        }
        if (unGeneratedNeighbours) {
            chunkHolder.recalculateNeighbourPriorities();
            return null;
        }
        if (neighbourReadRadius <= 0) {
            neighbours = new ArrayList<IChunkAccess>(1);
            chunkHolderNeighbours = new ArrayList<NewChunkHolder>(1);
            neighbours.add(chunk);
            chunkHolderNeighbours.add(chunkHolder);
        } else {
            neighbours = new ArrayList((2 * neighbourReadRadius + 1) * (2 * neighbourReadRadius + 1));
            chunkHolderNeighbours = new ArrayList((2 * neighbourReadRadius + 1) * (2 * neighbourReadRadius + 1));
            for (int dz = -neighbourReadRadius; dz <= neighbourReadRadius; ++dz) {
                for (int dx = -neighbourReadRadius; dx <= neighbourReadRadius; ++dx) {
                    NewChunkHolder holder = (dx | dz) == 0 ? chunkHolder : this.chunkHolderManager.getChunkHolder(dx + chunkX, dz + chunkZ);
                    neighbours.add(holder.getChunkForNeighbourAccess());
                    chunkHolderNeighbours.add(holder);
                }
            }
        }
        ChunkProgressionTask task = this.createTask(chunkX, chunkZ, chunk, chunkHolder, neighbours, toStatus, chunkHolder.getEffectivePriority());
        allTasks.add(task);
        chunkHolder.setGenerationTask(task, toStatus, chunkHolderNeighbours);
        return task;
    }

    private boolean checkNeighbour(int chunkX, int chunkZ, ChunkStatus requiredStatus, NewChunkHolder center, List<ChunkProgressionTask> tasks, PrioritisedExecutor.Priority minPriority) {
        NewChunkHolder chunkHolder = this.chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (chunkHolder == null) {
            throw new IllegalStateException("Missing chunkholder when required");
        }
        ChunkStatus holderStatus = chunkHolder.getCurrentGenStatus();
        if (holderStatus != null && holderStatus.b(requiredStatus)) {
            return false;
        }
        if (chunkHolder.hasFailedGeneration()) {
            return true;
        }
        center.addGenerationBlockingNeighbour(chunkHolder);
        chunkHolder.addWaitingNeighbour(center, requiredStatus);
        if (chunkHolder.upgradeGenTarget(requiredStatus)) {
            return true;
        }
        this.schedule(chunkX, chunkZ, requiredStatus, chunkHolder, tasks, minPriority);
        return true;
    }

    @Deprecated
    public PrioritisedExecutor.PrioritisedTask scheduleChunkTask(Runnable run) {
        return this.scheduleChunkTask(run, PrioritisedExecutor.Priority.NORMAL);
    }

    @Deprecated
    public PrioritisedExecutor.PrioritisedTask scheduleChunkTask(Runnable run, PrioritisedExecutor.Priority priority) {
        return this.mainThreadExecutor.queueRunnable(run, priority);
    }

    public PrioritisedExecutor.PrioritisedTask createChunkTask(int chunkX, int chunkZ, Runnable run) {
        return this.createChunkTask(chunkX, chunkZ, run, PrioritisedExecutor.Priority.NORMAL);
    }

    public PrioritisedExecutor.PrioritisedTask createChunkTask(int chunkX, int chunkZ, Runnable run, PrioritisedExecutor.Priority priority) {
        return this.mainThreadExecutor.createTask(run, priority);
    }

    public PrioritisedExecutor.PrioritisedTask scheduleChunkTask(int chunkX, int chunkZ, Runnable run) {
        return this.mainThreadExecutor.queueRunnable(run);
    }

    public PrioritisedExecutor.PrioritisedTask scheduleChunkTask(int chunkX, int chunkZ, Runnable run, PrioritisedExecutor.Priority priority) {
        return this.mainThreadExecutor.queueRunnable(run, priority);
    }

    public void executeTasksUntil(BooleanSupplier exit) {
        if (Bukkit.isPrimaryThread()) {
            this.mainThreadExecutor.executeConditionally(exit);
        } else {
            long counter = 1L;
            while (!exit.getAsBoolean()) {
                counter = ConcurrentUtil.linearLongBackoff(counter, 100000L, 5000000L);
            }
        }
    }

    public boolean halt(boolean sync, long maxWaitNS) {
        this.lightExecutor.halt();
        this.genExecutor.halt();
        this.parallelGenExecutor.halt();
        this.loadExecutor.halt();
        long time = System.nanoTime();
        if (sync) {
            long failures = 9L;
            while (true) {
                if (!(this.lightExecutor.isActive() || this.genExecutor.isActive() || this.parallelGenExecutor.isActive() || this.loadExecutor.isActive())) {
                    return true;
                }
                if (System.nanoTime() - time >= maxWaitNS) {
                    return false;
                }
                failures = ConcurrentUtil.linearLongBackoff(failures, 500000L, 50000000L);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushChunkWait(WorldServer world, int chunkX, int chunkZ) {
        ArrayDeque<ChunkInfo> arrayDeque = WAITING_CHUNKS;
        synchronized (arrayDeque) {
            WAITING_CHUNKS.push(new ChunkInfo(chunkX, chunkZ, world));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void popChunkWait() {
        ArrayDeque<ChunkInfo> arrayDeque = WAITING_CHUNKS;
        synchronized (arrayDeque) {
            WAITING_CHUNKS.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChunkInfo[] getChunkInfos() {
        ArrayDeque<ChunkInfo> arrayDeque = WAITING_CHUNKS;
        synchronized (arrayDeque) {
            return WAITING_CHUNKS.toArray(new ChunkInfo[0]);
        }
    }

    public static void dumpAllChunkLoadInfo(boolean longPrint) {
        ChunkInfo[] chunkInfos = ChunkTaskScheduler.getChunkInfos();
        if (chunkInfos.length > 0) {
            LOGGER.error("Chunk wait task info below: ");
            for (ChunkInfo chunkInfo : chunkInfos) {
                NewChunkHolder holder = chunkInfo.world.chunkTaskScheduler.chunkHolderManager.getChunkHolder(chunkInfo.chunkX, chunkInfo.chunkZ);
                LOGGER.error("Chunk wait: " + chunkInfo);
                LOGGER.error("Chunk holder: " + holder);
            }
            if (longPrint) {
                File file = new File(new File(new File("."), "debug"), "chunks-watchdog.txt");
                LOGGER.error("Writing chunk information dump to " + file);
                try {
                    MCUtil.dumpChunks(file, true);
                    LOGGER.error("Successfully written chunk information!");
                }
                catch (Throwable thr) {
                    MinecraftServer.n.warn("Failed to dump chunk information to file " + file.toString(), thr);
                }
            }
        }
    }

    static {
        initialised = false;
        ChunkStatus.c.writeRadius = 0;
        ChunkStatus.d.writeRadius = 0;
        ChunkStatus.e.writeRadius = 0;
        ChunkStatus.f.writeRadius = 0;
        ChunkStatus.g.writeRadius = 0;
        ChunkStatus.h.writeRadius = 0;
        ChunkStatus.i.writeRadius = 0;
        ChunkStatus.j.writeRadius = 0;
        ChunkStatus.k.writeRadius = 1;
        ChunkStatus.l.writeRadius = 1;
        ChunkStatus.m.writeRadius = 0;
        ChunkStatus.n.writeRadius = 0;
        ChunkStatus.o.writeRadius = 0;
        List<ChunkStatus> parallelCapableStatus = Arrays.asList(ChunkStatus.c, ChunkStatus.d, ChunkStatus.e, ChunkStatus.f, ChunkStatus.g, ChunkStatus.h, ChunkStatus.i, ChunkStatus.j, ChunkStatus.n);
        for (ChunkStatus status : parallelCapableStatus) {
            status.isParallelCapable = true;
        }
        WAITING_CHUNKS = new ArrayDeque();
    }

    public static final class ChunkInfo {
        public final int chunkX;
        public final int chunkZ;
        public final WorldServer world;

        public ChunkInfo(int chunkX, int chunkZ, WorldServer world) {
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.world = world;
        }

        public String toString() {
            return "[( " + this.chunkX + "," + this.chunkZ + ") in '" + this.world.getWorld().getName() + "']";
        }
    }
}

