/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.subcommands;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.command.PaperSubcommand;
import java.util.Objects;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DumpItemCommand
implements PaperSubcommand {
    @Override
    public boolean execute(CommandSender sender, String subCommand, String[] args) {
        this.doDumpItem(sender);
        return true;
    }

    private void doDumpItem(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command");
            return;
        }
        ItemStack itemStack = CraftItemStack.asNMSCopy(((CraftPlayer)sender).getItemInHand());
        @Nullable NBTTagCompound tag = itemStack.u();
        @Nullable Component nbtComponent = tag == null ? null : PaperAdventure.asAdventure(GameProfileSerializer.c((NBTBase)tag));
        String itemId = Objects.requireNonNull(((CraftWorld)((CraftPlayer)sender).getWorld()).getHandle().u_().d(Registries.C).b(itemStack.c())).toString();
        BuildableComponent message = ((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)itemId, (TextColor)NamedTextColor.YELLOW))).apply(b2 -> {
            if (nbtComponent != null) {
                b2.append(nbtComponent);
            }
        })).build();
        Bukkit.getConsoleSender().sendMessage((Component)message);
        sender.sendMessage((Component)message);
        sender.sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("    Click to copy item to clipboard").color((TextColor)NamedTextColor.GRAY)).decorate(TextDecoration.ITALIC)).clickEvent(ClickEvent.copyToClipboard((String)(tag == null ? itemId : itemId + tag))));
    }
}

