/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.ConfigurationPart;
import io.papermc.paper.configuration.Configurations;
import io.papermc.paper.configuration.MergeMap;
import io.papermc.paper.configuration.NestedSetting;
import io.papermc.paper.configuration.constraint.Constraint;
import io.papermc.paper.configuration.constraint.Constraints;
import io.papermc.paper.configuration.legacy.MaxEntityCollisionsInitializer;
import io.papermc.paper.configuration.legacy.RequiresSpigotInitialization;
import io.papermc.paper.configuration.legacy.SpawnLoadedRangeInitializer;
import io.papermc.paper.configuration.serializer.NbtPathSerializer;
import io.papermc.paper.configuration.type.BooleanOrDefault;
import io.papermc.paper.configuration.type.DoubleOrDefault;
import io.papermc.paper.configuration.type.Duration;
import io.papermc.paper.configuration.type.EngineMode;
import io.papermc.paper.configuration.type.IntOr;
import io.papermc.paper.configuration.type.fallback.ArrowDespawnRate;
import io.papermc.paper.configuration.type.fallback.AutosavePeriod;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import org.slf4j.Logger;
import org.spigotmc.SpigotWorldConfig;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Required;
import org.spongepowered.configurate.objectmapping.meta.Setting;

public class WorldConfiguration
extends ConfigurationPart {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    static final int CURRENT_VERSION = 30;
    private final transient SpigotWorldConfig spigotConfig;
    private final transient MinecraftKey worldKey;
    @Setting(value="_version")
    public int version = 30;
    public Anticheat anticheat;
    public Entities entities;
    public Lootables lootables;
    public MaxGrowthHeight maxGrowthHeight;
    public Scoreboards scoreboards;
    public Environment environment;
    public Spawn spawn;
    public Maps maps;
    public Fixes fixes;
    public UnsupportedSettings unsupportedSettings;
    public Hopper hopper;
    public Collisions collisions;
    public Chunks chunks;
    public FishingTimeRange fishingTimeRange;
    public TickRates tickRates;
    @Setting(value="feature-seeds")
    public FeatureSeeds featureSeeds;
    public Misc misc;

    WorldConfiguration(SpigotWorldConfig spigotConfig, MinecraftKey worldKey) {
        this.spigotConfig = spigotConfig;
        this.worldKey = worldKey;
    }

    public boolean isDefault() {
        return this.worldKey.equals(Configurations.WORLD_DEFAULTS_KEY);
    }

    public class Misc
    extends ConfigurationPart {
        public int lightQueueSize = 20;
        public boolean updatePathfindingOnBlockUpdate = true;
        public boolean showSignClickCommandFailureMsgsToPlayer = false;
        public RedstoneImplementation redstoneImplementation = RedstoneImplementation.VANILLA;
        public boolean disableEndCredits = false;
        public float maxLeashDistance = 10.0f;
        public boolean disableSprintInterruptionOnAttack = false;
        public int shieldBlockingDelay = 5;
        public boolean disableRelativeProjectileVelocity = false;

        public static enum RedstoneImplementation {
            VANILLA,
            EIGENCRAFT,
            ALTERNATE_CURRENT;

        }
    }

    public class FeatureSeeds
    extends ConfigurationPart.Post {
        @Setting(value="generate-random-seeds-for-all")
        public boolean generateRandomSeedsForAll = false;
        @Setting(value="features")
        public Reference2LongMap<Holder<WorldGenFeatureConfigured<?, ?>>> features = new Reference2LongOpenHashMap();

        @Override
        public void postProcess() {
            this.features.defaultReturnValue(-1L);
        }
    }

    public class TickRates
    extends ConfigurationPart {
        public int grassSpread = 1;
        public int containerUpdate = 1;
        public int mobSpawner = 1;
        public Table<EntityTypes<?>, String, Integer> sensor = (Table)SystemUtils.a(HashBasedTable.create(), table -> table.put(EntityTypes.bf, (Object)"secondarypoisensor", (Object)40));
        public Table<EntityTypes<?>, String, Integer> behavior = (Table)SystemUtils.a(HashBasedTable.create(), table -> table.put(EntityTypes.bf, (Object)"validatenearbypoi", (Object)-1));
    }

    public class FishingTimeRange
    extends ConfigurationPart {
        public int minimum = 100;
        public int maximum = 600;
    }

    public class Chunks
    extends ConfigurationPart {
        public AutosavePeriod autoSaveInterval = AutosavePeriod.def();
        public int maxAutoSaveChunksPerTick = 24;
        public int fixedChunkInhabitedTime = -1;
        public boolean preventMovingIntoUnloadedChunks = false;
        public Duration delayChunkUnloadsBy = Duration.of("10s");
        public Reference2IntMap<EntityTypes<?>> entityPerChunkSaveLimit = (Reference2IntMap)SystemUtils.a(new Reference2IntOpenHashMap(BuiltInRegistries.h.b()), map -> {
            map.defaultReturnValue(-1);
            map.put(EntityTypes.J, -1);
            map.put(EntityTypes.aP, -1);
            map.put(EntityTypes.D, -1);
            map.put(EntityTypes.e, -1);
            map.put(EntityTypes.ag, -1);
            map.put(EntityTypes.aM, -1);
        });
        public boolean flushRegionsOnSave = false;
    }

    public class Collisions
    extends ConfigurationPart {
        public boolean onlyPlayersCollide = false;
        public boolean allowVehicleCollisions = true;
        public boolean fixClimbingBypassingCrammingRule = false;
        @RequiresSpigotInitialization(value=MaxEntityCollisionsInitializer.class)
        public int maxEntityCollisions = 8;
        public boolean allowPlayerCrammingDamage = false;
    }

    public class Hopper
    extends ConfigurationPart {
        public boolean cooldownWhenFull = true;
        public boolean disableMoveEvent = false;
        public boolean ignoreOccludingBlocks = false;
    }

    public class UnsupportedSettings
    extends ConfigurationPart {
        public boolean fixInvulnerableEndCrystalExploit = true;
    }

    public class Fixes
    extends ConfigurationPart {
        public boolean fixItemsMergingThroughWalls = false;
        public boolean disableUnloadedChunkEnderpearlExploit = true;
        public boolean preventTntFromMovingInWater = false;
        public boolean splitOverstackedLoot = true;
        public boolean fixCuringZombieVillagerDiscountExploit = true;
        public IntOr.Disabled fallingBlockHeightNerf = IntOr.Disabled.DISABLED;
        public IntOr.Disabled tntEntityHeightNerf = IntOr.Disabled.DISABLED;
    }

    public class Maps
    extends ConfigurationPart {
        public int itemFrameCursorLimit = 128;
        public int itemFrameCursorUpdateInterval = 10;
    }

    public class Spawn
    extends ConfigurationPart {
        @RequiresSpigotInitialization(value=SpawnLoadedRangeInitializer.class)
        public short keepSpawnLoadedRange = (short)10;
        public boolean keepSpawnLoaded = true;
        public boolean allowUsingSignsInsideSpawnProtection = false;
    }

    public class Environment
    extends ConfigurationPart {
        public boolean disableThunder = false;
        public boolean disableIceAndSnow = false;
        public boolean optimizeExplosions = false;
        public boolean disableExplosionKnockback = false;
        public boolean generateFlatBedrock = false;
        public FrostedIce frostedIce;
        public TreasureMaps treasureMaps;
        public int fireTickDelay = 30;
        public int waterOverLavaFlowSpeed = 5;
        public int portalSearchRadius = 128;
        public int portalCreateRadius = 16;
        public boolean portalSearchVanillaDimensionScaling = true;
        public boolean disableTeleportationSuffocationCheck = false;
        public IntOr.Disabled netherCeilingVoidDamageHeight = IntOr.Disabled.DISABLED;

        public class TreasureMaps
        extends ConfigurationPart {
            public boolean enabled = true;
            @NestedSetting(value={"find-already-discovered", "villager-trade"})
            public boolean findAlreadyDiscoveredVillager = false;
            @NestedSetting(value={"find-already-discovered", "loot-tables"})
            public BooleanOrDefault findAlreadyDiscoveredLootTable = BooleanOrDefault.USE_DEFAULT;
        }

        public class FrostedIce
        extends ConfigurationPart {
            public boolean enabled = true;
            public Delay delay;

            public class Delay
            extends ConfigurationPart {
                public int min = 20;
                public int max = 40;
            }
        }
    }

    public class Scoreboards
    extends ConfigurationPart {
        public boolean allowNonPlayerEntitiesOnScoreboards = true;
        public boolean useVanillaWorldScoreboardNameColoring = false;
    }

    public class MaxGrowthHeight
    extends ConfigurationPart {
        public int cactus = 3;
        public int reeds = 3;
        public Bamboo bamboo;

        public class Bamboo
        extends ConfigurationPart {
            public int max = 16;
            public int min = 11;
        }
    }

    public class Lootables
    extends ConfigurationPart {
        public boolean autoReplenish = false;
        public boolean restrictPlayerReloot = true;
        public boolean resetSeedOnFill = true;
        public int maxRefills = -1;
        public Duration refreshMin = Duration.of("12h");
        public Duration refreshMax = Duration.of("2d");
    }

    public class Entities
    extends ConfigurationPart {
        public boolean entitiesTargetWithFollowRange = false;
        public MobEffects mobEffects;
        public ArmorStands armorStands;
        public Markers markers;
        public Spawning spawning;
        public Behavior behavior;

        public class Behavior
        extends ConfigurationPart {
            public boolean disableChestCatDetection = false;
            public boolean spawnerNerfedMobsShouldJump = false;
            public int experienceMergeMaxValue = -1;
            public boolean shouldRemoveDragon = false;
            public boolean zombiesTargetTurtleEggs = true;
            public boolean piglinsGuardChests = true;
            public double babyZombieMovementModifier = 0.5;
            public boolean allowSpiderWorldBorderClimbing = true;
            public DoorBreakingDifficulty doorBreakingDifficulty;
            public boolean disableCreeperLingeringEffect = false;
            public boolean enderDragonsDeathAlwaysPlacesDragonEgg = false;
            public boolean phantomsDoNotSpawnOnCreativePlayers = true;
            public boolean phantomsOnlyAttackInsomniacs = true;
            public int playerInsomniaStartTicks = 72000;
            public int phantomsSpawnAttemptMinSeconds = 60;
            public int phantomsSpawnAttemptMaxSeconds = 119;
            public boolean parrotsAreUnaffectedByPlayerMovement = false;
            public double zombieVillagerInfectionChance = -1.0;
            public MobsCanAlwaysPickUpLoot mobsCanAlwaysPickUpLoot;
            public boolean disablePlayerCrits = false;
            public boolean nerfPigmenFromNetherPortals = false;
            public PillagerPatrols pillagerPatrols;

            public class PillagerPatrols
            extends ConfigurationPart {
                public boolean disable = false;
                public double spawnChance = 0.2;
                public SpawnDelay spawnDelay;
                public Start start;

                public class Start
                extends ConfigurationPart {
                    public boolean perPlayer = false;
                    public int day = 5;
                }

                public class SpawnDelay
                extends ConfigurationPart {
                    public boolean perPlayer = false;
                    public int ticks = 12000;
                }
            }

            public class MobsCanAlwaysPickUpLoot
            extends ConfigurationPart {
                public boolean zombies = false;
                public boolean skeletons = false;
            }

            public class DoorBreakingDifficulty
            extends ConfigurationPart {
                public List<EnumDifficulty> zombie = Arrays.stream(EnumDifficulty.values()).filter(EntityZombie.bZ).toList();
                public List<EnumDifficulty> husk = Arrays.stream(EnumDifficulty.values()).filter(EntityZombie.bZ).toList();
                @Setting(value="zombie_villager")
                public List<EnumDifficulty> zombieVillager = Arrays.stream(EnumDifficulty.values()).filter(EntityZombie.bZ).toList();
                @Setting(value="zombified_piglin")
                public List<EnumDifficulty> zombified_piglin = Arrays.stream(EnumDifficulty.values()).filter(EntityZombie.bZ).toList();
                public List<EnumDifficulty> vindicator = Arrays.stream(EnumDifficulty.values()).filter(EntityVindicator.e).toList();

                public List<EnumDifficulty> get(EntityTypes<?> type) {
                    return this.getOrDefault(type, null);
                }

                public List<EnumDifficulty> getOrDefault(EntityTypes<?> type, List<EnumDifficulty> fallback) {
                    if (type == EntityTypes.bp) {
                        return this.zombie;
                    }
                    if (type == EntityTypes.Z) {
                        return this.husk;
                    }
                    if (type == EntityTypes.br) {
                        return this.zombieVillager;
                    }
                    if (type == EntityTypes.bs) {
                        return this.zombified_piglin;
                    }
                    if (type == EntityTypes.bg) {
                        return this.vindicator;
                    }
                    return fallback;
                }
            }
        }

        public class Spawning
        extends ConfigurationPart {
            public ArrowDespawnRate nonPlayerArrowDespawnRate;
            public ArrowDespawnRate creativeArrowDespawnRate;
            public boolean filterBadTileEntityNbtFromFallingBlocks;
            public List<ArgumentNBTKey.g> filteredEntityTagNbtPaths;
            public boolean disableMobSpawnerSpawnEggTransformation;
            public boolean perPlayerMobSpawns;
            public boolean scanForLegacyEnderDragon;
            @MergeMap
            public Reference2IntMap<EnumCreatureType> spawnLimits;
            @MergeMap
            public Map<EnumCreatureType, DespawnRange> despawnRanges;
            public WaterAnimalSpawnHeight wateranimalSpawnHeight;
            public SlimeSpawnHeight slimeSpawnHeight;
            public WanderingTrader wanderingTrader;
            public boolean allChunksAreSlimeChunks;
            @Constraint(value=Constraints.BelowZeroDoubleToDefault.class)
            public DoubleOrDefault skeletonHorseThunderSpawnChance;
            public boolean ironGolemsCanSpawnInAir;
            public boolean countAllMobsForSpawning;
            public int monsterSpawnMaxLightLevel;
            public DuplicateUUID duplicateUuid;
            public AltItemDespawnRate altItemDespawnRate;

            public Spawning() {
                this.nonPlayerArrowDespawnRate = ArrowDespawnRate.def(WorldConfiguration.this.spigotConfig);
                this.creativeArrowDespawnRate = ArrowDespawnRate.def(WorldConfiguration.this.spigotConfig);
                this.filterBadTileEntityNbtFromFallingBlocks = true;
                this.filteredEntityTagNbtPaths = NbtPathSerializer.fromString(List.of("Pos", "Motion", "SleepingX", "SleepingY", "SleepingZ"));
                this.disableMobSpawnerSpawnEggTransformation = false;
                this.perPlayerMobSpawns = true;
                this.scanForLegacyEnderDragon = true;
                this.spawnLimits = (Reference2IntMap)SystemUtils.a(new Reference2IntOpenHashMap(SpawnerCreature.f.length), map -> Arrays.stream(SpawnerCreature.f).forEach(mobCategory -> map.put(mobCategory, -1)));
                this.despawnRanges = Arrays.stream(EnumCreatureType.values()).collect(Collectors.toMap(Function.identity(), category -> new DespawnRange(category.g(), category.f())));
                this.allChunksAreSlimeChunks = false;
                this.skeletonHorseThunderSpawnChance = DoubleOrDefault.USE_DEFAULT;
                this.ironGolemsCanSpawnInAir = false;
                this.countAllMobsForSpawning = false;
                this.monsterSpawnMaxLightLevel = -1;
            }

            @ConfigSerializable
            public record DespawnRange(@Required int soft, @Required int hard) {
            }

            public class AltItemDespawnRate
            extends ConfigurationPart {
                public boolean enabled = false;
                public Reference2IntMap<Item> items = new Reference2IntOpenHashMap(Map.of(Items.w, 300));
            }

            public class DuplicateUUID
            extends ConfigurationPart {
                public DuplicateUUIDMode mode = DuplicateUUIDMode.SAFE_REGEN;
                public int safeRegenDeleteRange = 32;

                public static enum DuplicateUUIDMode {
                    SAFE_REGEN,
                    DELETE,
                    NOTHING,
                    WARN;

                }
            }

            public class WanderingTrader
            extends ConfigurationPart {
                public int spawnMinuteLength = 1200;
                public int spawnDayLength = 24000;
                public int spawnChanceFailureIncrement = 25;
                public int spawnChanceMin = 25;
                public int spawnChanceMax = 75;
            }

            public class SlimeSpawnHeight
            extends ConfigurationPart {
                public SurfaceSpawnableSlimeBiome surfaceBiome;
                public SlimeChunk slimeChunk;

                public class SlimeChunk
                extends ConfigurationPart {
                    public double maximum = 40.0;
                }

                public class SurfaceSpawnableSlimeBiome
                extends ConfigurationPart {
                    public double maximum = 70.0;
                    public double minimum = 50.0;
                }
            }

            public class WaterAnimalSpawnHeight
            extends ConfigurationPart {
                public IntOr.Default maximum = IntOr.Default.USE_DEFAULT;
                public IntOr.Default minimum = IntOr.Default.USE_DEFAULT;
            }
        }

        public class Markers
        extends ConfigurationPart {
            public boolean tick = true;
        }

        public class ArmorStands
        extends ConfigurationPart {
            public boolean doCollisionEntityLookups = true;
            public boolean tick = true;
        }

        public class MobEffects
        extends ConfigurationPart {
            public boolean undeadImmuneToCertainEffects = true;
            public boolean spidersImmuneToPoisonEffect = true;
            public ImmuneToWitherEffect immuneToWitherEffect;

            public class ImmuneToWitherEffect
            extends ConfigurationPart {
                public boolean wither = true;
                public boolean witherSkeleton = true;
            }
        }
    }

    public class Anticheat
    extends ConfigurationPart {
        public Obfuscation obfuscation;
        public AntiXray antiXray;

        public class AntiXray
        extends ConfigurationPart {
            public boolean enabled = false;
            public EngineMode engineMode = EngineMode.HIDE;
            public int maxBlockHeight = 64;
            public int updateRadius = 2;
            public boolean lavaObscures = false;
            public boolean usePermission = false;
            public List<String> hiddenBlocks = List.of("copper_ore", "deepslate_copper_ore", "gold_ore", "deepslate_gold_ore", "iron_ore", "deepslate_iron_ore", "coal_ore", "deepslate_coal_ore", "lapis_ore", "deepslate_lapis_ore", "mossy_cobblestone", "obsidian", "chest", "diamond_ore", "deepslate_diamond_ore", "redstone_ore", "deepslate_redstone_ore", "clay", "emerald_ore", "deepslate_emerald_ore", "ender_chest");
            public List<String> replacementBlocks = List.of("stone", "oak_planks", "deepslate");
        }

        public class Obfuscation
        extends ConfigurationPart {
            public Items items = new Items();

            public class Items
            extends ConfigurationPart {
                public boolean hideItemmeta = false;
                public boolean hideDurability = false;
                public boolean hideItemmetaWithVisualEffects = false;
            }
        }
    }
}

