/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.serializer.registry;

import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

abstract class RegistryEntrySerializer<T, R>
extends ScalarSerializer<T> {
    private final ResourceKey<? extends IRegistry<R>> registryKey;
    private final boolean omitMinecraftNamespace;

    protected RegistryEntrySerializer(TypeToken<T> type, ResourceKey<? extends IRegistry<R>> registryKey, boolean omitMinecraftNamespace) {
        super(type);
        this.registryKey = registryKey;
        this.omitMinecraftNamespace = omitMinecraftNamespace;
    }

    protected RegistryEntrySerializer(Class<T> type, ResourceKey<? extends IRegistry<R>> registryKey, boolean omitMinecraftNamespace) {
        super(type);
        this.registryKey = registryKey;
        this.omitMinecraftNamespace = omitMinecraftNamespace;
    }

    protected final IRegistry<R> registry() {
        return MinecraftServer.getServer().aX().d(this.registryKey);
    }

    protected abstract T convertFromResourceKey(ResourceKey<R> var1) throws SerializationException;

    public final T deserialize(Type type, Object obj) throws SerializationException {
        return this.convertFromResourceKey(this.deserializeKey(obj));
    }

    protected abstract ResourceKey<R> convertToResourceKey(T var1);

    protected final Object serialize(T item, Predicate<Class<?>> typeSupported) {
        ResourceKey<R> key = this.convertToResourceKey(item);
        if (this.omitMinecraftNamespace && key.a().b().equals("minecraft")) {
            return key.a().a();
        }
        return key.a().toString();
    }

    private ResourceKey<R> deserializeKey(Object input) throws SerializationException {
        @Nullable MinecraftKey key = MinecraftKey.a(input.toString());
        if (key == null) {
            throw new SerializationException("Could not create a key from " + input);
        }
        return ResourceKey.a(this.registryKey, key);
    }
}

