/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.type;

import java.lang.reflect.Type;
import java.util.OptionalDouble;
import java.util.function.Predicate;
import org.apache.commons.lang3.math.NumberUtils;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;

public final class DoubleOrDefault {
    private static final String DEFAULT_VALUE = "default";
    public static final DoubleOrDefault USE_DEFAULT = new DoubleOrDefault(OptionalDouble.empty());
    public static final ScalarSerializer<DoubleOrDefault> SERIALIZER = new Serializer();
    private OptionalDouble value;

    public DoubleOrDefault(OptionalDouble value) {
        this.value = value;
    }

    public OptionalDouble value() {
        return this.value;
    }

    public void value(OptionalDouble value) {
        this.value = value;
    }

    public double or(double fallback) {
        return this.value.orElse(fallback);
    }

    private static final class Serializer
    extends ScalarSerializer<DoubleOrDefault> {
        Serializer() {
            super(DoubleOrDefault.class);
        }

        public DoubleOrDefault deserialize(Type type, Object obj) throws SerializationException {
            if (obj instanceof String) {
                String string = (String)obj;
                if (DoubleOrDefault.DEFAULT_VALUE.equalsIgnoreCase(string)) {
                    return USE_DEFAULT;
                }
                if (NumberUtils.isParsable((String)string)) {
                    return new DoubleOrDefault(OptionalDouble.of(Double.parseDouble(string)));
                }
            } else if (obj instanceof Number) {
                Number num = (Number)obj;
                return new DoubleOrDefault(OptionalDouble.of(num.doubleValue()));
            }
            throw new SerializationException(obj + "(" + type + ") is not a double or 'default'");
        }

        protected Object serialize(DoubleOrDefault item, Predicate<Class<?>> typeSupported) {
            OptionalDouble value = item.value();
            if (value.isPresent()) {
                return value.getAsDouble();
            }
            return DoubleOrDefault.DEFAULT_VALUE;
        }
    }
}

