/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.bootstrap;

import io.papermc.paper.plugin.PluginInitializerManager;
import io.papermc.paper.plugin.bootstrap.PluginProviderContext;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.provider.PluginProvider;
import java.nio.file.Path;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.jetbrains.annotations.NotNull;

public record PluginProviderContextImpl(PluginMeta config, Path dataFolder, ComponentLogger logger, Path pluginSource) implements PluginProviderContext
{
    public static PluginProviderContextImpl of(PluginMeta config, ComponentLogger logger, Path pluginSource) {
        Path dataFolder = PluginInitializerManager.instance().pluginDirectoryPath().resolve(config.getName());
        return new PluginProviderContextImpl(config, dataFolder, logger, pluginSource);
    }

    public static PluginProviderContextImpl of(PluginProvider<?> provider, Path pluginFolder) {
        Path dataFolder = pluginFolder.resolve(provider.getMeta().getName());
        return new PluginProviderContextImpl(provider.getMeta(), dataFolder, provider.getLogger(), provider.getSource());
    }

    @NotNull
    public PluginMeta getConfiguration() {
        return this.config;
    }

    @NotNull
    public Path getDataDirectory() {
        return this.dataFolder;
    }

    @NotNull
    public ComponentLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public Path getPluginSource() {
        return this.pluginSource;
    }
}

