/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.entrypoint.dependency;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.provider.PluginProvider;
import io.papermc.paper.plugin.provider.entrypoint.DependencyContext;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MetaDependencyTree
implements DependencyContext {
    private final MutableGraph<String> graph;
    private final Set<String> dependencies = new HashSet<String>();

    public MetaDependencyTree() {
        this((MutableGraph<String>)GraphBuilder.directed().build());
    }

    public MetaDependencyTree(MutableGraph<String> graph) {
        this.graph = graph;
    }

    public void add(PluginProvider<?> provider) {
        this.add(provider.getMeta());
    }

    public void remove(PluginProvider<?> provider) {
        this.remove(provider.getMeta());
    }

    public void add(PluginMeta configuration) {
        String identifier = configuration.getName();
        for (String dependency : configuration.getPluginDependencies()) {
            this.graph.putEdge((Object)identifier, (Object)dependency);
        }
        for (String dependency : configuration.getPluginSoftDependencies()) {
            this.graph.putEdge((Object)identifier, (Object)dependency);
        }
        this.graph.addNode((Object)identifier);
        for (String provides : configuration.getProvidedPlugins()) {
            this.graph.putEdge((Object)identifier, (Object)provides);
            this.dependencies.add(provides);
        }
        this.dependencies.add(identifier);
    }

    public void remove(PluginMeta configuration) {
        String identifier = configuration.getName();
        for (String dependency : configuration.getPluginDependencies()) {
            this.graph.removeEdge((Object)identifier, (Object)dependency);
        }
        for (String dependency : configuration.getPluginSoftDependencies()) {
            this.graph.removeEdge((Object)identifier, (Object)dependency);
        }
        this.graph.removeNode((Object)identifier);
        for (String provides : configuration.getProvidedPlugins()) {
            this.graph.removeEdge((Object)identifier, (Object)provides);
            this.dependencies.remove(provides);
        }
        this.dependencies.remove(identifier);
    }

    public boolean isTransitiveDependency(@NotNull PluginMeta plugin, @NotNull PluginMeta depend) {
        String pluginIdentifier = plugin.getName();
        if (this.graph.nodes().contains(pluginIdentifier)) {
            Set reachableNodes = Graphs.reachableNodes(this.graph, (Object)pluginIdentifier);
            if (reachableNodes.contains(depend.getName())) {
                return true;
            }
            for (String provided : depend.getProvidedPlugins()) {
                if (!reachableNodes.contains(provided)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasDependency(@NotNull String pluginIdentifier) {
        return this.dependencies.contains(pluginIdentifier);
    }

    public void addDirectDependency(String dependency) {
        this.dependencies.add(dependency);
    }

    public String toString() {
        return "ProviderDependencyTree{graph=" + this.graph + "}";
    }

    public MutableGraph<String> getGraph() {
        return this.graph;
    }
}

