/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.manager;

import com.destroystokyo.paper.event.server.ServerExceptionEvent;
import com.destroystokyo.paper.exception.ServerException;
import com.destroystokyo.paper.exception.ServerPluginEnableDisableException;
import com.google.common.base.Preconditions;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.entrypoint.Entrypoint;
import io.papermc.paper.plugin.entrypoint.EntrypointHandler;
import io.papermc.paper.plugin.entrypoint.dependency.MetaDependencyTree;
import io.papermc.paper.plugin.entrypoint.strategy.PluginGraphCycleException;
import io.papermc.paper.plugin.manager.MultiRuntimePluginProviderStorage;
import io.papermc.paper.plugin.manager.RuntimePluginEntrypointHandler;
import io.papermc.paper.plugin.manager.SingularRuntimePluginProviderStorage;
import io.papermc.paper.plugin.provider.classloader.ConfiguredPluginClassLoader;
import io.papermc.paper.plugin.provider.classloader.PaperClassLoaderStorage;
import io.papermc.paper.plugin.provider.source.DirectoryProviderSource;
import io.papermc.paper.plugin.provider.source.FileProviderSource;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommandYamlParser;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftMagicNumbers;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.UnknownDependencyException;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.serialize.SerializationException;

class PaperPluginInstanceManager {
    private static final FileProviderSource FILE_PROVIDER_SOURCE = new FileProviderSource(arg_0 -> PaperPluginInstanceManager.lambda$static$0("File '%s'", arg_0));
    private static final DirectoryProviderSource DIRECTORY_PROVIDER_SOURCE = new DirectoryProviderSource();
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private final Map<String, Plugin> lookupNames = new HashMap<String, Plugin>();
    private final PluginManager pluginManager;
    private final CommandMap commandMap;
    private final Server server;
    private final MetaDependencyTree dependencyTree = new MetaDependencyTree((MutableGraph<String>)GraphBuilder.directed().build());

    public PaperPluginInstanceManager(PluginManager pluginManager, CommandMap commandMap, Server server) {
        this.commandMap = commandMap;
        this.server = server;
        this.pluginManager = pluginManager;
    }

    @Nullable
    public Plugin getPlugin(@NotNull String name) {
        return this.lookupNames.get(name.replace(' ', '_').toLowerCase(Locale.ENGLISH));
    }

    @NotNull
    public Plugin[] getPlugins() {
        return this.plugins.toArray(new Plugin[0]);
    }

    public boolean isPluginEnabled(@NotNull String name) {
        Plugin plugin = this.getPlugin(name);
        return this.isPluginEnabled(plugin);
    }

    public synchronized boolean isPluginEnabled(@Nullable Plugin plugin) {
        if (plugin != null && this.plugins.contains(plugin)) {
            return plugin.isEnabled();
        }
        return false;
    }

    public void loadPlugin(Plugin provided) {
        PluginMeta configuration = provided.getPluginMeta();
        this.plugins.add(provided);
        this.lookupNames.put(configuration.getName().toLowerCase(Locale.ENGLISH), provided);
        for (String providedPlugin : configuration.getProvidedPlugins()) {
            this.lookupNames.putIfAbsent(providedPlugin.toLowerCase(Locale.ENGLISH), provided);
        }
        this.dependencyTree.add(configuration);
    }

    @Nullable
    public Plugin loadPlugin(@NotNull Path path) throws InvalidPluginException, UnknownDependencyException {
        RuntimePluginEntrypointHandler<SingularRuntimePluginProviderStorage> runtimePluginEntrypointHandler = new RuntimePluginEntrypointHandler<SingularRuntimePluginProviderStorage>(new SingularRuntimePluginProviderStorage(this.dependencyTree));
        try {
            FILE_PROVIDER_SOURCE.registerProviders((EntrypointHandler)runtimePluginEntrypointHandler, path);
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
        catch (PluginGraphCycleException exception) {
            throw new InvalidPluginException("Cannot import plugin that causes cyclic dependencies!");
        }
        catch (InvalidDescriptionException | SerializationException ex) {
            throw new InvalidPluginException(ex);
        }
        catch (Exception e2) {
            throw new InvalidPluginException((Throwable)e2);
        }
        try {
            runtimePluginEntrypointHandler.enter(Entrypoint.PLUGIN);
        }
        catch (Throwable e3) {
            throw new InvalidPluginException(e3);
        }
        return (Plugin)runtimePluginEntrypointHandler.getPluginProviderStorage().getSingleLoaded().orElseThrow(() -> new InvalidPluginException("Plugin didn't load any plugin providers?"));
    }

    @NotNull
    public Plugin[] loadPlugins(@NotNull Path directory) {
        Preconditions.checkArgument((boolean)Files.isDirectory(directory, new LinkOption[0]), (Object)"Directory must be a directory");
        RuntimePluginEntrypointHandler<MultiRuntimePluginProviderStorage> runtimePluginEntrypointHandler = new RuntimePluginEntrypointHandler<MultiRuntimePluginProviderStorage>(new MultiRuntimePluginProviderStorage(this.dependencyTree));
        try {
            DIRECTORY_PROVIDER_SOURCE.registerProviders((EntrypointHandler)runtimePluginEntrypointHandler, directory);
            runtimePluginEntrypointHandler.enter(Entrypoint.PLUGIN);
        }
        catch (Exception e2) {
            this.server.getLogger().log(Level.SEVERE, "Unknown error occurred while loading plugins through PluginManager.", e2);
        }
        return (Plugin[])runtimePluginEntrypointHandler.getPluginProviderStorage().getLoaded().toArray(new JavaPlugin[0]);
    }

    public void disablePlugins() {
        Plugin[] plugins = this.getPlugins();
        for (int i2 = plugins.length - 1; i2 >= 0; --i2) {
            this.disablePlugin(plugins[i2]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPlugins() {
        PaperPluginInstanceManager paperPluginInstanceManager = this;
        synchronized (paperPluginInstanceManager) {
            this.disablePlugins();
            this.plugins.clear();
            this.lookupNames.clear();
        }
    }

    public synchronized void enablePlugin(@NotNull Plugin plugin) {
        List bukkitCommands;
        if (plugin.isEnabled()) {
            return;
        }
        if (plugin.getPluginMeta() instanceof PluginDescriptionFile && !(bukkitCommands = PluginCommandYamlParser.parse((Plugin)plugin)).isEmpty()) {
            this.commandMap.registerAll(plugin.getPluginMeta().getName(), bukkitCommands);
        }
        try {
            PluginDescriptionFile descriptionFile;
            String enableMsg = "Enabling " + plugin.getPluginMeta().getDisplayName();
            PluginMeta pluginMeta = plugin.getPluginMeta();
            if (pluginMeta instanceof PluginDescriptionFile && CraftMagicNumbers.isLegacy(descriptionFile = (PluginDescriptionFile)pluginMeta)) {
                enableMsg = enableMsg + "*";
            }
            plugin.getLogger().info(enableMsg);
            JavaPlugin jPlugin = (JavaPlugin)plugin;
            ClassLoader classLoader = jPlugin.getClass().getClassLoader();
            if (classLoader instanceof ConfiguredPluginClassLoader) {
                ConfiguredPluginClassLoader classLoader2 = (ConfiguredPluginClassLoader)classLoader;
                if (PaperClassLoaderStorage.instance().registerUnsafePlugin(classLoader2)) {
                    this.server.getLogger().log(Level.WARNING, "Enabled plugin with unregistered ConfiguredPluginClassLoader " + plugin.getPluginMeta().getDisplayName());
                }
            }
            try {
                jPlugin.setEnabled(true);
            }
            catch (Throwable ex) {
                this.server.getLogger().log(Level.SEVERE, "Error occurred while enabling " + plugin.getPluginMeta().getDisplayName() + " (Is it up to date?)", ex);
                this.server.getPluginManager().disablePlugin((Plugin)jPlugin);
                return;
            }
            this.server.getPluginManager().callEvent((Event)new PluginEnableEvent(plugin));
        }
        catch (Throwable ex) {
            this.handlePluginException("Error occurred (in the plugin loader) while enabling " + plugin.getPluginMeta().getDisplayName() + " (Is it up to date?)", ex, plugin);
        }
        HandlerList.bakeAll();
    }

    public synchronized void disablePlugin(@NotNull Plugin plugin) {
        String pluginName;
        block17: {
            if (!(plugin instanceof JavaPlugin)) {
                throw new IllegalArgumentException("Only expects java plugins.");
            }
            JavaPlugin javaPlugin = (JavaPlugin)plugin;
            if (!plugin.isEnabled()) {
                return;
            }
            pluginName = plugin.getPluginMeta().getDisplayName();
            try {
                plugin.getLogger().info("Disabling %s".formatted(pluginName));
                this.server.getPluginManager().callEvent((Event)new PluginDisableEvent(plugin));
                javaPlugin.setEnabled(false);
                ClassLoader classLoader = plugin.getClass().getClassLoader();
                if (!(classLoader instanceof ConfiguredPluginClassLoader)) break block17;
                ConfiguredPluginClassLoader configuredPluginClassLoader = (ConfiguredPluginClassLoader)classLoader;
                try {
                    configuredPluginClassLoader.close();
                }
                catch (IOException ex) {
                    this.server.getLogger().log(Level.WARNING, "Error closing the classloader for '" + pluginName + "'", ex);
                }
                PaperClassLoaderStorage.instance().unregisterClassloader(configuredPluginClassLoader);
            }
            catch (Throwable ex) {
                this.handlePluginException("Error occurred (in the plugin loader) while disabling " + pluginName + " (Is it up to date?)", ex, plugin);
            }
        }
        try {
            this.server.getScheduler().cancelTasks(plugin);
        }
        catch (Throwable ex) {
            this.handlePluginException("Error occurred (in the plugin loader) while cancelling tasks for " + pluginName + " (Is it up to date?)", ex, plugin);
        }
        try {
            this.server.getServicesManager().unregisterAll(plugin);
        }
        catch (Throwable ex) {
            this.handlePluginException("Error occurred (in the plugin loader) while unregistering services for " + pluginName + " (Is it up to date?)", ex, plugin);
        }
        try {
            HandlerList.unregisterAll((Plugin)plugin);
        }
        catch (Throwable ex) {
            this.handlePluginException("Error occurred (in the plugin loader) while unregistering events for " + pluginName + " (Is it up to date?)", ex, plugin);
        }
        try {
            this.server.getMessenger().unregisterIncomingPluginChannel(plugin);
            this.server.getMessenger().unregisterOutgoingPluginChannel(plugin);
        }
        catch (Throwable ex) {
            this.handlePluginException("Error occurred (in the plugin loader) while unregistering plugin channels for " + pluginName + " (Is it up to date?)", ex, plugin);
        }
        try {
            for (World world : this.server.getWorlds()) {
                world.removePluginChunkTickets(plugin);
            }
        }
        catch (Throwable ex) {
            this.handlePluginException("Error occurred (in the plugin loader) while removing chunk tickets for " + pluginName + " (Is it up to date?)", ex, plugin);
        }
    }

    private void handlePluginException(String msg, Throwable ex, Plugin plugin) {
        Bukkit.getServer().getLogger().log(Level.SEVERE, msg, ex);
        this.pluginManager.callEvent((Event)new ServerExceptionEvent((ServerException)new ServerPluginEnableDisableException(msg, ex, plugin)));
    }

    public boolean isTransitiveDepend(@NotNull PluginMeta plugin, @NotNull PluginMeta depend) {
        return this.dependencyTree.isTransitiveDependency(plugin, depend);
    }

    public boolean hasDependency(String pluginIdentifier) {
        return this.getPlugin(pluginIdentifier) != null;
    }

    @ApiStatus.Internal
    public MutableGraph<String> getDependencyGraph() {
        return this.dependencyTree.getGraph();
    }

    private static /* synthetic */ String lambda$static$0(String rec$, Object xva$0) {
        return "File '%s'".formatted(xva$0);
    }
}

