/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.provider.type.paper;

import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.provider.configuration.LoadOrderConfiguration;
import io.papermc.paper.plugin.provider.configuration.PaperPluginMeta;
import io.papermc.paper.plugin.provider.configuration.type.LoadConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PaperBootstrapOrderConfiguration
implements LoadOrderConfiguration {
    private final PaperPluginMeta paperPluginMeta;
    private final List<String> loadBefore = new ArrayList<String>();
    private final List<String> loadAfter = new ArrayList<String>();

    public PaperBootstrapOrderConfiguration(PaperPluginMeta paperPluginMeta) {
        this.paperPluginMeta = paperPluginMeta;
        for (LoadConfiguration configuration : paperPluginMeta.getLoadAfter()) {
            if (!configuration.bootstrap()) continue;
            this.loadAfter.add(configuration.name());
        }
        for (LoadConfiguration configuration : paperPluginMeta.getLoadBefore()) {
            if (!configuration.bootstrap()) continue;
            this.loadBefore.add(configuration.name());
        }
    }

    @Override
    @NotNull
    public List<String> getLoadBefore() {
        return this.loadBefore;
    }

    @Override
    @NotNull
    public List<String> getLoadAfter() {
        return this.loadAfter;
    }

    @Override
    @NotNull
    public PluginMeta getMeta() {
        return this.paperPluginMeta;
    }
}

