/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import io.papermc.paper.util.CachedLists;
import io.papermc.paper.util.WorldUtil;
import io.papermc.paper.voxel.AABBVoxelShape;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.IEntityAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeArray;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapeCollisionEntity;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_19_R3.util.UnsafeList;

public final class CollisionUtil {
    public static final double COLLISION_EPSILON = 1.0E-7;
    public static final long KNOWN_EMPTY_BLOCK = 0L;
    public static final long KNOWN_FULL_BLOCK = 1L;
    public static final long KNOWN_UNKNOWN_BLOCK = 2L;
    public static final long KNOWN_SPECIAL_BLOCK = 3L;

    public static boolean isSpecialCollidingBlock(BlockBase.BlockData block) {
        return block.shapeExceedsCube() || block.b() == Blocks.bP;
    }

    public static boolean isEmpty(AxisAlignedBB aabb) {
        return aabb.d - aabb.a < 1.0E-7 && aabb.e - aabb.b < 1.0E-7 && aabb.f - aabb.c < 1.0E-7;
    }

    public static boolean isEmpty(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return maxX - minX < 1.0E-7 && maxY - minY < 1.0E-7 && maxZ - minZ < 1.0E-7;
    }

    public static AxisAlignedBB getBoxForChunk(int chunkX, int chunkZ) {
        double x2 = chunkX << 4;
        double z2 = chunkZ << 4;
        return new AxisAlignedBB(x2 - 3.0E-7, Double.NEGATIVE_INFINITY, z2 - 3.0E-7, x2 + 16.0000003, Double.POSITIVE_INFINITY, z2 + 16.0000003, false);
    }

    public static boolean voxelShapeIntersect(double minX1, double minY1, double minZ1, double maxX1, double maxY1, double maxZ1, double minX2, double minY2, double minZ2, double maxX2, double maxY2, double maxZ2) {
        return minX1 - maxX2 < -1.0E-7 && maxX1 - minX2 > 1.0E-7 && minY1 - maxY2 < -1.0E-7 && maxY1 - minY2 > 1.0E-7 && minZ1 - maxZ2 < -1.0E-7 && maxZ1 - minZ2 > 1.0E-7;
    }

    public static boolean voxelShapeIntersect(AxisAlignedBB box, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return box.a - maxX < -1.0E-7 && box.d - minX > 1.0E-7 && box.b - maxY < -1.0E-7 && box.e - minY > 1.0E-7 && box.c - maxZ < -1.0E-7 && box.f - minZ > 1.0E-7;
    }

    public static boolean voxelShapeIntersect(AxisAlignedBB box1, AxisAlignedBB box2) {
        return box1.a - box2.d < -1.0E-7 && box1.d - box2.a > 1.0E-7 && box1.b - box2.e < -1.0E-7 && box1.e - box2.b > 1.0E-7 && box1.c - box2.f < -1.0E-7 && box1.f - box2.c > 1.0E-7;
    }

    public static double collideX(AxisAlignedBB target, AxisAlignedBB source, double source_move) {
        if (source_move == 0.0) {
            return 0.0;
        }
        if (source.b - target.e < -1.0E-7 && source.e - target.b > 1.0E-7 && source.c - target.f < -1.0E-7 && source.f - target.c > 1.0E-7) {
            if (source_move >= 0.0) {
                double max_move = target.a - source.d;
                if (max_move < -1.0E-7) {
                    return source_move;
                }
                return Math.min(max_move, source_move);
            }
            double max_move = target.d - source.a;
            if (max_move > 1.0E-7) {
                return source_move;
            }
            return Math.max(max_move, source_move);
        }
        return source_move;
    }

    public static double collideY(AxisAlignedBB target, AxisAlignedBB source, double source_move) {
        if (source_move == 0.0) {
            return 0.0;
        }
        if (source.a - target.d < -1.0E-7 && source.d - target.a > 1.0E-7 && source.c - target.f < -1.0E-7 && source.f - target.c > 1.0E-7) {
            if (source_move >= 0.0) {
                double max_move = target.b - source.e;
                if (max_move < -1.0E-7) {
                    return source_move;
                }
                return Math.min(max_move, source_move);
            }
            double max_move = target.e - source.b;
            if (max_move > 1.0E-7) {
                return source_move;
            }
            return Math.max(max_move, source_move);
        }
        return source_move;
    }

    public static double collideZ(AxisAlignedBB target, AxisAlignedBB source, double source_move) {
        if (source_move == 0.0) {
            return 0.0;
        }
        if (source.a - target.d < -1.0E-7 && source.d - target.a > 1.0E-7 && source.b - target.e < -1.0E-7 && source.e - target.b > 1.0E-7) {
            if (source_move >= 0.0) {
                double max_move = target.c - source.f;
                if (max_move < -1.0E-7) {
                    return source_move;
                }
                return Math.min(max_move, source_move);
            }
            double max_move = target.f - source.c;
            if (max_move > 1.0E-7) {
                return source_move;
            }
            return Math.max(max_move, source_move);
        }
        return source_move;
    }

    public static AxisAlignedBB offsetX(AxisAlignedBB box, double dx) {
        return new AxisAlignedBB(box.a + dx, box.b, box.c, box.d + dx, box.e, box.f, false);
    }

    public static AxisAlignedBB offsetY(AxisAlignedBB box, double dy) {
        return new AxisAlignedBB(box.a, box.b + dy, box.c, box.d, box.e + dy, box.f, false);
    }

    public static AxisAlignedBB offsetZ(AxisAlignedBB box, double dz) {
        return new AxisAlignedBB(box.a, box.b, box.c + dz, box.d, box.e, box.f + dz, false);
    }

    public static AxisAlignedBB expandRight(AxisAlignedBB box, double dx) {
        return new AxisAlignedBB(box.a, box.b, box.c, box.d + dx, box.e, box.f, false);
    }

    public static AxisAlignedBB expandLeft(AxisAlignedBB box, double dx) {
        return new AxisAlignedBB(box.a - dx, box.b, box.c, box.d, box.e, box.f, false);
    }

    public static AxisAlignedBB expandUpwards(AxisAlignedBB box, double dy) {
        return new AxisAlignedBB(box.a, box.b, box.c, box.d, box.e + dy, box.f, false);
    }

    public static AxisAlignedBB expandDownwards(AxisAlignedBB box, double dy) {
        return new AxisAlignedBB(box.a, box.b - dy, box.c, box.d, box.e, box.f, false);
    }

    public static AxisAlignedBB expandForwards(AxisAlignedBB box, double dz) {
        return new AxisAlignedBB(box.a, box.b, box.c, box.d, box.e, box.f + dz, false);
    }

    public static AxisAlignedBB expandBackwards(AxisAlignedBB box, double dz) {
        return new AxisAlignedBB(box.a, box.b, box.c - dz, box.d, box.e, box.f, false);
    }

    public static AxisAlignedBB cutRight(AxisAlignedBB box, double dx) {
        return new AxisAlignedBB(box.d, box.b, box.c, box.d + dx, box.e, box.f, false);
    }

    public static AxisAlignedBB cutLeft(AxisAlignedBB box, double dx) {
        return new AxisAlignedBB(box.a + dx, box.b, box.c, box.a, box.e, box.f, false);
    }

    public static AxisAlignedBB cutUpwards(AxisAlignedBB box, double dy) {
        return new AxisAlignedBB(box.a, box.e, box.c, box.d, box.e + dy, box.f, false);
    }

    public static AxisAlignedBB cutDownwards(AxisAlignedBB box, double dy) {
        return new AxisAlignedBB(box.a, box.b + dy, box.c, box.d, box.b, box.f, false);
    }

    public static AxisAlignedBB cutForwards(AxisAlignedBB box, double dz) {
        return new AxisAlignedBB(box.a, box.b, box.f, box.d, box.e, box.f + dz, false);
    }

    public static AxisAlignedBB cutBackwards(AxisAlignedBB box, double dz) {
        return new AxisAlignedBB(box.a, box.b, box.c + dz, box.d, box.e, box.c, false);
    }

    public static double performCollisionsX(AxisAlignedBB currentBoundingBox, double value, List<AxisAlignedBB> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i2 = 0; i2 < len; ++i2) {
            AxisAlignedBB target = potentialCollisions.get(i2);
            value = CollisionUtil.collideX(target, currentBoundingBox, value);
        }
        return value;
    }

    public static double performCollisionsY(AxisAlignedBB currentBoundingBox, double value, List<AxisAlignedBB> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i2 = 0; i2 < len; ++i2) {
            AxisAlignedBB target = potentialCollisions.get(i2);
            value = CollisionUtil.collideY(target, currentBoundingBox, value);
        }
        return value;
    }

    public static double performCollisionsZ(AxisAlignedBB currentBoundingBox, double value, List<AxisAlignedBB> potentialCollisions) {
        int len = potentialCollisions.size();
        for (int i2 = 0; i2 < len; ++i2) {
            AxisAlignedBB target = potentialCollisions.get(i2);
            value = CollisionUtil.collideZ(target, currentBoundingBox, value);
        }
        return value;
    }

    public static Vec3D performCollisions(Vec3D moveVector, AxisAlignedBB axisalignedbb, List<AxisAlignedBB> potentialCollisions) {
        boolean xSmaller;
        double x2 = moveVector.c;
        double y2 = moveVector.d;
        double z2 = moveVector.e;
        if (y2 != 0.0 && (y2 = CollisionUtil.performCollisionsY(axisalignedbb, y2, potentialCollisions)) != 0.0) {
            axisalignedbb = CollisionUtil.offsetY(axisalignedbb, y2);
        }
        boolean bl = xSmaller = Math.abs(x2) < Math.abs(z2);
        if (xSmaller && z2 != 0.0 && (z2 = CollisionUtil.performCollisionsZ(axisalignedbb, z2, potentialCollisions)) != 0.0) {
            axisalignedbb = CollisionUtil.offsetZ(axisalignedbb, z2);
        }
        if (x2 != 0.0) {
            x2 = CollisionUtil.performCollisionsX(axisalignedbb, x2, potentialCollisions);
            if (!xSmaller && x2 != 0.0) {
                axisalignedbb = CollisionUtil.offsetX(axisalignedbb, x2);
            }
        }
        if (!xSmaller && z2 != 0.0) {
            z2 = CollisionUtil.performCollisionsZ(axisalignedbb, z2, potentialCollisions);
        }
        return new Vec3D(x2, y2, z2);
    }

    public static boolean addBoxesToIfIntersects(VoxelShape shape, AxisAlignedBB aabb, List<AxisAlignedBB> list) {
        if (shape instanceof AABBVoxelShape) {
            AABBVoxelShape shapeCasted = (AABBVoxelShape)shape;
            if (CollisionUtil.voxelShapeIntersect(shapeCasted.aabb, aabb) && !CollisionUtil.isEmpty(shapeCasted.aabb)) {
                list.add(shapeCasted.aabb);
                return true;
            }
            return false;
        }
        if (shape instanceof VoxelShapeArray) {
            VoxelShapeArray shapeCasted = (VoxelShapeArray)shape;
            double offX = shapeCasted.getOffsetX();
            double offY = shapeCasted.getOffsetY();
            double offZ = shapeCasted.getOffsetZ();
            boolean ret = false;
            for (AxisAlignedBB boundingBox : shapeCasted.getBoundingBoxesRepresentation()) {
                double minX = boundingBox.a + offX;
                double minY = boundingBox.b + offY;
                double minZ = boundingBox.c + offZ;
                double maxX = boundingBox.d + offX;
                double maxY = boundingBox.e + offY;
                double maxZ = boundingBox.f + offZ;
                if (!CollisionUtil.voxelShapeIntersect(aabb, minX, minY, minZ, maxX, maxY, maxZ) || CollisionUtil.isEmpty(minX, minY, minZ, maxX, maxY, maxZ)) continue;
                list.add(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ, false));
                ret = true;
            }
            return ret;
        }
        List<AxisAlignedBB> boxes = shape.d();
        boolean ret = false;
        int len = boxes.size();
        for (int i2 = 0; i2 < len; ++i2) {
            AxisAlignedBB box = boxes.get(i2);
            if (!CollisionUtil.voxelShapeIntersect(box, aabb) || CollisionUtil.isEmpty(box)) continue;
            list.add(box);
            ret = true;
        }
        return ret;
    }

    public static void addBoxesTo(VoxelShape shape, List<AxisAlignedBB> list) {
        block5: {
            block4: {
                if (!(shape instanceof AABBVoxelShape)) break block4;
                AABBVoxelShape shapeCasted = (AABBVoxelShape)shape;
                if (CollisionUtil.isEmpty(shapeCasted.aabb)) break block5;
                list.add(shapeCasted.aabb);
                break block5;
            }
            if (shape instanceof VoxelShapeArray) {
                VoxelShapeArray shapeCasted = (VoxelShapeArray)shape;
                double offX = shapeCasted.getOffsetX();
                double offY = shapeCasted.getOffsetY();
                double offZ = shapeCasted.getOffsetZ();
                for (AxisAlignedBB boundingBox : shapeCasted.getBoundingBoxesRepresentation()) {
                    AxisAlignedBB box = boundingBox.d(offX, offY, offZ);
                    if (CollisionUtil.isEmpty(box)) continue;
                    list.add(box);
                }
            } else {
                List<AxisAlignedBB> boxes = shape.d();
                int len = boxes.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    AxisAlignedBB box = boxes.get(i2);
                    if (CollisionUtil.isEmpty(box)) continue;
                    list.add(box);
                }
            }
        }
    }

    public static boolean isAlmostCollidingOnBorder(WorldBorder worldborder, AxisAlignedBB boundingBox) {
        return CollisionUtil.isAlmostCollidingOnBorder(worldborder, boundingBox.a, boundingBox.d, boundingBox.c, boundingBox.f);
    }

    public static boolean isAlmostCollidingOnBorder(WorldBorder worldborder, double boxMinX, double boxMaxX, double boxMinZ, double boxMaxZ) {
        double borderMaxZ;
        double borderMinX = worldborder.e();
        double borderMaxX = worldborder.g();
        double borderMinZ = worldborder.f();
        return !CollisionUtil.voxelShapeIntersect(boxMinX + 1.0E-7, Double.NEGATIVE_INFINITY, boxMinZ + 1.0E-7, boxMaxX - 1.0E-7, Double.POSITIVE_INFINITY, boxMaxZ - 1.0E-7, borderMinX, Double.NEGATIVE_INFINITY, borderMinZ, borderMaxX, Double.POSITIVE_INFINITY, borderMaxZ = worldborder.h()) && CollisionUtil.voxelShapeIntersect(boxMinX - 1.0E-7, Double.NEGATIVE_INFINITY, boxMinZ - 1.0E-7, boxMaxX + 1.0E-7, Double.POSITIVE_INFINITY, boxMaxZ + 1.0E-7, borderMinX, Double.NEGATIVE_INFINITY, borderMinZ, borderMaxX, Double.POSITIVE_INFINITY, borderMaxZ);
    }

    public static boolean isCollidingWithBorderEdge(WorldBorder worldborder, AxisAlignedBB boundingBox) {
        return CollisionUtil.isCollidingWithBorderEdge(worldborder, boundingBox.a, boundingBox.d, boundingBox.c, boundingBox.f);
    }

    public static boolean isCollidingWithBorderEdge(WorldBorder worldborder, double boxMinX, double boxMaxX, double boxMinZ, double boxMaxZ) {
        double borderMinX = worldborder.e() + 1.0E-7;
        double borderMaxX = worldborder.g() - 1.0E-7;
        double borderMinZ = worldborder.f() + 1.0E-7;
        double borderMaxZ = worldborder.h() - 1.0E-7;
        return boxMinX < borderMinX || boxMaxX > borderMaxX || boxMinZ < borderMinZ || boxMaxZ > borderMaxZ;
    }

    public static boolean getCollisionsForBlocksOrWorldBorder(ICollisionAccess getter, Entity entity, AxisAlignedBB aabb, List<AxisAlignedBB> into, boolean loadChunks, boolean collidesWithUnloaded, boolean checkBorder, boolean checkOnly, BiPredicate<IBlockData, BlockPosition> predicate) {
        boolean ret = false;
        if (checkBorder && CollisionUtil.isAlmostCollidingOnBorder(getter.p_(), aabb)) {
            if (checkOnly) {
                return true;
            }
            CollisionUtil.addBoxesTo(getter.p_().c(), into);
            ret = true;
        }
        int minBlockX = MathHelper.a(aabb.a - 1.0E-7) - 1;
        int maxBlockX = MathHelper.a(aabb.d + 1.0E-7) + 1;
        int minBlockY = MathHelper.a(aabb.b - 1.0E-7) - 1;
        int maxBlockY = MathHelper.a(aabb.e + 1.0E-7) + 1;
        int minBlockZ = MathHelper.a(aabb.c - 1.0E-7) - 1;
        int maxBlockZ = MathHelper.a(aabb.f + 1.0E-7) + 1;
        int minSection = WorldUtil.getMinSection(getter);
        int maxSection = WorldUtil.getMaxSection(getter);
        int minBlock = minSection << 4;
        int maxBlock = maxSection << 4 | 0xF;
        BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();
        LazyEntityCollisionContext collisionShape = null;
        if (minBlockY > maxBlock || maxBlockY < minBlock) {
            return ret;
        }
        int minYIterate = Math.max(minBlock, minBlockY);
        int maxYIterate = Math.min(maxBlock, maxBlockY);
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int maxChunkY = maxBlockY >> 4;
        int minChunkYIterate = minYIterate >> 4;
        int maxChunkYIterate = maxYIterate >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ChunkProviderServer chunkProvider = getter instanceof RegionLimitedWorldAccess ? null : (getter instanceof WorldServer ? ((WorldServer)getter).k() : null);
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            int minZ = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
            int maxZ = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                IChunkAccess chunk;
                int minX = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                int maxX = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                int chunkXGlobalPos = currChunkX << 4;
                int chunkZGlobalPos = currChunkZ << 4;
                if (chunkProvider == null) {
                    chunk = (IChunkAccess)getter.c(currChunkX, currChunkZ);
                } else {
                    IChunkAccess iChunkAccess = chunk = loadChunks ? chunkProvider.a(currChunkX, currChunkZ, true) : chunkProvider.getChunkAtIfLoadedImmediately(currChunkX, currChunkZ);
                }
                if (chunk == null) {
                    if (!collidesWithUnloaded) continue;
                    if (checkOnly) {
                        return true;
                    }
                    into.add(CollisionUtil.getBoxForChunk(currChunkX, currChunkZ));
                    ret = true;
                    continue;
                }
                ChunkSection[] sections = chunk.d();
                for (int currChunkY = minChunkYIterate; currChunkY <= maxChunkYIterate; ++currChunkY) {
                    int maxYIterateLocal;
                    int maxZIterate;
                    int minZIterate;
                    int maxXIterate;
                    int minXIterate;
                    ChunkSection section = sections[currChunkY - minSection];
                    if (section == null || section.c()) continue;
                    DataPaletteBlock<IBlockData> blocks = section.i;
                    int minY = currChunkY == minChunkYIterate ? minYIterate & 0xF : 0;
                    int maxY = currChunkY == maxChunkYIterate ? maxYIterate & 0xF : 15;
                    int chunkYGlobalPos = currChunkY << 4;
                    boolean sectionHasSpecial = section.hasSpecialCollidingBlocks();
                    if (!sectionHasSpecial) {
                        minXIterate = currChunkX == minChunkX ? minX + 1 : minX;
                        maxXIterate = currChunkX == maxChunkX ? maxX - 1 : maxX;
                        minZIterate = currChunkZ == minChunkZ ? minZ + 1 : minZ;
                        maxZIterate = currChunkZ == maxChunkZ ? maxZ - 1 : maxZ;
                        minYIterateLocal = currChunkY == minChunkY ? minY + 1 : minY;
                        int n2 = maxYIterateLocal = currChunkY == maxChunkY ? maxY - 1 : maxY;
                        if (minXIterate > maxXIterate || minZIterate > maxZIterate) {
                            continue;
                        }
                    } else {
                        minXIterate = minX;
                        maxXIterate = maxX;
                        minZIterate = minZ;
                        maxZIterate = maxZ;
                        minYIterateLocal = minY;
                        maxYIterateLocal = maxY;
                    }
                    for (int currY = minYIterateLocal; currY <= maxYIterateLocal; ++currY) {
                        long collisionForHorizontal = section.getKnownBlockInfoHorizontalRaw(currY, minZIterate & 0xF);
                        int currZ = minZIterate;
                        while (currZ <= maxZIterate) {
                            int xAxisBits = maxXIterate - minXIterate + 1 << 1;
                            long bitset = (1L << xAxisBits) - 1L;
                            int shift = (currZ & 1) << 5;
                            if ((collisionForHorizontal & (bitset <<= (shift += minXIterate << 1))) != 0L) {
                                block9: for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                    int localBlockIndex = currX | currZ << 4 | currY << 8;
                                    int blockInfo = (int)ChunkSection.getKnownBlockInfo(localBlockIndex, collisionForHorizontal);
                                    switch (blockInfo) {
                                        case 0: {
                                            continue block9;
                                        }
                                        case 1: {
                                            double blockX = currX | chunkXGlobalPos;
                                            double blockY = currY | chunkYGlobalPos;
                                            double blockZ = currZ | chunkZGlobalPos;
                                            AxisAlignedBB blockBox = new AxisAlignedBB(blockX, blockY, blockZ, blockX + 1.0, blockY + 1.0, blockZ + 1.0, true);
                                            if (predicate != null) {
                                                if (!CollisionUtil.voxelShapeIntersect(aabb, blockBox)) {
                                                    continue block9;
                                                }
                                            } else {
                                                if (!CollisionUtil.voxelShapeIntersect(aabb, blockBox)) continue block9;
                                                if (checkOnly) {
                                                    return true;
                                                }
                                                into.add(blockBox);
                                                ret = true;
                                                continue block9;
                                            }
                                        }
                                        default: {
                                            VoxelShape voxelshape2;
                                            int blockX = currX | chunkXGlobalPos;
                                            int blockY = currY | chunkYGlobalPos;
                                            int blockZ = currZ | chunkZGlobalPos;
                                            int edgeCount = (blockX == minBlockX || blockX == maxBlockX ? 1 : 0) + (blockY == minBlockY || blockY == maxBlockY ? 1 : 0) + (blockZ == minBlockZ || blockZ == maxBlockZ ? 1 : 0);
                                            if (edgeCount == 3) continue block9;
                                            IBlockData blockData = blocks.a(localBlockIndex);
                                            if (edgeCount == 1 && !blockData.shapeExceedsCube() || edgeCount == 2 && blockData.b() != Blocks.bP) continue block9;
                                            mutablePos.d(blockX, blockY, blockZ);
                                            if (collisionShape == null) {
                                                collisionShape = new LazyEntityCollisionContext(entity);
                                            }
                                            if ((voxelshape2 = blockData.b((IBlockAccess)getter, (BlockPosition)mutablePos, collisionShape)) == VoxelShapes.a()) continue block9;
                                            VoxelShape voxelshape3 = voxelshape2.a((double)blockX, (double)blockY, (double)blockZ);
                                            if (predicate != null && !predicate.test(blockData, mutablePos)) continue block9;
                                            if (checkOnly) {
                                                if (!voxelshape3.intersects(aabb)) continue block9;
                                                return true;
                                            }
                                            ret |= CollisionUtil.addBoxesToIfIntersects(voxelshape3, aabb, into);
                                        }
                                    }
                                }
                            }
                            collisionForHorizontal = (++currZ & 1) == 0 ? section.getKnownBlockInfoHorizontalRaw(currY, currZ & 0xF) : collisionForHorizontal;
                        }
                    }
                }
            }
        }
        return ret;
    }

    public static boolean getCollisionsForBlocksOrWorldBorderReference(ICollisionAccess getter, Entity entity, AxisAlignedBB aabb, List<AxisAlignedBB> into, boolean loadChunks, boolean collidesWithUnloaded, boolean checkBorder, boolean checkOnly, BiPredicate<IBlockData, BlockPosition> predicate) {
        boolean ret = false;
        if (checkBorder && CollisionUtil.isAlmostCollidingOnBorder(getter.p_(), aabb)) {
            if (checkOnly) {
                return true;
            }
            CollisionUtil.addBoxesTo(getter.p_().c(), into);
            ret = true;
        }
        int minBlockX = MathHelper.a(aabb.a - 1.0E-7) - 1;
        int maxBlockX = MathHelper.a(aabb.d + 1.0E-7) + 1;
        int minBlockY = MathHelper.a(aabb.b - 1.0E-7) - 1;
        int maxBlockY = MathHelper.a(aabb.e + 1.0E-7) + 1;
        int minBlockZ = MathHelper.a(aabb.c - 1.0E-7) - 1;
        int maxBlockZ = MathHelper.a(aabb.f + 1.0E-7) + 1;
        int minSection = WorldUtil.getMinSection(getter);
        int maxSection = WorldUtil.getMaxSection(getter);
        int minBlock = minSection << 4;
        int maxBlock = maxSection << 4 | 0xF;
        BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();
        LazyEntityCollisionContext collisionShape = null;
        if (minBlockY > maxBlock || maxBlockY < minBlock) {
            return ret;
        }
        int minYIterate = Math.max(minBlock, minBlockY);
        int maxYIterate = Math.min(maxBlock, maxBlockY);
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int maxChunkY = maxBlockY >> 4;
        int minChunkYIterate = minYIterate >> 4;
        int maxChunkYIterate = maxYIterate >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ChunkProviderServer chunkProvider = getter instanceof RegionLimitedWorldAccess ? null : (getter instanceof WorldServer ? ((WorldServer)getter).k() : null);
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            int minZ = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
            int maxZ = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 15;
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                IChunkAccess chunk;
                int minX = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                int maxX = currChunkX == maxChunkX ? maxBlockX & 0xF : 15;
                int chunkXGlobalPos = currChunkX << 4;
                int chunkZGlobalPos = currChunkZ << 4;
                if (chunkProvider == null) {
                    chunk = (IChunkAccess)getter.c(currChunkX, currChunkZ);
                } else {
                    IChunkAccess iChunkAccess = chunk = loadChunks ? chunkProvider.a(currChunkX, currChunkZ, true) : chunkProvider.getChunkAtIfLoadedImmediately(currChunkX, currChunkZ);
                }
                if (chunk == null) {
                    if (!collidesWithUnloaded) continue;
                    if (checkOnly) {
                        return true;
                    }
                    into.add(CollisionUtil.getBoxForChunk(currChunkX, currChunkZ));
                    ret = true;
                    continue;
                }
                ChunkSection[] sections = chunk.d();
                for (int currChunkY = minChunkYIterate; currChunkY <= maxChunkYIterate; ++currChunkY) {
                    ChunkSection section = sections[currChunkY - minSection];
                    if (section == null || section.c()) continue;
                    DataPaletteBlock<IBlockData> blocks = section.i;
                    int minY = currChunkY == minChunkYIterate ? minYIterate & 0xF : 0;
                    int maxY = currChunkY == maxChunkYIterate ? maxYIterate & 0xF : 15;
                    int chunkYGlobalPos = currChunkY << 4;
                    for (int currY = minY; currY <= maxY; ++currY) {
                        for (int currZ = minZ; currZ <= maxZ; ++currZ) {
                            for (int currX = minX; currX <= maxX; ++currX) {
                                VoxelShape voxelshape2;
                                IBlockData blockData;
                                int blockZ;
                                int blockY;
                                int localBlockIndex = currX | currZ << 4 | currY << 8;
                                int blockX = currX | chunkXGlobalPos;
                                int edgeCount = (blockX == minBlockX || blockX == maxBlockX ? 1 : 0) + ((blockY = currY | chunkYGlobalPos) == minBlockY || blockY == maxBlockY ? 1 : 0) + ((blockZ = currZ | chunkZGlobalPos) == minBlockZ || blockZ == maxBlockZ ? 1 : 0);
                                if (edgeCount == 3 || (blockData = blocks.a(localBlockIndex)).getBlockCollisionBehavior() == 0L || edgeCount == 1 && !blockData.shapeExceedsCube() || edgeCount == 2 && blockData.b() != Blocks.bP) continue;
                                mutablePos.d(blockX, blockY, blockZ);
                                if (collisionShape == null) {
                                    collisionShape = new LazyEntityCollisionContext(entity);
                                }
                                if ((voxelshape2 = blockData.b((IBlockAccess)getter, (BlockPosition)mutablePos, collisionShape)) == VoxelShapes.a()) continue;
                                VoxelShape voxelshape3 = voxelshape2.a((double)blockX, (double)blockY, (double)blockZ);
                                if (predicate != null && !predicate.test(blockData, mutablePos)) continue;
                                if (checkOnly) {
                                    if (!voxelshape3.intersects(aabb)) continue;
                                    return true;
                                }
                                ret |= CollisionUtil.addBoxesToIfIntersects(voxelshape3, aabb, into);
                            }
                        }
                    }
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getEntityHardCollisions(ICollisionAccess getter, Entity entity, AxisAlignedBB aabb, List<AxisAlignedBB> into, boolean checkOnly, Predicate<Entity> predicate) {
        if (CollisionUtil.isEmpty(aabb) || !(getter instanceof IEntityAccess)) {
            return false;
        }
        IEntityAccess entityGetter = (IEntityAccess)((Object)getter);
        boolean ret = false;
        aabb = aabb.c(-1.0E-7, -1.0E-7, -1.0E-7);
        UnsafeList<Entity> entities = CachedLists.getTempGetEntitiesList();
        try {
            if (entity != null && entity.hardCollides()) {
                entityGetter.getEntities(entity, aabb, predicate, entities);
            } else {
                entityGetter.getHardCollidingEntities(entity, aabb, predicate, entities);
            }
            int len = entities.size();
            for (int i2 = 0; i2 < len; ++i2) {
                Entity otherEntity = (Entity)entities.get(i2);
                if ((entity != null || !otherEntity.bs()) && (entity == null || !entity.h(otherEntity))) continue;
                if (checkOnly) {
                    boolean bl = true;
                    return bl;
                }
                into.add(otherEntity.cD());
                ret = true;
            }
        }
        finally {
            CachedLists.returnTempGetEntitiesList(entities);
        }
        return ret;
    }

    public static boolean getCollisions(ICollisionAccess view, Entity entity, AxisAlignedBB aabb, List<AxisAlignedBB> into, boolean loadChunks, boolean collidesWithUnloadedChunks, boolean checkBorder, boolean checkOnly, BiPredicate<IBlockData, BlockPosition> blockPredicate, Predicate<Entity> entityPredicate) {
        if (checkOnly) {
            return CollisionUtil.getCollisionsForBlocksOrWorldBorder(view, entity, aabb, into, loadChunks, collidesWithUnloadedChunks, checkBorder, checkOnly, blockPredicate) || CollisionUtil.getEntityHardCollisions(view, entity, aabb, into, checkOnly, entityPredicate);
        }
        return CollisionUtil.getCollisionsForBlocksOrWorldBorder(view, entity, aabb, into, loadChunks, collidesWithUnloadedChunks, checkBorder, checkOnly, blockPredicate) | CollisionUtil.getEntityHardCollisions(view, entity, aabb, into, checkOnly, entityPredicate);
    }

    private CollisionUtil() {
        throw new RuntimeException();
    }

    public static final class LazyEntityCollisionContext
    extends VoxelShapeCollisionEntity {
        private VoxelShapeCollision delegate;

        public LazyEntityCollisionContext(Entity entity) {
            super(false, 0.0, null, null, entity);
        }

        public VoxelShapeCollision getDelegate() {
            Entity entity = this.c();
            return this.delegate == null ? (this.delegate = entity == null ? VoxelShapeCollision.a() : VoxelShapeCollision.a(entity)) : this.delegate;
        }

        @Override
        public boolean b() {
            return this.getDelegate().b();
        }

        @Override
        public boolean a(VoxelShape shape, BlockPosition pos, boolean defaultValue) {
            return this.getDelegate().a(shape, pos, defaultValue);
        }

        @Override
        public boolean a(Item item) {
            return this.getDelegate().a(item);
        }

        @Override
        public boolean a(Fluid state, Fluid fluidState) {
            return this.getDelegate().a(state, fluidState);
        }
    }
}

