/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;

public class TickThread
extends Thread {
    public static final boolean STRICT_THREAD_CHECKS = Boolean.getBoolean("paper.strict-thread-checks");
    public final int id;
    private static final AtomicInteger ID_GENERATOR;

    @Deprecated
    public static void softEnsureTickThread(String reason) {
        if (!STRICT_THREAD_CHECKS) {
            return;
        }
        TickThread.ensureTickThread(reason);
    }

    @Deprecated
    public static void ensureTickThread(String reason) {
        if (!TickThread.isTickThread()) {
            MinecraftServer.n.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(WorldServer world, int chunkX, int chunkZ, String reason) {
        if (!TickThread.isTickThreadFor(world, chunkX, chunkZ)) {
            MinecraftServer.n.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(Entity entity, String reason) {
        if (!TickThread.isTickThreadFor(entity)) {
            MinecraftServer.n.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public TickThread(String name) {
        this((Runnable)null, name);
    }

    public TickThread(Runnable run, String name) {
        this(run, name, ID_GENERATOR.incrementAndGet());
    }

    private TickThread(Runnable run, String name, int id) {
        super(run, name);
        this.id = id;
    }

    public static TickThread getCurrentTickThread() {
        return (TickThread)Thread.currentThread();
    }

    public static boolean isTickThread() {
        return Thread.currentThread() instanceof TickThread;
    }

    public static boolean isTickThreadFor(WorldServer world, int chunkX, int chunkZ) {
        return Thread.currentThread() instanceof TickThread;
    }

    public static boolean isTickThreadFor(Entity entity) {
        return Thread.currentThread() instanceof TickThread;
    }

    static {
        if (STRICT_THREAD_CHECKS) {
            MinecraftServer.n.warn("Strict thread checks enabled - performance may suffer");
        }
        ID_GENERATOR = new AtomicInteger();
    }
}

