/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util.table;

import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;

public final class ZeroCollidingReferenceStateTable {
    protected final long[] this_index_table;
    protected final Comparable<?>[] this_table;
    protected final IBlockDataHolder<?, ?> this_state;
    protected long[] index_table;
    protected IBlockDataHolder<?, ?>[][] value_table;

    public ZeroCollidingReferenceStateTable(IBlockDataHolder<?, ?> state, Map<IBlockState<?>, Comparable<?>> this_map) {
        this.this_state = state;
        this.this_index_table = this.create_table(this_map.keySet());
        int max_id = -1;
        for (IBlockState<?> iBlockState : this_map.keySet()) {
            int id = ZeroCollidingReferenceStateTable.lookup_vindex(iBlockState, this.this_index_table);
            if (id <= max_id) continue;
            max_id = id;
        }
        this.this_table = new Comparable[max_id + 1];
        for (Map.Entry entry : this_map.entrySet()) {
            this.this_table[ZeroCollidingReferenceStateTable.lookup_vindex((IBlockState)entry.getKey(), (long[])this.this_index_table)] = (Comparable)entry.getValue();
        }
    }

    public void loadInTable(Table<IBlockState<?>, Comparable<?>, IBlockDataHolder<?, ?>> table, Map<IBlockState<?>, Comparable<?>> this_map) {
        HashSet combined = new HashSet(table.rowKeySet());
        combined.addAll(this_map.keySet());
        this.index_table = this.create_table(combined);
        int max_id = -1;
        for (IBlockState iBlockState : combined) {
            int n2 = ZeroCollidingReferenceStateTable.lookup_vindex(iBlockState, this.index_table);
            if (n2 <= max_id) continue;
            max_id = n2;
        }
        this.value_table = new IBlockDataHolder[max_id + 1][];
        Map map = table.rowMap();
        for (IBlockState iBlockState : map.keySet()) {
            Map propertyMap = (Map)map.get(iBlockState);
            int id = ZeroCollidingReferenceStateTable.lookup_vindex(iBlockState, this.index_table);
            this.value_table[id] = new IBlockDataHolder[iBlockState.a().size()];
            IBlockDataHolder[] states = this.value_table[id];
            for (Map.Entry entry : propertyMap.entrySet()) {
                if (entry.getValue() == null) continue;
                states[iBlockState.getIdFor((Comparable)entry.getKey())] = (IBlockDataHolder)entry.getValue();
            }
        }
        for (Map.Entry<IBlockState<?>, Comparable<?>> entry : this_map.entrySet()) {
            IBlockState<?> property = entry.getKey();
            int index = ZeroCollidingReferenceStateTable.lookup_vindex(property, this.index_table);
            if (this.value_table[index] == null) {
                this.value_table[index] = new IBlockDataHolder[property.a().size()];
            }
            this.value_table[index][property.getIdFor(entry.getValue())] = this.this_state;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected long[] create_table(Collection<IBlockState<?>> collection) {
        void var5_9;
        int max_id = -1;
        for (IBlockState<?> property : collection) {
            int n2 = property.getId();
            if (n2 <= max_id) continue;
            max_id = n2;
        }
        long[] ret = new long[max_id + 1 + 31 >>> 5];
        for (IBlockState iBlockState : collection) {
            int id = iBlockState.getId();
            int n3 = id >>> 5;
            ret[n3] = ret[n3] | 1L << (id & 0x1F);
        }
        int total = 0;
        boolean bl = true;
        int len = ret.length;
        while (var5_9 < len) {
            void v1 = var5_9;
            ret[v1] = ret[v1] | (long)(total += Long.bitCount(ret[var5_9 - true] & 0xFFFFFFFFL)) << 32;
            ++var5_9;
        }
        return ret;
    }

    public Comparable<?> get(IBlockState<?> state) {
        Comparable<?>[] table = this.this_table;
        int index = ZeroCollidingReferenceStateTable.lookup_vindex(state, this.this_index_table);
        if (index < 0 || index >= table.length) {
            return null;
        }
        return table[index];
    }

    public IBlockDataHolder<?, ?> get(IBlockState<?> property, Comparable<?> with) {
        int withId = property.getIdFor(with);
        if (withId < 0) {
            return null;
        }
        int index = ZeroCollidingReferenceStateTable.lookup_vindex(property, this.index_table);
        IBlockDataHolder<?, ?>[][] table = this.value_table;
        if (index < 0 || index >= table.length) {
            return null;
        }
        IBlockDataHolder<?, ?>[] values = table[index];
        if (withId >= values.length) {
            return null;
        }
        return values[withId];
    }

    protected static int lookup_vindex(IBlockState<?> property, long[] index_table) {
        int id = property.getId();
        long bitset_mask = 1L << (id & 0x1F);
        long lower_mask = bitset_mask - 1L;
        int index = id >>> 5;
        if (index >= index_table.length) {
            return -1;
        }
        long index_value = index_table[index];
        long contains_check = (index_value & bitset_mask) - 1L >> 63;
        return (int)((index_value >>> 32) + (long)Long.bitCount(index_value & lower_mask) | contains_check);
    }
}

