/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.world;

import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadedWorldUpgrader {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ResourceKey<WorldDimension> dimensionType;
    private final String worldName;
    private final File worldDir;
    private final ExecutorService threadPool;
    private final DataFixer dataFixer;
    private final Optional<ResourceKey<Codec<? extends ChunkGenerator>>> generatorKey;
    private final boolean removeCaches;

    public ThreadedWorldUpgrader(ResourceKey<WorldDimension> dimensionType, String worldName, File worldDir, int threads, DataFixer dataFixer, Optional<ResourceKey<Codec<? extends ChunkGenerator>>> generatorKey, boolean removeCaches) {
        this.dimensionType = dimensionType;
        this.worldName = worldName;
        this.worldDir = worldDir;
        this.threadPool = Executors.newFixedThreadPool(Math.max(1, threads), new ThreadFactory(){
            private final AtomicInteger threadCounter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable run) {
                Thread ret = new Thread(run);
                ret.setName("World upgrader thread for world " + ThreadedWorldUpgrader.this.worldName + " #" + this.threadCounter.getAndIncrement());
                ret.setUncaughtExceptionHandler((thread, throwable) -> LOGGER.fatal("Error upgrading world", throwable));
                return ret;
            }
        });
        this.dataFixer = dataFixer;
        this.generatorKey = generatorKey;
        this.removeCaches = removeCaches;
    }

    public void convert() {
        File worldFolder = Convertable.getStorageFolder(this.worldDir.toPath(), this.dimensionType).toFile();
        WorldPersistentData worldPersistentData = new WorldPersistentData(new File(worldFolder, "data"), this.dataFixer);
        File regionFolder = new File(worldFolder, "region");
        LOGGER.info("Force upgrading " + this.worldName);
        LOGGER.info("Counting regionfiles for " + this.worldName);
        File[] regionFiles = regionFolder.listFiles((dir, name) -> WorldUpgrader.q.matcher(name).matches());
        if (regionFiles == null) {
            LOGGER.info("Found no regionfiles to convert for world " + this.worldName);
            return;
        }
        LOGGER.info("Found " + regionFiles.length + " regionfiles to convert");
        LOGGER.info("Starting conversion now for world " + this.worldName);
        WorldInfo info = new WorldInfo(() -> worldPersistentData, new IChunkLoader(regionFolder.toPath(), this.dataFixer, false), this.removeCaches, this.dimensionType, this.generatorKey);
        long expectedChunks = (long)regionFiles.length * 1024L;
        for (File regionFile : regionFiles) {
            ChunkCoordIntPair regionPos = RegionFileCache.getRegionFileCoordinates(regionFile.toPath());
            if (regionPos == null) {
                expectedChunks -= 1024L;
                continue;
            }
            this.threadPool.execute(new ConvertTask(info, regionPos.e >> 5, regionPos.f >> 5));
        }
        this.threadPool.shutdown();
        DecimalFormat format = new DecimalFormat("#0.00");
        long start = System.nanoTime();
        while (!this.threadPool.isTerminated()) {
            long current = info.convertedChunks.get();
            LOGGER.info("{}% completed ({} / {} chunks)...", (Object)format.format((double)current / (double)expectedChunks * 100.0), (Object)current, (Object)expectedChunks);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        long end = System.nanoTime();
        try {
            info.loader.close();
        }
        catch (IOException ex) {
            LOGGER.fatal("Failed to close chunk loader", (Throwable)ex);
        }
        LOGGER.info("Completed conversion. Took {}s, {} out of {} chunks needed to be converted/modified ({}%)", (Object)((int)Math.ceil((double)(end - start) * 1.0E-9)), (Object)info.modifiedChunks.get(), (Object)expectedChunks, (Object)format.format((double)info.modifiedChunks.get() / (double)expectedChunks * 100.0));
    }

    private static final class WorldInfo {
        public final Supplier<WorldPersistentData> persistentDataSupplier;
        public final IChunkLoader loader;
        public final boolean removeCaches;
        public final ResourceKey<WorldDimension> worldKey;
        public final Optional<ResourceKey<Codec<? extends ChunkGenerator>>> generatorKey;
        public final AtomicLong convertedChunks = new AtomicLong();
        public final AtomicLong modifiedChunks = new AtomicLong();

        private WorldInfo(Supplier<WorldPersistentData> persistentDataSupplier, IChunkLoader loader, boolean removeCaches, ResourceKey<WorldDimension> worldKey, Optional<ResourceKey<Codec<? extends ChunkGenerator>>> generatorKey) {
            this.persistentDataSupplier = persistentDataSupplier;
            this.loader = loader;
            this.removeCaches = removeCaches;
            this.worldKey = worldKey;
            this.generatorKey = generatorKey;
        }
    }

    private static final class ConvertTask
    implements Runnable {
        private final WorldInfo worldInfo;
        private final int regionX;
        private final int regionZ;

        public ConvertTask(WorldInfo worldInfo, int regionX, int regionZ) {
            this.worldInfo = worldInfo;
            this.regionX = regionX;
            this.regionZ = regionZ;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int regionCX = this.regionX << 5;
            int regionCZ = this.regionZ << 5;
            Supplier<WorldPersistentData> persistentDataSupplier = this.worldInfo.persistentDataSupplier;
            IChunkLoader loader = this.worldInfo.loader;
            boolean removeCaches = this.worldInfo.removeCaches;
            ResourceKey<WorldDimension> worldKey = this.worldInfo.worldKey;
            for (int cz = regionCZ; cz < regionCZ + 32; ++cz) {
                for (int cx = regionCX; cx < regionCX + 32; ++cx) {
                    ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(cx, cz);
                    try {
                        boolean modified;
                        NBTTagCompound chunkNBT = loader.f(chunkPos).join().orElse(null);
                        if (chunkNBT == null) continue;
                        int versionBefore = IChunkLoader.a(chunkNBT);
                        chunkNBT = loader.upgradeChunkTag(worldKey, persistentDataSupplier, chunkNBT, this.worldInfo.generatorKey, chunkPos, null);
                        boolean bl = modified = versionBefore < SharedConstants.b().d().c();
                        if (removeCaches) {
                            NBTTagCompound level = chunkNBT.p("Level");
                            modified |= level.e("Heightmaps");
                            level.r("Heightmaps");
                            modified |= level.e("isLightOn");
                            level.r("isLightOn");
                        }
                        if (!modified) continue;
                        this.worldInfo.modifiedChunks.getAndIncrement();
                        loader.a(chunkPos, chunkNBT);
                        continue;
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error upgrading chunk {}", (Object)chunkPos, (Object)ex);
                        continue;
                    }
                    finally {
                        this.worldInfo.convertedChunks.getAndIncrement();
                    }
                }
            }
        }
    }
}

