/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.UUID;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.storage.DataVersion;
import org.slf4j.Logger;

public class MinecraftVersion
implements WorldVersion {
    private static final Logger b = LogUtils.getLogger();
    public static final WorldVersion a = new MinecraftVersion();
    private final String c;
    private final String d;
    private final boolean e;
    private final DataVersion f;
    private final int g;
    private final int h;
    private final int i;
    private final Date j;

    private MinecraftVersion() {
        this.c = UUID.randomUUID().toString().replaceAll("-", "");
        this.d = "1.19.4";
        this.e = true;
        this.f = new DataVersion(3337, "main");
        this.g = SharedConstants.c();
        this.h = 13;
        this.i = 12;
        this.j = new Date();
    }

    private MinecraftVersion(JsonObject json) {
        this.c = ChatDeserializer.h(json, "id");
        this.d = ChatDeserializer.h(json, "name");
        this.e = ChatDeserializer.j(json, "stable");
        this.f = new DataVersion(ChatDeserializer.n(json, "world_version"), ChatDeserializer.a(json, "series_id", DataVersion.a));
        this.g = ChatDeserializer.n(json, "protocol_version");
        JsonObject jsonObject = ChatDeserializer.t(json, "pack_version");
        this.h = ChatDeserializer.n(jsonObject, "resource");
        this.i = ChatDeserializer.n(jsonObject, "data");
        this.j = Date.from(ZonedDateTime.parse(ChatDeserializer.h(json, "build_time")).toInstant());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static WorldVersion a() {
        try (InputStream inputStream = MinecraftVersion.class.getResourceAsStream("/version.json");){
            MinecraftVersion minecraftVersion;
            if (inputStream == null) {
                b.warn("Missing version information!");
                WorldVersion worldVersion = a;
                return worldVersion;
            }
            try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
                minecraftVersion = new MinecraftVersion(ChatDeserializer.a(inputStreamReader));
            }
            return minecraftVersion;
        }
        catch (JsonParseException | IOException exception) {
            throw new IllegalStateException("Game version information is corrupt", exception);
        }
    }

    @Override
    @Override
    public String b() {
        return this.c;
    }

    @Override
    @Override
    public String c() {
        return this.d;
    }

    @Override
    @Override
    public DataVersion d() {
        return this.f;
    }

    @Override
    @Override
    public int e() {
        return this.g;
    }

    @Override
    @Override
    public int a(EnumResourcePackType type) {
        return type == EnumResourcePackType.b ? this.i : this.h;
    }

    @Override
    @Override
    public Date f() {
        return this.j;
    }

    @Override
    @Override
    public boolean g() {
        return this.e;
    }
}

