/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public class CriterionConditionPlayer
implements EntitySubPredicate {
    public static final int b = 100;
    private final CriterionConditionValue.IntegerRange c;
    @Nullable
    private final EnumGamemode d;
    private final Map<Statistic<?>, CriterionConditionValue.IntegerRange> e;
    private final Object2BooleanMap<MinecraftKey> f;
    private final Map<MinecraftKey, c> g;
    private final CriterionConditionEntity h;

    private static c b(JsonElement json) {
        if (json.isJsonPrimitive()) {
            boolean bl = json.getAsBoolean();
            return new b(bl);
        }
        Object2BooleanOpenHashMap object2BooleanMap = new Object2BooleanOpenHashMap();
        JsonObject jsonObject = ChatDeserializer.m(json, "criterion data");
        jsonObject.entrySet().forEach(arg_0 -> CriterionConditionPlayer.a((Object2BooleanMap)object2BooleanMap, arg_0));
        return new a((Object2BooleanMap<String>)object2BooleanMap);
    }

    CriterionConditionPlayer(CriterionConditionValue.IntegerRange experienceLevel, @Nullable EnumGamemode gameMode, Map<Statistic<?>, CriterionConditionValue.IntegerRange> stats, Object2BooleanMap<MinecraftKey> recipes, Map<MinecraftKey, c> advancements, CriterionConditionEntity lookingAt) {
        this.c = experienceLevel;
        this.d = gameMode;
        this.e = stats;
        this.f = recipes;
        this.g = advancements;
        this.h = lookingAt;
    }

    @Override
    @Override
    public boolean a(Entity entity2, WorldServer world, @Nullable Vec3D pos) {
        if (!(entity2 instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer serverPlayer = (EntityPlayer)entity2;
        if (!this.c.d(serverPlayer.cc)) {
            return false;
        }
        if (this.d != null && this.d != serverPlayer.d.b()) {
            return false;
        }
        ServerStatisticManager statsCounter = serverPlayer.D();
        for (Map.Entry<Statistic<?>, CriterionConditionValue.IntegerRange> entry : this.e.entrySet()) {
            int i2 = statsCounter.a(entry.getKey());
            if (entry.getValue().d(i2)) continue;
            return false;
        }
        RecipeBookServer recipeBook = serverPlayer.E();
        for (Object2BooleanMap.Entry entry2 : this.f.object2BooleanEntrySet()) {
            if (recipeBook.b((MinecraftKey)entry2.getKey()) == entry2.getBooleanValue()) continue;
            return false;
        }
        if (!this.g.isEmpty()) {
            AdvancementDataPlayer advancementDataPlayer = serverPlayer.M();
            AdvancementDataWorld serverAdvancementManager = serverPlayer.cH().az();
            for (Map.Entry<MinecraftKey, c> entry3 : this.g.entrySet()) {
                Advancement advancement = serverAdvancementManager.a(entry3.getKey());
                if (advancement != null && entry3.getValue().test(advancementDataPlayer.b(advancement))) continue;
                return false;
            }
        }
        if (this.h != CriterionConditionEntity.a) {
            Vec3D vec3D = serverPlayer.bk();
            Vec3D vec32 = serverPlayer.j(1.0f);
            Vec3D vec33 = vec3D.b(vec32.c * 100.0, vec32.d * 100.0, vec32.e * 100.0);
            MovingObjectPositionEntity entityHitResult = ProjectileHelper.a(serverPlayer.H, serverPlayer, vec3D, vec33, new AxisAlignedBB(vec3D, vec33).g(1.0), entity -> !entity.F_(), 0.0f);
            if (entityHitResult == null || entityHitResult.c() != MovingObjectPosition.EnumMovingObjectType.c) {
                return false;
            }
            Entity entity22 = entityHitResult.a();
            if (!this.h.a(serverPlayer, entity22) || !serverPlayer.B(entity22)) {
                return false;
            }
        }
        return true;
    }

    public static CriterionConditionPlayer a(JsonObject json) {
        CriterionConditionValue.IntegerRange ints = CriterionConditionValue.IntegerRange.a(json.get("level"));
        String string = ChatDeserializer.a(json, "gamemode", "");
        EnumGamemode gameType = EnumGamemode.a(string, null);
        HashMap map = Maps.newHashMap();
        JsonArray jsonArray = ChatDeserializer.a(json, "stats", null);
        if (jsonArray != null) {
            for (JsonElement jsonElement : jsonArray) {
                JsonObject jsonObject = ChatDeserializer.m(jsonElement, "stats entry");
                MinecraftKey resourceLocation = new MinecraftKey(ChatDeserializer.h(jsonObject, "type"));
                StatisticWrapper<?> statType = BuiltInRegistries.x.a(resourceLocation);
                if (statType == null) {
                    throw new JsonParseException("Invalid stat type: " + resourceLocation);
                }
                MinecraftKey resourceLocation2 = new MinecraftKey(ChatDeserializer.h(jsonObject, "stat"));
                Statistic<?> stat = CriterionConditionPlayer.a(statType, resourceLocation2);
                CriterionConditionValue.IntegerRange ints2 = CriterionConditionValue.IntegerRange.a(jsonObject.get("value"));
                map.put(stat, ints2);
            }
        }
        Object2BooleanOpenHashMap object2BooleanMap = new Object2BooleanOpenHashMap();
        JsonObject jsonObject2 = ChatDeserializer.a(json, "recipes", new JsonObject());
        for (Map.Entry entry : jsonObject2.entrySet()) {
            MinecraftKey resourceLocation3 = new MinecraftKey((String)entry.getKey());
            boolean bl = ChatDeserializer.c((JsonElement)entry.getValue(), "recipe present");
            object2BooleanMap.put((Object)resourceLocation3, bl);
        }
        HashMap map2 = Maps.newHashMap();
        JsonObject jsonObject3 = ChatDeserializer.a(json, "advancements", new JsonObject());
        for (Map.Entry entry2 : jsonObject3.entrySet()) {
            MinecraftKey resourceLocation4 = new MinecraftKey((String)entry2.getKey());
            c advancementPredicate = CriterionConditionPlayer.b((JsonElement)entry2.getValue());
            map2.put(resourceLocation4, advancementPredicate);
        }
        CriterionConditionEntity entityPredicate = CriterionConditionEntity.a(json.get("looking_at"));
        return new CriterionConditionPlayer(ints, gameType, map, (Object2BooleanMap<MinecraftKey>)object2BooleanMap, map2, entityPredicate);
    }

    private static <T> Statistic<T> a(StatisticWrapper<T> type, MinecraftKey id) {
        IRegistry<T> registry = type.a();
        T object = registry.a(id);
        if (object == null) {
            throw new JsonParseException("Unknown object " + id + " for stat type " + BuiltInRegistries.x.b(type));
        }
        return type.b(object);
    }

    private static <T> MinecraftKey a(Statistic<T> stat) {
        return stat.a().a().b(stat.b());
    }

    @Override
    @Override
    public JsonObject a() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("level", this.c.d());
        if (this.d != null) {
            jsonObject.addProperty("gamemode", this.d.b());
        }
        if (!this.e.isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            this.e.forEach((stat, ints) -> {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("type", BuiltInRegistries.x.b(stat.a()).toString());
                jsonObject.addProperty("stat", CriterionConditionPlayer.a(stat).toString());
                jsonObject.add("value", ints.d());
                jsonArray.add((JsonElement)jsonObject);
            });
            jsonObject.add("stats", (JsonElement)jsonArray);
        }
        if (!this.f.isEmpty()) {
            JsonObject jsonObject2 = new JsonObject();
            this.f.forEach((id, boolean_) -> jsonObject2.addProperty(id.toString(), boolean_));
            jsonObject.add("recipes", (JsonElement)jsonObject2);
        }
        if (!this.g.isEmpty()) {
            JsonObject jsonObject3 = new JsonObject();
            this.g.forEach((id, advancementPredicate) -> jsonObject3.add(id.toString(), advancementPredicate.a()));
            jsonObject.add("advancements", (JsonElement)jsonObject3);
        }
        jsonObject.add("looking_at", this.h.a());
        return jsonObject;
    }

    @Override
    @Override
    public EntitySubPredicate.a c() {
        return EntitySubPredicate.b.d;
    }

    private static /* synthetic */ void a(Object2BooleanMap object2BooleanMap, Map.Entry entry) {
        boolean bl = ChatDeserializer.c((JsonElement)entry.getValue(), "criterion test");
        object2BooleanMap.put((Object)((String)entry.getKey()), bl);
    }

    static class b
    implements c {
        private final boolean a;

        public b(boolean done) {
            this.a = done;
        }

        @Override
        @Override
        public JsonElement a() {
            return new JsonPrimitive(Boolean.valueOf(this.a));
        }

        @Override
        public boolean a(AdvancementProgress advancementProgress) {
            return advancementProgress.a() == this.a;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((AdvancementProgress)object);
        }
    }

    static class a
    implements c {
        private final Object2BooleanMap<String> a;

        public a(Object2BooleanMap<String> criteria) {
            this.a = criteria;
        }

        @Override
        @Override
        public JsonElement a() {
            JsonObject jsonObject = new JsonObject();
            this.a.forEach((arg_0, arg_1) -> ((JsonObject)jsonObject).addProperty(arg_0, arg_1));
            return jsonObject;
        }

        @Override
        public boolean a(AdvancementProgress advancementProgress) {
            for (Object2BooleanMap.Entry entry : this.a.object2BooleanEntrySet()) {
                CriterionProgress criterionProgress = advancementProgress.c((String)entry.getKey());
                if (criterionProgress != null && criterionProgress.a() == entry.getBooleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((AdvancementProgress)object);
        }
    }

    static interface c
    extends Predicate<AdvancementProgress> {
        public JsonElement a();
    }

    public static class d {
        private CriterionConditionValue.IntegerRange a = CriterionConditionValue.IntegerRange.e;
        @Nullable
        private EnumGamemode b;
        private final Map<Statistic<?>, CriterionConditionValue.IntegerRange> c = Maps.newHashMap();
        private final Object2BooleanMap<MinecraftKey> d = new Object2BooleanOpenHashMap();
        private final Map<MinecraftKey, c> e = Maps.newHashMap();
        private CriterionConditionEntity f = CriterionConditionEntity.a;

        public static d a() {
            return new d();
        }

        public d a(CriterionConditionValue.IntegerRange experienceLevel) {
            this.a = experienceLevel;
            return this;
        }

        public d a(Statistic<?> stat, CriterionConditionValue.IntegerRange value) {
            this.c.put(stat, value);
            return this;
        }

        public d a(MinecraftKey id, boolean unlocked) {
            this.d.put((Object)id, unlocked);
            return this;
        }

        public d a(EnumGamemode gameMode) {
            this.b = gameMode;
            return this;
        }

        public d a(CriterionConditionEntity lookingAt) {
            this.f = lookingAt;
            return this;
        }

        public d b(MinecraftKey id, boolean done) {
            this.e.put(id, new b(done));
            return this;
        }

        public d a(MinecraftKey id, Map<String, Boolean> criteria) {
            this.e.put(id, new a((Object2BooleanMap<String>)new Object2BooleanOpenHashMap(criteria)));
            return this;
        }

        public CriterionConditionPlayer b() {
            return new CriterionConditionPlayer(this.a, this.b, this.c, this.d, this.e, this.f);
        }
    }
}

