/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.destroystokyo.paper.brigadier.BukkitBrigadierCommandSource;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ResultConsumer;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BinaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TaskChainer;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_19_R3.command.VanillaCommandWrapper;
import org.bukkit.entity.Entity;
import org.spigotmc.SpigotConfig;

public class CommandListenerWrapper
implements ICompletionProvider,
BukkitBrigadierCommandSource {
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("permissions.requires.player"));
    public static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("permissions.requires.entity"));
    public final ICommandListener c;
    private final Vec3D d;
    private final WorldServer e;
    private final int f;
    private final String g;
    private final IChatBaseComponent h;
    private final MinecraftServer i;
    private final boolean j;
    @Nullable
    private final net.minecraft.world.entity.Entity k;
    @Nullable
    private final ResultConsumer<CommandListenerWrapper> l;
    private final ArgumentAnchor.Anchor m;
    private final Vec2F n;
    private final CommandSigningContext o;
    private final TaskChainer p;
    public Map<Thread, CommandNode> currentCommand = new ConcurrentHashMap<Thread, CommandNode>();
    public boolean bypassSelectorPermissions = false;

    public CommandListenerWrapper(ICommandListener output, Vec3D pos, Vec2F rot, WorldServer world, int level, String name, IChatBaseComponent displayName, MinecraftServer server, @Nullable net.minecraft.world.entity.Entity entity) {
        this(output, pos, rot, world, level, name, displayName, server, entity, false, (ResultConsumer<CommandListenerWrapper>)((ResultConsumer)(commandcontext, flag, j2) -> {}), ArgumentAnchor.Anchor.a, CommandSigningContext.a, TaskChainer.immediate(server));
    }

    protected CommandListenerWrapper(ICommandListener output, Vec3D pos, Vec2F rot, WorldServer world, int level, String name, IChatBaseComponent displayName, MinecraftServer server, @Nullable net.minecraft.world.entity.Entity entity, boolean silent, @Nullable ResultConsumer<CommandListenerWrapper> consumer, ArgumentAnchor.Anchor entityAnchor, CommandSigningContext signedArguments, TaskChainer messageChainTaskQueue) {
        this.c = output;
        this.d = pos;
        this.e = world;
        this.j = silent;
        this.k = entity;
        this.f = level;
        this.g = name;
        this.h = displayName;
        this.i = server;
        this.l = consumer;
        this.m = entityAnchor;
        this.n = rot;
        this.o = signedArguments;
        this.p = messageChainTaskQueue;
    }

    public CommandListenerWrapper a(ICommandListener output) {
        return this.c == output ? this : new CommandListenerWrapper(output, this.d, this.n, this.e, this.f, this.g, this.h, this.i, this.k, this.j, this.l, this.m, this.o, this.p);
    }

    public CommandListenerWrapper a(net.minecraft.world.entity.Entity entity) {
        return this.k == entity ? this : new CommandListenerWrapper(this.c, this.d, this.n, this.e, this.f, entity.Z().getString(), entity.G_(), this.i, entity, this.j, this.l, this.m, this.o, this.p);
    }

    public CommandListenerWrapper a(Vec3D position) {
        return this.d.equals(position) ? this : new CommandListenerWrapper(this.c, position, this.n, this.e, this.f, this.g, this.h, this.i, this.k, this.j, this.l, this.m, this.o, this.p);
    }

    public CommandListenerWrapper a(Vec2F rotation) {
        return this.n.c(rotation) ? this : new CommandListenerWrapper(this.c, this.d, rotation, this.e, this.f, this.g, this.h, this.i, this.k, this.j, this.l, this.m, this.o, this.p);
    }

    public CommandListenerWrapper a(ResultConsumer<CommandListenerWrapper> consumer) {
        return Objects.equals(this.l, consumer) ? this : new CommandListenerWrapper(this.c, this.d, this.n, this.e, this.f, this.g, this.h, this.i, this.k, this.j, consumer, this.m, this.o, this.p);
    }

    public CommandListenerWrapper a(ResultConsumer<CommandListenerWrapper> consumer, BinaryOperator<ResultConsumer<CommandListenerWrapper>> merger) {
        ResultConsumer resultconsumer1 = (ResultConsumer)merger.apply(this.l, consumer);
        return this.a((ResultConsumer<CommandListenerWrapper>)resultconsumer1);
    }

    public CommandListenerWrapper a() {
        return !this.j && !this.c.e_() ? new CommandListenerWrapper(this.c, this.d, this.n, this.e, this.f, this.g, this.h, this.i, this.k, true, this.l, this.m, this.o, this.p) : this;
    }

    public CommandListenerWrapper a(int level) {
        return level == this.f ? this : new CommandListenerWrapper(this.c, this.d, this.n, this.e, level, this.g, this.h, this.i, this.k, this.j, this.l, this.m, this.o, this.p);
    }

    public CommandListenerWrapper b(int level) {
        return level <= this.f ? this : new CommandListenerWrapper(this.c, this.d, this.n, this.e, level, this.g, this.h, this.i, this.k, this.j, this.l, this.m, this.o, this.p);
    }

    public CommandListenerWrapper a(ArgumentAnchor.Anchor anchor) {
        return anchor == this.m ? this : new CommandListenerWrapper(this.c, this.d, this.n, this.e, this.f, this.g, this.h, this.i, this.k, this.j, this.l, anchor, this.o, this.p);
    }

    public CommandListenerWrapper a(WorldServer world) {
        if (world == this.e) {
            return this;
        }
        double d0 = DimensionManager.a(this.e.q_(), world.q_());
        Vec3D vec3d = new Vec3D(this.d.c * d0, this.d.d, this.d.e * d0);
        return new CommandListenerWrapper(this.c, vec3d, this.n, world, this.f, this.g, this.h, this.i, this.k, this.j, this.l, this.m, this.o, this.p);
    }

    public CommandListenerWrapper a(net.minecraft.world.entity.Entity entity, ArgumentAnchor.Anchor anchor) {
        return this.b(anchor.a(entity));
    }

    public CommandListenerWrapper b(Vec3D position) {
        Vec3D vec3d1 = this.m.a(this);
        double d0 = position.c - vec3d1.c;
        double d1 = position.d - vec3d1.d;
        double d2 = position.e - vec3d1.e;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float f2 = MathHelper.g((float)(-(MathHelper.d(d1, d3) * 57.2957763671875)));
        float f1 = MathHelper.g((float)(MathHelper.d(d2, d0) * 57.2957763671875) - 90.0f);
        return this.a(new Vec2F(f2, f1));
    }

    public CommandListenerWrapper a(CommandSigningContext signedArguments) {
        return signedArguments == this.o ? this : new CommandListenerWrapper(this.c, this.d, this.n, this.e, this.f, this.g, this.h, this.i, this.k, this.j, this.l, this.m, signedArguments, this.p);
    }

    public CommandListenerWrapper a(TaskChainer messageChainTaskQueue) {
        return messageChainTaskQueue == this.p ? this : new CommandListenerWrapper(this.c, this.d, this.n, this.e, this.f, this.g, this.h, this.i, this.k, this.j, this.l, this.m, this.o, messageChainTaskQueue);
    }

    public IChatBaseComponent b() {
        return this.h;
    }

    public String c() {
        return this.g;
    }

    public Entity getBukkitEntity() {
        return this.f() != null ? this.f().getBukkitEntity() : null;
    }

    public org.bukkit.World getBukkitWorld() {
        return this.e() != null ? this.e().getWorld() : null;
    }

    public Location getBukkitLocation() {
        Vec3D pos = this.d();
        org.bukkit.World world = this.getBukkitWorld();
        Vec2F rot = this.k();
        return world != null && pos != null ? new Location(world, pos.c, pos.d, pos.e, rot != null ? rot.j : 0.0f, rot != null ? rot.i : 0.0f) : null;
    }

    @Override
    public boolean c(int level) {
        CommandNode currentCommand = this.currentCommand.get(Thread.currentThread());
        if (currentCommand != null) {
            return this.hasPermission(level, VanillaCommandWrapper.getPermission(currentCommand));
        }
        return this.f >= level;
    }

    public boolean hasPermission(int i2, String bukkitPermission) {
        return (this.e() == null || !this.e().getCraftServer().ignoreVanillaPermissions) && this.f >= i2 || this.getBukkitSender().hasPermission(bukkitPermission);
    }

    public Vec3D d() {
        return this.d;
    }

    public WorldServer e() {
        return this.e;
    }

    @Nullable
    public net.minecraft.world.entity.Entity f() {
        return this.k;
    }

    public net.minecraft.world.entity.Entity g() throws CommandSyntaxException {
        if (this.k == null) {
            throw b.create();
        }
        return this.k;
    }

    public EntityPlayer h() throws CommandSyntaxException {
        net.minecraft.world.entity.Entity entity = this.k;
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            return entityplayer;
        }
        throw a.create();
    }

    @Nullable
    public EntityPlayer i() {
        EntityPlayer entityplayer1;
        net.minecraft.world.entity.Entity entity = this.k;
        EntityPlayer entityplayer = entity instanceof EntityPlayer ? (entityplayer1 = (EntityPlayer)entity) : null;
        return entityplayer;
    }

    public boolean j() {
        return this.k instanceof EntityPlayer;
    }

    public Vec2F k() {
        return this.n;
    }

    public MinecraftServer l() {
        return this.i;
    }

    public ArgumentAnchor.Anchor m() {
        return this.m;
    }

    public CommandSigningContext n() {
        return this.o;
    }

    public TaskChainer o() {
        return this.p;
    }

    public boolean a(EntityPlayer recipient) {
        EntityPlayer entityplayer1 = this.i();
        return recipient == entityplayer1 ? false : entityplayer1 != null && entityplayer1.U() || recipient.U();
    }

    public void a(OutgoingChatMessage message, boolean filterMaskEnabled, ChatMessageType.a params) {
        if (!this.j) {
            EntityPlayer entityplayer = this.i();
            if (entityplayer != null) {
                entityplayer.a(message, filterMaskEnabled, params);
            } else {
                this.c.a(params.a(message.a()));
            }
        }
    }

    public void a(IChatBaseComponent message) {
        if (!this.j) {
            EntityPlayer entityplayer = this.i();
            if (entityplayer != null) {
                entityplayer.a(message);
            } else {
                this.c.a(message);
            }
        }
    }

    public void a(IChatBaseComponent message, boolean broadcastToOps) {
        if (this.c.d_() && !this.j) {
            this.c.a(message);
        }
        if (broadcastToOps && this.c.M_() && !this.j) {
            this.c(message);
        }
    }

    private void c(IChatBaseComponent message) {
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("chat.type.admin", this.b(), message).a(EnumChatFormat.h, EnumChatFormat.u);
        if (this.i.aK().b(GameRules.o)) {
            for (EntityPlayer entityplayer : this.i.ac().t()) {
                if (entityplayer == this.c || !entityplayer.getBukkitEntity().hasPermission("minecraft.admin.command_feedback")) continue;
                entityplayer.a(ichatmutablecomponent);
            }
        }
        if (this.c != this.i && this.i.aK().b(GameRules.l) && !SpigotConfig.silentCommandBlocks) {
            this.i.a(ichatmutablecomponent);
        }
    }

    public void b(IChatBaseComponent message) {
        this.sendFailure(message, true);
    }

    public void sendFailure(IChatBaseComponent message, boolean withStyle) {
        if (this.c.j_() && !this.j) {
            this.c.a(withStyle ? IChatBaseComponent.h().b(message).a(EnumChatFormat.m) : message);
        }
    }

    public void a(CommandContext<CommandListenerWrapper> context, boolean success, int result) {
        if (this.l != null) {
            this.l.onCommandComplete(context, success, result);
        }
    }

    @Override
    public Collection<String> p() {
        return Lists.newArrayList((Object[])this.i.J());
    }

    @Override
    public Collection<String> q() {
        return this.i.aF().f();
    }

    @Override
    public Stream<MinecraftKey> r() {
        return BuiltInRegistries.c.s().map(SoundEffect::a);
    }

    @Override
    public Stream<MinecraftKey> s() {
        return this.i.aE().d();
    }

    @Override
    public CompletableFuture<Suggestions> a(CommandContext<?> context) {
        return Suggestions.empty();
    }

    @Override
    public CompletableFuture<Suggestions> a(ResourceKey<? extends IRegistry<?>> registryRef, ICompletionProvider.a suggestedIdType, SuggestionsBuilder builder, CommandContext<?> context) {
        return this.u().c(registryRef).map(iregistry -> {
            this.a((IRegistry<?>)iregistry, suggestedIdType, builder);
            return builder.buildFuture();
        }).orElseGet(Suggestions::empty);
    }

    @Override
    public Set<ResourceKey<World>> t() {
        return this.i.E();
    }

    @Override
    public IRegistryCustom u() {
        return this.i.aX();
    }

    @Override
    public FeatureFlagSet v() {
        return this.e.G();
    }

    public CommandSender getBukkitSender() {
        return this.c.getBukkitSender(this);
    }

    @Override
    public Collection<String> x() {
        ICommandListener iCommandListener;
        if (GlobalConfiguration.get().commands.fixTargetSelectorTagCompletion && (iCommandListener = this.c) instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)iCommandListener;
            double pickDistance = player.d.b().g() ? 5.0 : 4.5;
            Vec3D min = player.n(1.0f);
            Vec3D viewVector = player.j(1.0f);
            Vec3D max = min.b(viewVector.c * pickDistance, viewVector.d * pickDistance, viewVector.e * pickDistance);
            AxisAlignedBB aabb = player.cD().b(viewVector.a(pickDistance)).c(1.0, 1.0, 1.0);
            pickDistance = player.d.b().g() ? 6.0 : pickDistance;
            MovingObjectPositionEntity hitResult = ProjectileHelper.a(player, min, max, aabb, e2 -> !e2.F_() && e2.bm(), pickDistance);
            return hitResult != null ? Collections.singletonList(hitResult.a().ct()) : ICompletionProvider.super.x();
        }
        return ICompletionProvider.super.x();
    }
}

