/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;

public class ResourceKeyArgument<T>
implements ArgumentType<ResourceKey<T>> {
    private static final Collection<String> a = Arrays.asList("foo", "foo:bar", "012");
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(id -> IChatBaseComponent.a("commands.place.feature.invalid", id));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(id -> IChatBaseComponent.a("commands.place.structure.invalid", id));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(id -> IChatBaseComponent.a("commands.place.jigsaw.invalid", id));
    final ResourceKey<? extends IRegistry<T>> e;

    public ResourceKeyArgument(ResourceKey<? extends IRegistry<T>> registryRef) {
        this.e = registryRef;
    }

    public static <T> ResourceKeyArgument<T> a(ResourceKey<? extends IRegistry<T>> registryRef) {
        return new ResourceKeyArgument<T>(registryRef);
    }

    private static <T> ResourceKey<T> a(CommandContext<CommandListenerWrapper> context, String name, ResourceKey<IRegistry<T>> registryRef, DynamicCommandExceptionType invalidException) throws CommandSyntaxException {
        ResourceKey resourceKey = (ResourceKey)context.getArgument(name, ResourceKey.class);
        Optional<ResourceKey<T>> optional = resourceKey.c(registryRef);
        return optional.orElseThrow(() -> invalidException.create((Object)resourceKey));
    }

    private static <T> IRegistry<T> a(CommandContext<CommandListenerWrapper> context, ResourceKey<? extends IRegistry<T>> registryRef) {
        return ((CommandListenerWrapper)context.getSource()).l().aX().d(registryRef);
    }

    private static <T> Holder.c<T> b(CommandContext<CommandListenerWrapper> context, String name, ResourceKey<IRegistry<T>> registryRef, DynamicCommandExceptionType invalidException) throws CommandSyntaxException {
        ResourceKey resourceKey = ResourceKeyArgument.a(context, name, registryRef, invalidException);
        return ResourceKeyArgument.a(context, registryRef).b(resourceKey).orElseThrow(() -> invalidException.create((Object)resourceKey.a()));
    }

    public static Holder.c<WorldGenFeatureConfigured<?, ?>> a(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ResourceKeyArgument.b(context, name, Registries.aq, b);
    }

    public static Holder.c<Structure> b(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ResourceKeyArgument.b(context, name, Registries.ax, c);
    }

    public static Holder.c<WorldGenFeatureDefinedStructurePoolTemplate> c(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ResourceKeyArgument.b(context, name, Registries.aA, d);
    }

    public ResourceKey<T> a(StringReader stringReader) throws CommandSyntaxException {
        MinecraftKey resourceLocation = MinecraftKey.a(stringReader);
        return ResourceKey.a(this.e, resourceLocation);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        Object object = commandContext.getSource();
        if (object instanceof ICompletionProvider) {
            ICompletionProvider sharedSuggestionProvider = (ICompletionProvider)object;
            return sharedSuggestionProvider.a(this.e, ICompletionProvider.a.b, suggestionsBuilder, commandContext);
        }
        return suggestionsBuilder.buildFuture();
    }

    public Collection<String> getExamples() {
        return a;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.a(stringReader);
    }

    public static class net.minecraft.commands.arguments.ResourceKeyArgument$a<T>
    implements ArgumentTypeInfo<ResourceKeyArgument<T>, a> {
        @Override
        @Override
        public void a(a properties, PacketDataSerializer buf) {
            buf.a(properties.b.a());
        }

        @Override
        @Override
        public a a(PacketDataSerializer friendlyByteBuf) {
            MinecraftKey resourceLocation = friendlyByteBuf.t();
            return new a(ResourceKey.a(resourceLocation));
        }

        @Override
        @Override
        public void a(a properties, JsonObject json) {
            json.addProperty("registry", properties.b.a().toString());
        }

        @Override
        @Override
        public a a(ResourceKeyArgument<T> argumentType) {
            return new a(argumentType.e);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.a b(PacketDataSerializer buf) {
            return this.a(buf);
        }

        public final class a
        implements ArgumentTypeInfo.a<ResourceKeyArgument<T>> {
            final ResourceKey<? extends IRegistry<T>> b;

            a(ResourceKey<? extends IRegistry<T>> registryRef) {
                this.b = registryRef;
            }

            @Override
            public ResourceKeyArgument<T> a(CommandBuildContext commandBuildContext) {
                return new ResourceKeyArgument(this.b);
            }

            @Override
            @Override
            public ArgumentTypeInfo<ResourceKeyArgument<T>, ?> a() {
                return a.this;
            }

            @Override
            public /* synthetic */ ArgumentType b(CommandBuildContext commandRegistryAccess) {
                return this.a(commandRegistryAccess);
            }
        }
    }
}

