/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector;

import com.google.common.primitives.Doubles;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionRange;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.options.PlayerSelector;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class ArgumentParserSelector {
    public static final char a = '@';
    private static final char o = '[';
    private static final char p = ']';
    public static final char b = '=';
    private static final char q = ',';
    public static final char c = '!';
    public static final char d = '#';
    private static final char r = 'p';
    private static final char s = 'a';
    private static final char t = 'r';
    private static final char u = 's';
    private static final char v = 'e';
    public static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.invalid"));
    public static final DynamicCommandExceptionType f = new DynamicCommandExceptionType(object -> IChatBaseComponent.a("argument.entity.selector.unknown", object));
    public static final SimpleCommandExceptionType g = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.selector.not_allowed"));
    public static final SimpleCommandExceptionType h = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.selector.missing"));
    public static final SimpleCommandExceptionType i = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.options.unterminated"));
    public static final DynamicCommandExceptionType j = new DynamicCommandExceptionType(object -> IChatBaseComponent.a("argument.entity.options.valueless", object));
    public static final BiConsumer<Vec3D, List<? extends Entity>> k = (vec3d, list) -> list.sort((entity, entity1) -> Doubles.compare((double)entity.e((Vec3D)vec3d), (double)entity1.e((Vec3D)vec3d)));
    public static final BiConsumer<Vec3D, List<? extends Entity>> l = (vec3d, list) -> list.sort((entity, entity1) -> Doubles.compare((double)entity1.e((Vec3D)vec3d), (double)entity.e((Vec3D)vec3d)));
    public static final BiConsumer<Vec3D, List<? extends Entity>> m = (vec3d, list) -> Collections.shuffle(list);
    public static final BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> n = (suggestionsbuilder, consumer) -> suggestionsbuilder.buildFuture();
    private final StringReader w;
    private final boolean x;
    private int y;
    private boolean z;
    private boolean A;
    private CriterionConditionValue.DoubleRange B;
    private CriterionConditionValue.IntegerRange C;
    @Nullable
    private Double D;
    @Nullable
    private Double E;
    @Nullable
    private Double F;
    @Nullable
    private Double G;
    @Nullable
    private Double H;
    @Nullable
    private Double I;
    private CriterionConditionRange J;
    private CriterionConditionRange K;
    private Predicate<Entity> L;
    private BiConsumer<Vec3D, List<? extends Entity>> M;
    private boolean N;
    @Nullable
    private String O;
    private int P;
    @Nullable
    private UUID Q;
    private BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> R;
    private boolean S;
    private boolean T;
    private boolean U;
    private boolean V;
    private boolean W;
    private boolean X;
    private boolean Y;
    private boolean Z;
    @Nullable
    private EntityTypes<?> aa;
    private boolean ab;
    private boolean ac;
    private boolean ad;
    private boolean ae;
    public boolean parsingEntityArgumentSuggestions;

    public ArgumentParserSelector(StringReader reader) {
        this(reader, true);
    }

    public ArgumentParserSelector(StringReader reader, boolean atAllowed) {
        this(reader, atAllowed, false);
    }

    public ArgumentParserSelector(StringReader reader, boolean atAllowed, boolean parsingEntityArgumentSuggestions) {
        this.parsingEntityArgumentSuggestions = parsingEntityArgumentSuggestions;
        this.B = CriterionConditionValue.DoubleRange.e;
        this.C = CriterionConditionValue.IntegerRange.e;
        this.J = CriterionConditionRange.a;
        this.K = CriterionConditionRange.a;
        this.L = entity -> true;
        this.M = EntitySelector.b;
        this.R = n;
        this.w = reader;
        this.x = atAllowed;
    }

    public EntitySelector a() {
        AxisAlignedBB axisalignedbb;
        if (this.G == null && this.H == null && this.I == null) {
            if (this.B.b() != null) {
                double d0 = (Double)this.B.b();
                axisalignedbb = new AxisAlignedBB(-d0, -d0, -d0, d0 + 1.0, d0 + 1.0, d0 + 1.0);
            } else {
                axisalignedbb = null;
            }
        } else {
            axisalignedbb = this.a(this.G == null ? 0.0 : this.G, this.H == null ? 0.0 : this.H, this.I == null ? 0.0 : this.I);
        }
        Function<Vec3D, Vec3D> function = this.D == null && this.E == null && this.F == null ? vec3d -> vec3d : vec3d -> new Vec3D(this.D == null ? vec3d.c : this.D, this.E == null ? vec3d.d : this.E, this.F == null ? vec3d.e : this.F);
        return new EntitySelector(this.y, this.z, this.A, this.L, this.B, function, axisalignedbb, this.M, this.N, this.O, this.Q, this.aa, this.ae);
    }

    private AxisAlignedBB a(double x2, double y2, double z2) {
        boolean flag = x2 < 0.0;
        boolean flag1 = y2 < 0.0;
        boolean flag2 = z2 < 0.0;
        double d3 = flag ? x2 : 0.0;
        double d4 = flag1 ? y2 : 0.0;
        double d5 = flag2 ? z2 : 0.0;
        double d6 = (flag ? 0.0 : x2) + 1.0;
        double d7 = (flag1 ? 0.0 : y2) + 1.0;
        double d8 = (flag2 ? 0.0 : z2) + 1.0;
        return new AxisAlignedBB(d3, d4, d5, d6, d7, d8);
    }

    private void I() {
        if (this.J != CriterionConditionRange.a) {
            this.L = this.L.and(this.a(this.J, Entity::dy));
        }
        if (this.K != CriterionConditionRange.a) {
            this.L = this.L.and(this.a(this.K, Entity::dw));
        }
        if (!this.C.c()) {
            this.L = this.L.and(entity -> !(entity instanceof EntityPlayer) ? false : this.C.d(((EntityPlayer)entity).cc));
        }
    }

    private Predicate<Entity> a(CriterionConditionRange angleRange, ToDoubleFunction<Entity> entityToAngle) {
        double d0 = MathHelper.g(angleRange.a() == null ? 0.0f : angleRange.a().floatValue());
        double d1 = MathHelper.g(angleRange.b() == null ? 359.0f : angleRange.b().floatValue());
        return entity -> {
            double d2 = MathHelper.d(entityToAngle.applyAsDouble((Entity)entity));
            return d0 > d1 ? d2 >= d0 || d2 <= d1 : d2 >= d0 && d2 <= d1;
        };
    }

    protected void parseSelector(boolean overridePermissions) throws CommandSyntaxException {
        this.ae = !overridePermissions;
        this.R = this::d;
        if (!this.w.canRead()) {
            throw h.createWithContext((ImmutableStringReader)this.w);
        }
        int i2 = this.w.getCursor();
        char c0 = this.w.read();
        if (c0 == 'p') {
            this.y = 1;
            this.z = false;
            this.M = k;
            this.a(EntityTypes.bt);
        } else if (c0 == 'a') {
            this.y = Integer.MAX_VALUE;
            this.z = false;
            this.M = EntitySelector.b;
            this.a(EntityTypes.bt);
        } else if (c0 == 'r') {
            this.y = 1;
            this.z = false;
            this.M = m;
            this.a(EntityTypes.bt);
        } else if (c0 == 's') {
            this.y = 1;
            this.z = true;
            this.N = true;
        } else {
            if (c0 != 'e') {
                this.w.setCursor(i2);
                throw f.createWithContext((ImmutableStringReader)this.w, (Object)("@" + String.valueOf(c0)));
            }
            this.y = Integer.MAX_VALUE;
            this.z = true;
            this.M = EntitySelector.b;
            this.L = Entity::bq;
        }
        this.R = this::e;
        if (this.w.canRead() && this.w.peek() == '[') {
            this.w.skip();
            this.R = this::f;
            this.d();
        }
    }

    protected void c() throws CommandSyntaxException {
        if (this.w.canRead()) {
            this.R = this::c;
        }
        int i2 = this.w.getCursor();
        String s2 = this.w.readString();
        try {
            this.Q = UUID.fromString(s2);
            this.z = true;
        }
        catch (IllegalArgumentException illegalargumentexception) {
            if (s2.isEmpty() || s2.length() > 16) {
                this.w.setCursor(i2);
                throw e.createWithContext((ImmutableStringReader)this.w);
            }
            this.z = false;
            this.O = s2;
        }
        this.y = 1;
    }

    protected void d() throws CommandSyntaxException {
        this.R = this::g;
        this.w.skipWhitespace();
        while (this.w.canRead() && this.w.peek() != ']') {
            this.w.skipWhitespace();
            int i2 = this.w.getCursor();
            String s2 = this.w.readString();
            PlayerSelector.a playerselector_a = PlayerSelector.a(this, s2, i2);
            this.w.skipWhitespace();
            if (!this.w.canRead() || this.w.peek() != '=') {
                this.w.setCursor(i2);
                throw j.createWithContext((ImmutableStringReader)this.w, (Object)s2);
            }
            this.w.skip();
            this.w.skipWhitespace();
            this.R = n;
            playerselector_a.handle(this);
            this.w.skipWhitespace();
            this.R = this::h;
            if (!this.w.canRead()) continue;
            if (this.w.peek() == ',') {
                this.w.skip();
                this.R = this::g;
                continue;
            }
            if (this.w.peek() == ']') break;
            throw i.createWithContext((ImmutableStringReader)this.w);
        }
        if (this.w.canRead()) {
            this.w.skip();
            this.R = n;
            return;
        }
        throw i.createWithContext((ImmutableStringReader)this.w);
    }

    public boolean e() {
        this.w.skipWhitespace();
        if (this.w.canRead() && this.w.peek() == '!') {
            this.w.skip();
            this.w.skipWhitespace();
            return true;
        }
        return false;
    }

    public boolean f() {
        this.w.skipWhitespace();
        if (this.w.canRead() && this.w.peek() == '#') {
            this.w.skip();
            this.w.skipWhitespace();
            return true;
        }
        return false;
    }

    public StringReader g() {
        return this.w;
    }

    public void a(Predicate<Entity> predicate) {
        this.L = this.L.and(predicate);
    }

    public void h() {
        this.A = true;
    }

    public CriterionConditionValue.DoubleRange i() {
        return this.B;
    }

    public void a(CriterionConditionValue.DoubleRange distance) {
        this.B = distance;
    }

    public CriterionConditionValue.IntegerRange j() {
        return this.C;
    }

    public void a(CriterionConditionValue.IntegerRange levelRange) {
        this.C = levelRange;
    }

    public CriterionConditionRange k() {
        return this.J;
    }

    public void a(CriterionConditionRange pitchRange) {
        this.J = pitchRange;
    }

    public CriterionConditionRange l() {
        return this.K;
    }

    public void b(CriterionConditionRange yawRange) {
        this.K = yawRange;
    }

    @Nullable
    public Double m() {
        return this.D;
    }

    @Nullable
    public Double n() {
        return this.E;
    }

    @Nullable
    public Double o() {
        return this.F;
    }

    public void a(double x2) {
        this.D = x2;
    }

    public void b(double y2) {
        this.E = y2;
    }

    public void c(double z2) {
        this.F = z2;
    }

    public void d(double dx) {
        this.G = dx;
    }

    public void e(double dy) {
        this.H = dy;
    }

    public void f(double dz) {
        this.I = dz;
    }

    @Nullable
    public Double p() {
        return this.G;
    }

    @Nullable
    public Double q() {
        return this.H;
    }

    @Nullable
    public Double r() {
        return this.I;
    }

    public void a(int limit) {
        this.y = limit;
    }

    public void a(boolean includesNonPlayers) {
        this.z = includesNonPlayers;
    }

    public BiConsumer<Vec3D, List<? extends Entity>> s() {
        return this.M;
    }

    public void a(BiConsumer<Vec3D, List<? extends Entity>> sorter) {
        this.M = sorter;
    }

    public EntitySelector t() throws CommandSyntaxException {
        return this.parse(false);
    }

    public EntitySelector parse(boolean overridePermissions) throws CommandSyntaxException {
        this.P = this.w.getCursor();
        this.R = this::b;
        if (this.w.canRead() && this.w.peek() == '@') {
            if (!this.x) {
                throw g.createWithContext((ImmutableStringReader)this.w);
            }
            this.w.skip();
            this.parseSelector(overridePermissions);
        } else {
            this.c();
        }
        this.I();
        return this.a();
    }

    private static void a(SuggestionsBuilder builder) {
        builder.suggest("@p", (Message)IChatBaseComponent.c("argument.entity.selector.nearestPlayer"));
        builder.suggest("@a", (Message)IChatBaseComponent.c("argument.entity.selector.allPlayers"));
        builder.suggest("@r", (Message)IChatBaseComponent.c("argument.entity.selector.randomPlayer"));
        builder.suggest("@s", (Message)IChatBaseComponent.c("argument.entity.selector.self"));
        builder.suggest("@e", (Message)IChatBaseComponent.c("argument.entity.selector.allEntities"));
    }

    private CompletableFuture<Suggestions> b(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        consumer.accept(builder);
        if (this.x) {
            ArgumentParserSelector.a(builder);
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> c(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        SuggestionsBuilder suggestionsbuilder1 = builder.createOffset(this.P);
        consumer.accept(suggestionsbuilder1);
        return builder.add(suggestionsbuilder1).buildFuture();
    }

    private CompletableFuture<Suggestions> d(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        SuggestionsBuilder suggestionsbuilder1 = builder.createOffset(builder.getStart() - 1);
        ArgumentParserSelector.a(suggestionsbuilder1);
        builder.add(suggestionsbuilder1);
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> e(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest(String.valueOf('['));
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> f(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest(String.valueOf(']'));
        PlayerSelector.a(this, builder);
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> g(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        PlayerSelector.a(this, builder);
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> h(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest(String.valueOf(','));
        builder.suggest(String.valueOf(']'));
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> i(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        builder.suggest(String.valueOf('='));
        return builder.buildFuture();
    }

    public boolean u() {
        return this.N;
    }

    public void a(BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> suggestionProvider) {
        this.R = suggestionProvider;
    }

    public CompletableFuture<Suggestions> a(SuggestionsBuilder builder, Consumer<SuggestionsBuilder> consumer) {
        return this.R.apply(builder.createOffset(this.w.getCursor()), consumer);
    }

    public boolean v() {
        return this.S;
    }

    public void b(boolean selectsName) {
        this.S = selectsName;
    }

    public boolean w() {
        return this.T;
    }

    public void c(boolean excludesName) {
        this.T = excludesName;
    }

    public boolean x() {
        return this.U;
    }

    public void d(boolean hasLimit) {
        this.U = hasLimit;
    }

    public boolean y() {
        return this.V;
    }

    public void e(boolean hasSorter) {
        this.V = hasSorter;
    }

    public boolean z() {
        return this.W;
    }

    public void f(boolean selectsGameMode) {
        this.W = selectsGameMode;
    }

    public boolean A() {
        return this.X;
    }

    public void g(boolean excludesGameMode) {
        this.X = excludesGameMode;
    }

    public boolean B() {
        return this.Y;
    }

    public void h(boolean selectsTeam) {
        this.Y = selectsTeam;
    }

    public boolean C() {
        return this.Z;
    }

    public void i(boolean excludesTeam) {
        this.Z = excludesTeam;
    }

    public void a(EntityTypes<?> entityType) {
        this.aa = entityType;
    }

    public void D() {
        this.ab = true;
    }

    public boolean E() {
        return this.aa != null;
    }

    public boolean F() {
        return this.ab;
    }

    public boolean G() {
        return this.ac;
    }

    public void j(boolean selectsScores) {
        this.ac = selectsScores;
    }

    public boolean H() {
        return this.ad;
    }

    public void k(boolean selectsAdvancements) {
        this.ad = selectsAdvancements;
    }
}

