/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector.options;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.CriterionConditionRange;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeamBase;

public class PlayerSelector {
    private static final Map<String, b> i = Maps.newHashMap();
    public static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(option -> IChatBaseComponent.a("argument.entity.options.unknown", option));
    public static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(option -> IChatBaseComponent.a("argument.entity.options.inapplicable", option));
    public static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.options.distance.negative"));
    public static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.options.level.negative"));
    public static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.entity.options.limit.toosmall"));
    public static final DynamicCommandExceptionType f = new DynamicCommandExceptionType(sortType -> IChatBaseComponent.a("argument.entity.options.sort.irreversible", sortType));
    public static final DynamicCommandExceptionType g = new DynamicCommandExceptionType(gameMode -> IChatBaseComponent.a("argument.entity.options.mode.invalid", gameMode));
    public static final DynamicCommandExceptionType h = new DynamicCommandExceptionType(entity -> IChatBaseComponent.a("argument.entity.options.type.invalid", entity));
    public static final DynamicCommandExceptionType ERROR_ENTITY_TAG_INVALID = new DynamicCommandExceptionType(object -> PaperAdventure.asVanilla(Component.text((String)("Invalid or unknown entity type tag '" + object + "'")).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"You can disable this error in 'paper.yml'")))));

    private static void a(String id, a handler, Predicate<ArgumentParserSelector> condition, IChatBaseComponent description) {
        i.put(id, new b(handler, condition, description));
    }

    public static void a() {
        if (i.isEmpty()) {
            PlayerSelector.a("name", reader -> {
                int i2 = reader.g().getCursor();
                boolean bl = reader.e();
                String string = reader.g().readString();
                if (reader.w() && !bl) {
                    reader.g().setCursor(i2);
                    throw b.createWithContext((ImmutableStringReader)reader.g(), (Object)"name");
                }
                if (bl) {
                    reader.c(true);
                } else {
                    reader.b(true);
                }
                reader.a(readerx -> readerx.Z().getString().equals(string) != bl);
            }, reader -> !reader.v(), IChatBaseComponent.c("argument.entity.options.name.description"));
            PlayerSelector.a("distance", reader -> {
                int i2 = reader.g().getCursor();
                CriterionConditionValue.DoubleRange doubles = CriterionConditionValue.DoubleRange.a(reader.g());
                if (doubles.a() != null && (Double)doubles.a() < 0.0 || doubles.b() != null && (Double)doubles.b() < 0.0) {
                    reader.g().setCursor(i2);
                    throw c.createWithContext((ImmutableStringReader)reader.g());
                }
                reader.a(doubles);
                reader.h();
            }, reader -> reader.i().c(), IChatBaseComponent.c("argument.entity.options.distance.description"));
            PlayerSelector.a("level", reader -> {
                int i2 = reader.g().getCursor();
                CriterionConditionValue.IntegerRange ints = CriterionConditionValue.IntegerRange.a(reader.g());
                if (ints.a() != null && (Integer)ints.a() < 0 || ints.b() != null && (Integer)ints.b() < 0) {
                    reader.g().setCursor(i2);
                    throw d.createWithContext((ImmutableStringReader)reader.g());
                }
                reader.a(ints);
                reader.a(false);
            }, reader -> reader.j().c(), IChatBaseComponent.c("argument.entity.options.level.description"));
            PlayerSelector.a("x", reader -> {
                reader.h();
                reader.a(reader.g().readDouble());
            }, reader -> reader.m() == null, IChatBaseComponent.c("argument.entity.options.x.description"));
            PlayerSelector.a("y", reader -> {
                reader.h();
                reader.b(reader.g().readDouble());
            }, reader -> reader.n() == null, IChatBaseComponent.c("argument.entity.options.y.description"));
            PlayerSelector.a("z", reader -> {
                reader.h();
                reader.c(reader.g().readDouble());
            }, reader -> reader.o() == null, IChatBaseComponent.c("argument.entity.options.z.description"));
            PlayerSelector.a("dx", reader -> {
                reader.h();
                reader.d(reader.g().readDouble());
            }, reader -> reader.p() == null, IChatBaseComponent.c("argument.entity.options.dx.description"));
            PlayerSelector.a("dy", reader -> {
                reader.h();
                reader.e(reader.g().readDouble());
            }, reader -> reader.q() == null, IChatBaseComponent.c("argument.entity.options.dy.description"));
            PlayerSelector.a("dz", reader -> {
                reader.h();
                reader.f(reader.g().readDouble());
            }, reader -> reader.r() == null, IChatBaseComponent.c("argument.entity.options.dz.description"));
            PlayerSelector.a("x_rotation", reader -> reader.a(CriterionConditionRange.a(reader.g(), true, MathHelper::g)), reader -> reader.k() == CriterionConditionRange.a, IChatBaseComponent.c("argument.entity.options.x_rotation.description"));
            PlayerSelector.a("y_rotation", reader -> reader.b(CriterionConditionRange.a(reader.g(), true, MathHelper::g)), reader -> reader.l() == CriterionConditionRange.a, IChatBaseComponent.c("argument.entity.options.y_rotation.description"));
            PlayerSelector.a("limit", reader -> {
                int i2 = reader.g().getCursor();
                int j2 = reader.g().readInt();
                if (j2 < 1) {
                    reader.g().setCursor(i2);
                    throw e.createWithContext((ImmutableStringReader)reader.g());
                }
                reader.a(j2);
                reader.d(true);
            }, reader -> !reader.u() && !reader.x(), IChatBaseComponent.c("argument.entity.options.limit.description"));
            PlayerSelector.a("sort", reader -> {
                int i2 = reader.g().getCursor();
                String string = reader.g().readUnquotedString();
                reader.a((builder, consumer) -> ICompletionProvider.b(Arrays.asList("nearest", "furthest", "random", "arbitrary"), builder));
                reader.a(switch (string) {
                    case "nearest" -> ArgumentParserSelector.k;
                    case "furthest" -> ArgumentParserSelector.l;
                    case "random" -> ArgumentParserSelector.m;
                    case "arbitrary" -> EntitySelector.b;
                    default -> {
                        reader.g().setCursor(i2);
                        throw f.createWithContext((ImmutableStringReader)reader.g(), (Object)string);
                    }
                });
                reader.e(true);
            }, reader -> !reader.u() && !reader.y(), IChatBaseComponent.c("argument.entity.options.sort.description"));
            PlayerSelector.a("gamemode", reader -> {
                reader.a((builder, consumer) -> {
                    String string = builder.getRemaining().toLowerCase(Locale.ROOT);
                    boolean bl = !reader.A();
                    boolean bl2 = true;
                    if (!string.isEmpty()) {
                        if (string.charAt(0) == '!') {
                            bl = false;
                            string = string.substring(1);
                        } else {
                            bl2 = false;
                        }
                    }
                    for (EnumGamemode gameType : EnumGamemode.values()) {
                        if (!gameType.b().toLowerCase(Locale.ROOT).startsWith(string)) continue;
                        if (bl2) {
                            builder.suggest("!" + gameType.b());
                        }
                        if (!bl) continue;
                        builder.suggest(gameType.b());
                    }
                    return builder.buildFuture();
                });
                int i2 = reader.g().getCursor();
                boolean bl = reader.e();
                if (reader.A() && !bl) {
                    reader.g().setCursor(i2);
                    throw b.createWithContext((ImmutableStringReader)reader.g(), (Object)"gamemode");
                }
                String string = reader.g().readUnquotedString();
                EnumGamemode gameType = EnumGamemode.a(string, (EnumGamemode)null);
                if (gameType == null) {
                    reader.g().setCursor(i2);
                    throw g.createWithContext((ImmutableStringReader)reader.g(), (Object)string);
                }
                reader.a(false);
                reader.a(entity -> {
                    if (!(entity instanceof EntityPlayer)) {
                        return false;
                    }
                    EnumGamemode gameType2 = ((EntityPlayer)entity).d.b();
                    return bl ? gameType2 != gameType : gameType2 == gameType;
                });
                if (bl) {
                    reader.g(true);
                } else {
                    reader.f(true);
                }
            }, reader -> !reader.z(), IChatBaseComponent.c("argument.entity.options.gamemode.description"));
            PlayerSelector.a("team", reader -> {
                boolean bl = reader.e();
                String string = reader.g().readUnquotedString();
                reader.a(entity -> {
                    if (!(entity instanceof EntityLiving)) {
                        return false;
                    }
                    ScoreboardTeamBase team = entity.cb();
                    String string2 = team == null ? "" : team.b();
                    return string2.equals(string) != bl;
                });
                if (bl) {
                    reader.i(true);
                } else {
                    reader.h(true);
                }
            }, reader -> !reader.B(), IChatBaseComponent.c("argument.entity.options.team.description"));
            PlayerSelector.a("type", reader -> {
                reader.a((builder, consumer) -> {
                    ICompletionProvider.a(BuiltInRegistries.h.e(), builder, String.valueOf('!'));
                    ICompletionProvider.a(BuiltInRegistries.h.j().map(TagKey::b), builder, "!#");
                    if (!reader.F()) {
                        ICompletionProvider.a(BuiltInRegistries.h.e(), builder);
                        ICompletionProvider.a(BuiltInRegistries.h.j().map(TagKey::b), builder, String.valueOf('#'));
                    }
                    return builder.buildFuture();
                });
                int i2 = reader.g().getCursor();
                boolean bl = reader.e();
                if (reader.F() && !bl) {
                    reader.g().setCursor(i2);
                    throw b.createWithContext((ImmutableStringReader)reader.g(), (Object)"type");
                }
                if (bl) {
                    reader.D();
                }
                if (reader.f()) {
                    TagKey<EntityTypes<?>> tagKey = TagKey.a(Registries.r, MinecraftKey.a(reader.g()));
                    if (reader.parsingEntityArgumentSuggestions && GlobalConfiguration.get().commands.fixTargetSelectorTagCompletion && BuiltInRegistries.h.b(tagKey).isEmpty()) {
                        reader.g().setCursor(i2);
                        throw ERROR_ENTITY_TAG_INVALID.createWithContext((ImmutableStringReader)reader.g(), tagKey);
                    }
                    reader.a(entity -> entity.ae().a(tagKey) != bl);
                } else {
                    MinecraftKey resourceLocation = MinecraftKey.a(reader.g());
                    EntityTypes entityType = (EntityTypes)BuiltInRegistries.h.b(resourceLocation).orElseThrow(() -> {
                        reader.g().setCursor(i2);
                        return h.createWithContext((ImmutableStringReader)reader.g(), (Object)resourceLocation.toString());
                    });
                    if (Objects.equals(EntityTypes.bt, entityType) && !bl) {
                        reader.a(false);
                    }
                    reader.a(entity -> Objects.equals(entityType, entity.ae()) != bl);
                    if (!bl) {
                        reader.a(entityType);
                    }
                }
            }, reader -> !reader.E(), IChatBaseComponent.c("argument.entity.options.type.description"));
            PlayerSelector.a("tag", reader -> {
                boolean bl = reader.e();
                String string = reader.g().readUnquotedString();
                reader.a(entity -> {
                    if ("".equals(string)) {
                        return entity.ag().isEmpty() != bl;
                    }
                    return entity.ag().contains(string) != bl;
                });
            }, reader -> true, IChatBaseComponent.c("argument.entity.options.tag.description"));
            PlayerSelector.a("nbt", reader -> {
                boolean bl = reader.e();
                NBTTagCompound compoundTag = new MojangsonParser(reader.g()).f();
                reader.a(entity -> {
                    ItemStack itemStack;
                    NBTTagCompound compoundTag2 = entity.f(new NBTTagCompound());
                    if (entity instanceof EntityPlayer && !(itemStack = ((EntityPlayer)entity).fJ().f()).b()) {
                        compoundTag2.a("SelectedItem", itemStack.b(new NBTTagCompound()));
                    }
                    return GameProfileSerializer.a((NBTBase)compoundTag, compoundTag2, true) != bl;
                });
            }, reader -> true, IChatBaseComponent.c("argument.entity.options.nbt.description"));
            PlayerSelector.a("scores", reader -> {
                StringReader stringReader = reader.g();
                HashMap map = Maps.newHashMap();
                stringReader.expect('{');
                stringReader.skipWhitespace();
                while (stringReader.canRead() && stringReader.peek() != '}') {
                    stringReader.skipWhitespace();
                    String string = stringReader.readUnquotedString();
                    stringReader.skipWhitespace();
                    stringReader.expect('=');
                    stringReader.skipWhitespace();
                    CriterionConditionValue.IntegerRange ints = CriterionConditionValue.IntegerRange.a(stringReader);
                    map.put(string, ints);
                    stringReader.skipWhitespace();
                    if (!stringReader.canRead() || stringReader.peek() != ',') continue;
                    stringReader.skip();
                }
                stringReader.expect('}');
                if (!map.isEmpty()) {
                    reader.a(entity -> {
                        ScoreboardServer scoreboard = entity.cH().aF();
                        String string = entity.cu();
                        for (Map.Entry entry : map.entrySet()) {
                            ScoreboardObjective objective = scoreboard.d((String)entry.getKey());
                            if (objective == null) {
                                return false;
                            }
                            if (!scoreboard.b(string, objective)) {
                                return false;
                            }
                            ScoreboardScore score = scoreboard.c(string, objective);
                            int i2 = score.b();
                            if (((CriterionConditionValue.IntegerRange)entry.getValue()).d(i2)) continue;
                            return false;
                        }
                        return true;
                    });
                }
                reader.j(true);
            }, reader -> !reader.G(), IChatBaseComponent.c("argument.entity.options.scores.description"));
            PlayerSelector.a("advancements", reader -> {
                StringReader stringReader = reader.g();
                HashMap map = Maps.newHashMap();
                stringReader.expect('{');
                stringReader.skipWhitespace();
                while (stringReader.canRead() && stringReader.peek() != '}') {
                    stringReader.skipWhitespace();
                    MinecraftKey resourceLocation = MinecraftKey.a(stringReader);
                    stringReader.skipWhitespace();
                    stringReader.expect('=');
                    stringReader.skipWhitespace();
                    if (stringReader.canRead() && stringReader.peek() == '{') {
                        HashMap map2 = Maps.newHashMap();
                        stringReader.skipWhitespace();
                        stringReader.expect('{');
                        stringReader.skipWhitespace();
                        while (stringReader.canRead() && stringReader.peek() != '}') {
                            stringReader.skipWhitespace();
                            String string = stringReader.readUnquotedString();
                            stringReader.skipWhitespace();
                            stringReader.expect('=');
                            stringReader.skipWhitespace();
                            boolean bl = stringReader.readBoolean();
                            map2.put(string, criterionProgress -> criterionProgress.a() == bl);
                            stringReader.skipWhitespace();
                            if (!stringReader.canRead() || stringReader.peek() != ',') continue;
                            stringReader.skip();
                        }
                        stringReader.skipWhitespace();
                        stringReader.expect('}');
                        stringReader.skipWhitespace();
                        map.put(resourceLocation, advancementProgress -> {
                            for (Map.Entry entry : map2.entrySet()) {
                                CriterionProgress criterionProgress = advancementProgress.c((String)entry.getKey());
                                if (criterionProgress != null && ((Predicate)entry.getValue()).test(criterionProgress)) continue;
                                return false;
                            }
                            return true;
                        });
                    } else {
                        boolean bl2 = stringReader.readBoolean();
                        map.put(resourceLocation, advancementProgress -> advancementProgress.a() == bl2);
                    }
                    stringReader.skipWhitespace();
                    if (!stringReader.canRead() || stringReader.peek() != ',') continue;
                    stringReader.skip();
                }
                stringReader.expect('}');
                if (!map.isEmpty()) {
                    reader.a(entity -> {
                        if (!(entity instanceof EntityPlayer)) {
                            return false;
                        }
                        EntityPlayer serverPlayer = (EntityPlayer)entity;
                        AdvancementDataPlayer playerAdvancements = serverPlayer.M();
                        AdvancementDataWorld serverAdvancementManager = serverPlayer.cH().az();
                        for (Map.Entry entry : map.entrySet()) {
                            Advancement advancement = serverAdvancementManager.a((MinecraftKey)entry.getKey());
                            if (advancement != null && ((Predicate)entry.getValue()).test(playerAdvancements.b(advancement))) continue;
                            return false;
                        }
                        return true;
                    });
                    reader.a(false);
                }
                reader.k(true);
            }, reader -> !reader.H(), IChatBaseComponent.c("argument.entity.options.advancements.description"));
            PlayerSelector.a("predicate", reader -> {
                boolean bl = reader.e();
                MinecraftKey resourceLocation = MinecraftKey.a(reader.g());
                reader.a(entity -> {
                    if (!(entity.H instanceof WorldServer)) {
                        return false;
                    }
                    WorldServer serverLevel = (WorldServer)entity.H;
                    LootItemCondition lootItemCondition = serverLevel.n().aI().a(resourceLocation);
                    if (lootItemCondition == null) {
                        return false;
                    }
                    LootTableInfo lootContext = new LootTableInfo.Builder(serverLevel).a(LootContextParameters.a, entity).a(LootContextParameters.f, entity.de()).a(LootContextParameterSets.d);
                    return bl ^ lootItemCondition.test(lootContext);
                });
            }, reader -> true, IChatBaseComponent.c("argument.entity.options.predicate.description"));
        }
    }

    public static a a(ArgumentParserSelector reader, String option, int restoreCursor) throws CommandSyntaxException {
        b option2 = i.get(option);
        if (option2 != null) {
            if (option2.b.test(reader)) {
                return option2.a;
            }
            throw b.createWithContext((ImmutableStringReader)reader.g(), (Object)option);
        }
        reader.g().setCursor(restoreCursor);
        throw a.createWithContext((ImmutableStringReader)reader.g(), (Object)option);
    }

    public static void a(ArgumentParserSelector reader, SuggestionsBuilder suggestionBuilder) {
        String string = suggestionBuilder.getRemaining().toLowerCase(Locale.ROOT);
        for (Map.Entry<String, b> entry : i.entrySet()) {
            if (!entry.getValue().b.test(reader) || !entry.getKey().toLowerCase(Locale.ROOT).startsWith(string)) continue;
            suggestionBuilder.suggest(entry.getKey() + "=", (Message)entry.getValue().c);
        }
    }

    record b(a a, Predicate<ArgumentParserSelector> b, IChatBaseComponent c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "modifier;canUse;description", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "modifier;canUse;description", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "modifier;canUse;description", "a", "b", "c"}, this, o2);
        }
    }

    public static interface a {
        public void handle(ArgumentParserSelector var1) throws CommandSyntaxException;
    }
}

