/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.Lifecycle;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.Registry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;

public interface IRegistry<T>
extends Keyable,
Registry<T> {
    public ResourceKey<? extends IRegistry<T>> c();

    default public Codec<T> q() {
        Codec codec = MinecraftKey.a.flatXmap(id -> Optional.ofNullable(this.a((MinecraftKey)id)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + this.c() + ": " + id)), value -> this.c(value).map(ResourceKey::a).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry element in " + this.c() + ":" + value)));
        Codec<Object> codec2 = ExtraCodecs.a((E value) -> this.c(value).isPresent() ? this.a(value) : -1, this::a, -1);
        return ExtraCodecs.a(ExtraCodecs.b(codec, codec2), this::e, this::e);
    }

    default public Codec<Holder<T>> r() {
        Codec codec = MinecraftKey.a.flatXmap(id -> this.b(ResourceKey.a(this.c(), id)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + this.c() + ": " + id)), entry -> entry.e().map(ResourceKey::a).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry element in " + this.c() + ":" + entry)));
        return ExtraCodecs.a(codec, (E entry) -> this.e(entry.a()), entry -> this.e(entry.a()));
    }

    default public <U> Stream<U> keys(DynamicOps<U> dynamicOps) {
        return this.e().stream().map(id -> dynamicOps.createString(id.toString()));
    }

    @Nullable
    public MinecraftKey b(T var1);

    public Optional<ResourceKey<T>> c(T var1);

    @Override
    @Override
    public int a(@Nullable T var1);

    @Nullable
    public T a(@Nullable ResourceKey<T> var1);

    @Nullable
    public T a(@Nullable MinecraftKey var1);

    public Lifecycle e(T var1);

    public Lifecycle d();

    default public Optional<T> b(@Nullable MinecraftKey id) {
        return Optional.ofNullable(this.a(id));
    }

    default public Optional<T> d(@Nullable ResourceKey<T> key) {
        return Optional.ofNullable(this.a(key));
    }

    default public T e(ResourceKey<T> key) {
        T object = this.a(key);
        if (object == null) {
            throw new IllegalStateException("Missing key in " + this.c() + ": " + key);
        }
        return object;
    }

    public Set<MinecraftKey> e();

    public Set<Map.Entry<ResourceKey<T>, T>> g();

    public Set<ResourceKey<T>> f();

    public Optional<Holder.c<T>> a(RandomSource var1);

    default public Stream<T> s() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean c(MinecraftKey var1);

    public boolean c(ResourceKey<T> var1);

    public static <T> T a(IRegistry<? super T> registry, String id, T entry) {
        return IRegistry.a(registry, new MinecraftKey(id), entry);
    }

    public static <V, T extends V> T a(IRegistry<V> registry, MinecraftKey id, T entry) {
        return IRegistry.a(registry, ResourceKey.a(registry.c(), id), entry);
    }

    public static <V, T extends V> T a(IRegistry<V> registry, ResourceKey<V> key, T entry) {
        ((IRegistryWritable)registry).a(key, entry, Lifecycle.stable());
        return entry;
    }

    public static <T> Holder.c<T> b(IRegistry<T> registry, ResourceKey<T> resourceKey, T object) {
        return ((IRegistryWritable)registry).a(resourceKey, object, Lifecycle.stable());
    }

    public static <T> Holder.c<T> b(IRegistry<T> registry, MinecraftKey resourceLocation, T object) {
        return IRegistry.b(registry, ResourceKey.a(registry.c(), resourceLocation), object);
    }

    public static <V, T extends V> T a(IRegistry<V> registry, int rawId, String id, T entry) {
        ((IRegistryWritable)registry).b(rawId, ResourceKey.a(registry.c(), new MinecraftKey(id)), entry, Lifecycle.stable());
        return entry;
    }

    public IRegistry<T> l();

    public Holder.c<T> f(T var1);

    public Optional<Holder.c<T>> c(int var1);

    public Optional<Holder.c<T>> b(ResourceKey<T> var1);

    public Holder<T> d(T var1);

    default public Holder.c<T> f(ResourceKey<T> key) {
        return this.b(key).orElseThrow(() -> new IllegalStateException("Missing key in " + this.c() + ": " + key));
    }

    public Stream<Holder.c<T>> h();

    public Optional<HolderSet.Named<T>> b(TagKey<T> var1);

    default public Iterable<Holder<T>> c(TagKey<T> tag) {
        return (Iterable)DataFixUtils.orElse(this.b(tag), List.of());
    }

    public HolderSet.Named<T> a(TagKey<T> var1);

    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> i();

    public Stream<TagKey<T>> j();

    public void m();

    public void a(Map<TagKey<T>, List<Holder<T>>> var1);

    default public Registry<Holder<T>> t() {
        return new Registry<Holder<T>>(){

            @Override
            @Override
            public int a(Holder<T> value) {
                return IRegistry.this.a(value.a());
            }

            @Nullable
            @Override
            public Holder<T> c(int i2) {
                return IRegistry.this.c(i2).orElse(null);
            }

            @Override
            @Override
            public int b() {
                return IRegistry.this.b();
            }

            @Override
            @Override
            public Iterator<Holder<T>> iterator() {
                return IRegistry.this.h().map(entry -> entry).iterator();
            }

            @Override
            @Nullable
            public /* synthetic */ Object a(int index) {
                return this.c(index);
            }
        };
    }

    public HolderOwner<T> o();

    public HolderLookup.c<T> p();

    default public HolderLookup.c<T> u() {
        return new HolderLookup.c.a<T>(){

            @Override
            @Override
            protected HolderLookup.c<T> a() {
                return IRegistry.this.p();
            }

            @Override
            @Override
            public Optional<HolderSet.Named<T>> a(TagKey<T> tag) {
                return Optional.of(this.b(tag));
            }

            @Override
            @Override
            public HolderSet.Named<T> b(TagKey<T> tag) {
                return IRegistry.this.a(tag);
            }
        };
    }
}

