/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.serialization.Lifecycle;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

public class RegistrySetBuilder {
    private final List<g<?>> a = new ArrayList();

    static <T> HolderGetter<T> a(final HolderLookup.c<T> wrapper) {
        return new c<T>(wrapper){

            @Override
            @Override
            public Optional<Holder.c<T>> a(ResourceKey<T> key) {
                return wrapper.a(key);
            }
        };
    }

    public <T> RegistrySetBuilder a(ResourceKey<? extends IRegistry<T>> registryRef, Lifecycle lifecycle, e<T> bootstrapFunction) {
        this.a.add(new g<T>(registryRef, lifecycle, bootstrapFunction));
        return this;
    }

    public <T> RegistrySetBuilder a(ResourceKey<? extends IRegistry<T>> registryRef, e<T> bootstrapFunction) {
        return this.a(registryRef, Lifecycle.stable(), bootstrapFunction);
    }

    private a b(IRegistryCustom registryManager) {
        a buildState = net.minecraft.core.RegistrySetBuilder$a.a(registryManager, this.a.stream().map(g::a));
        this.a.forEach(registry -> registry.b(buildState));
        return buildState;
    }

    public HolderLookup.b a(IRegistryCustom baseRegistryManager) {
        a buildState = this.b(baseRegistryManager);
        Stream<HolderLookup.c> stream = baseRegistryManager.b().map(entry -> entry.b().p());
        Stream<HolderLookup.c> stream2 = this.a.stream().map(info -> info.a(buildState).a());
        HolderLookup.b provider = HolderLookup.b.a(Stream.concat(stream, stream2.peek(buildState::a)));
        buildState.b();
        buildState.c();
        return provider;
    }

    public HolderLookup.b a(IRegistryCustom baseRegistryManager, HolderLookup.b wrapperLookup) {
        a buildState = this.b(baseRegistryManager);
        HashMap map = new HashMap();
        buildState.d().forEach(registry -> map.put(registry.a, registry));
        this.a.stream().map(info -> info.a(buildState)).forEach(registry -> map.put(registry.a, registry));
        Stream<HolderLookup.c> stream = baseRegistryManager.b().map(entry -> entry.b().p());
        HolderLookup.b provider = HolderLookup.b.a(Stream.concat(stream, map.values().stream().map(f::a).peek(buildState::a)));
        buildState.a(wrapperLookup);
        buildState.b();
        buildState.c();
        return provider;
    }

    record g<T>(ResourceKey<? extends IRegistry<T>> a, Lifecycle b, e<T> c) {
        void b(a registries) {
            this.c.run(registries.a());
        }

        public f<T> a(a registries) {
            HashMap map = new HashMap();
            Iterator<Map.Entry<ResourceKey<?>, d<?>>> iterator = registries.d.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceKey<?>, d<?>> entry = iterator.next();
                ResourceKey<?> resourceKey = entry.getKey();
                if (!resourceKey.b(this.a)) continue;
                ResourceKey<?> resourceKey2 = resourceKey;
                d<?> registeredValue = entry.getValue();
                Holder.c<Object> reference = registries.b.a.remove(resourceKey);
                map.put(resourceKey2, new i(registeredValue, Optional.ofNullable(reference)));
                iterator.remove();
            }
            return new f(this.a, this.b, map);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{g.class, "key;lifecycle;bootstrap", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{g.class, "key;lifecycle;bootstrap", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{g.class, "key;lifecycle;bootstrap", "a", "b", "c"}, this, object);
        }
    }

    @FunctionalInterface
    public static interface e<T> {
        public void run(BootstapContext<T> var1);
    }

    record a(b a, h b, Map<MinecraftKey, HolderGetter<?>> c, Map<ResourceKey<?>, d<?>> d, List<RuntimeException> e) {
        private final b a;
        private final h b;
        private final Map<MinecraftKey, HolderGetter<?>> c;
        private final Map<ResourceKey<?>, d<?>> d;
        private final List<RuntimeException> e;

        public static a a(IRegistryCustom dynamicRegistryManager, Stream<ResourceKey<? extends IRegistry<?>>> registryRefs) {
            b compositeOwner = new b();
            ArrayList<RuntimeException> list = new ArrayList<RuntimeException>();
            h universalLookup = new h(compositeOwner);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            dynamicRegistryManager.b().forEach(entry -> builder.put((Object)entry.a().a(), RegistrySetBuilder.a(entry.b().p())));
            registryRefs.forEach(registryRef -> builder.put((Object)registryRef.a(), (Object)universalLookup));
            return new a(compositeOwner, universalLookup, (Map<MinecraftKey, HolderGetter<?>>)builder.build(), new HashMap(), (List<RuntimeException>)list);
        }

        public <T> BootstapContext<T> a() {
            return new BootstapContext<T>(){

                @Override
                @Override
                public Holder.c<T> a(ResourceKey<T> key, T value, Lifecycle lifecycle) {
                    d registeredValue = d.put(key, new d(value, lifecycle));
                    if (registeredValue != null) {
                        e.add(new IllegalStateException("Duplicate registration for " + key + ", new=" + value + ", old=" + registeredValue.a));
                    }
                    return b.c(key);
                }

                @Override
                @Override
                public <S> HolderGetter<S> a(ResourceKey<? extends IRegistry<? extends S>> registryRef) {
                    return c.getOrDefault(registryRef.a(), b);
                }
            };
        }

        public void b() {
            for (ResourceKey<Object> resourceKey : this.b.a.keySet()) {
                this.e.add(new IllegalStateException("Unreferenced key: " + resourceKey));
            }
            this.d.forEach((key, value) -> this.e.add(new IllegalStateException("Orpaned value " + value.a + " for key " + key)));
        }

        public void c() {
            if (!this.e.isEmpty()) {
                IllegalStateException illegalStateException = new IllegalStateException("Errors during registry creation");
                for (RuntimeException runtimeException : this.e) {
                    illegalStateException.addSuppressed(runtimeException);
                }
                throw illegalStateException;
            }
        }

        public void a(HolderOwner<?> owner) {
            this.a.b(owner);
        }

        public void a(HolderLookup.b lookup) {
            HashMap<MinecraftKey, Optional> map = new HashMap<MinecraftKey, Optional>();
            Iterator<Map.Entry<ResourceKey<Object>, Holder.c<Object>>> iterator = this.b.a.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceKey<Object>, Holder.c<Object>> entry2 = iterator.next();
                ResourceKey<Object> resourceKey = entry2.getKey();
                Holder.c<Object> reference = entry2.getValue();
                map.computeIfAbsent(resourceKey.b(), registryId -> lookup.a(ResourceKey.a(registryId))).flatMap(entryLookup -> entryLookup.a(resourceKey)).ifPresent(entry -> {
                    reference.b(entry.a());
                    iterator.remove();
                });
            }
        }

        public Stream<f<?>> d() {
            return this.b.a.keySet().stream().map(ResourceKey::b).distinct().map(registry -> new f(ResourceKey.a(registry), Lifecycle.stable(), Map.of()));
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "owner;lookup;registries;registeredValues;errors", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "owner;lookup;registries;registeredValues;errors", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "owner;lookup;registries;registeredValues;errors", "a", "b", "c", "d", "e"}, this, object);
        }

        public b e() {
            return this.a;
        }

        public h f() {
            return this.b;
        }

        public Map<MinecraftKey, HolderGetter<?>> g() {
            return this.c;
        }

        public Map<ResourceKey<?>, d<?>> h() {
            return this.d;
        }

        public List<RuntimeException> i() {
            return this.e;
        }
    }

    record f<T>(ResourceKey<? extends IRegistry<? extends T>> a, Lifecycle b, Map<ResourceKey<T>, i<T>> c) {
        private final ResourceKey<? extends IRegistry<? extends T>> a;
        private final Lifecycle b;
        private final Map<ResourceKey<T>, i<T>> c;

        public HolderLookup.c<T> a() {
            return new HolderLookup.c<T>(){
                private final Map<ResourceKey<T>, Holder.c<T>> b;
                {
                    this.b = c.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> {
                        i valueAndHolder = (i)entry.getValue();
                        Holder.c reference = valueAndHolder.b().orElseGet(() -> Holder.c.a(this, (ResourceKey)entry.getKey()));
                        reference.b(valueAndHolder.a().a());
                        return reference;
                    }));
                }

                @Override
                @Override
                public ResourceKey<? extends IRegistry<? extends T>> f() {
                    return a;
                }

                @Override
                @Override
                public Lifecycle g() {
                    return b;
                }

                @Override
                @Override
                public Optional<Holder.c<T>> a(ResourceKey<T> key) {
                    return Optional.ofNullable(this.b.get(key));
                }

                @Override
                @Override
                public Stream<Holder.c<T>> b() {
                    return this.b.values().stream();
                }

                @Override
                @Override
                public Optional<HolderSet.Named<T>> a(TagKey<T> tag) {
                    return Optional.empty();
                }

                @Override
                @Override
                public Stream<HolderSet.Named<T>> d() {
                    return Stream.empty();
                }
            };
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{f.class, "key;lifecycle;values", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{f.class, "key;lifecycle;values", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{f.class, "key;lifecycle;values", "a", "b", "c"}, this, object);
        }

        public ResourceKey<? extends IRegistry<? extends T>> b() {
            return this.a;
        }

        public Lifecycle c() {
            return this.b;
        }

        public Map<ResourceKey<T>, i<T>> d() {
            return this.c;
        }
    }

    record i<T>(d<T> a, Optional<Holder.c<T>> b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{i.class, "value;holder", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{i.class, "value;holder", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{i.class, "value;holder", "a", "b"}, this, object);
        }
    }

    record d<T>(T a, Lifecycle b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "value;lifecycle", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "value;lifecycle", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "value;lifecycle", "a", "b"}, this, object);
        }
    }

    static class h
    extends c<Object> {
        final Map<ResourceKey<Object>, Holder.c<Object>> a = new HashMap<ResourceKey<Object>, Holder.c<Object>>();

        public h(HolderOwner<Object> entryOwner) {
            super(entryOwner);
        }

        @Override
        @Override
        public Optional<Holder.c<Object>> a(ResourceKey<Object> key) {
            return Optional.of(this.c(key));
        }

        <T> Holder.c<T> c(ResourceKey<T> key) {
            return this.a.computeIfAbsent(key, key2 -> Holder.c.a(this.b, key2));
        }
    }

    static class b
    implements HolderOwner<Object> {
        private final Set<HolderOwner<?>> a = Sets.newIdentityHashSet();

        b() {
        }

        @Override
        @Override
        public boolean a(HolderOwner<Object> other) {
            return this.a.contains(other);
        }

        public void b(HolderOwner<?> owner) {
            this.a.add(owner);
        }
    }

    static abstract class c<T>
    implements HolderGetter<T> {
        protected final HolderOwner<T> b;

        protected c(HolderOwner<T> entryOwner) {
            this.b = entryOwner;
        }

        @Override
        @Override
        public Optional<HolderSet.Named<T>> a(TagKey<T> tag) {
            return Optional.of(HolderSet.a(this.b, tag));
        }
    }
}

