/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import com.mojang.util.UUIDTypeAdapter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.SystemUtils;

public final class UUIDUtil {
    public static final Codec<UUID> a = Codec.INT_STREAM.comapFlatMap(uuidStream -> SystemUtils.a(uuidStream, 4).map(UUIDUtil::a), uuid -> Arrays.stream(UUIDUtil.a(uuid)));
    public static final Codec<UUID> b = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)UUID.fromString(string), (Lifecycle)Lifecycle.stable());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DataResult.error(() -> "Invalid UUID " + string + ": " + illegalArgumentException.getMessage());
        }
    }, UUID::toString);
    public static Codec<UUID> c = Codec.either(a, (Codec)Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)UUIDTypeAdapter.fromString((String)string), (Lifecycle)Lifecycle.stable());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return DataResult.error(() -> "Invalid UUID " + string + ": " + illegalArgumentException.getMessage());
        }
    }, UUIDTypeAdapter::fromUUID)).xmap(either -> either.map(uuid -> uuid, uuid -> uuid), Either::right);
    public static final int d = 16;
    private static final String e = "OfflinePlayer:";

    private UUIDUtil() {
    }

    public static UUID a(int[] array) {
        return new UUID((long)array[0] << 32 | (long)array[1] & 0xFFFFFFFFL, (long)array[2] << 32 | (long)array[3] & 0xFFFFFFFFL);
    }

    public static int[] a(UUID uuid) {
        long l2 = uuid.getMostSignificantBits();
        long m2 = uuid.getLeastSignificantBits();
        return UUIDUtil.a(l2, m2);
    }

    private static int[] a(long uuidMost, long uuidLeast) {
        return new int[]{(int)(uuidMost >> 32), (int)uuidMost, (int)(uuidLeast >> 32), (int)uuidLeast};
    }

    public static byte[] b(UUID uuid) {
        byte[] bs = new byte[16];
        ByteBuffer.wrap(bs).order(ByteOrder.BIG_ENDIAN).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
        return bs;
    }

    public static UUID a(Dynamic<?> dynamic) {
        int[] is = dynamic.asIntStream().toArray();
        if (is.length != 4) {
            throw new IllegalArgumentException("Could not read UUID. Expected int-array of length 4, got " + is.length + ".");
        }
        return UUIDUtil.a(is);
    }

    public static UUID a(GameProfile profile) {
        UUID uUID = profile.getId();
        if (uUID == null) {
            uUID = UUIDUtil.a(profile.getName());
        }
        return uUID;
    }

    public static UUID a(String nickname) {
        return UUID.nameUUIDFromBytes((e + nickname).getBytes(StandardCharsets.UTF_8));
    }
}

