/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableRegistry;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.slf4j.Logger;

public class LootTableProvider
implements DebugReportProvider {
    private static final Logger d = LogUtils.getLogger();
    private final PackOutput.a e;
    private final Set<MinecraftKey> f;
    private final List<a> g;

    public LootTableProvider(PackOutput output, Set<MinecraftKey> lootTableIds, List<a> lootTypeGenerators) {
        this.e = output.a(PackOutput.b.a, "loot_tables");
        this.g = lootTypeGenerators;
        this.f = lootTableIds;
    }

    @Override
    @Override
    public CompletableFuture<?> a(CachedOutput writer) {
        HashMap map = Maps.newHashMap();
        this.g.forEach(lootTypeGenerator -> lootTypeGenerator.a().get().generate((id, builder) -> {
            if (map.put(id, builder.a(subProviderEntry.b).b()) != null) {
                throw new IllegalStateException("Duplicate loot table " + id);
            }
        }));
        LootCollector validationContext = new LootCollector(LootContextParameterSets.l, id -> null, map::get);
        Sets.SetView set = Sets.difference(this.f, map.keySet());
        for (MinecraftKey resourceLocation : set) {
            validationContext.a("Missing built-in table: " + resourceLocation);
        }
        map.forEach((id, table) -> LootTableRegistry.a(validationContext, id, table));
        Multimap<String, String> multimap = validationContext.a();
        if (!multimap.isEmpty()) {
            multimap.forEach((name, message) -> d.warn("Found validation problem in {}: {}", name, message));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> {
            MinecraftKey resourceLocation = (MinecraftKey)entry.getKey();
            LootTable lootTable = (LootTable)entry.getValue();
            Path path = this.e.a(resourceLocation);
            return DebugReportProvider.a(writer, LootTableRegistry.a(lootTable), path);
        }).toArray(CompletableFuture[]::new));
    }

    @Override
    @Override
    public final String a() {
        return "Loot Tables";
    }

    public record a(Supplier<LootTableSubProvider> a, LootContextParameterSet b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "provider;paramSet", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "provider;paramSet", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "provider;paramSet", "a", "b"}, this, object);
        }
    }
}

