/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPropertyJigsawOrientation;
import net.minecraft.core.EnumDirection;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.models.model.TexturedModel;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.MangrovePropaguleBlock;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.level.block.state.properties.BlockPropertyBambooSize;
import net.minecraft.world.level.block.state.properties.BlockPropertyBellAttach;
import net.minecraft.world.level.block.state.properties.BlockPropertyComparatorMode;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoorHinge;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertyPistonType;
import net.minecraft.world.level.block.state.properties.BlockPropertyRedstoneSide;
import net.minecraft.world.level.block.state.properties.BlockPropertySlabType;
import net.minecraft.world.level.block.state.properties.BlockPropertyStairsShape;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.block.state.properties.BlockPropertyWallHeight;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.block.state.properties.Tilt;

public class BlockModelGenerators {
    final Consumer<BlockStateGenerator> b;
    final BiConsumer<MinecraftKey, Supplier<JsonElement>> c;
    private final Consumer<Item> d;
    final List<Block> e = ImmutableList.of((Object)Blocks.ey, (Object)Blocks.eE, (Object)Blocks.hX);
    final Map<Block, c> f = ImmutableMap.builder().put((Object)Blocks.b, BlockModelGenerators::a).put((Object)Blocks.rD, BlockModelGenerators::c).put((Object)Blocks.eM, BlockModelGenerators::b).build();
    final Map<Block, TexturedModel> g = ImmutableMap.builder().put((Object)Blocks.aU, (Object)TexturedModel.x.get(Blocks.aU)).put((Object)Blocks.jo, (Object)TexturedModel.x.get(Blocks.jo)).put((Object)Blocks.jR, (Object)TexturedModel.a(TextureMapping.a(Blocks.aU, "_top"))).put((Object)Blocks.jT, (Object)TexturedModel.a(TextureMapping.a(Blocks.jo, "_top"))).put((Object)Blocks.aW, (Object)TexturedModel.c.get(Blocks.aU).a((TextureMapping textureMap) -> textureMap.a(TextureSlot.i, TextureMapping.F(Blocks.aW)))).put((Object)Blocks.jq, (Object)TexturedModel.c.get(Blocks.jo).a((TextureMapping textureMap) -> textureMap.a(TextureSlot.i, TextureMapping.F(Blocks.jq)))).put((Object)Blocks.hc, (Object)TexturedModel.c.get(Blocks.hc)).put((Object)Blocks.jS, (Object)TexturedModel.a(TextureMapping.a(Blocks.hc, "_bottom"))).put((Object)Blocks.pn, (Object)TexturedModel.y.get(Blocks.pn)).put((Object)Blocks.rD, (Object)TexturedModel.y.get(Blocks.rD)).put((Object)Blocks.hd, (Object)TexturedModel.c.get(Blocks.hd).a((TextureMapping textureMap) -> textureMap.a(TextureSlot.i, TextureMapping.F(Blocks.hd)))).put((Object)Blocks.aV, (Object)TexturedModel.c.get(Blocks.aV).a((TextureMapping textures) -> {
        textures.a(TextureSlot.d, TextureMapping.a(Blocks.aU, "_top"));
        textures.a(TextureSlot.i, TextureMapping.F(Blocks.aV));
    })).put((Object)Blocks.jp, (Object)TexturedModel.c.get(Blocks.jp).a((TextureMapping textures) -> {
        textures.a(TextureSlot.d, TextureMapping.a(Blocks.jo, "_top"));
        textures.a(TextureSlot.i, TextureMapping.F(Blocks.jp));
    })).build();
    static final Map<BlockFamily.b, BiConsumer<b, Block>> h = ImmutableMap.builder().put((Object)BlockFamily.b.a, b::a).put((Object)BlockFamily.b.e, b::l).put((Object)BlockFamily.b.b, b::k).put((Object)BlockFamily.b.c, b::k).put((Object)BlockFamily.b.f, b::c).put((Object)BlockFamily.b.g, b::d).put((Object)BlockFamily.b.h, b::e).put((Object)BlockFamily.b.i, b::f).put((Object)BlockFamily.b.k, b::h).put((Object)BlockFamily.b.l, b::i).put((Object)BlockFamily.b.m, b::j).put((Object)BlockFamily.b.n, b::g).put((Object)BlockFamily.b.p, b::m).put((Object)BlockFamily.b.q, b::b).build();
    public static final List<Pair<BlockStateBoolean, Function<MinecraftKey, Variant>>> a = List.of(Pair.of((Object)BlockProperties.L, model -> Variant.a().a(VariantProperties.c, model)), Pair.of((Object)BlockProperties.M, model -> Variant.a().a(VariantProperties.c, model).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)), Pair.of((Object)BlockProperties.N, model -> Variant.a().a(VariantProperties.c, model).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)), Pair.of((Object)BlockProperties.O, model -> Variant.a().a(VariantProperties.c, model).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)), Pair.of((Object)BlockProperties.J, model -> Variant.a().a(VariantProperties.c, model).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true)), Pair.of((Object)BlockProperties.K, model -> Variant.a().a(VariantProperties.c, model).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)));
    private static final Map<d, MinecraftKey> i = new HashMap<d, MinecraftKey>();

    private static BlockStateGenerator a(Block block, MinecraftKey modelId, TextureMapping textures, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector) {
        MinecraftKey resourceLocation = ModelTemplates.d.a(block, textures, modelCollector);
        return BlockModelGenerators.a(block, modelId, resourceLocation);
    }

    private static BlockStateGenerator b(Block block, MinecraftKey modelId, TextureMapping textures, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector) {
        MinecraftKey resourceLocation = ModelTemplates.e.a(block, textures, modelCollector);
        return BlockModelGenerators.c(block, resourceLocation);
    }

    private static BlockStateGenerator c(Block block, MinecraftKey modelId, TextureMapping textures, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector) {
        MinecraftKey resourceLocation = ModelTemplates.k.a(block, textures, modelCollector);
        return BlockModelGenerators.a(block, modelId, resourceLocation).a(BlockModelGenerators.g());
    }

    public BlockModelGenerators(Consumer<BlockStateGenerator> blockStateCollector, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector, Consumer<Item> simpleItemModelExemptionCollector) {
        this.b = blockStateCollector;
        this.c = modelCollector;
        this.d = simpleItemModelExemptionCollector;
    }

    void a(Block block) {
        this.d.accept(block.k());
    }

    void a(Block block, MinecraftKey parentModelId) {
        this.c.accept(ModelLocationUtils.a(block.k()), new DelegatedModel(parentModelId));
    }

    private void a(Item item, MinecraftKey parentModelId) {
        this.c.accept(ModelLocationUtils.a(item), new DelegatedModel(parentModelId));
    }

    void a(Item item) {
        ModelTemplates.bt.a(ModelLocationUtils.a(item), TextureMapping.b(item), this.c);
    }

    private void b(Block block) {
        Item item = block.k();
        if (item != Items.a) {
            ModelTemplates.bt.a(ModelLocationUtils.a(item), TextureMapping.E(block), this.c);
        }
    }

    private void a(Block block, String textureSuffix) {
        Item item = block.k();
        ModelTemplates.bt.a(ModelLocationUtils.a(item), TextureMapping.k(TextureMapping.a(block, textureSuffix)), this.c);
    }

    private static PropertyDispatch b() {
        return PropertyDispatch.a(BlockProperties.R).a(EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, Variant.a());
    }

    private static PropertyDispatch c() {
        return PropertyDispatch.a(BlockProperties.R).a(EnumDirection.d, Variant.a()).a(EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.c, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.d));
    }

    private static PropertyDispatch d() {
        return PropertyDispatch.a(BlockProperties.R).a(EnumDirection.f, Variant.a()).a(EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.c, Variant.a().a(VariantProperties.b, VariantProperties.a.d));
    }

    private static PropertyDispatch e() {
        return PropertyDispatch.a(BlockProperties.P).a(EnumDirection.a, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.b, Variant.a().a(VariantProperties.a, VariantProperties.a.d)).a(EnumDirection.c, Variant.a()).a(EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b));
    }

    private static MultiVariantGenerator b(Block block, MinecraftKey modelId) {
        return MultiVariantGenerator.a(block, BlockModelGenerators.a(modelId));
    }

    private static Variant[] a(MinecraftKey modelId) {
        return new Variant[]{Variant.a().a(VariantProperties.c, modelId), Variant.a().a(VariantProperties.c, modelId).a(VariantProperties.b, VariantProperties.a.b), Variant.a().a(VariantProperties.c, modelId).a(VariantProperties.b, VariantProperties.a.c), Variant.a().a(VariantProperties.c, modelId).a(VariantProperties.b, VariantProperties.a.d)};
    }

    private static MultiVariantGenerator a(Block block, MinecraftKey firstModelId, MinecraftKey secondModelId) {
        return MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, firstModelId), Variant.a().a(VariantProperties.c, secondModelId), Variant.a().a(VariantProperties.c, firstModelId).a(VariantProperties.b, VariantProperties.a.c), Variant.a().a(VariantProperties.c, secondModelId).a(VariantProperties.b, VariantProperties.a.c));
    }

    private static PropertyDispatch a(BlockStateBoolean property, MinecraftKey trueModel, MinecraftKey falseModel) {
        return PropertyDispatch.a(property).a((Boolean)true, Variant.a().a(VariantProperties.c, trueModel)).a((Boolean)false, Variant.a().a(VariantProperties.c, falseModel));
    }

    private void c(Block block) {
        MinecraftKey resourceLocation = TexturedModel.a.create(block, this.c);
        MinecraftKey resourceLocation2 = TexturedModel.b.create(block, this.c);
        this.b.accept(BlockModelGenerators.a(block, resourceLocation, resourceLocation2));
    }

    private void d(Block block) {
        MinecraftKey resourceLocation = TexturedModel.a.create(block, this.c);
        this.b.accept(BlockModelGenerators.b(block, resourceLocation));
    }

    private void f() {
        this.b.accept(MultiVariantGenerator.a(Blocks.J).a(PropertyDispatch.a(BlockProperties.bv).a((T1 dustedLevel) -> {
            String string = "_" + dustedLevel;
            MinecraftKey resourceLocation = TextureMapping.a(Blocks.J, string);
            return Variant.a().a(VariantProperties.c, ModelTemplates.c.a(Blocks.J, string, new TextureMapping().a(TextureSlot.a, resourceLocation), this.c));
        })));
        this.a(Blocks.J, TextureMapping.a(Blocks.J, "_0"));
    }

    static BlockStateGenerator b(Block buttonBlock, MinecraftKey regularModelId, MinecraftKey pressedModelId) {
        return MultiVariantGenerator.a(buttonBlock).a(PropertyDispatch.a(BlockProperties.w).a((Boolean)false, Variant.a().a(VariantProperties.c, regularModelId)).a((Boolean)true, Variant.a().a(VariantProperties.c, pressedModelId))).a(PropertyDispatch.a(BlockProperties.U, BlockProperties.R).a(BlockPropertyAttachPosition.a, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.a, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.a, EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.a, EnumDirection.c, Variant.a()).a(BlockPropertyAttachPosition.b, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a(BlockPropertyAttachPosition.b, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a(BlockPropertyAttachPosition.b, EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a(BlockPropertyAttachPosition.b, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a(BlockPropertyAttachPosition.c, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.c, Variant.a().a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.c)));
    }

    private static PropertyDispatch.d<EnumDirection, BlockPropertyDoubleBlockHalf, BlockPropertyDoorHinge, Boolean> a(PropertyDispatch.d<EnumDirection, BlockPropertyDoubleBlockHalf, BlockPropertyDoorHinge, Boolean> variantMap, BlockPropertyDoubleBlockHalf targetHalf, MinecraftKey leftHingeClosedModelId, MinecraftKey leftHingeOpenModelId, MinecraftKey rightHingeClosedModelId, MinecraftKey rightHingeOpenModelId) {
        return variantMap.a(EnumDirection.f, targetHalf, BlockPropertyDoorHinge.a, (Boolean)false, Variant.a().a(VariantProperties.c, leftHingeClosedModelId)).a(EnumDirection.d, targetHalf, BlockPropertyDoorHinge.a, (Boolean)false, Variant.a().a(VariantProperties.c, leftHingeClosedModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, targetHalf, BlockPropertyDoorHinge.a, (Boolean)false, Variant.a().a(VariantProperties.c, leftHingeClosedModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.c, targetHalf, BlockPropertyDoorHinge.a, (Boolean)false, Variant.a().a(VariantProperties.c, leftHingeClosedModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, targetHalf, BlockPropertyDoorHinge.b, (Boolean)false, Variant.a().a(VariantProperties.c, rightHingeClosedModelId)).a(EnumDirection.d, targetHalf, BlockPropertyDoorHinge.b, (Boolean)false, Variant.a().a(VariantProperties.c, rightHingeClosedModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, targetHalf, BlockPropertyDoorHinge.b, (Boolean)false, Variant.a().a(VariantProperties.c, rightHingeClosedModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.c, targetHalf, BlockPropertyDoorHinge.b, (Boolean)false, Variant.a().a(VariantProperties.c, rightHingeClosedModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, targetHalf, BlockPropertyDoorHinge.a, (Boolean)true, Variant.a().a(VariantProperties.c, leftHingeOpenModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.d, targetHalf, BlockPropertyDoorHinge.a, (Boolean)true, Variant.a().a(VariantProperties.c, leftHingeOpenModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, targetHalf, BlockPropertyDoorHinge.a, (Boolean)true, Variant.a().a(VariantProperties.c, leftHingeOpenModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, targetHalf, BlockPropertyDoorHinge.a, (Boolean)true, Variant.a().a(VariantProperties.c, leftHingeOpenModelId)).a(EnumDirection.f, targetHalf, BlockPropertyDoorHinge.b, (Boolean)true, Variant.a().a(VariantProperties.c, rightHingeOpenModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.d, targetHalf, BlockPropertyDoorHinge.b, (Boolean)true, Variant.a().a(VariantProperties.c, rightHingeOpenModelId)).a(EnumDirection.e, targetHalf, BlockPropertyDoorHinge.b, (Boolean)true, Variant.a().a(VariantProperties.c, rightHingeOpenModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.c, targetHalf, BlockPropertyDoorHinge.b, (Boolean)true, Variant.a().a(VariantProperties.c, rightHingeOpenModelId).a(VariantProperties.b, VariantProperties.a.c));
    }

    private static BlockStateGenerator a(Block doorBlock, MinecraftKey bottomLeftHingeClosedModelId, MinecraftKey bottomLeftHingeOpenModelId, MinecraftKey bottomRightHingeClosedModelId, MinecraftKey bottomRightHingeOpenModelId, MinecraftKey topLeftHingeClosedModelId, MinecraftKey topLeftHingeOpenModelId, MinecraftKey topRightHingeClosedModelId, MinecraftKey topRightHingeOpenModelId) {
        return MultiVariantGenerator.a(doorBlock).a(BlockModelGenerators.a(BlockModelGenerators.a(PropertyDispatch.a(BlockProperties.R, BlockProperties.ae, BlockProperties.be, BlockProperties.u), BlockPropertyDoubleBlockHalf.b, bottomLeftHingeClosedModelId, bottomLeftHingeOpenModelId, bottomRightHingeClosedModelId, bottomRightHingeOpenModelId), BlockPropertyDoubleBlockHalf.a, topLeftHingeClosedModelId, topLeftHingeOpenModelId, topRightHingeClosedModelId, topRightHingeOpenModelId));
    }

    static BlockStateGenerator a(Block customFenceBlock, MinecraftKey postModelId, MinecraftKey northModelId, MinecraftKey eastModelId, MinecraftKey southModelId, MinecraftKey westModelId) {
        return MultiPartGenerator.a(customFenceBlock).a(Variant.a().a(VariantProperties.c, postModelId)).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, northModelId).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, eastModelId).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.N, true), Variant.a().a(VariantProperties.c, southModelId).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, westModelId).a(VariantProperties.d, false));
    }

    static BlockStateGenerator c(Block fenceBlock, MinecraftKey postModelId, MinecraftKey sideModelId) {
        return MultiPartGenerator.a(fenceBlock).a(Variant.a().a(VariantProperties.c, postModelId)).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, sideModelId).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, sideModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.N, true), Variant.a().a(VariantProperties.c, sideModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, sideModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true));
    }

    static BlockStateGenerator a(Block wallBlock, MinecraftKey postModelId, MinecraftKey lowSideModelId, MinecraftKey tallSideModelId) {
        return MultiPartGenerator.a(wallBlock).a((Condition)Condition.a().a(BlockProperties.J, true), Variant.a().a(VariantProperties.c, postModelId)).a((Condition)Condition.a().a(BlockProperties.X, BlockPropertyWallHeight.b), Variant.a().a(VariantProperties.c, lowSideModelId).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.W, BlockPropertyWallHeight.b), Variant.a().a(VariantProperties.c, lowSideModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.Y, BlockPropertyWallHeight.b), Variant.a().a(VariantProperties.c, lowSideModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.Z, BlockPropertyWallHeight.b), Variant.a().a(VariantProperties.c, lowSideModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.X, BlockPropertyWallHeight.c), Variant.a().a(VariantProperties.c, tallSideModelId).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.W, BlockPropertyWallHeight.c), Variant.a().a(VariantProperties.c, tallSideModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.Y, BlockPropertyWallHeight.c), Variant.a().a(VariantProperties.c, tallSideModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.Z, BlockPropertyWallHeight.c), Variant.a().a(VariantProperties.c, tallSideModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true));
    }

    static BlockStateGenerator a(Block fenceGateBlock, MinecraftKey openModelId, MinecraftKey closedModelId, MinecraftKey openWallModelId, MinecraftKey closedWallModelId, boolean uvlock) {
        return MultiVariantGenerator.a(fenceGateBlock, Variant.a().a(VariantProperties.d, uvlock)).a(BlockModelGenerators.c()).a(PropertyDispatch.a(BlockProperties.q, BlockProperties.u).a((Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, closedModelId)).a((Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, closedWallModelId)).a((Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId)).a((Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, openWallModelId)));
    }

    static BlockStateGenerator b(Block stairsBlock, MinecraftKey innerModelId, MinecraftKey regularModelId, MinecraftKey outerModelId) {
        return MultiVariantGenerator.a(stairsBlock).a(PropertyDispatch.a(BlockProperties.R, BlockProperties.af, BlockProperties.bi).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.b, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.b, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.b, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId)).a(EnumDirection.c, BlockPropertyHalf.b, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.a, Variant.a().a(VariantProperties.c, regularModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.e, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.d, Variant.a().a(VariantProperties.c, outerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.c, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.f, BlockPropertyHalf.a, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.e, BlockPropertyHalf.a, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a(EnumDirection.d, BlockPropertyHalf.a, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a(EnumDirection.c, BlockPropertyHalf.a, BlockPropertyStairsShape.b, Variant.a().a(VariantProperties.c, innerModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)));
    }

    private static BlockStateGenerator c(Block trapdoorBlock, MinecraftKey topModelId, MinecraftKey bottomModelId, MinecraftKey openModelId) {
        return MultiVariantGenerator.a(trapdoorBlock).a(PropertyDispatch.a(BlockProperties.R, BlockProperties.af, BlockProperties.u).a(EnumDirection.c, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.d, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.d, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId)).a(EnumDirection.d, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.d, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.a)).a(EnumDirection.f, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.e, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b)));
    }

    private static BlockStateGenerator d(Block trapdoorBlock, MinecraftKey topModelId, MinecraftKey bottomModelId, MinecraftKey openModelId) {
        return MultiVariantGenerator.a(trapdoorBlock).a(PropertyDispatch.a(BlockProperties.R, BlockProperties.af, BlockProperties.u).a(EnumDirection.c, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.d, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.f, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.e, BlockPropertyHalf.b, (Boolean)false, Variant.a().a(VariantProperties.c, bottomModelId)).a(EnumDirection.c, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.d, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.f, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.e, BlockPropertyHalf.a, (Boolean)false, Variant.a().a(VariantProperties.c, topModelId)).a(EnumDirection.c, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId)).a(EnumDirection.d, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.b, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId)).a(EnumDirection.d, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyHalf.a, (Boolean)true, Variant.a().a(VariantProperties.c, openModelId).a(VariantProperties.b, VariantProperties.a.d)));
    }

    static MultiVariantGenerator c(Block block, MinecraftKey modelId) {
        return MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, modelId));
    }

    private static PropertyDispatch g() {
        return PropertyDispatch.a(BlockProperties.I).a(EnumDirection.EnumAxis.b, Variant.a()).a(EnumDirection.EnumAxis.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.EnumAxis.a, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b));
    }

    static BlockStateGenerator a(Block block, TextureMapping textureMap, BiConsumer<MinecraftKey, Supplier<JsonElement>> modelCollector) {
        MinecraftKey resourceLocation = ModelTemplates.f.a(block, textureMap, modelCollector);
        MinecraftKey resourceLocation2 = ModelTemplates.g.a(block, textureMap, modelCollector);
        MinecraftKey resourceLocation3 = ModelTemplates.h.a(block, textureMap, modelCollector);
        MinecraftKey resourceLocation4 = ModelTemplates.i.a(block, textureMap, modelCollector);
        return MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, resourceLocation4)).a(PropertyDispatch.a(BlockProperties.I).a(EnumDirection.EnumAxis.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(EnumDirection.EnumAxis.b, Variant.a().a(VariantProperties.c, resourceLocation2)).a(EnumDirection.EnumAxis.c, Variant.a().a(VariantProperties.c, resourceLocation3)));
    }

    static BlockStateGenerator d(Block block, MinecraftKey modelId) {
        return MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, modelId)).a(BlockModelGenerators.g());
    }

    private void e(Block block, MinecraftKey modelId) {
        this.b.accept(BlockModelGenerators.d(block, modelId));
    }

    private void a(Block block, TexturedModel.a modelFactory) {
        MinecraftKey resourceLocation = modelFactory.create(block, this.c);
        this.b.accept(BlockModelGenerators.d(block, resourceLocation));
    }

    private void b(Block block, TexturedModel.a modelFactory) {
        MinecraftKey resourceLocation = modelFactory.create(block, this.c);
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, resourceLocation)).a(BlockModelGenerators.b()));
    }

    static BlockStateGenerator d(Block block, MinecraftKey verticalModelId, MinecraftKey horizontalModelId) {
        return MultiVariantGenerator.a(block).a(PropertyDispatch.a(BlockProperties.I).a(EnumDirection.EnumAxis.b, Variant.a().a(VariantProperties.c, verticalModelId)).a(EnumDirection.EnumAxis.c, Variant.a().a(VariantProperties.c, horizontalModelId).a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.EnumAxis.a, Variant.a().a(VariantProperties.c, horizontalModelId).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b)));
    }

    private void a(Block block, TexturedModel.a verticalModelFactory, TexturedModel.a horizontalModelFactory) {
        MinecraftKey resourceLocation = verticalModelFactory.create(block, this.c);
        MinecraftKey resourceLocation2 = horizontalModelFactory.create(block, this.c);
        this.b.accept(BlockModelGenerators.d(block, resourceLocation, resourceLocation2));
    }

    private MinecraftKey a(Block block, String suffix, ModelTemplate model, Function<MinecraftKey, TextureMapping> texturesFactory) {
        return model.a(block, suffix, texturesFactory.apply(TextureMapping.a(block, suffix)), this.c);
    }

    static BlockStateGenerator e(Block pressurePlateBlock, MinecraftKey upModelId, MinecraftKey downModelId) {
        return MultiVariantGenerator.a(pressurePlateBlock).a(BlockModelGenerators.a(BlockProperties.w, downModelId, upModelId));
    }

    static BlockStateGenerator e(Block slabBlock, MinecraftKey bottomModelId, MinecraftKey topModelId, MinecraftKey fullModelId) {
        return MultiVariantGenerator.a(slabBlock).a(PropertyDispatch.a(BlockProperties.bh).a(BlockPropertySlabType.b, Variant.a().a(VariantProperties.c, bottomModelId)).a(BlockPropertySlabType.a, Variant.a().a(VariantProperties.c, topModelId)).a(BlockPropertySlabType.c, Variant.a().a(VariantProperties.c, fullModelId)));
    }

    private void e(Block block) {
        this.c(block, TexturedModel.a);
    }

    private void c(Block block, TexturedModel.a modelFactory) {
        this.b.accept(BlockModelGenerators.c(block, modelFactory.create(block, this.c)));
    }

    private void a(Block block, TextureMapping textures, ModelTemplate model) {
        MinecraftKey resourceLocation = model.a(block, textures, this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private b f(Block block) {
        TexturedModel texturedModel = this.g.getOrDefault(block, TexturedModel.a.get(block));
        return new b(texturedModel.b()).a(block, texturedModel.a());
    }

    public void a(Block strippedLog, Block hangingSign, Block wallHangingSign) {
        TextureMapping textureMapping = TextureMapping.t(strippedLog);
        MinecraftKey resourceLocation = ModelTemplates.Y.a(hangingSign, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(hangingSign, resourceLocation));
        this.b.accept(BlockModelGenerators.c(wallHangingSign, resourceLocation));
        this.a(hangingSign.k());
        this.a(wallHangingSign);
    }

    void g(Block doorBlock) {
        TextureMapping textureMapping = TextureMapping.s(doorBlock);
        MinecraftKey resourceLocation = ModelTemplates.t.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.u.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.v.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.w.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation5 = ModelTemplates.x.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation6 = ModelTemplates.y.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation7 = ModelTemplates.z.a(doorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation8 = ModelTemplates.A.a(doorBlock, textureMapping, this.c);
        this.a(doorBlock.k());
        this.b.accept(BlockModelGenerators.a(doorBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4, resourceLocation5, resourceLocation6, resourceLocation7, resourceLocation8));
    }

    void h(Block trapdoorBlock) {
        TextureMapping textureMapping = TextureMapping.b(trapdoorBlock);
        MinecraftKey resourceLocation = ModelTemplates.ai.a(trapdoorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.aj.a(trapdoorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.ak.a(trapdoorBlock, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(trapdoorBlock, resourceLocation, resourceLocation2, resourceLocation3));
        this.a(trapdoorBlock, resourceLocation2);
    }

    void i(Block trapdoorBlock) {
        TextureMapping textureMapping = TextureMapping.b(trapdoorBlock);
        MinecraftKey resourceLocation = ModelTemplates.af.a(trapdoorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.ag.a(trapdoorBlock, textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.ah.a(trapdoorBlock, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.d(trapdoorBlock, resourceLocation, resourceLocation2, resourceLocation3));
        this.a(trapdoorBlock, resourceLocation2);
    }

    private void h() {
        this.a(Blocks.rx);
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.rx);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.rx, "_partial_tilt");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.rx, "_full_tilt");
        this.b.accept(MultiVariantGenerator.a(Blocks.rx).a(BlockModelGenerators.b()).a(PropertyDispatch.a(BlockProperties.bl).a(Tilt.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(Tilt.b, Variant.a().a(VariantProperties.c, resourceLocation)).a(Tilt.c, Variant.a().a(VariantProperties.c, resourceLocation2)).a(Tilt.d, Variant.a().a(VariantProperties.c, resourceLocation3))));
    }

    private f j(Block logBlock) {
        return new f(TextureMapping.m(logBlock));
    }

    private void k(Block block) {
        this.a(block, block);
    }

    private void a(Block block, Block modelReference) {
        this.b.accept(BlockModelGenerators.c(block, ModelLocationUtils.a(modelReference)));
    }

    private void a(Block block, e tintType) {
        this.b(block);
        this.b(block, tintType);
    }

    private void a(Block block, e tintType, TextureMapping texture) {
        this.b(block);
        this.b(block, tintType, texture);
    }

    private void b(Block block, e tintType) {
        TextureMapping textureMapping = TextureMapping.c(block);
        this.b(block, tintType, textureMapping);
    }

    private void b(Block block, e tintType, TextureMapping crossTexture) {
        MinecraftKey resourceLocation = tintType.a().a(block, crossTexture, this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private void a(Block block, e tintType, IBlockState<Integer> stageProperty, int ... stages) {
        if (stageProperty.a().size() != stages.length) {
            throw new IllegalArgumentException("missing values for property: " + stageProperty);
        }
        PropertyDispatch propertyDispatch = PropertyDispatch.a(stageProperty).a((T1 integer) -> {
            String string = "_stage" + stages[integer];
            TextureMapping textureMapping = TextureMapping.c(TextureMapping.a(block, string));
            MinecraftKey resourceLocation = tintType.a().a(block, string, textureMapping, this.c);
            return Variant.a().a(VariantProperties.c, resourceLocation);
        });
        this.a(block.k());
        this.b.accept(MultiVariantGenerator.a(block).a(propertyDispatch));
    }

    private void a(Block plantBlock, Block flowerPotBlock, e tintType) {
        this.a(plantBlock, tintType);
        TextureMapping textureMapping = TextureMapping.d(plantBlock);
        MinecraftKey resourceLocation = tintType.b().a(flowerPotBlock, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(flowerPotBlock, resourceLocation));
    }

    private void b(Block coralFanBlock, Block coralWallFanBlock) {
        TexturedModel texturedModel = TexturedModel.o.get(coralFanBlock);
        MinecraftKey resourceLocation = texturedModel.a(coralFanBlock, this.c);
        this.b.accept(BlockModelGenerators.c(coralFanBlock, resourceLocation));
        MinecraftKey resourceLocation2 = ModelTemplates.aA.a(coralWallFanBlock, texturedModel.b(), this.c);
        this.b.accept(MultiVariantGenerator.a(coralWallFanBlock, Variant.a().a(VariantProperties.c, resourceLocation2)).a(BlockModelGenerators.b()));
        this.b(coralFanBlock);
    }

    private void c(Block stemBlock, Block attachedStemBlock) {
        this.a(stemBlock.k());
        TextureMapping textureMapping = TextureMapping.h(stemBlock);
        TextureMapping textureMapping2 = TextureMapping.a(stemBlock, attachedStemBlock);
        MinecraftKey resourceLocation = ModelTemplates.aS.a(attachedStemBlock, textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(attachedStemBlock, Variant.a().a(VariantProperties.c, resourceLocation)).a(PropertyDispatch.a(BlockProperties.R).a(EnumDirection.e, Variant.a()).a(EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.c))));
        this.b.accept(MultiVariantGenerator.a(stemBlock).a(PropertyDispatch.a(BlockProperties.av).a((T1 integer) -> Variant.a().a(VariantProperties.c, ModelTemplates.aR[integer].a(stemBlock, textureMapping, this.c)))));
    }

    private void a(Block coral, Block deadCoral, Block coralBlock, Block deadCoralBlock, Block coralFan, Block deadCoralFan, Block coralWallFan, Block deadCoralWallFan) {
        this.a(coral, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(deadCoral, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.e(coralBlock);
        this.e(deadCoralBlock);
        this.b(coralFan, coralWallFan);
        this.b(deadCoralFan, deadCoralWallFan);
    }

    private void c(Block doubleBlock, e tintType) {
        this.a(doubleBlock, "_top");
        MinecraftKey resourceLocation = this.a(doubleBlock, "_top", tintType.a(), TextureMapping::c);
        MinecraftKey resourceLocation2 = this.a(doubleBlock, "_bottom", tintType.a(), TextureMapping::c);
        this.f(doubleBlock, resourceLocation, resourceLocation2);
    }

    private void i() {
        this.a(Blocks.iC, "_front");
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.iC, "_top");
        MinecraftKey resourceLocation2 = this.a(Blocks.iC, "_bottom", net.minecraft.data.models.BlockModelGenerators$e.b.a(), TextureMapping::c);
        this.f(Blocks.iC, resourceLocation, resourceLocation2);
    }

    private void j() {
        MinecraftKey resourceLocation = this.a(Blocks.bw, "_top", ModelTemplates.bi, TextureMapping::a);
        MinecraftKey resourceLocation2 = this.a(Blocks.bw, "_bottom", ModelTemplates.bi, TextureMapping::a);
        this.f(Blocks.bw, resourceLocation, resourceLocation2);
    }

    private void k() {
        this.a(Blocks.rz);
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.rz, "_top");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.rz, "_bottom");
        this.b.accept(MultiVariantGenerator.a(Blocks.rz).a(BlockModelGenerators.b()).a(PropertyDispatch.a(BlockProperties.ae).a(BlockPropertyDoubleBlockHalf.b, Variant.a().a(VariantProperties.c, resourceLocation2)).a(BlockPropertyDoubleBlockHalf.a, Variant.a().a(VariantProperties.c, resourceLocation))));
    }

    private void f(Block block, MinecraftKey upperHalfModelId, MinecraftKey lowerHalfModelId) {
        this.b.accept(MultiVariantGenerator.a(block).a(PropertyDispatch.a(BlockProperties.ae).a(BlockPropertyDoubleBlockHalf.b, Variant.a().a(VariantProperties.c, lowerHalfModelId)).a(BlockPropertyDoubleBlockHalf.a, Variant.a().a(VariantProperties.c, upperHalfModelId))));
    }

    private void l(Block rail) {
        TextureMapping textureMapping = TextureMapping.e(rail);
        TextureMapping textureMapping2 = TextureMapping.e(TextureMapping.a(rail, "_corner"));
        MinecraftKey resourceLocation = ModelTemplates.aq.a(rail, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.ar.a(rail, textureMapping2, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.as.a(rail, textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.at.a(rail, textureMapping, this.c);
        this.b(rail);
        this.b.accept(MultiVariantGenerator.a(rail).a(PropertyDispatch.a(BlockProperties.ag).a(BlockPropertyTrackPosition.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(BlockPropertyTrackPosition.b, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyTrackPosition.c, Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyTrackPosition.d, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyTrackPosition.e, Variant.a().a(VariantProperties.c, resourceLocation3)).a(BlockPropertyTrackPosition.f, Variant.a().a(VariantProperties.c, resourceLocation4)).a(BlockPropertyTrackPosition.g, Variant.a().a(VariantProperties.c, resourceLocation2)).a(BlockPropertyTrackPosition.h, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyTrackPosition.i, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyTrackPosition.j, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void m(Block rail) {
        MinecraftKey resourceLocation = this.a(rail, "", ModelTemplates.aq, TextureMapping::e);
        MinecraftKey resourceLocation2 = this.a(rail, "", ModelTemplates.as, TextureMapping::e);
        MinecraftKey resourceLocation3 = this.a(rail, "", ModelTemplates.at, TextureMapping::e);
        MinecraftKey resourceLocation4 = this.a(rail, "_on", ModelTemplates.aq, TextureMapping::e);
        MinecraftKey resourceLocation5 = this.a(rail, "_on", ModelTemplates.as, TextureMapping::e);
        MinecraftKey resourceLocation6 = this.a(rail, "_on", ModelTemplates.at, TextureMapping::e);
        PropertyDispatch propertyDispatch = PropertyDispatch.a(BlockProperties.w, BlockProperties.ah).a((T1 on, T2 shape) -> {
            switch (shape) {
                case a: {
                    return Variant.a().a(VariantProperties.c, on != false ? resourceLocation4 : resourceLocation);
                }
                case b: {
                    return Variant.a().a(VariantProperties.c, on != false ? resourceLocation4 : resourceLocation).a(VariantProperties.b, VariantProperties.a.b);
                }
                case c: {
                    return Variant.a().a(VariantProperties.c, on != false ? resourceLocation5 : resourceLocation2).a(VariantProperties.b, VariantProperties.a.b);
                }
                case d: {
                    return Variant.a().a(VariantProperties.c, on != false ? resourceLocation6 : resourceLocation3).a(VariantProperties.b, VariantProperties.a.b);
                }
                case e: {
                    return Variant.a().a(VariantProperties.c, on != false ? resourceLocation5 : resourceLocation2);
                }
                case f: {
                    return Variant.a().a(VariantProperties.c, on != false ? resourceLocation6 : resourceLocation3);
                }
            }
            throw new UnsupportedOperationException("Fix you generator!");
        });
        this.b(rail);
        this.b.accept(MultiVariantGenerator.a(rail).a(propertyDispatch));
    }

    private a a(MinecraftKey modelId, Block particleBlock) {
        return new a(modelId, particleBlock);
    }

    private a d(Block block, Block particleBlock) {
        return new a(ModelLocationUtils.a(block), particleBlock);
    }

    private void a(Block block, Item particleSource) {
        MinecraftKey resourceLocation = ModelTemplates.Y.a(block, TextureMapping.a(particleSource), this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private void f(Block block, MinecraftKey particleSource) {
        MinecraftKey resourceLocation = ModelTemplates.Y.a(block, TextureMapping.h(particleSource), this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private void e(Block wool, Block carpet) {
        this.e(wool);
        MinecraftKey resourceLocation = TexturedModel.i.get(wool).a(carpet, this.c);
        this.b.accept(BlockModelGenerators.c(carpet, resourceLocation));
    }

    private void n(Block flowerbed) {
        this.a(flowerbed.k());
        MinecraftKey resourceLocation = TexturedModel.j.create(flowerbed, this.c);
        MinecraftKey resourceLocation2 = TexturedModel.k.create(flowerbed, this.c);
        MinecraftKey resourceLocation3 = TexturedModel.l.create(flowerbed, this.c);
        MinecraftKey resourceLocation4 = TexturedModel.m.create(flowerbed, this.c);
        this.b.accept(MultiPartGenerator.a(flowerbed).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(1), new Integer[]{2, 3, 4}).a(BlockProperties.R, EnumDirection.c), Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(1), new Integer[]{2, 3, 4}).a(BlockProperties.R, EnumDirection.f), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(1), new Integer[]{2, 3, 4}).a(BlockProperties.R, EnumDirection.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(1), new Integer[]{2, 3, 4}).a(BlockProperties.R, EnumDirection.e), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(2), new Integer[]{3, 4}).a(BlockProperties.R, EnumDirection.c), Variant.a().a(VariantProperties.c, resourceLocation2)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(2), new Integer[]{3, 4}).a(BlockProperties.R, EnumDirection.f), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(2), new Integer[]{3, 4}).a(BlockProperties.R, EnumDirection.d), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(2), new Integer[]{3, 4}).a(BlockProperties.R, EnumDirection.e), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(3), new Integer[]{4}).a(BlockProperties.R, EnumDirection.c), Variant.a().a(VariantProperties.c, resourceLocation3)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(3), new Integer[]{4}).a(BlockProperties.R, EnumDirection.f), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(3), new Integer[]{4}).a(BlockProperties.R, EnumDirection.d), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.c)).a((Condition)Condition.a().a(BlockProperties.S, Integer.valueOf(3), new Integer[]{4}).a(BlockProperties.R, EnumDirection.e), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.d)).a((Condition)Condition.a().a(BlockProperties.S, 4).a(BlockProperties.R, EnumDirection.c), Variant.a().a(VariantProperties.c, resourceLocation4)).a((Condition)Condition.a().a(BlockProperties.S, 4).a(BlockProperties.R, EnumDirection.f), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.S, 4).a(BlockProperties.R, EnumDirection.d), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.c)).a((Condition)Condition.a().a(BlockProperties.S, 4).a(BlockProperties.R, EnumDirection.e), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.d)));
    }

    private void a(TexturedModel.a modelFactory, Block ... blocks) {
        for (Block block : blocks) {
            MinecraftKey resourceLocation = modelFactory.create(block, this.c);
            this.b.accept(BlockModelGenerators.b(block, resourceLocation));
        }
    }

    private void b(TexturedModel.a modelFactory, Block ... blocks) {
        for (Block block : blocks) {
            MinecraftKey resourceLocation = modelFactory.create(block, this.c);
            this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, resourceLocation)).a(BlockModelGenerators.c()));
        }
    }

    private void f(Block glass, Block glassPane) {
        this.e(glass);
        TextureMapping textureMapping = TextureMapping.b(glass, glassPane);
        MinecraftKey resourceLocation = ModelTemplates.aG.a(glassPane, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.aH.a(glassPane, textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.aI.a(glassPane, textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.aE.a(glassPane, textureMapping, this.c);
        MinecraftKey resourceLocation5 = ModelTemplates.aF.a(glassPane, textureMapping, this.c);
        Item item = glassPane.k();
        ModelTemplates.bt.a(ModelLocationUtils.a(item), TextureMapping.E(glass), this.c);
        this.b.accept(MultiPartGenerator.a(glassPane).a(Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, resourceLocation2)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.N, true), Variant.a().a(VariantProperties.c, resourceLocation3)).a((Condition)Condition.a().a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.L, false), Variant.a().a(VariantProperties.c, resourceLocation4)).a((Condition)Condition.a().a(BlockProperties.M, false), Variant.a().a(VariantProperties.c, resourceLocation5)).a((Condition)Condition.a().a(BlockProperties.N, false), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.O, false), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.d)));
    }

    private void o(Block commandBlock) {
        TextureMapping textureMapping = TextureMapping.y(commandBlock);
        MinecraftKey resourceLocation = ModelTemplates.aJ.a(commandBlock, textureMapping, this.c);
        MinecraftKey resourceLocation2 = this.a(commandBlock, "_conditional", ModelTemplates.aJ, (MinecraftKey id) -> textureMapping.c(TextureSlot.i, (MinecraftKey)id));
        this.b.accept(MultiVariantGenerator.a(commandBlock).a(BlockModelGenerators.a(BlockProperties.c, resourceLocation2, resourceLocation)).a(BlockModelGenerators.e()));
    }

    private void p(Block anvil) {
        MinecraftKey resourceLocation = TexturedModel.q.create(anvil, this.c);
        this.b.accept(BlockModelGenerators.c(anvil, resourceLocation).a(BlockModelGenerators.c()));
    }

    private List<Variant> a(int age) {
        String string = "_age" + age;
        return IntStream.range(1, 5).mapToObj(i2 -> Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.mV, i2 + string))).collect(Collectors.toList());
    }

    private void l() {
        this.a(Blocks.mV);
        this.b.accept(MultiPartGenerator.a(Blocks.mV).a((Condition)Condition.a().a(BlockProperties.aq, 0), this.a(0)).a((Condition)Condition.a().a(BlockProperties.aq, 1), this.a(1)).a((Condition)Condition.a().a(BlockProperties.bk, BlockPropertyBambooSize.b), Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.mV, "_small_leaves"))).a((Condition)Condition.a().a(BlockProperties.bk, BlockPropertyBambooSize.c), Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.mV, "_large_leaves"))));
    }

    private PropertyDispatch m() {
        return PropertyDispatch.a(BlockProperties.P).a(EnumDirection.a, Variant.a().a(VariantProperties.a, VariantProperties.a.c)).a(EnumDirection.b, Variant.a()).a(EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b));
    }

    private void n() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.nQ, "_top_open");
        this.b.accept(MultiVariantGenerator.a(Blocks.nQ).a(this.m()).a(PropertyDispatch.a(BlockProperties.u).a((Boolean)false, Variant.a().a(VariantProperties.c, TexturedModel.e.create(Blocks.nQ, this.c))).a((Boolean)true, Variant.a().a(VariantProperties.c, TexturedModel.e.get(Blocks.nQ).a((TextureMapping textureMapping) -> textureMapping.a(TextureSlot.f, resourceLocation)).a(Blocks.nQ, "_open", this.c)))));
    }

    private static <T extends Comparable<T>> PropertyDispatch a(IBlockState<T> property, T fence, MinecraftKey higherOrEqualModelId, MinecraftKey lowerModelId) {
        Variant variant = Variant.a().a(VariantProperties.c, higherOrEqualModelId);
        Variant variant2 = Variant.a().a(VariantProperties.c, lowerModelId);
        return PropertyDispatch.a(property).a((T1 comparable2) -> {
            boolean bl = comparable2.compareTo(fence) >= 0;
            return bl ? variant : variant2;
        });
    }

    private void a(Block beehive, Function<Block, TextureMapping> texturesFactory) {
        TextureMapping textureMapping = texturesFactory.apply(beehive).b(TextureSlot.i, TextureSlot.c);
        TextureMapping textureMapping2 = textureMapping.c(TextureSlot.g, TextureMapping.a(beehive, "_front_honey"));
        MinecraftKey resourceLocation = ModelTemplates.o.a(beehive, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.o.a(beehive, "_honey", textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(beehive).a(BlockModelGenerators.b()).a(BlockModelGenerators.a(BlockProperties.aN, 5, resourceLocation2, resourceLocation)));
    }

    private void a(Block crop, IBlockState<Integer> ageProperty, int ... ageTextureIndices) {
        if (ageProperty.a().size() != ageTextureIndices.length) {
            throw new IllegalArgumentException();
        }
        Int2ObjectOpenHashMap int2ObjectMap = new Int2ObjectOpenHashMap();
        PropertyDispatch propertyDispatch = PropertyDispatch.a(ageProperty).a(arg_0 -> this.a(ageTextureIndices, (Int2ObjectMap)int2ObjectMap, crop, arg_0));
        this.a(crop.k());
        this.b.accept(MultiVariantGenerator.a(crop).a(propertyDispatch));
    }

    private void o() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.nZ, "_floor");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.nZ, "_ceiling");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.nZ, "_wall");
        MinecraftKey resourceLocation4 = ModelLocationUtils.a(Blocks.nZ, "_between_walls");
        this.a(Items.vm);
        this.b.accept(MultiVariantGenerator.a(Blocks.nZ).a(PropertyDispatch.a(BlockProperties.R, BlockProperties.V).a(EnumDirection.c, BlockPropertyBellAttach.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(EnumDirection.d, BlockPropertyBellAttach.a, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyBellAttach.a, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyBellAttach.a, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyBellAttach.b, Variant.a().a(VariantProperties.c, resourceLocation2)).a(EnumDirection.d, BlockPropertyBellAttach.b, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.f, BlockPropertyBellAttach.b, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.e, BlockPropertyBellAttach.b, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.c, BlockPropertyBellAttach.c, Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.d, BlockPropertyBellAttach.c, Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.f, BlockPropertyBellAttach.c, Variant.a().a(VariantProperties.c, resourceLocation3)).a(EnumDirection.e, BlockPropertyBellAttach.c, Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.d, BlockPropertyBellAttach.d, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.c, BlockPropertyBellAttach.d, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.d)).a(EnumDirection.f, BlockPropertyBellAttach.d, Variant.a().a(VariantProperties.c, resourceLocation4)).a(EnumDirection.e, BlockPropertyBellAttach.d, Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.c))));
    }

    private void p() {
        this.b.accept(MultiVariantGenerator.a(Blocks.nV, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.nV))).a(PropertyDispatch.a(BlockProperties.U, BlockProperties.R).a(BlockPropertyAttachPosition.a, EnumDirection.c, Variant.a()).a(BlockPropertyAttachPosition.a, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.a, EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.a, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.b, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(BlockPropertyAttachPosition.b, EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.b, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.b, EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.c, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.c, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void d(Block cooker, TexturedModel.a modelFactory) {
        MinecraftKey resourceLocation = modelFactory.create(cooker, this.c);
        MinecraftKey resourceLocation2 = TextureMapping.a(cooker, "_front_on");
        MinecraftKey resourceLocation3 = modelFactory.get(cooker).a((TextureMapping textures) -> textures.a(TextureSlot.g, resourceLocation2)).a(cooker, "_on", this.c);
        this.b.accept(MultiVariantGenerator.a(cooker).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation3, resourceLocation)).a(BlockModelGenerators.b()));
    }

    private void a(Block ... blocks) {
        MinecraftKey resourceLocation = ModelLocationUtils.a("campfire_off");
        for (Block block : blocks) {
            MinecraftKey resourceLocation2 = ModelTemplates.ba.a(block, TextureMapping.D(block), this.c);
            this.a(block.k());
            this.b.accept(MultiVariantGenerator.a(block).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation2, resourceLocation)).a(BlockModelGenerators.c()));
        }
    }

    private void q(Block block) {
        MinecraftKey resourceLocation = ModelTemplates.br.a(block, TextureMapping.l(block), this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private void r(Block block) {
        MinecraftKey resourceLocation = ModelTemplates.bs.a(block, TextureMapping.l(block), this.c);
        this.b.accept(BlockModelGenerators.c(block, resourceLocation));
    }

    private void q() {
        TextureMapping textureMapping = TextureMapping.a(TextureMapping.F(Blocks.ck), TextureMapping.F(Blocks.n));
        MinecraftKey resourceLocation = ModelTemplates.i.a(Blocks.ck, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(Blocks.ck, resourceLocation));
    }

    private void r() {
        this.a(Items.li);
        this.b.accept(MultiPartGenerator.a(Blocks.cv).a(Condition.b(Condition.a().a(BlockProperties.ab, BlockPropertyRedstoneSide.c).a(BlockProperties.aa, BlockPropertyRedstoneSide.c).a(BlockProperties.ac, BlockPropertyRedstoneSide.c).a(BlockProperties.ad, BlockPropertyRedstoneSide.c), Condition.a().a(BlockProperties.ab, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}).a(BlockProperties.aa, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Condition.a().a(BlockProperties.aa, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}).a(BlockProperties.ac, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Condition.a().a(BlockProperties.ac, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}).a(BlockProperties.ad, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Condition.a().a(BlockProperties.ad, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}).a(BlockProperties.ab, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a})), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_dot"))).a((Condition)Condition.a().a(BlockProperties.ab, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_side0"))).a((Condition)Condition.a().a(BlockProperties.ac, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_side_alt0"))).a((Condition)Condition.a().a(BlockProperties.aa, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_side_alt1")).a(VariantProperties.b, VariantProperties.a.d)).a((Condition)Condition.a().a(BlockProperties.ad, (Comparable)((Object)BlockPropertyRedstoneSide.b), (Comparable[])new BlockPropertyRedstoneSide[]{BlockPropertyRedstoneSide.a}), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_side1")).a(VariantProperties.b, VariantProperties.a.d)).a((Condition)Condition.a().a(BlockProperties.ab, BlockPropertyRedstoneSide.a), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_up"))).a((Condition)Condition.a().a(BlockProperties.aa, BlockPropertyRedstoneSide.a), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_up")).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.ac, BlockPropertyRedstoneSide.a), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_up")).a(VariantProperties.b, VariantProperties.a.c)).a((Condition)Condition.a().a(BlockProperties.ad, BlockPropertyRedstoneSide.a), Variant.a().a(VariantProperties.c, ModelLocationUtils.a("redstone_dust_up")).a(VariantProperties.b, VariantProperties.a.d)));
    }

    private void s() {
        this.a(Items.lm);
        this.b.accept(MultiVariantGenerator.a(Blocks.gX).a(BlockModelGenerators.c()).a(PropertyDispatch.a(BlockProperties.bd, BlockProperties.w).a(BlockPropertyComparatorMode.a, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.gX))).a(BlockPropertyComparatorMode.a, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.gX, "_on"))).a(BlockPropertyComparatorMode.b, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.gX, "_subtract"))).a(BlockPropertyComparatorMode.b, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.gX, "_on_subtract")))));
    }

    private void t() {
        TextureMapping textureMapping = TextureMapping.a(Blocks.jQ);
        TextureMapping textureMapping2 = TextureMapping.a(TextureMapping.a(Blocks.jD, "_side"), textureMapping.a(TextureSlot.f));
        MinecraftKey resourceLocation = ModelTemplates.Z.a(Blocks.jD, textureMapping2, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.aa.a(Blocks.jD, textureMapping2, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.i.b(Blocks.jD, "_double", textureMapping2, this.c);
        this.b.accept(BlockModelGenerators.e(Blocks.jD, resourceLocation, resourceLocation2, resourceLocation3));
        this.b.accept(BlockModelGenerators.c(Blocks.jQ, ModelTemplates.c.a(Blocks.jQ, textureMapping, this.c)));
    }

    private void u() {
        this.a(Items.rx);
        this.b.accept(MultiPartGenerator.a(Blocks.fr).a(Variant.a().a(VariantProperties.c, TextureMapping.F(Blocks.fr))).a((Condition)Condition.a().a(BlockProperties.k, true), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fr, "_bottle0"))).a((Condition)Condition.a().a(BlockProperties.l, true), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fr, "_bottle1"))).a((Condition)Condition.a().a(BlockProperties.m, true), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fr, "_bottle2"))).a((Condition)Condition.a().a(BlockProperties.k, false), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fr, "_empty0"))).a((Condition)Condition.a().a(BlockProperties.l, false), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fr, "_empty1"))).a((Condition)Condition.a().a(BlockProperties.m, false), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fr, "_empty2"))));
    }

    private void s(Block mushroomBlock) {
        MinecraftKey resourceLocation = ModelTemplates.bn.a(mushroomBlock, TextureMapping.b(mushroomBlock), this.c);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a("mushroom_block_inside");
        this.b.accept(MultiPartGenerator.a(mushroomBlock).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.N, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.J, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.K, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.L, false), Variant.a().a(VariantProperties.c, resourceLocation2)).a((Condition)Condition.a().a(BlockProperties.M, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.N, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.O, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.J, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, false)).a((Condition)Condition.a().a(BlockProperties.K, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, false)));
        this.a(mushroomBlock, TexturedModel.a.createWithSuffix(mushroomBlock, "_inventory", this.c));
    }

    private void v() {
        this.a(Items.qJ);
        this.b.accept(MultiVariantGenerator.a(Blocks.eg).a(PropertyDispatch.a(BlockProperties.ay).a((Integer)0, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.eg))).a((Integer)1, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.eg, "_slice1"))).a((Integer)2, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.eg, "_slice2"))).a((Integer)3, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.eg, "_slice3"))).a((Integer)4, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.eg, "_slice4"))).a((Integer)5, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.eg, "_slice5"))).a((Integer)6, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.eg, "_slice6")))));
    }

    private void w() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.c, TextureMapping.a(Blocks.nT, "_side3")).a(TextureSlot.o, TextureMapping.F(Blocks.t)).a(TextureSlot.n, TextureMapping.a(Blocks.nT, "_top")).a(TextureSlot.j, TextureMapping.a(Blocks.nT, "_side3")).a(TextureSlot.l, TextureMapping.a(Blocks.nT, "_side3")).a(TextureSlot.k, TextureMapping.a(Blocks.nT, "_side1")).a(TextureSlot.m, TextureMapping.a(Blocks.nT, "_side2"));
        this.b.accept(BlockModelGenerators.c(Blocks.nT, ModelTemplates.a.a(Blocks.nT, textureMapping, this.c)));
    }

    private void x() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.c, TextureMapping.a(Blocks.nX, "_front")).a(TextureSlot.o, TextureMapping.a(Blocks.nX, "_bottom")).a(TextureSlot.n, TextureMapping.a(Blocks.nX, "_top")).a(TextureSlot.j, TextureMapping.a(Blocks.nX, "_front")).a(TextureSlot.k, TextureMapping.a(Blocks.nX, "_front")).a(TextureSlot.l, TextureMapping.a(Blocks.nX, "_side")).a(TextureSlot.m, TextureMapping.a(Blocks.nX, "_side"));
        this.b.accept(BlockModelGenerators.c(Blocks.nX, ModelTemplates.a.a(Blocks.nX, textureMapping, this.c)));
    }

    private void a(Block block, Block otherTextureSource, BiFunction<Block, Block, TextureMapping> texturesFactory) {
        TextureMapping textureMapping = texturesFactory.apply(block, otherTextureSource);
        this.b.accept(BlockModelGenerators.c(block, ModelTemplates.a.a(block, textureMapping, this.c)));
    }

    private void y() {
        TextureMapping textureMapping = TextureMapping.k(Blocks.dU);
        this.b.accept(BlockModelGenerators.c(Blocks.dU, ModelLocationUtils.a(Blocks.dU)));
        this.a(Blocks.ee, textureMapping);
        this.a(Blocks.ef, textureMapping);
    }

    private void a(Block block, TextureMapping texture) {
        MinecraftKey resourceLocation = ModelTemplates.n.a(block, texture.c(TextureSlot.g, TextureMapping.F(block)), this.c);
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, resourceLocation)).a(BlockModelGenerators.b()));
    }

    private void z() {
        this.a(Items.ry);
        this.k(Blocks.fs);
        this.b.accept(BlockModelGenerators.c(Blocks.fu, ModelTemplates.bq.a(Blocks.fu, TextureMapping.j(TextureMapping.a(Blocks.H, "_still")), this.c)));
        this.b.accept(MultiVariantGenerator.a(Blocks.ft).a(PropertyDispatch.a(LayeredCauldronBlock.e).a((Integer)1, Variant.a().a(VariantProperties.c, ModelTemplates.bo.a(Blocks.ft, "_level1", TextureMapping.j(TextureMapping.a(Blocks.G, "_still")), this.c))).a((Integer)2, Variant.a().a(VariantProperties.c, ModelTemplates.bp.a(Blocks.ft, "_level2", TextureMapping.j(TextureMapping.a(Blocks.G, "_still")), this.c))).a((Integer)3, Variant.a().a(VariantProperties.c, ModelTemplates.bq.a(Blocks.ft, "_full", TextureMapping.j(TextureMapping.a(Blocks.G, "_still")), this.c)))));
        this.b.accept(MultiVariantGenerator.a(Blocks.fv).a(PropertyDispatch.a(LayeredCauldronBlock.e).a((Integer)1, Variant.a().a(VariantProperties.c, ModelTemplates.bo.a(Blocks.fv, "_level1", TextureMapping.j(TextureMapping.F(Blocks.qy)), this.c))).a((Integer)2, Variant.a().a(VariantProperties.c, ModelTemplates.bp.a(Blocks.fv, "_level2", TextureMapping.j(TextureMapping.F(Blocks.qy)), this.c))).a((Integer)3, Variant.a().a(VariantProperties.c, ModelTemplates.bq.a(Blocks.fv, "_full", TextureMapping.j(TextureMapping.F(Blocks.qy)), this.c)))));
    }

    private void A() {
        TextureMapping textureMapping = TextureMapping.b(Blocks.ku);
        MinecraftKey resourceLocation = ModelTemplates.aC.a(Blocks.ku, textureMapping, this.c);
        MinecraftKey resourceLocation2 = this.a(Blocks.ku, "_dead", ModelTemplates.aC, (MinecraftKey id) -> textureMapping.c(TextureSlot.b, (MinecraftKey)id));
        this.b.accept(MultiVariantGenerator.a(Blocks.ku).a(BlockModelGenerators.a(BlockProperties.au, 5, resourceLocation2, resourceLocation)));
    }

    private void t(Block block) {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.f, TextureMapping.a(Blocks.cC, "_top")).a(TextureSlot.i, TextureMapping.a(Blocks.cC, "_side")).a(TextureSlot.g, TextureMapping.a(block, "_front"));
        TextureMapping textureMapping2 = new TextureMapping().a(TextureSlot.i, TextureMapping.a(Blocks.cC, "_top")).a(TextureSlot.g, TextureMapping.a(block, "_front_vertical"));
        MinecraftKey resourceLocation = ModelTemplates.n.a(block, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.p.a(block, textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(block).a(PropertyDispatch.a(BlockProperties.P).a(EnumDirection.a, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.a, VariantProperties.a.c)).a(EnumDirection.b, Variant.a().a(VariantProperties.c, resourceLocation2)).a(EnumDirection.c, Variant.a().a(VariantProperties.c, resourceLocation)).a(EnumDirection.f, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.d, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void B() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.fx);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.fx, "_filled");
        this.b.accept(MultiVariantGenerator.a(Blocks.fx).a(PropertyDispatch.a(BlockProperties.h).a((Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation)).a((Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation2))).a(BlockModelGenerators.c()));
    }

    private void C() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.kt, "_side");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.kt, "_noside");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.kt, "_noside1");
        MinecraftKey resourceLocation4 = ModelLocationUtils.a(Blocks.kt, "_noside2");
        MinecraftKey resourceLocation5 = ModelLocationUtils.a(Blocks.kt, "_noside3");
        this.b.accept(MultiPartGenerator.a(Blocks.kt).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.N, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.J, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.K, true), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.L, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2), Variant.a().a(VariantProperties.c, resourceLocation3), Variant.a().a(VariantProperties.c, resourceLocation4), Variant.a().a(VariantProperties.c, resourceLocation5)).a((Condition)Condition.a().a(BlockProperties.M, false), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.N, false), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.O, false), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.J, false), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.d, true)).a((Condition)Condition.a().a(BlockProperties.K, false), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true), Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.e, 2).a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.d, true)));
    }

    private void D() {
        this.b.accept(MultiPartGenerator.a(Blocks.oY).a(Variant.a().a(VariantProperties.c, TextureMapping.F(Blocks.oY))).a((Condition)Condition.a().a(BlockProperties.aL, 1), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.oY, "_contents1"))).a((Condition)Condition.a().a(BlockProperties.aL, 2), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.oY, "_contents2"))).a((Condition)Condition.a().a(BlockProperties.aL, 3), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.oY, "_contents3"))).a((Condition)Condition.a().a(BlockProperties.aL, 4), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.oY, "_contents4"))).a((Condition)Condition.a().a(BlockProperties.aL, 5), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.oY, "_contents5"))).a((Condition)Condition.a().a(BlockProperties.aL, 6), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.oY, "_contents6"))).a((Condition)Condition.a().a(BlockProperties.aL, 7), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.oY, "_contents7"))).a((Condition)Condition.a().a(BlockProperties.aL, 8), Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.oY, "_contents_ready"))));
    }

    private void u(Block block) {
        this.a(block);
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, ModelTemplates.am.a(block, TextureMapping.c(block), this.c))).a(this.m()));
    }

    private void E() {
        this.u(Blocks.qu);
        this.u(Blocks.qt);
        this.u(Blocks.qs);
        this.u(Blocks.qr);
    }

    private void F() {
        this.a(Blocks.rn);
        PropertyDispatch.b<EnumDirection, DripstoneThickness> c2 = PropertyDispatch.a(BlockProperties.bm, BlockProperties.bn);
        for (DripstoneThickness dripstoneThickness : DripstoneThickness.values()) {
            c2.a(EnumDirection.b, dripstoneThickness, this.a(EnumDirection.b, dripstoneThickness));
        }
        for (DripstoneThickness dripstoneThickness2 : DripstoneThickness.values()) {
            c2.a(EnumDirection.a, dripstoneThickness2, this.a(EnumDirection.a, dripstoneThickness2));
        }
        this.b.accept(MultiVariantGenerator.a(Blocks.rn).a(c2));
    }

    private Variant a(EnumDirection direction, DripstoneThickness thickness) {
        String string = "_" + direction.c() + "_" + thickness.c();
        TextureMapping textureMapping = TextureMapping.c(TextureMapping.a(Blocks.rn, string));
        return Variant.a().a(VariantProperties.c, ModelTemplates.al.a(Blocks.rn, string, textureMapping, this.c));
    }

    private void v(Block block) {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, TextureMapping.F(Blocks.dV)).a(TextureSlot.f, TextureMapping.F(block)).a(TextureSlot.i, TextureMapping.a(block, "_side"));
        this.b.accept(BlockModelGenerators.c(block, ModelTemplates.m.a(block, textureMapping, this.c)));
    }

    private void G() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.gY, "_side");
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.f, TextureMapping.a(Blocks.gY, "_top")).a(TextureSlot.i, resourceLocation);
        TextureMapping textureMapping2 = new TextureMapping().a(TextureSlot.f, TextureMapping.a(Blocks.gY, "_inverted_top")).a(TextureSlot.i, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.gY).a(PropertyDispatch.a(BlockProperties.p).a((Boolean)false, Variant.a().a(VariantProperties.c, ModelTemplates.aD.a(Blocks.gY, textureMapping, this.c))).a((Boolean)true, Variant.a().a(VariantProperties.c, ModelTemplates.aD.a(ModelLocationUtils.a(Blocks.gY, "_inverted"), textureMapping2, this.c)))));
    }

    private void w(Block block) {
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(block))).a(this.m()));
    }

    private void H() {
        Block block = Blocks.rm;
        MinecraftKey resourceLocation = ModelLocationUtils.a(block, "_on");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(block);
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(block))).a(this.m()).a(BlockModelGenerators.a(BlockProperties.w, resourceLocation, resourceLocation2)));
    }

    private void I() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.B, TextureMapping.F(Blocks.j)).a(TextureSlot.f, TextureMapping.F(Blocks.cB));
        TextureMapping textureMapping2 = new TextureMapping().a(TextureSlot.B, TextureMapping.F(Blocks.j)).a(TextureSlot.f, TextureMapping.a(Blocks.cB, "_moist"));
        MinecraftKey resourceLocation = ModelTemplates.aU.a(Blocks.cB, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.aU.a(TextureMapping.a(Blocks.cB, "_moist"), textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.cB).a(BlockModelGenerators.a(BlockProperties.aQ, 7, resourceLocation2, resourceLocation)));
    }

    private List<MinecraftKey> x(Block texture) {
        MinecraftKey resourceLocation = ModelTemplates.aV.a(ModelLocationUtils.a(texture, "_floor0"), TextureMapping.u(texture), this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.aV.a(ModelLocationUtils.a(texture, "_floor1"), TextureMapping.v(texture), this.c);
        return ImmutableList.of((Object)resourceLocation, (Object)resourceLocation2);
    }

    private List<MinecraftKey> y(Block texture) {
        MinecraftKey resourceLocation = ModelTemplates.aW.a(ModelLocationUtils.a(texture, "_side0"), TextureMapping.u(texture), this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.aW.a(ModelLocationUtils.a(texture, "_side1"), TextureMapping.v(texture), this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.aX.a(ModelLocationUtils.a(texture, "_side_alt0"), TextureMapping.u(texture), this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.aX.a(ModelLocationUtils.a(texture, "_side_alt1"), TextureMapping.v(texture), this.c);
        return ImmutableList.of((Object)resourceLocation, (Object)resourceLocation2, (Object)resourceLocation3, (Object)resourceLocation4);
    }

    private List<MinecraftKey> z(Block texture) {
        MinecraftKey resourceLocation = ModelTemplates.aY.a(ModelLocationUtils.a(texture, "_up0"), TextureMapping.u(texture), this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.aY.a(ModelLocationUtils.a(texture, "_up1"), TextureMapping.v(texture), this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.aZ.a(ModelLocationUtils.a(texture, "_up_alt0"), TextureMapping.u(texture), this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.aZ.a(ModelLocationUtils.a(texture, "_up_alt1"), TextureMapping.v(texture), this.c);
        return ImmutableList.of((Object)resourceLocation, (Object)resourceLocation2, (Object)resourceLocation3, (Object)resourceLocation4);
    }

    private static List<Variant> a(List<MinecraftKey> modelIds, UnaryOperator<Variant> processor) {
        return modelIds.stream().map(modelId -> Variant.a().a(VariantProperties.c, modelId)).map(processor).collect(Collectors.toList());
    }

    private void J() {
        Condition.c condition = Condition.a().a(BlockProperties.L, false).a(BlockProperties.M, false).a(BlockProperties.N, false).a(BlockProperties.O, false).a(BlockProperties.J, false);
        List<MinecraftKey> list = this.x(Blocks.cq);
        List<MinecraftKey> list2 = this.y(Blocks.cq);
        List<MinecraftKey> list3 = this.z(Blocks.cq);
        this.b.accept(MultiPartGenerator.a(Blocks.cq).a((Condition)condition, BlockModelGenerators.a(list, variant -> variant)).a(Condition.b(Condition.a().a(BlockProperties.L, true), condition), BlockModelGenerators.a(list2, variant -> variant)).a(Condition.b(Condition.a().a(BlockProperties.M, true), condition), BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.b))).a(Condition.b(Condition.a().a(BlockProperties.N, true), condition), BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.c))).a(Condition.b(Condition.a().a(BlockProperties.O, true), condition), BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.d))).a((Condition)Condition.a().a(BlockProperties.J, true), BlockModelGenerators.a(list3, variant -> variant)));
    }

    private void K() {
        List<MinecraftKey> list = this.x(Blocks.cr);
        List<MinecraftKey> list2 = this.y(Blocks.cr);
        this.b.accept(MultiPartGenerator.a(Blocks.cr).a(BlockModelGenerators.a(list, variant -> variant)).a(BlockModelGenerators.a(list2, variant -> variant)).a(BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.b))).a(BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.c))).a(BlockModelGenerators.a(list2, variant -> variant.a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void A(Block lantern) {
        MinecraftKey resourceLocation = TexturedModel.s.create(lantern, this.c);
        MinecraftKey resourceLocation2 = TexturedModel.t.create(lantern, this.c);
        this.a(lantern.k());
        this.b.accept(MultiVariantGenerator.a(lantern).a(BlockModelGenerators.a(BlockProperties.j, resourceLocation2, resourceLocation)));
    }

    private void L() {
        TextureMapping textureMapping = TextureMapping.a(TextureMapping.a(Blocks.ac, "_side"), TextureMapping.a(Blocks.ac, "_top"));
        MinecraftKey resourceLocation = ModelTemplates.i.a(Blocks.ac, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.d(Blocks.ac, resourceLocation));
    }

    private void M() {
        this.a(Items.Q);
        Block block = Blocks.E;
        PropertyDispatch.b<Boolean, Integer> c2 = PropertyDispatch.a(MangrovePropaguleBlock.c, MangrovePropaguleBlock.a);
        MinecraftKey resourceLocation = ModelLocationUtils.a(block);
        for (int i2 = 0; i2 <= 4; ++i2) {
            MinecraftKey resourceLocation2 = ModelLocationUtils.a(block, "_hanging_" + i2);
            c2.a((Boolean)true, (Integer)i2, Variant.a().a(VariantProperties.c, resourceLocation2));
            c2.a((Boolean)false, (Integer)i2, Variant.a().a(VariantProperties.c, resourceLocation));
        }
        this.b.accept(MultiVariantGenerator.a(Blocks.E).a(c2));
    }

    private void N() {
        this.b.accept(MultiVariantGenerator.a(Blocks.kF).a(PropertyDispatch.a(BlockProperties.as).a((Integer)0, Variant.a().a(VariantProperties.c, this.a(Blocks.kF, "_0", ModelTemplates.c, TextureMapping::b))).a((Integer)1, Variant.a().a(VariantProperties.c, this.a(Blocks.kF, "_1", ModelTemplates.c, TextureMapping::b))).a((Integer)2, Variant.a().a(VariantProperties.c, this.a(Blocks.kF, "_2", ModelTemplates.c, TextureMapping::b))).a((Integer)3, Variant.a().a(VariantProperties.c, this.a(Blocks.kF, "_3", ModelTemplates.c, TextureMapping::b)))));
    }

    private void O() {
        MinecraftKey resourceLocation = TextureMapping.F(Blocks.j);
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, resourceLocation).b(TextureSlot.e, TextureSlot.c).a(TextureSlot.f, TextureMapping.a(Blocks.i, "_top")).a(TextureSlot.i, TextureMapping.a(Blocks.i, "_snow"));
        Variant variant = Variant.a().a(VariantProperties.c, ModelTemplates.m.a(Blocks.i, "_snow", textureMapping, this.c));
        this.a(Blocks.i, ModelLocationUtils.a(Blocks.i), variant);
        MinecraftKey resourceLocation2 = TexturedModel.e.get(Blocks.fk).a((TextureMapping textures) -> textures.a(TextureSlot.e, resourceLocation)).a(Blocks.fk, this.c);
        this.a(Blocks.fk, resourceLocation2, variant);
        MinecraftKey resourceLocation3 = TexturedModel.e.get(Blocks.l).a((TextureMapping textures) -> textures.a(TextureSlot.e, resourceLocation)).a(Blocks.l, this.c);
        this.a(Blocks.l, resourceLocation3, variant);
    }

    private void a(Block topSoil, MinecraftKey modelId, Variant snowyVariant) {
        List<Variant> list = Arrays.asList(BlockModelGenerators.a(modelId));
        this.b.accept(MultiVariantGenerator.a(topSoil).a(PropertyDispatch.a(BlockProperties.z).a((Boolean)true, snowyVariant).a((Boolean)false, list)));
    }

    private void P() {
        this.a(Items.qp);
        this.b.accept(MultiVariantGenerator.a(Blocks.fB).a(PropertyDispatch.a(BlockProperties.ar).a((Integer)0, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fB, "_stage0"))).a((Integer)1, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fB, "_stage1"))).a((Integer)2, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fB, "_stage2")))).a(BlockModelGenerators.c()));
    }

    private void Q() {
        this.b.accept(BlockModelGenerators.b(Blocks.kB, ModelLocationUtils.a(Blocks.kB)));
    }

    private void g(Block pressurePlate, Block textureSource) {
        TextureMapping textureMapping = TextureMapping.b(textureSource);
        MinecraftKey resourceLocation = ModelTemplates.W.a(pressurePlate, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.X.a(pressurePlate, textureMapping, this.c);
        this.b.accept(MultiVariantGenerator.a(pressurePlate).a(BlockModelGenerators.a(BlockProperties.aT, 1, resourceLocation2, resourceLocation)));
    }

    private void R() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.hb);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.hb, "_side");
        this.a(Items.ls);
        this.b.accept(MultiVariantGenerator.a(Blocks.hb).a(PropertyDispatch.a(BlockProperties.Q).a(EnumDirection.a, Variant.a().a(VariantProperties.c, resourceLocation)).a(EnumDirection.c, Variant.a().a(VariantProperties.c, resourceLocation2)).a(EnumDirection.f, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.b)).a(EnumDirection.d, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.c)).a(EnumDirection.e, Variant.a().a(VariantProperties.c, resourceLocation2).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void h(Block modelSource, Block child) {
        MinecraftKey resourceLocation = ModelLocationUtils.a(modelSource);
        this.b.accept(MultiVariantGenerator.a(child, Variant.a().a(VariantProperties.c, resourceLocation)));
        this.a(child, resourceLocation);
    }

    private void S() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.eW, "_post_ends");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.eW, "_post");
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.eW, "_cap");
        MinecraftKey resourceLocation4 = ModelLocationUtils.a(Blocks.eW, "_cap_alt");
        MinecraftKey resourceLocation5 = ModelLocationUtils.a(Blocks.eW, "_side");
        MinecraftKey resourceLocation6 = ModelLocationUtils.a(Blocks.eW, "_side_alt");
        this.b.accept(MultiPartGenerator.a(Blocks.eW).a(Variant.a().a(VariantProperties.c, resourceLocation)).a((Condition)Condition.a().a(BlockProperties.L, false).a(BlockProperties.M, false).a(BlockProperties.N, false).a(BlockProperties.O, false), Variant.a().a(VariantProperties.c, resourceLocation2)).a((Condition)Condition.a().a(BlockProperties.L, true).a(BlockProperties.M, false).a(BlockProperties.N, false).a(BlockProperties.O, false), Variant.a().a(VariantProperties.c, resourceLocation3)).a((Condition)Condition.a().a(BlockProperties.L, false).a(BlockProperties.M, true).a(BlockProperties.N, false).a(BlockProperties.O, false), Variant.a().a(VariantProperties.c, resourceLocation3).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.L, false).a(BlockProperties.M, false).a(BlockProperties.N, true).a(BlockProperties.O, false), Variant.a().a(VariantProperties.c, resourceLocation4)).a((Condition)Condition.a().a(BlockProperties.L, false).a(BlockProperties.M, false).a(BlockProperties.N, false).a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, resourceLocation4).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.L, true), Variant.a().a(VariantProperties.c, resourceLocation5)).a((Condition)Condition.a().a(BlockProperties.M, true), Variant.a().a(VariantProperties.c, resourceLocation5).a(VariantProperties.b, VariantProperties.a.b)).a((Condition)Condition.a().a(BlockProperties.N, true), Variant.a().a(VariantProperties.c, resourceLocation6)).a((Condition)Condition.a().a(BlockProperties.O, true), Variant.a().a(VariantProperties.c, resourceLocation6).a(VariantProperties.b, VariantProperties.a.b)));
        this.b(Blocks.eW);
    }

    private void B(Block block) {
        this.b.accept(MultiVariantGenerator.a(block, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(block))).a(BlockModelGenerators.b()));
    }

    private void T() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.dv);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.dv, "_on");
        this.b(Blocks.dv);
        this.b.accept(MultiVariantGenerator.a(Blocks.dv).a(BlockModelGenerators.a(BlockProperties.w, resourceLocation, resourceLocation2)).a(PropertyDispatch.a(BlockProperties.U, BlockProperties.R).a(BlockPropertyAttachPosition.c, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.c, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.c)).a(BlockPropertyAttachPosition.c, EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.c).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.a, EnumDirection.c, Variant.a()).a(BlockPropertyAttachPosition.a, EnumDirection.f, Variant.a().a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.a, EnumDirection.d, Variant.a().a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.a, EnumDirection.e, Variant.a().a(VariantProperties.b, VariantProperties.a.d)).a(BlockPropertyAttachPosition.b, EnumDirection.c, Variant.a().a(VariantProperties.a, VariantProperties.a.b)).a(BlockPropertyAttachPosition.b, EnumDirection.f, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b)).a(BlockPropertyAttachPosition.b, EnumDirection.d, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.c)).a(BlockPropertyAttachPosition.b, EnumDirection.e, Variant.a().a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.d))));
    }

    private void U() {
        this.b(Blocks.fl);
        this.b.accept(BlockModelGenerators.b(Blocks.fl, ModelLocationUtils.a(Blocks.fl)));
    }

    private void V() {
        this.b(Blocks.sh);
        this.b.accept(BlockModelGenerators.c(Blocks.sh, ModelLocationUtils.a(Blocks.sh)));
    }

    private void W() {
        this.b.accept(MultiVariantGenerator.a(Blocks.ed).a(PropertyDispatch.a(BlockProperties.H).a(EnumDirection.EnumAxis.a, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ed, "_ns"))).a(EnumDirection.EnumAxis.c, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.ed, "_ew")))));
    }

    private void X() {
        MinecraftKey resourceLocation = TexturedModel.a.create(Blocks.dV, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.dV, Variant.a().a(VariantProperties.c, resourceLocation), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.a, VariantProperties.a.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.b).a(VariantProperties.a, VariantProperties.a.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.c).a(VariantProperties.a, VariantProperties.a.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.b), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.c), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, VariantProperties.a.d).a(VariantProperties.a, VariantProperties.a.d)));
    }

    private void Y() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.kL);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.kL, "_on");
        this.b.accept(MultiVariantGenerator.a(Blocks.kL).a(BlockModelGenerators.a(BlockProperties.w, resourceLocation2, resourceLocation)).a(BlockModelGenerators.e()));
    }

    private void Z() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, TextureMapping.a(Blocks.bx, "_bottom")).a(TextureSlot.i, TextureMapping.a(Blocks.bx, "_side"));
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.bx, "_top_sticky");
        MinecraftKey resourceLocation2 = TextureMapping.a(Blocks.bx, "_top");
        TextureMapping textureMapping2 = textureMapping.c(TextureSlot.E, resourceLocation);
        TextureMapping textureMapping3 = textureMapping.c(TextureSlot.E, resourceLocation2);
        MinecraftKey resourceLocation3 = ModelLocationUtils.a(Blocks.bx, "_base");
        this.a(Blocks.bx, resourceLocation3, textureMapping3);
        this.a(Blocks.bq, resourceLocation3, textureMapping2);
        MinecraftKey resourceLocation4 = ModelTemplates.m.a(Blocks.bx, "_inventory", textureMapping.c(TextureSlot.f, resourceLocation2), this.c);
        MinecraftKey resourceLocation5 = ModelTemplates.m.a(Blocks.bq, "_inventory", textureMapping.c(TextureSlot.f, resourceLocation), this.c);
        this.a(Blocks.bx, resourceLocation4);
        this.a(Blocks.bq, resourceLocation5);
    }

    private void a(Block piston, MinecraftKey extendedModelId, TextureMapping textures) {
        MinecraftKey resourceLocation = ModelTemplates.bf.a(piston, textures, this.c);
        this.b.accept(MultiVariantGenerator.a(piston).a(BlockModelGenerators.a(BlockProperties.g, extendedModelId, resourceLocation)).a(BlockModelGenerators.e()));
    }

    private void aa() {
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.F, TextureMapping.a(Blocks.bx, "_top")).a(TextureSlot.i, TextureMapping.a(Blocks.bx, "_side"));
        TextureMapping textureMapping2 = textureMapping.c(TextureSlot.E, TextureMapping.a(Blocks.bx, "_top_sticky"));
        TextureMapping textureMapping3 = textureMapping.c(TextureSlot.E, TextureMapping.a(Blocks.bx, "_top"));
        this.b.accept(MultiVariantGenerator.a(Blocks.by).a(PropertyDispatch.a(BlockProperties.x, BlockProperties.bg).a((Boolean)false, BlockPropertyPistonType.a, Variant.a().a(VariantProperties.c, ModelTemplates.bg.a(Blocks.bx, "_head", textureMapping3, this.c))).a((Boolean)false, BlockPropertyPistonType.b, Variant.a().a(VariantProperties.c, ModelTemplates.bg.a(Blocks.bx, "_head_sticky", textureMapping2, this.c))).a((Boolean)true, BlockPropertyPistonType.a, Variant.a().a(VariantProperties.c, ModelTemplates.bh.a(Blocks.bx, "_head_short", textureMapping3, this.c))).a((Boolean)true, BlockPropertyPistonType.b, Variant.a().a(VariantProperties.c, ModelTemplates.bh.a(Blocks.bx, "_head_short_sticky", textureMapping2, this.c)))).a(BlockModelGenerators.e()));
    }

    private void ab() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.qz, "_inactive");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.qz, "_active");
        this.a(Blocks.qz, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.qz).a(PropertyDispatch.a(BlockProperties.bo).a((T1 sculkSensorPhase) -> Variant.a().a(VariantProperties.c, sculkSensorPhase == SculkSensorPhase.b ? resourceLocation2 : resourceLocation))));
    }

    private void ac() {
        MinecraftKey resourceLocation = ModelTemplates.bH.a(Blocks.qD, TextureMapping.a(false), this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.bH.a(Blocks.qD, "_can_summon", TextureMapping.a(true), this.c);
        this.a(Blocks.qD, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.qD).a(BlockModelGenerators.a(BlockProperties.G, resourceLocation2, resourceLocation)));
    }

    private void ad() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.nO, "_stable");
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.nO, "_unstable");
        this.a(Blocks.nO, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.nO).a(BlockModelGenerators.a(BlockProperties.b, resourceLocation2, resourceLocation)));
    }

    private void ae() {
        MinecraftKey resourceLocation = this.a(Blocks.rp, "", ModelTemplates.am, TextureMapping::c);
        MinecraftKey resourceLocation2 = this.a(Blocks.rp, "_lit", ModelTemplates.am, TextureMapping::c);
        this.b.accept(MultiVariantGenerator.a(Blocks.rp).a(BlockModelGenerators.a(BlockProperties.D, resourceLocation2, resourceLocation)));
        MinecraftKey resourceLocation3 = this.a(Blocks.rq, "", ModelTemplates.am, TextureMapping::c);
        MinecraftKey resourceLocation4 = this.a(Blocks.rq, "_lit", ModelTemplates.am, TextureMapping::c);
        this.b.accept(MultiVariantGenerator.a(Blocks.rq).a(BlockModelGenerators.a(BlockProperties.D, resourceLocation4, resourceLocation3)));
    }

    private void af() {
        MinecraftKey resourceLocation = TexturedModel.a.create(Blocks.fA, this.c);
        MinecraftKey resourceLocation2 = this.a(Blocks.fA, "_on", ModelTemplates.c, TextureMapping::b);
        this.b.accept(MultiVariantGenerator.a(Blocks.fA).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation2, resourceLocation)));
    }

    private void i(Block torch, Block wallTorch) {
        TextureMapping textureMapping = TextureMapping.x(torch);
        this.b.accept(BlockModelGenerators.c(torch, ModelTemplates.bd.a(torch, textureMapping, this.c)));
        this.b.accept(MultiVariantGenerator.a(wallTorch, Variant.a().a(VariantProperties.c, ModelTemplates.be.a(wallTorch, textureMapping, this.c))).a(BlockModelGenerators.d()));
        this.b(torch);
        this.a(wallTorch);
    }

    private void ag() {
        TextureMapping textureMapping = TextureMapping.x(Blocks.dJ);
        TextureMapping textureMapping2 = TextureMapping.i(TextureMapping.a(Blocks.dJ, "_off"));
        MinecraftKey resourceLocation = ModelTemplates.bd.a(Blocks.dJ, textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.bd.a(Blocks.dJ, "_off", textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.dJ).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation, resourceLocation2)));
        MinecraftKey resourceLocation3 = ModelTemplates.be.a(Blocks.dK, textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.be.a(Blocks.dK, "_off", textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.dK).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation3, resourceLocation4)).a(BlockModelGenerators.d()));
        this.b(Blocks.dJ);
        this.a(Blocks.dK);
    }

    private void ah() {
        this.a(Items.ll);
        this.b.accept(MultiVariantGenerator.a(Blocks.eh).a(PropertyDispatch.a(BlockProperties.aA, BlockProperties.s, BlockProperties.w).a((T1 tick, T2 locked, T3 on) -> {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('_').append(tick).append("tick");
            if (on.booleanValue()) {
                stringBuilder.append("_on");
            }
            if (locked.booleanValue()) {
                stringBuilder.append("_locked");
            }
            return Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.eh, stringBuilder.toString()));
        })).a(BlockModelGenerators.c()));
    }

    private void ai() {
        this.a(Items.cw);
        this.b.accept(MultiVariantGenerator.a(Blocks.mR).a(PropertyDispatch.a(BlockProperties.aS, BlockProperties.C).a((Integer)1, (Boolean)false, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("dead_sea_pickle")))).a((Integer)2, (Boolean)false, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("two_dead_sea_pickles")))).a((Integer)3, (Boolean)false, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("three_dead_sea_pickles")))).a((Integer)4, (Boolean)false, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("four_dead_sea_pickles")))).a((Integer)1, (Boolean)true, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("sea_pickle")))).a((Integer)2, (Boolean)true, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("two_sea_pickles")))).a((Integer)3, (Boolean)true, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("three_sea_pickles")))).a((Integer)4, (Boolean)true, Arrays.asList(BlockModelGenerators.a(ModelLocationUtils.a("four_sea_pickles"))))));
    }

    private void aj() {
        TextureMapping textureMapping = TextureMapping.a(Blocks.dM);
        MinecraftKey resourceLocation = ModelTemplates.c.a(Blocks.dO, textureMapping, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.dM).a(PropertyDispatch.a(BlockProperties.aF).a((T1 height) -> Variant.a().a(VariantProperties.c, height < 8 ? ModelLocationUtils.a(Blocks.dM, "_height" + height * 2) : resourceLocation))));
        this.a(Blocks.dM, ModelLocationUtils.a(Blocks.dM, "_height2"));
        this.b.accept(BlockModelGenerators.c(Blocks.dO, resourceLocation));
    }

    private void ak() {
        this.b.accept(MultiVariantGenerator.a(Blocks.nY, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.nY))).a(BlockModelGenerators.b()));
    }

    private void al() {
        MinecraftKey resourceLocation = TexturedModel.a.create(Blocks.oW, this.c);
        this.a(Blocks.oW, resourceLocation);
        this.b.accept(MultiVariantGenerator.a(Blocks.oW).a(PropertyDispatch.a(BlockProperties.bj).a((T1 mode) -> Variant.a().a(VariantProperties.c, this.a(Blocks.oW, "_" + mode.c(), ModelTemplates.c, TextureMapping::b)))));
    }

    private void am() {
        this.a(Items.vp);
        this.b.accept(MultiVariantGenerator.a(Blocks.oe).a(PropertyDispatch.a(BlockProperties.as).a((T1 stage) -> Variant.a().a(VariantProperties.c, this.a(Blocks.oe, "_stage" + stage, ModelTemplates.am, TextureMapping::c)))));
    }

    private void an() {
        this.a(Items.oA);
        this.b.accept(MultiVariantGenerator.a(Blocks.fH).a(PropertyDispatch.a(BlockProperties.a, BlockProperties.M, BlockProperties.L, BlockProperties.N, BlockProperties.O).a((Boolean)false, (Boolean)false, (Boolean)false, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_ns"))).a((Boolean)false, (Boolean)true, (Boolean)false, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_n")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)false, (Boolean)false, (Boolean)true, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_n"))).a((Boolean)false, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_n")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)false, (Boolean)false, (Boolean)false, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_n")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)false, (Boolean)true, (Boolean)true, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_ne"))).a((Boolean)false, (Boolean)true, (Boolean)false, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_ne")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)false, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_ne")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)false, (Boolean)false, (Boolean)true, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_ne")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)false, (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_ns"))).a((Boolean)false, (Boolean)true, (Boolean)false, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_ns")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)false, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_nse"))).a((Boolean)false, (Boolean)true, (Boolean)false, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_nse")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)false, (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_nse")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)false, (Boolean)true, (Boolean)true, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_nse")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)false, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_nsew"))).a((Boolean)true, (Boolean)false, (Boolean)false, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_attached_ns"))).a((Boolean)true, (Boolean)false, (Boolean)true, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_attached_n"))).a((Boolean)true, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_attached_n")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)true, (Boolean)true, (Boolean)false, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_attached_n")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)true, (Boolean)false, (Boolean)false, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_attached_n")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)true, (Boolean)true, (Boolean)true, (Boolean)false, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_attached_ne"))).a((Boolean)true, (Boolean)true, (Boolean)false, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_attached_ne")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)true, (Boolean)false, (Boolean)false, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_attached_ne")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)true, (Boolean)false, (Boolean)true, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_attached_ne")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)true, (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_attached_ns"))).a((Boolean)true, (Boolean)true, (Boolean)false, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_attached_ns")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)true, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)false, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_attached_nse"))).a((Boolean)true, (Boolean)true, (Boolean)false, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_attached_nse")).a(VariantProperties.b, VariantProperties.a.b)).a((Boolean)true, (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_attached_nse")).a(VariantProperties.b, VariantProperties.a.c)).a((Boolean)true, (Boolean)true, (Boolean)true, (Boolean)false, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_attached_nse")).a(VariantProperties.b, VariantProperties.a.d)).a((Boolean)true, (Boolean)true, (Boolean)true, (Boolean)true, (Boolean)true, Variant.a().a(VariantProperties.c, ModelLocationUtils.a(Blocks.fH, "_attached_nsew")))));
    }

    private void ao() {
        this.b(Blocks.fG);
        this.b.accept(MultiVariantGenerator.a(Blocks.fG).a(PropertyDispatch.a(BlockProperties.a, BlockProperties.w).a((T1 boolean_, T2 boolean2) -> Variant.a().a(VariantProperties.c, TextureMapping.a(Blocks.fG, (boolean_ != false ? "_attached" : "") + (boolean2 != false ? "_on" : ""))))).a(BlockModelGenerators.b()));
    }

    private MinecraftKey a(int eggs, String prefix, TextureMapping textures) {
        switch (eggs) {
            case 1: {
                return ModelTemplates.bj.a(ModelLocationUtils.a(prefix + "turtle_egg"), textures, this.c);
            }
            case 2: {
                return ModelTemplates.bk.a(ModelLocationUtils.a("two_" + prefix + "turtle_eggs"), textures, this.c);
            }
            case 3: {
                return ModelTemplates.bl.a(ModelLocationUtils.a("three_" + prefix + "turtle_eggs"), textures, this.c);
            }
            case 4: {
                return ModelTemplates.bm.a(ModelLocationUtils.a("four_" + prefix + "turtle_eggs"), textures, this.c);
            }
        }
        throw new UnsupportedOperationException();
    }

    private MinecraftKey a(Integer eggs, Integer hatch) {
        switch (hatch) {
            case 0: {
                return this.a(eggs, "", TextureMapping.b(TextureMapping.F(Blocks.mc)));
            }
            case 1: {
                return this.a(eggs, "slightly_cracked_", TextureMapping.b(TextureMapping.a(Blocks.mc, "_slightly_cracked")));
            }
            case 2: {
                return this.a(eggs, "very_cracked_", TextureMapping.b(TextureMapping.a(Blocks.mc, "_very_cracked")));
            }
        }
        throw new UnsupportedOperationException();
    }

    private void ap() {
        this.a(Items.jR);
        this.b.accept(MultiVariantGenerator.a(Blocks.mc).a(PropertyDispatch.a(BlockProperties.aD, BlockProperties.aE).b((T1 integer, T2 integer2) -> Arrays.asList(BlockModelGenerators.a(this.a((Integer)integer, (Integer)integer2))))));
    }

    private void C(Block block) {
        this.b(block);
        MinecraftKey resourceLocation = ModelLocationUtils.a(block);
        MultiPartGenerator multiPartGenerator = MultiPartGenerator.a(block);
        Condition.c terminalCondition2 = SystemUtils.a(Condition.a(), (T terminalCondition) -> a.stream().map(Pair::getFirst).forEach(property -> {
            if (block.o().b(property)) {
                terminalCondition.a(property, false);
            }
        }));
        for (Pair<BlockStateBoolean, Function<MinecraftKey, Variant>> pair : a) {
            BlockStateBoolean booleanProperty = (BlockStateBoolean)pair.getFirst();
            Function function = (Function)pair.getSecond();
            if (!block.o().b(booleanProperty)) continue;
            multiPartGenerator.a((Condition)Condition.a().a(booleanProperty, true), (Variant)function.apply(resourceLocation));
            multiPartGenerator.a((Condition)terminalCondition2, (Variant)function.apply(resourceLocation));
        }
        this.b.accept(multiPartGenerator);
    }

    private void aq() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.qC, "_bottom");
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, resourceLocation).a(TextureSlot.f, TextureMapping.a(Blocks.qC, "_top")).a(TextureSlot.i, TextureMapping.a(Blocks.qC, "_side"));
        TextureMapping textureMapping2 = new TextureMapping().a(TextureSlot.e, resourceLocation).a(TextureSlot.f, TextureMapping.a(Blocks.qC, "_top_bloom")).a(TextureSlot.i, TextureMapping.a(Blocks.qC, "_side_bloom"));
        MinecraftKey resourceLocation2 = ModelTemplates.m.a(Blocks.qC, "", textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.m.a(Blocks.qC, "_bloom", textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.qC).a(PropertyDispatch.a(BlockProperties.E).a((T1 boolean_) -> Variant.a().a(VariantProperties.c, boolean_ != false ? resourceLocation3 : resourceLocation2))));
        this.a(Items.fL, resourceLocation2);
    }

    private void ar() {
        Block block = Blocks.cl;
        MinecraftKey resourceLocation = ModelLocationUtils.a(block);
        MultiPartGenerator multiPartGenerator = MultiPartGenerator.a(block);
        Map.of(EnumDirection.c, VariantProperties.a.a, EnumDirection.f, VariantProperties.a.b, EnumDirection.d, VariantProperties.a.c, EnumDirection.e, VariantProperties.a.d).forEach((direction, rotation) -> {
            Condition.c terminalCondition = Condition.a().a(BlockProperties.R, direction);
            multiPartGenerator.a((Condition)terminalCondition, Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, rotation).a(VariantProperties.d, true));
            this.a(multiPartGenerator, terminalCondition, (VariantProperties.a)((Object)rotation));
        });
        this.b.accept(multiPartGenerator);
        this.a(block, ModelLocationUtils.a(block, "_inventory"));
        i.clear();
    }

    private void a(MultiPartGenerator blockStateSupplier, Condition.c facingCondition, VariantProperties.a rotation) {
        Map.of(BlockProperties.bp, ModelTemplates.aK, BlockProperties.bq, ModelTemplates.aL, BlockProperties.br, ModelTemplates.aM, BlockProperties.bs, ModelTemplates.aN, BlockProperties.bt, ModelTemplates.aO, BlockProperties.bu, ModelTemplates.aP).forEach((property, model) -> {
            this.a(blockStateSupplier, facingCondition, rotation, (BlockStateBoolean)property, (ModelTemplate)model, true);
            this.a(blockStateSupplier, facingCondition, rotation, (BlockStateBoolean)property, (ModelTemplate)model, false);
        });
    }

    private void a(MultiPartGenerator blockStateSupplier, Condition.c facingCondition, VariantProperties.a rotation, BlockStateBoolean property, ModelTemplate model, boolean occupied) {
        String string = occupied ? "_occupied" : "_empty";
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.b, TextureMapping.a(Blocks.cl, string));
        d bookSlotModelCacheKey = new d(model, string);
        MinecraftKey resourceLocation = i.computeIfAbsent(bookSlotModelCacheKey, key -> model.a(Blocks.cl, string, textureMapping, this.c));
        blockStateSupplier.a(Condition.a(facingCondition, Condition.a().a(property, occupied)), Variant.a().a(VariantProperties.c, resourceLocation).a(VariantProperties.b, rotation));
    }

    private void as() {
        this.b.accept(BlockModelGenerators.c(Blocks.kG, ModelTemplates.c.a(Blocks.kG, TextureMapping.b(ModelLocationUtils.a("magma")), this.c)));
    }

    private void D(Block shulkerBox) {
        this.c(shulkerBox, TexturedModel.p);
        ModelTemplates.by.a(ModelLocationUtils.a(shulkerBox.k()), TextureMapping.t(shulkerBox), this.c);
    }

    private void b(Block plant, Block plantStem, e tintType) {
        this.b(plant, tintType);
        this.b(plantStem, tintType);
    }

    private void j(Block bed, Block particleSource) {
        ModelTemplates.bz.a(ModelLocationUtils.a(bed.k()), TextureMapping.t(particleSource), this.c);
    }

    private void at() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.b);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.b, "_mirrored");
        this.b.accept(BlockModelGenerators.a(Blocks.eN, resourceLocation, resourceLocation2));
        this.a(Blocks.eN, resourceLocation);
    }

    private void au() {
        MinecraftKey resourceLocation = ModelLocationUtils.a(Blocks.rD);
        MinecraftKey resourceLocation2 = ModelLocationUtils.a(Blocks.rD, "_mirrored");
        this.b.accept(BlockModelGenerators.a(Blocks.rX, resourceLocation, resourceLocation2).a(BlockModelGenerators.g()));
        this.a(Blocks.rX, resourceLocation);
    }

    private void k(Block root, Block pottedRoot) {
        this.a(root, net.minecraft.data.models.BlockModelGenerators$e.b);
        TextureMapping textureMapping = TextureMapping.d(TextureMapping.a(root, "_pot"));
        MinecraftKey resourceLocation = net.minecraft.data.models.BlockModelGenerators$e.b.b().a(pottedRoot, textureMapping, this.c);
        this.b.accept(BlockModelGenerators.c(pottedRoot, resourceLocation));
    }

    private void av() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.ph, "_bottom");
        MinecraftKey resourceLocation2 = TextureMapping.a(Blocks.ph, "_top_off");
        MinecraftKey resourceLocation3 = TextureMapping.a(Blocks.ph, "_top");
        MinecraftKey[] resourceLocations = new MinecraftKey[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            TextureMapping textureMapping = new TextureMapping().a(TextureSlot.e, resourceLocation).a(TextureSlot.f, i2 == 0 ? resourceLocation2 : resourceLocation3).a(TextureSlot.i, TextureMapping.a(Blocks.ph, "_side" + i2));
            resourceLocations[i2] = ModelTemplates.m.a(Blocks.ph, "_" + i2, textureMapping, this.c);
        }
        this.b.accept(MultiVariantGenerator.a(Blocks.ph).a(PropertyDispatch.a(BlockProperties.aZ).a((T1 charges) -> Variant.a().a(VariantProperties.c, resourceLocations[charges]))));
        this.a(Items.vN, resourceLocations[0]);
    }

    private Variant a(BlockPropertyJigsawOrientation orientation, Variant variant) {
        switch (orientation) {
            case b: {
                return variant.a(VariantProperties.a, VariantProperties.a.b);
            }
            case c: {
                return variant.a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.c);
            }
            case d: {
                return variant.a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.d);
            }
            case a: {
                return variant.a(VariantProperties.a, VariantProperties.a.b).a(VariantProperties.b, VariantProperties.a.b);
            }
            case f: {
                return variant.a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.b, VariantProperties.a.c);
            }
            case g: {
                return variant.a(VariantProperties.a, VariantProperties.a.d);
            }
            case h: {
                return variant.a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.b, VariantProperties.a.b);
            }
            case e: {
                return variant.a(VariantProperties.a, VariantProperties.a.d).a(VariantProperties.b, VariantProperties.a.d);
            }
            case k: {
                return variant;
            }
            case l: {
                return variant.a(VariantProperties.b, VariantProperties.a.c);
            }
            case i: {
                return variant.a(VariantProperties.b, VariantProperties.a.d);
            }
            case j: {
                return variant.a(VariantProperties.b, VariantProperties.a.b);
            }
        }
        throw new UnsupportedOperationException("Rotation " + orientation + " can't be expressed with existing x and y values");
    }

    private void aw() {
        MinecraftKey resourceLocation = TextureMapping.a(Blocks.oX, "_top");
        MinecraftKey resourceLocation2 = TextureMapping.a(Blocks.oX, "_bottom");
        MinecraftKey resourceLocation3 = TextureMapping.a(Blocks.oX, "_side");
        MinecraftKey resourceLocation4 = TextureMapping.a(Blocks.oX, "_lock");
        TextureMapping textureMapping = new TextureMapping().a(TextureSlot.o, resourceLocation3).a(TextureSlot.m, resourceLocation3).a(TextureSlot.l, resourceLocation3).a(TextureSlot.c, resourceLocation).a(TextureSlot.j, resourceLocation).a(TextureSlot.k, resourceLocation2).a(TextureSlot.n, resourceLocation4);
        MinecraftKey resourceLocation5 = ModelTemplates.b.a(Blocks.oX, textureMapping, this.c);
        this.b.accept(MultiVariantGenerator.a(Blocks.oX, Variant.a().a(VariantProperties.c, resourceLocation5)).a(PropertyDispatch.a(BlockProperties.T).a((T1 frontAndTop) -> this.a((BlockPropertyJigsawOrientation)frontAndTop, Variant.a()))));
    }

    private void ax() {
        Block block = Blocks.n;
        MinecraftKey resourceLocation = ModelLocationUtils.a(block);
        TexturedModel texturedModel = TexturedModel.a.get(block);
        Block block2 = Blocks.jG;
        MinecraftKey resourceLocation2 = ModelTemplates.Z.a(block2, texturedModel.b(), this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.aa.a(block2, texturedModel.b(), this.c);
        this.b.accept(BlockModelGenerators.e(block2, resourceLocation2, resourceLocation3, resourceLocation));
    }

    public void a() {
        BlockFamilies.a().filter(BlockFamily::c).forEach(family -> this.f(family.a()).a((BlockFamily)family));
        this.f(Blocks.qN).a(BlockFamilies.w).a(new Block[]{Blocks.rd}).a(BlockFamilies.y);
        this.f(Blocks.qM).a(BlockFamilies.A).a(new Block[]{Blocks.rc}).a(BlockFamilies.C);
        this.f(Blocks.qL).a(BlockFamilies.E).a(new Block[]{Blocks.rb}).a(BlockFamilies.G);
        this.f(Blocks.qK).a(BlockFamilies.I).a(new Block[]{Blocks.ra}).a(BlockFamilies.K);
        this.k(Blocks.a);
        this.a(Blocks.mY, Blocks.a);
        this.a(Blocks.mX, Blocks.a);
        this.k(Blocks.fN);
        this.k(Blocks.dP);
        this.a(Blocks.mZ, Blocks.G);
        this.k(Blocks.fz);
        this.k(Blocks.mb);
        this.k(Blocks.fq);
        this.k(Blocks.fQ);
        this.a(Items.tg);
        this.k(Blocks.pc);
        this.k(Blocks.G);
        this.k(Blocks.H);
        this.k(Blocks.hU);
        this.a(Items.fu);
        this.l(Blocks.pI, Blocks.pZ);
        this.l(Blocks.pJ, Blocks.qa);
        this.l(Blocks.pK, Blocks.qb);
        this.l(Blocks.pL, Blocks.qc);
        this.l(Blocks.pM, Blocks.qd);
        this.l(Blocks.pN, Blocks.qe);
        this.l(Blocks.pO, Blocks.qf);
        this.l(Blocks.pP, Blocks.qg);
        this.l(Blocks.pQ, Blocks.qh);
        this.l(Blocks.pR, Blocks.qi);
        this.l(Blocks.pS, Blocks.qj);
        this.l(Blocks.pT, Blocks.qk);
        this.l(Blocks.pU, Blocks.ql);
        this.l(Blocks.pV, Blocks.qm);
        this.l(Blocks.pW, Blocks.qn);
        this.l(Blocks.pX, Blocks.qo);
        this.l(Blocks.pH, Blocks.pY);
        this.k(Blocks.mW);
        this.k(Blocks.gr);
        this.k(Blocks.qy);
        this.k(Blocks.rr);
        this.q(Blocks.rs);
        this.q(Blocks.rt);
        this.r(Blocks.sc);
        this.r(Blocks.sd);
        this.ae();
        this.e(Blocks.rw, Blocks.ru);
        this.n(Blocks.rv);
        this.a(Blocks.hV, Items.hd);
        this.a(Items.hd);
        this.ay();
        this.a(Blocks.kK, Items.iD);
        this.a(Items.iD);
        this.f(Blocks.bP, TextureMapping.a(Blocks.bx, "_side"));
        this.e(Blocks.Q);
        this.e(Blocks.R);
        this.e(Blocks.iA);
        this.e(Blocks.cw);
        this.e(Blocks.cx);
        this.e(Blocks.cy);
        this.e(Blocks.fD);
        this.e(Blocks.fE);
        this.e(Blocks.fI);
        this.e(Blocks.M);
        this.e(Blocks.S);
        this.e(Blocks.N);
        this.e(Blocks.cg);
        this.e(Blocks.O);
        this.e(Blocks.P);
        this.e(Blocks.ch);
        this.c(Blocks.pf, TexturedModel.c);
        this.e(Blocks.pe);
        this.e(Blocks.aQ);
        this.e(Blocks.aR);
        this.e(Blocks.aS);
        this.e(Blocks.ha);
        this.e(Blocks.dH);
        this.e(Blocks.dI);
        this.e(Blocks.gZ);
        this.e(Blocks.py);
        this.e(Blocks.mS);
        this.e(Blocks.dQ);
        this.e(Blocks.k);
        this.e(Blocks.pg);
        this.e(Blocks.fy);
        this.e(Blocks.ec);
        this.e(Blocks.L);
        this.e(Blocks.pd);
        this.e(Blocks.dN);
        this.c(Blocks.dS, TexturedModel.f);
        this.c(Blocks.pm, TexturedModel.c);
        this.c(Blocks.eZ, TexturedModel.c);
        this.k(Blocks.ab);
        this.k(Blocks.fZ);
        this.e(Blocks.kH);
        this.e(Blocks.aX);
        this.e(Blocks.iB);
        this.e(Blocks.cn);
        this.e(Blocks.pG);
        this.e(Blocks.ih);
        this.e(Blocks.ou);
        this.e(Blocks.dW);
        this.e(Blocks.dX);
        this.e(Blocks.cs);
        this.e(Blocks.aN);
        this.c(Blocks.bv, TexturedModel.u);
        this.a(Items.cv);
        this.c(Blocks.cj, TexturedModel.e);
        this.c(Blocks.oZ, TexturedModel.c);
        this.e(Blocks.ol);
        this.e(Blocks.aO);
        this.e(Blocks.qp);
        this.e(Blocks.qq);
        this.e(Blocks.qw);
        this.e(Blocks.qv);
        this.e(Blocks.ro);
        this.e(Blocks.rZ);
        this.e(Blocks.sa);
        this.e(Blocks.sb);
        this.c(Blocks.qA);
        this.ax();
        this.e(Blocks.qI);
        this.e(Blocks.qJ);
        this.e(Blocks.qH);
        this.e(Blocks.qG);
        this.e(Blocks.qF);
        this.e(Blocks.qE);
        this.h(Blocks.qH, Blocks.qW);
        this.h(Blocks.qG, Blocks.qY);
        this.h(Blocks.qF, Blocks.qX);
        this.h(Blocks.qE, Blocks.qZ);
        this.g(Blocks.gV, Blocks.cg);
        this.g(Blocks.gW, Blocks.ch);
        this.E();
        this.q();
        this.ar();
        this.u();
        this.v();
        this.a(new Block[]{Blocks.oc, Blocks.od});
        this.w();
        this.z();
        this.A();
        this.C();
        this.D();
        this.G();
        this.B();
        this.w(Blocks.ks);
        this.H();
        this.I();
        this.J();
        this.K();
        this.N();
        this.O();
        this.P();
        this.Q();
        this.p();
        this.R();
        this.S();
        this.T();
        this.U();
        this.W();
        this.X();
        this.Y();
        this.Z();
        this.aa();
        this.ad();
        this.ag();
        this.af();
        this.ah();
        this.ai();
        this.x();
        this.aj();
        this.ak();
        this.al();
        this.am();
        this.an();
        this.ao();
        this.ap();
        this.C(Blocks.fe);
        this.C(Blocks.ff);
        this.C(Blocks.qB);
        this.as();
        this.aw();
        this.ab();
        this.ac();
        this.V();
        this.M();
        this.L();
        this.B(Blocks.cN);
        this.b(Blocks.cN);
        this.B(Blocks.nW);
        this.h();
        this.B(Blocks.ry);
        this.i(Blocks.co, Blocks.cp);
        this.i(Blocks.ea, Blocks.eb);
        this.a(Blocks.cz, Blocks.n, TextureMapping::c);
        this.a(Blocks.nU, Blocks.p, TextureMapping::d);
        this.v(Blocks.os);
        this.v(Blocks.oj);
        this.t(Blocks.aT);
        this.t(Blocks.hh);
        this.A(Blocks.oa);
        this.A(Blocks.ob);
        this.e(Blocks.eX, ModelLocationUtils.a(Blocks.eX));
        this.a(Blocks.dY, TexturedModel.c);
        this.a(Blocks.dZ, TexturedModel.c);
        this.e(Blocks.rY);
        this.a(Blocks.kJ, TexturedModel.c);
        this.d(Blocks.j);
        this.d(Blocks.rB);
        this.d(Blocks.I);
        this.f();
        this.d(Blocks.K);
        this.c(Blocks.F);
        this.c(Blocks.si, TexturedModel.e);
        this.a(Blocks.ii, TexturedModel.c, TexturedModel.d);
        this.a(Blocks.kw, TexturedModel.v, TexturedModel.w);
        this.a(Blocks.he, TexturedModel.v, TexturedModel.w);
        this.a(Blocks.se, TexturedModel.c, TexturedModel.d);
        this.a(Blocks.sf, TexturedModel.c, TexturedModel.d);
        this.a(Blocks.sg, TexturedModel.c, TexturedModel.d);
        this.b(Blocks.nP, TexturedModel.h);
        this.y();
        this.a(Blocks.pa, TextureMapping::z);
        this.a(Blocks.pb, TextureMapping::B);
        this.a(Blocks.kA, BlockProperties.as, 0, 1, 2, 3);
        this.a(Blocks.gs, BlockProperties.av, 0, 0, 1, 1, 2, 2, 2, 3);
        this.a(Blocks.fp, BlockProperties.as, 0, 1, 1, 2);
        this.a(Blocks.gt, BlockProperties.av, 0, 0, 1, 1, 2, 2, 2, 3);
        this.a(Blocks.cA, BlockProperties.av, 0, 1, 2, 3, 4, 5, 6, 7);
        this.a(Blocks.kz, net.minecraft.data.models.BlockModelGenerators$e.b, BlockProperties.ar, 0, 1, 2);
        this.a(ModelLocationUtils.a("decorated_pot"), Blocks.iz).b(Blocks.sj);
        this.a(ModelLocationUtils.a("banner"), Blocks.n).a(ModelTemplates.bA, Blocks.iI, Blocks.iJ, Blocks.iK, Blocks.iL, Blocks.iM, Blocks.iN, Blocks.iO, Blocks.iP, Blocks.iQ, Blocks.iR, Blocks.iS, Blocks.iT, Blocks.iU, Blocks.iV, Blocks.iW, Blocks.iX).b(Blocks.iY, Blocks.iZ, Blocks.ja, Blocks.jb, Blocks.jc, Blocks.jd, Blocks.je, Blocks.jf, Blocks.jg, Blocks.jh, Blocks.ji, Blocks.jj, Blocks.jk, Blocks.jl, Blocks.jm, Blocks.jn);
        this.a(ModelLocationUtils.a("bed"), Blocks.n).b(Blocks.aY, Blocks.aZ, Blocks.ba, Blocks.bb, Blocks.bc, Blocks.bd, Blocks.be, Blocks.bf, Blocks.bg, Blocks.bh, Blocks.bi, Blocks.bj, Blocks.bk, Blocks.bl, Blocks.bm, Blocks.bn);
        this.j(Blocks.aY, Blocks.bz);
        this.j(Blocks.aZ, Blocks.bA);
        this.j(Blocks.ba, Blocks.bB);
        this.j(Blocks.bb, Blocks.bC);
        this.j(Blocks.bc, Blocks.bD);
        this.j(Blocks.bd, Blocks.bE);
        this.j(Blocks.be, Blocks.bF);
        this.j(Blocks.bf, Blocks.bG);
        this.j(Blocks.bg, Blocks.bH);
        this.j(Blocks.bh, Blocks.bI);
        this.j(Blocks.bi, Blocks.bJ);
        this.j(Blocks.bj, Blocks.bK);
        this.j(Blocks.bk, Blocks.bL);
        this.j(Blocks.bl, Blocks.bM);
        this.j(Blocks.bm, Blocks.bN);
        this.j(Blocks.bn, Blocks.bO);
        this.a(ModelLocationUtils.a("skull"), Blocks.dW).a(ModelTemplates.bB, Blocks.gL, Blocks.gJ, Blocks.gH, Blocks.gD, Blocks.gF, Blocks.gP).a(Blocks.gN).b(Blocks.gM, Blocks.gO, Blocks.gK, Blocks.gI, Blocks.gE, Blocks.gG, Blocks.gQ);
        this.D(Blocks.kM);
        this.D(Blocks.kN);
        this.D(Blocks.kO);
        this.D(Blocks.kP);
        this.D(Blocks.kQ);
        this.D(Blocks.kR);
        this.D(Blocks.kS);
        this.D(Blocks.kT);
        this.D(Blocks.kU);
        this.D(Blocks.kV);
        this.D(Blocks.kW);
        this.D(Blocks.kX);
        this.D(Blocks.kY);
        this.D(Blocks.kZ);
        this.D(Blocks.la);
        this.D(Blocks.lb);
        this.D(Blocks.lc);
        this.c(Blocks.mT, TexturedModel.p);
        this.a(Blocks.mT);
        this.a(ModelLocationUtils.a("chest"), Blocks.n).b(Blocks.cu, Blocks.gU);
        this.a(ModelLocationUtils.a("ender_chest"), Blocks.cn).b(Blocks.fF);
        this.d(Blocks.fw, Blocks.cn).a(Blocks.fw, Blocks.kC);
        this.e(Blocks.aL);
        this.e(Blocks.aM);
        this.e(Blocks.lt);
        this.e(Blocks.lu);
        this.e(Blocks.lv);
        this.e(Blocks.lw);
        this.e(Blocks.lx);
        this.e(Blocks.ly);
        this.e(Blocks.lz);
        this.e(Blocks.lA);
        this.e(Blocks.lB);
        this.e(Blocks.lC);
        this.e(Blocks.lD);
        this.e(Blocks.lE);
        this.e(Blocks.lF);
        this.e(Blocks.lG);
        this.e(Blocks.lH);
        this.e(Blocks.lI);
        this.a(TexturedModel.a, Blocks.lJ, Blocks.lK, Blocks.lL, Blocks.lM, Blocks.lN, Blocks.lO, Blocks.lP, Blocks.lQ, Blocks.lR, Blocks.lS, Blocks.lT, Blocks.lU, Blocks.lV, Blocks.lW, Blocks.lX, Blocks.lY);
        this.e(Blocks.iz);
        this.e(Blocks.hi);
        this.e(Blocks.hj);
        this.e(Blocks.hk);
        this.e(Blocks.hl);
        this.e(Blocks.hm);
        this.e(Blocks.hn);
        this.e(Blocks.ho);
        this.e(Blocks.hp);
        this.e(Blocks.hq);
        this.e(Blocks.hr);
        this.e(Blocks.hs);
        this.e(Blocks.ht);
        this.e(Blocks.hu);
        this.e(Blocks.hv);
        this.e(Blocks.hw);
        this.e(Blocks.hx);
        this.e(Blocks.qx);
        this.f(Blocks.aP, Blocks.eY);
        this.f(Blocks.ei, Blocks.hy);
        this.f(Blocks.ej, Blocks.hz);
        this.f(Blocks.ek, Blocks.hA);
        this.f(Blocks.el, Blocks.hB);
        this.f(Blocks.em, Blocks.hC);
        this.f(Blocks.en, Blocks.hD);
        this.f(Blocks.eo, Blocks.hE);
        this.f(Blocks.ep, Blocks.hF);
        this.f(Blocks.eq, Blocks.hG);
        this.f(Blocks.er, Blocks.hH);
        this.f(Blocks.es, Blocks.hI);
        this.f(Blocks.et, Blocks.hJ);
        this.f(Blocks.eu, Blocks.hK);
        this.f(Blocks.ev, Blocks.hL);
        this.f(Blocks.ew, Blocks.hM);
        this.f(Blocks.ex, Blocks.hN);
        this.b(TexturedModel.n, Blocks.ld, Blocks.le, Blocks.lf, Blocks.lg, Blocks.lh, Blocks.li, Blocks.lj, Blocks.lk, Blocks.ll, Blocks.lm, Blocks.ln, Blocks.lo, Blocks.lp, Blocks.lq, Blocks.lr, Blocks.ls);
        this.e(Blocks.bz, Blocks.ij);
        this.e(Blocks.bA, Blocks.ik);
        this.e(Blocks.bB, Blocks.il);
        this.e(Blocks.bC, Blocks.im);
        this.e(Blocks.bD, Blocks.in);
        this.e(Blocks.bE, Blocks.io);
        this.e(Blocks.bF, Blocks.ip);
        this.e(Blocks.bG, Blocks.iq);
        this.e(Blocks.bH, Blocks.ir);
        this.e(Blocks.bI, Blocks.is);
        this.e(Blocks.bJ, Blocks.it);
        this.e(Blocks.bK, Blocks.iu);
        this.e(Blocks.bL, Blocks.iv);
        this.e(Blocks.bM, Blocks.iw);
        this.e(Blocks.bN, Blocks.ix);
        this.e(Blocks.bO, Blocks.iy);
        this.e(Blocks.rC);
        this.e(Blocks.eL);
        this.a(Blocks.bt, Blocks.ga, net.minecraft.data.models.BlockModelGenerators$e.a);
        this.a(Blocks.bQ, Blocks.gb, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bS, Blocks.gc, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bT, Blocks.gd, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bU, Blocks.ge, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bV, Blocks.gf, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bW, Blocks.gg, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bX, Blocks.gh, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bY, Blocks.gi, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bZ, Blocks.gj, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.ca, Blocks.gk, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.cb, Blocks.gl, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.cd, Blocks.gm, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.cc, Blocks.gn, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.cf, Blocks.go, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.ce, Blocks.gp, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bu, Blocks.gq, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.bR, Blocks.fR, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.F();
        this.s(Blocks.eT);
        this.s(Blocks.eU);
        this.s(Blocks.eV);
        this.a(Blocks.bs, net.minecraft.data.models.BlockModelGenerators$e.a);
        this.b(Blocks.dR, net.minecraft.data.models.BlockModelGenerators$e.a);
        this.a(Items.dl);
        this.b(Blocks.lZ, Blocks.ma, net.minecraft.data.models.BlockModelGenerators$e.a);
        this.a(Items.dm);
        this.a(Blocks.ma);
        this.b(Blocks.rA, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.rA);
        this.a(Blocks.rq);
        this.b(Blocks.ov, Blocks.ow, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.b(Blocks.ox, Blocks.oy, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Blocks.ov, "_plant");
        this.a(Blocks.ow);
        this.a(Blocks.ox, "_plant");
        this.a(Blocks.oy);
        this.a(Blocks.mU, net.minecraft.data.models.BlockModelGenerators$e.a, TextureMapping.c(TextureMapping.a(Blocks.mV, "_stage0")));
        this.l();
        this.a(Blocks.br, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.iD, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.iE, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.iF, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.iG, net.minecraft.data.models.BlockModelGenerators$e.a);
        this.c(Blocks.iH, net.minecraft.data.models.BlockModelGenerators$e.a);
        this.i();
        this.j();
        this.k();
        this.a(Blocks.ms, Blocks.mn, Blocks.mi, Blocks.md, Blocks.mC, Blocks.mx, Blocks.mM, Blocks.mH);
        this.a(Blocks.mt, Blocks.mo, Blocks.mj, Blocks.me, Blocks.mD, Blocks.my, Blocks.mN, Blocks.mI);
        this.a(Blocks.mu, Blocks.mp, Blocks.mk, Blocks.mf, Blocks.mE, Blocks.mz, Blocks.mO, Blocks.mJ);
        this.a(Blocks.mv, Blocks.mq, Blocks.ml, Blocks.mg, Blocks.mF, Blocks.mA, Blocks.mP, Blocks.mK);
        this.a(Blocks.mw, Blocks.mr, Blocks.mm, Blocks.mh, Blocks.mG, Blocks.mB, Blocks.mQ, Blocks.mL);
        this.c(Blocks.fd, Blocks.fb);
        this.c(Blocks.fc, Blocks.fa);
        this.j(Blocks.aa).c(Blocks.aa).a(Blocks.au);
        this.j(Blocks.al).c(Blocks.al).a(Blocks.aC);
        this.a(Blocks.al, Blocks.di, Blocks.dr);
        this.c(Blocks.aK, TexturedModel.r);
        this.j(Blocks.X).c(Blocks.X).a(Blocks.ar);
        this.j(Blocks.ah).c(Blocks.ah).a(Blocks.az);
        this.a(Blocks.ah, Blocks.dc, Blocks.dn);
        this.a(Blocks.B, Blocks.fW, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.aH, TexturedModel.r);
        this.j(Blocks.Y).d(Blocks.Y).a(Blocks.as);
        this.j(Blocks.ai).d(Blocks.ai).a(Blocks.aA);
        this.a(Blocks.ai, Blocks.dd, Blocks.do);
        this.a(Blocks.C, Blocks.fX, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.aI, TexturedModel.r);
        this.j(Blocks.V).c(Blocks.V).a(Blocks.ap);
        this.j(Blocks.af).c(Blocks.af).a(Blocks.ax);
        this.a(Blocks.af, Blocks.db, Blocks.dm);
        this.a(Blocks.z, Blocks.fU, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.aF, TexturedModel.r);
        this.j(Blocks.T).c(Blocks.T).a(Blocks.an);
        this.j(Blocks.ak).c(Blocks.ak).a(Blocks.av);
        this.a(Blocks.ak, Blocks.cZ, Blocks.dk);
        this.a(Blocks.x, Blocks.fS, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.aD, TexturedModel.r);
        this.j(Blocks.U).c(Blocks.U).a(Blocks.ao);
        this.j(Blocks.ae).c(Blocks.ae).a(Blocks.aw);
        this.a(Blocks.ae, Blocks.da, Blocks.dl);
        this.a(Blocks.y, Blocks.fT, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.aE, TexturedModel.r);
        this.j(Blocks.Z).c(Blocks.Z).a(Blocks.at);
        this.j(Blocks.aj).c(Blocks.aj).a(Blocks.aB);
        this.a(Blocks.aj, Blocks.df, Blocks.dq);
        this.a(Blocks.D, Blocks.fY, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.aJ, TexturedModel.r);
        this.j(Blocks.W).c(Blocks.W).a(Blocks.aq);
        this.j(Blocks.ag).c(Blocks.ag).a(Blocks.ay);
        this.a(Blocks.ag, Blocks.de, Blocks.dp);
        this.a(Blocks.A, Blocks.fV, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.c(Blocks.aG, TexturedModel.r);
        this.j(Blocks.oo).b(Blocks.oo).a(Blocks.oq);
        this.j(Blocks.op).b(Blocks.op).a(Blocks.or);
        this.a(Blocks.op, Blocks.dg, Blocks.ds);
        this.a(Blocks.ot, Blocks.pi, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.k(Blocks.oz, Blocks.pk);
        this.j(Blocks.of).b(Blocks.of).a(Blocks.oh);
        this.j(Blocks.og).b(Blocks.og).a(Blocks.oi);
        this.a(Blocks.og, Blocks.dh, Blocks.dt);
        this.a(Blocks.ok, Blocks.pj, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.k(Blocks.om, Blocks.pl);
        this.j(Blocks.ad).d(Blocks.ad);
        this.j(Blocks.am).d(Blocks.am);
        this.a(Blocks.v, Blocks.dj, Blocks.du);
        this.b(Blocks.on, net.minecraft.data.models.BlockModelGenerators$e.b);
        this.a(Items.di);
        this.g(Blocks.dx);
        this.i(Blocks.hX);
        this.t();
        this.l(Blocks.cO);
        this.m(Blocks.bo);
        this.m(Blocks.bp);
        this.m(Blocks.hg);
        this.s();
        this.o(Blocks.fM);
        this.o(Blocks.kD);
        this.o(Blocks.kE);
        this.p(Blocks.gR);
        this.p(Blocks.gS);
        this.p(Blocks.gT);
        this.n();
        this.o();
        this.d(Blocks.cC, TexturedModel.g);
        this.d(Blocks.nS, TexturedModel.g);
        this.d(Blocks.nR, TexturedModel.h);
        this.r();
        this.av();
        this.aq();
        this.h(Blocks.eK, Blocks.eS);
        this.h(Blocks.m, Blocks.eO);
        this.h(Blocks.eJ, Blocks.eR);
        this.h(Blocks.eI, Blocks.eQ);
        this.at();
        this.h(Blocks.eH, Blocks.eP);
        this.au();
        ItemMonsterEgg.h().forEach(item -> this.a((Item)item, ModelLocationUtils.b("template_spawn_egg")));
    }

    private void ay() {
        this.a(Blocks.hW);
        PropertyDispatch.a<Integer> c1 = PropertyDispatch.a(BlockProperties.aP);
        for (int i2 = 0; i2 < 16; ++i2) {
            String string = String.format(Locale.ROOT, "_%02d", i2);
            MinecraftKey resourceLocation = TextureMapping.a(Items.he, string);
            c1.a((Integer)i2, Variant.a().a(VariantProperties.c, ModelTemplates.Y.a(Blocks.hW, string, TextureMapping.h(resourceLocation), this.c)));
            ModelTemplates.bt.a(ModelLocationUtils.a(Items.he, string), TextureMapping.k(resourceLocation), this.c);
        }
        this.b.accept(MultiVariantGenerator.a(Blocks.hW).a(c1));
    }

    private void l(Block candle, Block cake) {
        this.a(candle.k());
        TextureMapping textureMapping = TextureMapping.b(TextureMapping.F(candle));
        TextureMapping textureMapping2 = TextureMapping.b(TextureMapping.a(candle, "_lit"));
        MinecraftKey resourceLocation = ModelTemplates.bC.a(candle, "_one_candle", textureMapping, this.c);
        MinecraftKey resourceLocation2 = ModelTemplates.bD.a(candle, "_two_candles", textureMapping, this.c);
        MinecraftKey resourceLocation3 = ModelTemplates.bE.a(candle, "_three_candles", textureMapping, this.c);
        MinecraftKey resourceLocation4 = ModelTemplates.bF.a(candle, "_four_candles", textureMapping, this.c);
        MinecraftKey resourceLocation5 = ModelTemplates.bC.a(candle, "_one_candle_lit", textureMapping2, this.c);
        MinecraftKey resourceLocation6 = ModelTemplates.bD.a(candle, "_two_candles_lit", textureMapping2, this.c);
        MinecraftKey resourceLocation7 = ModelTemplates.bE.a(candle, "_three_candles_lit", textureMapping2, this.c);
        MinecraftKey resourceLocation8 = ModelTemplates.bF.a(candle, "_four_candles_lit", textureMapping2, this.c);
        this.b.accept(MultiVariantGenerator.a(candle).a(PropertyDispatch.a(BlockProperties.az, BlockProperties.r).a((Integer)1, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation)).a((Integer)2, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation2)).a((Integer)3, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation3)).a((Integer)4, (Boolean)false, Variant.a().a(VariantProperties.c, resourceLocation4)).a((Integer)1, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation5)).a((Integer)2, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation6)).a((Integer)3, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation7)).a((Integer)4, (Boolean)true, Variant.a().a(VariantProperties.c, resourceLocation8))));
        MinecraftKey resourceLocation9 = ModelTemplates.bG.a(cake, TextureMapping.a(candle, false), this.c);
        MinecraftKey resourceLocation10 = ModelTemplates.bG.a(cake, "_lit", TextureMapping.a(candle, true), this.c);
        this.b.accept(MultiVariantGenerator.a(cake).a(BlockModelGenerators.a(BlockProperties.r, resourceLocation10, resourceLocation9)));
    }

    private /* synthetic */ Variant a(int[] age, Int2ObjectMap int2ObjectMap, Block block, Integer integer) {
        int i2 = age[integer];
        MinecraftKey resourceLocation = (MinecraftKey)int2ObjectMap.computeIfAbsent(i2, j2 -> this.a(block, "_stage" + i2, ModelTemplates.aT, TextureMapping::g));
        return Variant.a().a(VariantProperties.c, resourceLocation);
    }

    @FunctionalInterface
    static interface c {
        public BlockStateGenerator create(Block var1, MinecraftKey var2, TextureMapping var3, BiConsumer<MinecraftKey, Supplier<JsonElement>> var4);
    }

    class b {
        private final TextureMapping b;
        private final Map<ModelTemplate, MinecraftKey> c = Maps.newHashMap();
        @Nullable
        private BlockFamily d;
        @Nullable
        private MinecraftKey e;

        public b(TextureMapping textures) {
            this.b = textures;
        }

        public b a(Block block, ModelTemplate model) {
            this.e = model.a(block, this.b, BlockModelGenerators.this.c);
            if (BlockModelGenerators.this.f.containsKey(block)) {
                BlockModelGenerators.this.b.accept(BlockModelGenerators.this.f.get(block).create(block, this.e, this.b, BlockModelGenerators.this.c));
            } else {
                BlockModelGenerators.this.b.accept(BlockModelGenerators.c(block, this.e));
            }
            return this;
        }

        public b a(Block ... blocks) {
            if (this.e == null) {
                throw new IllegalStateException("Full block not generated yet");
            }
            for (Block block : blocks) {
                BlockModelGenerators.this.b.accept(BlockModelGenerators.c(block, this.e));
                BlockModelGenerators.this.a(block, this.e);
            }
            return this;
        }

        public b a(Block buttonBlock) {
            MinecraftKey resourceLocation = ModelTemplates.q.a(buttonBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.r.a(buttonBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.b(buttonBlock, resourceLocation, resourceLocation2));
            MinecraftKey resourceLocation3 = ModelTemplates.s.a(buttonBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.a(buttonBlock, resourceLocation3);
            return this;
        }

        public b b(Block wallBlock) {
            MinecraftKey resourceLocation = ModelTemplates.K.a(wallBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.L.a(wallBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation3 = ModelTemplates.M.a(wallBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.a(wallBlock, resourceLocation, resourceLocation2, resourceLocation3));
            MinecraftKey resourceLocation4 = ModelTemplates.N.a(wallBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.a(wallBlock, resourceLocation4);
            return this;
        }

        public b c(Block customFenceBlock) {
            TextureMapping textureMapping = TextureMapping.o(customFenceBlock);
            MinecraftKey resourceLocation = ModelTemplates.B.a(customFenceBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.C.a(customFenceBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation3 = ModelTemplates.D.a(customFenceBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation4 = ModelTemplates.E.a(customFenceBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation5 = ModelTemplates.F.a(customFenceBlock, textureMapping, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.a(customFenceBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4, resourceLocation5));
            MinecraftKey resourceLocation6 = ModelTemplates.G.a(customFenceBlock, textureMapping, BlockModelGenerators.this.c);
            BlockModelGenerators.this.a(customFenceBlock, resourceLocation6);
            return this;
        }

        public b d(Block fenceBlock) {
            MinecraftKey resourceLocation = ModelTemplates.H.a(fenceBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.I.a(fenceBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.c(fenceBlock, resourceLocation, resourceLocation2));
            MinecraftKey resourceLocation3 = ModelTemplates.J.a(fenceBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.a(fenceBlock, resourceLocation3);
            return this;
        }

        public b e(Block customFenceGateBlock) {
            TextureMapping textureMapping = TextureMapping.o(customFenceGateBlock);
            MinecraftKey resourceLocation = ModelTemplates.P.a(customFenceGateBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.O.a(customFenceGateBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation3 = ModelTemplates.R.a(customFenceGateBlock, textureMapping, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation4 = ModelTemplates.Q.a(customFenceGateBlock, textureMapping, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.a(customFenceGateBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4, false));
            return this;
        }

        public b f(Block fenceGateBlock) {
            MinecraftKey resourceLocation = ModelTemplates.T.a(fenceGateBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.S.a(fenceGateBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation3 = ModelTemplates.V.a(fenceGateBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation4 = ModelTemplates.U.a(fenceGateBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.a(fenceGateBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4, true));
            return this;
        }

        public b g(Block pressurePlateBlock) {
            MinecraftKey resourceLocation = ModelTemplates.W.a(pressurePlateBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.X.a(pressurePlateBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.e(pressurePlateBlock, resourceLocation, resourceLocation2));
            return this;
        }

        public b h(Block signBlock) {
            if (this.d == null) {
                throw new IllegalStateException("Family not defined");
            }
            Block block = this.d.b().get((Object)BlockFamily.b.r);
            MinecraftKey resourceLocation = ModelTemplates.Y.a(signBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.c(signBlock, resourceLocation));
            BlockModelGenerators.this.b.accept(BlockModelGenerators.c(block, resourceLocation));
            BlockModelGenerators.this.a(signBlock.k());
            BlockModelGenerators.this.a(block);
            return this;
        }

        public b i(Block block) {
            if (this.e == null) {
                throw new IllegalStateException("Full block not generated yet");
            }
            MinecraftKey resourceLocation = this.a(ModelTemplates.Z, block);
            MinecraftKey resourceLocation2 = this.a(ModelTemplates.aa, block);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.e(block, resourceLocation, resourceLocation2, this.e));
            BlockModelGenerators.this.a(block, resourceLocation);
            return this;
        }

        public b j(Block block) {
            MinecraftKey resourceLocation = this.a(ModelTemplates.ad, block);
            MinecraftKey resourceLocation2 = this.a(ModelTemplates.ac, block);
            MinecraftKey resourceLocation3 = this.a(ModelTemplates.ae, block);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.b(block, resourceLocation, resourceLocation2, resourceLocation3));
            BlockModelGenerators.this.a(block, resourceLocation2);
            return this;
        }

        private b k(Block block) {
            TexturedModel texturedModel = BlockModelGenerators.this.g.getOrDefault(block, TexturedModel.a.get(block));
            BlockModelGenerators.this.b.accept(BlockModelGenerators.c(block, texturedModel.a(block, BlockModelGenerators.this.c)));
            return this;
        }

        private b l(Block block) {
            BlockModelGenerators.this.g(block);
            return this;
        }

        private void m(Block block) {
            if (BlockModelGenerators.this.e.contains(block)) {
                BlockModelGenerators.this.i(block);
            } else {
                BlockModelGenerators.this.h(block);
            }
        }

        private MinecraftKey a(ModelTemplate model, Block block) {
            return this.c.computeIfAbsent(model, newModel -> newModel.a(block, this.b, BlockModelGenerators.this.c));
        }

        public b a(BlockFamily family) {
            this.d = family;
            family.b().forEach((variant, block) -> {
                BiConsumer<b, Block> biConsumer = h.get(variant);
                if (biConsumer != null) {
                    biConsumer.accept(this, (Block)block);
                }
            });
            return this;
        }
    }

    class f {
        private final TextureMapping b;

        public f(TextureMapping textures) {
            this.b = textures;
        }

        public f a(Block woodBlock) {
            TextureMapping textureMapping = this.b.c(TextureSlot.d, this.b.a(TextureSlot.i));
            MinecraftKey resourceLocation = ModelTemplates.i.a(woodBlock, textureMapping, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.d(woodBlock, resourceLocation));
            return this;
        }

        public f b(Block stemBlock) {
            MinecraftKey resourceLocation = ModelTemplates.i.a(stemBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.d(stemBlock, resourceLocation));
            return this;
        }

        public f c(Block logBlock) {
            MinecraftKey resourceLocation = ModelTemplates.i.a(logBlock, this.b, BlockModelGenerators.this.c);
            MinecraftKey resourceLocation2 = ModelTemplates.j.a(logBlock, this.b, BlockModelGenerators.this.c);
            BlockModelGenerators.this.b.accept(BlockModelGenerators.d(logBlock, resourceLocation, resourceLocation2));
            return this;
        }

        public f d(Block bambooBlock) {
            BlockModelGenerators.this.b.accept(BlockModelGenerators.a(bambooBlock, this.b, BlockModelGenerators.this.c));
            return this;
        }
    }

    static final class e
    extends Enum<e> {
        public static final /* enum */ e a = new e();
        public static final /* enum */ e b = new e();
        private static final /* synthetic */ e[] c;

        public static e[] values() {
            return (e[])c.clone();
        }

        public static e valueOf(String string) {
            return Enum.valueOf(e.class, string);
        }

        public ModelTemplate a() {
            return this == a ? ModelTemplates.an : ModelTemplates.am;
        }

        public ModelTemplate b() {
            return this == a ? ModelTemplates.ap : ModelTemplates.ao;
        }

        private static /* synthetic */ e[] c() {
            return new e[]{a, b};
        }

        static {
            c = net.minecraft.data.models.BlockModelGenerators$e.c();
        }
    }

    class a {
        private final MinecraftKey b;

        public a(MinecraftKey modelId, Block block) {
            this.b = ModelTemplates.Y.a(modelId, TextureMapping.t(block), BlockModelGenerators.this.c);
        }

        public a a(Block ... blocks) {
            for (Block block : blocks) {
                BlockModelGenerators.this.b.accept(BlockModelGenerators.c(block, this.b));
            }
            return this;
        }

        public a b(Block ... blocks) {
            for (Block block : blocks) {
                BlockModelGenerators.this.a(block);
            }
            return this.a(blocks);
        }

        public a a(ModelTemplate model, Block ... blocks) {
            for (Block block : blocks) {
                model.a(ModelLocationUtils.a(block.k()), TextureMapping.t(block), BlockModelGenerators.this.c);
            }
            return this.a(blocks);
        }
    }

    record d(ModelTemplate a, String b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "template;modelSuffix", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "template;modelSuffix", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "template;modelSuffix", "a", "b"}, this, object);
        }
    }
}

