/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.EnumArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.Items;

public class ItemModelGenerators {
    public static final MinecraftKey a = new MinecraftKey("trim_type");
    private static final List<a> b = List.of(new a("quartz", 0.1f, Map.of()), new a("iron", 0.2f, Map.of(EnumArmorMaterial.c, "iron_darker")), new a("netherite", 0.3f, Map.of(EnumArmorMaterial.g, "netherite_darker")), new a("redstone", 0.4f, Map.of()), new a("copper", 0.5f, Map.of()), new a("gold", 0.6f, Map.of(EnumArmorMaterial.d, "gold_darker")), new a("emerald", 0.7f, Map.of()), new a("diamond", 0.8f, Map.of(EnumArmorMaterial.e, "diamond_darker")), new a("lapis", 0.9f, Map.of()), new a("amethyst", 1.0f, Map.of()));
    private final BiConsumer<MinecraftKey, Supplier<JsonElement>> c;

    public ItemModelGenerators(BiConsumer<MinecraftKey, Supplier<JsonElement>> writer) {
        this.c = writer;
    }

    private void a(Item item, ModelTemplate model) {
        model.a(ModelLocationUtils.a(item), TextureMapping.b(item), this.c);
    }

    private void a(Item item, String suffix, ModelTemplate model) {
        model.a(ModelLocationUtils.a(item, suffix), TextureMapping.k(TextureMapping.a(item, suffix)), this.c);
    }

    private void a(Item item, Item texture, ModelTemplate model) {
        model.a(ModelLocationUtils.a(item), TextureMapping.b(texture), this.c);
    }

    private void a(Item compass) {
        for (int i2 = 0; i2 < 32; ++i2) {
            if (i2 == 16) continue;
            this.a(compass, String.format(Locale.ROOT, "_%02d", i2), ModelTemplates.bt);
        }
    }

    private void b(Item clock) {
        for (int i2 = 1; i2 < 64; ++i2) {
            this.a(clock, String.format(Locale.ROOT, "_%02d", i2), ModelTemplates.bt);
        }
    }

    private void a(MinecraftKey id, MinecraftKey layer0, MinecraftKey layer1) {
        ModelTemplates.bw.a(id, TextureMapping.c(layer0, layer1), this.c);
    }

    private void a(MinecraftKey id, MinecraftKey layer0, MinecraftKey layer1, MinecraftKey layer2) {
        ModelTemplates.bx.a(id, TextureMapping.a(layer0, layer1, layer2), this.c);
    }

    private MinecraftKey a(MinecraftKey id, String trimMaterialName) {
        return id.e("_" + trimMaterialName + "_trim");
    }

    private JsonObject a(MinecraftKey id, Map<TextureSlot, MinecraftKey> textures, ArmorMaterial armorMaterial) {
        JsonObject jsonObject = ModelTemplates.bw.a(id, textures);
        JsonArray jsonArray = new JsonArray();
        for (a trimModelData : b) {
            JsonObject jsonObject2 = new JsonObject();
            JsonObject jsonObject3 = new JsonObject();
            jsonObject3.addProperty(a.a(), (Number)Float.valueOf(trimModelData.b()));
            jsonObject2.add("predicate", (JsonElement)jsonObject3);
            jsonObject2.addProperty("model", this.a(id, trimModelData.a(armorMaterial)).toString());
            jsonArray.add((JsonElement)jsonObject2);
        }
        jsonObject.add("overrides", (JsonElement)jsonArray);
        return jsonObject;
    }

    private void a(ItemArmor armor) {
        MinecraftKey resourceLocation = ModelLocationUtils.a(armor);
        MinecraftKey resourceLocation2 = TextureMapping.c(armor);
        MinecraftKey resourceLocation3 = TextureMapping.a(armor, "_overlay");
        if (armor.d() == EnumArmorMaterial.a) {
            ModelTemplates.bw.a(resourceLocation, TextureMapping.c(resourceLocation2, resourceLocation3), this.c, (MinecraftKey id, Map<TextureSlot, MinecraftKey> textures) -> this.a(id, textures, armor.d()));
        } else {
            ModelTemplates.bt.a(resourceLocation, TextureMapping.k(resourceLocation2), this.c, (MinecraftKey id, Map<TextureSlot, MinecraftKey> textures) -> this.a(id, textures, armor.d()));
        }
        for (a trimModelData : b) {
            String string = trimModelData.a(armor.d());
            MinecraftKey resourceLocation4 = this.a(resourceLocation, string);
            String string2 = armor.b().b() + "_trim_" + string;
            MinecraftKey resourceLocation5 = new MinecraftKey(string2).d("trims/items/");
            if (armor.d() == EnumArmorMaterial.a) {
                this.a(resourceLocation4, resourceLocation2, resourceLocation3, resourceLocation5);
                continue;
            }
            this.a(resourceLocation4, resourceLocation2, resourceLocation5);
        }
    }

    public void a() {
        this.a(Items.nm, ModelTemplates.bt);
        this.a(Items.no, ModelTemplates.bt);
        this.a(Items.nn, ModelTemplates.bt);
        this.a(Items.np, ModelTemplates.bt);
        this.a(Items.nK, ModelTemplates.bt);
        this.a(Items.nB, ModelTemplates.bt);
        this.a(Items.tH, ModelTemplates.bt);
        this.a(Items.nD, ModelTemplates.bt);
        this.a(Items.tj, ModelTemplates.bt);
        this.a(Items.dt, ModelTemplates.bu);
        this.a(Items.rh, ModelTemplates.bt);
        this.a(Items.ul, ModelTemplates.bt);
        this.a(Items.un, ModelTemplates.bt);
        this.a(Items.ni, ModelTemplates.bt);
        this.a(Items.nj, ModelTemplates.bt);
        this.a(Items.qF, ModelTemplates.bt);
        this.a(Items.rv, ModelTemplates.bt);
        this.a(Items.rn, ModelTemplates.bu);
        this.a(Items.qB, ModelTemplates.bt);
        this.a(Items.qG, ModelTemplates.bt);
        this.a(Items.pX, ModelTemplates.bt);
        this.a(Items.oy, ModelTemplates.bt);
        this.a(Items.oF, ModelTemplates.bt);
        this.a(Items.pT, ModelTemplates.bt);
        this.a(Items.qC, ModelTemplates.bt);
        this.a(Items.pG, ModelTemplates.bt);
        this.a(Items.nb, ModelTemplates.bv);
        this.a(Items.nc, ModelTemplates.bv);
        this.a(Items.nF, ModelTemplates.bt);
        this.a(Items.mX, ModelTemplates.bt);
        this.a(Items.rj, ModelTemplates.bt);
        this.a(Items.ui, ModelTemplates.bt);
        this.a(Items.pU, ModelTemplates.bt);
        this.b(Items.qe);
        this.a(Items.nE, ModelTemplates.bt);
        this.a(Items.pP, ModelTemplates.bt);
        this.a(Items.tO, ModelTemplates.bt);
        this.a(Items.qa);
        this.a(Items.qb);
        this.a(Items.ri, ModelTemplates.bt);
        this.a(Items.rk, ModelTemplates.bt);
        this.a(Items.ql, ModelTemplates.bt);
        this.a(Items.tQ, ModelTemplates.bt);
        this.a(Items.pg, ModelTemplates.bt);
        this.a(Items.tD, ModelTemplates.bt);
        this.a(Items.qm, ModelTemplates.bt);
        this.a(Items.ra, ModelTemplates.bt);
        this.a(Items.nN, ModelTemplates.bt);
        this.a(Items.nO, ModelTemplates.bt);
        this.a(Items.uX, ModelTemplates.bt);
        this.a(Items.qz, ModelTemplates.bt);
        this.a(Items.nq, ModelTemplates.bt);
        this.a(Items.nr, ModelTemplates.bt);
        this.a(Items.nG, ModelTemplates.bt);
        this.a(Items.oq, ModelTemplates.bu);
        this.a(Items.or, ModelTemplates.bu);
        this.a(Items.tK, ModelTemplates.bt);
        this.a(Items.op, ModelTemplates.bu);
        this.a(Items.oo, ModelTemplates.bu);
        this.a(Items.on, ModelTemplates.bu);
        this.a(Items.uo, ModelTemplates.bt);
        this.a(Items.re, ModelTemplates.bt);
        this.a(Items.pZ, ModelTemplates.bt);
        this.a(Items.nH, ModelTemplates.bt);
        this.a(Items.ty, ModelTemplates.bt);
        this.a(Items.rz, ModelTemplates.bt);
        this.a(Items.rm, ModelTemplates.bt);
        this.a(Items.uh, ModelTemplates.bt);
        this.a(Items.ta, ModelTemplates.bt);
        this.a(Items.ru, ModelTemplates.bt);
        this.a(Items.tw, ModelTemplates.bt);
        this.a(Items.tb, ModelTemplates.bt);
        this.a(Items.pe, ModelTemplates.bt);
        this.a(Items.nA, ModelTemplates.bt);
        this.a(Items.uW, ModelTemplates.bt);
        this.a(Items.mY, ModelTemplates.bt);
        this.a(Items.ro, ModelTemplates.bt);
        this.a(Items.rs, ModelTemplates.bt);
        this.a(Items.rA, ModelTemplates.bt);
        this.a(Items.va, ModelTemplates.bt);
        this.a(Items.vq, ModelTemplates.bt);
        this.a(Items.qg, ModelTemplates.bt);
        this.a(Items.qo, ModelTemplates.bt);
        this.a(Items.tf, ModelTemplates.bt);
        this.a(Items.nP, ModelTemplates.bt);
        this.a(Items.pi, ModelTemplates.bt);
        this.a(Items.og, ModelTemplates.bu);
        this.a(Items.tm, ModelTemplates.bt);
        this.a(Items.oh, ModelTemplates.bu);
        this.a(Items.tJ, ModelTemplates.bt);
        this.a(Items.of, ModelTemplates.bu);
        this.a(Items.oe, ModelTemplates.bu);
        this.a(Items.od, ModelTemplates.bu);
        this.a(Items.nQ, ModelTemplates.bt);
        this.a(Items.rp, ModelTemplates.bt);
        this.a(Items.qx, ModelTemplates.bt);
        this.a(Items.qD, ModelTemplates.bt);
        this.a(Items.oC, ModelTemplates.bt);
        this.a(Items.uS, ModelTemplates.bt);
        this.a(Items.vu, ModelTemplates.bt);
        this.a(Items.vx, ModelTemplates.bt);
        this.a(Items.na, ModelTemplates.bt);
        this.a(Items.qn, ModelTemplates.bt);
        this.a(Items.nL, ModelTemplates.bt);
        this.a(Items.ol, ModelTemplates.bu);
        this.a(Items.om, ModelTemplates.bu);
        this.a(Items.tI, ModelTemplates.bt);
        this.a(Items.nM, ModelTemplates.bt);
        this.a(Items.uw, ModelTemplates.bt);
        this.a(Items.ok, ModelTemplates.bu);
        this.a(Items.oj, ModelTemplates.bu);
        this.a(Items.oi, ModelTemplates.bu);
        this.a(Items.te, ModelTemplates.bt);
        this.a(Items.nk, ModelTemplates.bt);
        this.a(Items.nl, ModelTemplates.bt);
        this.a(Items.ux, ModelTemplates.bt);
        this.a(Items.nI, ModelTemplates.bt);
        this.a(Items.pI, ModelTemplates.bt);
        this.a(Items.pL, ModelTemplates.bt);
        this.a(Items.tL, ModelTemplates.bt);
        this.a(Items.qt, ModelTemplates.bt);
        this.a(Items.qy, ModelTemplates.bt);
        this.a(Items.qv, ModelTemplates.bt);
        this.a(Items.qs, ModelTemplates.bt);
        this.a(Items.rw, ModelTemplates.bt);
        this.a(Items.ns, ModelTemplates.bt);
        this.a(Items.nt, ModelTemplates.bt);
        this.a(Items.nu, ModelTemplates.bt);
        this.a(Items.nv, ModelTemplates.bt);
        this.a(Items.tl, ModelTemplates.bt);
        this.a(Items.rd, ModelTemplates.bt);
        this.a(Items.pM, ModelTemplates.bt);
        this.a(Items.mW, ModelTemplates.bt);
        this.a(Items.uZ, ModelTemplates.bt);
        this.a(Items.oz, ModelTemplates.bt);
        this.a(Items.uO, ModelTemplates.bt);
        this.a(Items.uJ, ModelTemplates.bt);
        this.a(Items.uz, ModelTemplates.bt);
        this.a(Items.uB, ModelTemplates.bt);
        this.a(Items.uA, ModelTemplates.bt);
        this.a(Items.uC, ModelTemplates.bt);
        this.a(Items.uD, ModelTemplates.bt);
        this.a(Items.uE, ModelTemplates.bt);
        this.a(Items.uF, ModelTemplates.bt);
        this.a(Items.uN, ModelTemplates.bt);
        this.a(Items.uG, ModelTemplates.bt);
        this.a(Items.uH, ModelTemplates.bt);
        this.a(Items.uK, ModelTemplates.bt);
        this.a(Items.uI, ModelTemplates.bt);
        this.a(Items.uL, ModelTemplates.bt);
        this.a(Items.uM, ModelTemplates.bt);
        this.a(Items.tP, ModelTemplates.bt);
        this.a(Items.tN, ModelTemplates.bt);
        this.a(Items.uR, ModelTemplates.bt);
        this.a(Items.ov, ModelTemplates.bu);
        this.a(Items.ow, ModelTemplates.bu);
        this.a(Items.nR, ModelTemplates.bt);
        this.a(Items.ou, ModelTemplates.bu);
        this.a(Items.nS, ModelTemplates.bt);
        this.a(Items.ot, ModelTemplates.bu);
        this.a(Items.os, ModelTemplates.bu);
        this.a(Items.tz, ModelTemplates.bt);
        this.a(Items.tu, ModelTemplates.bt);
        this.a(Items.ne, ModelTemplates.bt);
        this.a(Items.nf, ModelTemplates.bt);
        this.a(Items.qr, ModelTemplates.bt);
        this.a(Items.ph, ModelTemplates.bt);
        this.a(Items.pW, ModelTemplates.bt);
        this.a(Items.uQ, ModelTemplates.bt);
        this.a(Items.vb, ModelTemplates.bt);
        this.a(Items.qw, ModelTemplates.bt);
        this.a(Items.tk, ModelTemplates.bt);
        this.a(Items.uj, ModelTemplates.bt);
        this.a(Items.pf, ModelTemplates.bt);
        this.a(Items.pJ, ModelTemplates.bt);
        this.a(Items.tB, ModelTemplates.bt);
        this.a(Items.tA, ModelTemplates.bt);
        this.a(Items.qk, ModelTemplates.bt);
        this.a(Items.pN, ModelTemplates.bt);
        this.a(Items.tv, ModelTemplates.bt);
        this.a(Items.qA, ModelTemplates.bt);
        this.a(Items.nJ, ModelTemplates.bt);
        this.a(Items.tC, ModelTemplates.bt);
        this.a(Items.tF, ModelTemplates.bt);
        this.a(Items.tG, ModelTemplates.bt);
        this.a(Items.tE, ModelTemplates.bt);
        this.a(Items.qE, ModelTemplates.bt);
        this.a(Items.rl, ModelTemplates.bt);
        this.a(Items.mV, ModelTemplates.bt);
        this.a(Items.qi, ModelTemplates.bt);
        this.a(Items.pO, ModelTemplates.bt);
        this.a(Items.nz, ModelTemplates.bt);
        this.a(Items.rc, ModelTemplates.bt);
        this.a(Items.uv, ModelTemplates.bt);
        this.a(Items.uY, ModelTemplates.bt);
        this.a(Items.pY, ModelTemplates.bt);
        this.a(Items.pK, ModelTemplates.bt);
        this.a(Items.wo, ModelTemplates.bt);
        this.a(Items.uq, ModelTemplates.bt);
        this.a(Items.rt, ModelTemplates.bt);
        this.a(Items.ng, ModelTemplates.bt);
        this.a(Items.nh, ModelTemplates.bt);
        this.a(Items.qf, ModelTemplates.bt);
        this.a(Items.ox, ModelTemplates.bu);
        this.a(Items.ob, ModelTemplates.bu);
        this.a(Items.oc, ModelTemplates.bu);
        this.a(Items.oa, ModelTemplates.bu);
        this.a(Items.nZ, ModelTemplates.bu);
        this.a(Items.nY, ModelTemplates.bu);
        this.a(Items.qI, ModelTemplates.bt);
        this.a(Items.uU, ModelTemplates.bt);
        this.a(Items.mZ, ModelTemplates.bt);
        this.a(Items.uu, ModelTemplates.bt);
        this.a(Items.uP, ModelTemplates.bt);
        this.a(Items.qj, ModelTemplates.bt);
        this.a(Items.pQ, ModelTemplates.bt);
        this.a(Items.pR, ModelTemplates.bt);
        this.a(Items.pS, ModelTemplates.bt);
        this.a(Items.pH, ModelTemplates.bt);
        this.a(Items.oE, ModelTemplates.bt);
        this.a(Items.qq, ModelTemplates.bt);
        this.a(Items.nW, ModelTemplates.bu);
        this.a(Items.nX, ModelTemplates.bu);
        this.a(Items.nV, ModelTemplates.bu);
        this.a(Items.nU, ModelTemplates.bu);
        this.a(Items.nT, ModelTemplates.bu);
        this.a(Items.tc, ModelTemplates.bt);
        this.a(Items.td, ModelTemplates.bt);
        this.a(Items.qu, ModelTemplates.bt);
        this.a(Items.wq, ModelTemplates.bt);
        this.a(Items.wr, ModelTemplates.bt);
        this.a(Items.ws, ModelTemplates.bt);
        this.a(Items.wt, ModelTemplates.bt);
        this.a(Items.wu, ModelTemplates.bt);
        this.a(Items.wv, ModelTemplates.bt);
        this.a(Items.ww, ModelTemplates.bt);
        this.a(Items.wx, ModelTemplates.bt);
        this.a(Items.wy, ModelTemplates.bt);
        this.a(Items.wz, ModelTemplates.bt);
        this.a(Items.wA, ModelTemplates.bt);
        this.a(Items.wB, ModelTemplates.bt);
        this.a(Items.uy, Items.ox, ModelTemplates.bu);
        this.a(Items.pj, Items.pi, ModelTemplates.bt);
        for (Item item : BuiltInRegistries.i) {
            if (!(item instanceof ItemArmor)) continue;
            ItemArmor armorItem = (ItemArmor)item;
            this.a(armorItem);
        }
        this.a(Items.wC, ModelTemplates.bt);
        this.a(Items.wD, ModelTemplates.bt);
        this.a(Items.wE, ModelTemplates.bt);
        this.a(Items.wF, ModelTemplates.bt);
    }

    record a(String a, float b, Map<ArmorMaterial, String> c) {
        public String a(ArmorMaterial armorMaterial) {
            return this.c.getOrDefault(armorMaterial, this.a);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "name;itemModelIndex;overrideArmorMaterials", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "name;itemModelIndex;overrideArmorMaterials", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "name;itemModelIndex;overrideArmorMaterials", "a", "b", "c"}, this, object);
        }
    }
}

