/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ModelProvider
implements DebugReportProvider {
    private final PackOutput.a d;
    private final PackOutput.a e;

    public ModelProvider(PackOutput output) {
        this.d = output.a(PackOutput.b.b, "blockstates");
        this.e = output.a(PackOutput.b.b, "models");
    }

    @Override
    @Override
    public CompletableFuture<?> a(CachedOutput writer) {
        HashMap map = Maps.newHashMap();
        Consumer<BlockStateGenerator> consumer = blockStateSupplier -> {
            Block block = blockStateSupplier.a();
            BlockStateGenerator blockStateGenerator = map.put(block, blockStateSupplier);
            if (blockStateGenerator != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + block);
            }
        };
        HashMap map2 = Maps.newHashMap();
        HashSet set = Sets.newHashSet();
        BiConsumer<MinecraftKey, Supplier<JsonElement>> biConsumer = (id, jsonSupplier) -> {
            Supplier supplier = map2.put(id, jsonSupplier);
            if (supplier != null) {
                throw new IllegalStateException("Duplicate model definition for " + id);
            }
        };
        Consumer<Item> consumer2 = set::add;
        new BlockModelGenerators(consumer, biConsumer, consumer2).a();
        new ItemModelGenerators(biConsumer).a();
        List<Block> list = BuiltInRegistries.f.s().filter(block -> !map.containsKey(block)).toList();
        if (!list.isEmpty()) {
            throw new IllegalStateException("Missing blockstate definitions for: " + list);
        }
        BuiltInRegistries.f.forEach(block -> {
            Item item = Item.l.get(block);
            if (item != null) {
                if (set.contains(item)) {
                    return;
                }
                MinecraftKey resourceLocation = ModelLocationUtils.a(item);
                if (!map2.containsKey(resourceLocation)) {
                    map2.put(resourceLocation, new DelegatedModel(ModelLocationUtils.a(block)));
                }
            }
        });
        CompletableFuture[] completableFutureArray = new CompletableFuture[2];
        completableFutureArray[0] = this.a(writer, map, block -> this.d.a(block.r().g().a()));
        completableFutureArray[1] = this.a(writer, map2, this.e::a);
        return CompletableFuture.allOf(completableFutureArray);
    }

    private <T> CompletableFuture<?> a(CachedOutput cache, Map<T, ? extends Supplier<JsonElement>> models, Function<T, Path> pathGetter) {
        return CompletableFuture.allOf((CompletableFuture[])models.entrySet().stream().map(entry -> {
            Path path = (Path)pathGetter.apply(entry.getKey());
            JsonElement jsonElement = (JsonElement)((Supplier)entry.getValue()).get();
            return DebugReportProvider.a(cache, jsonElement, path);
        }).toArray(CompletableFuture[]::new));
    }

    @Override
    @Override
    public final String a() {
        return "Model Definitions";
    }
}

