/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class TextureMapping {
    private final Map<TextureSlot, MinecraftKey> a = Maps.newHashMap();
    private final Set<TextureSlot> b = Sets.newHashSet();

    public TextureMapping a(TextureSlot key, MinecraftKey id) {
        this.a.put(key, id);
        return this;
    }

    public TextureMapping b(TextureSlot key, MinecraftKey id) {
        this.a.put(key, id);
        this.b.add(key);
        return this;
    }

    public Stream<TextureSlot> a() {
        return this.b.stream();
    }

    public TextureMapping a(TextureSlot parent, TextureSlot child) {
        this.a.put(child, this.a.get(parent));
        return this;
    }

    public TextureMapping b(TextureSlot parent, TextureSlot child) {
        this.a.put(child, this.a.get(parent));
        this.b.add(child);
        return this;
    }

    public MinecraftKey a(TextureSlot key) {
        for (TextureSlot textureSlot = key; textureSlot != null; textureSlot = textureSlot.b()) {
            MinecraftKey resourceLocation = this.a.get(textureSlot);
            if (resourceLocation == null) continue;
            return resourceLocation;
        }
        throw new IllegalStateException("Can't find texture for slot " + key);
    }

    public TextureMapping c(TextureSlot key, MinecraftKey id) {
        TextureMapping textureMapping = new TextureMapping();
        textureMapping.a.putAll(this.a);
        textureMapping.b.addAll(this.b);
        textureMapping.a(key, id);
        return textureMapping;
    }

    public static TextureMapping a(Block block) {
        MinecraftKey resourceLocation = TextureMapping.F(block);
        return TextureMapping.b(resourceLocation);
    }

    public static TextureMapping b(Block block) {
        MinecraftKey resourceLocation = TextureMapping.F(block);
        return TextureMapping.a(resourceLocation);
    }

    public static TextureMapping a(MinecraftKey id) {
        return new TextureMapping().a(TextureSlot.b, id);
    }

    public static TextureMapping b(MinecraftKey id) {
        return new TextureMapping().a(TextureSlot.a, id);
    }

    public static TextureMapping c(Block block) {
        return TextureMapping.d(TextureSlot.p, TextureMapping.F(block));
    }

    public static TextureMapping c(MinecraftKey id) {
        return TextureMapping.d(TextureSlot.p, id);
    }

    public static TextureMapping d(Block block) {
        return TextureMapping.d(TextureSlot.q, TextureMapping.F(block));
    }

    public static TextureMapping d(MinecraftKey id) {
        return TextureMapping.d(TextureSlot.q, id);
    }

    public static TextureMapping e(Block block) {
        return TextureMapping.d(TextureSlot.s, TextureMapping.F(block));
    }

    public static TextureMapping e(MinecraftKey id) {
        return TextureMapping.d(TextureSlot.s, id);
    }

    public static TextureMapping f(Block block) {
        return TextureMapping.d(TextureSlot.t, TextureMapping.F(block));
    }

    public static TextureMapping g(Block block) {
        return new TextureMapping().a(TextureSlot.P, TextureMapping.F(block)).a(TextureSlot.y, TextureMapping.a(block, "_stem"));
    }

    public static TextureMapping f(MinecraftKey id) {
        return TextureMapping.d(TextureSlot.t, id);
    }

    public static TextureMapping h(Block block) {
        return TextureMapping.d(TextureSlot.y, TextureMapping.F(block));
    }

    public static TextureMapping a(Block stem, Block upper) {
        return new TextureMapping().a(TextureSlot.y, TextureMapping.F(stem)).a(TextureSlot.z, TextureMapping.F(upper));
    }

    public static TextureMapping i(Block block) {
        return TextureMapping.d(TextureSlot.u, TextureMapping.F(block));
    }

    public static TextureMapping j(Block block) {
        return TextureMapping.d(TextureSlot.x, TextureMapping.F(block));
    }

    public static TextureMapping g(MinecraftKey id) {
        return TextureMapping.d(TextureSlot.A, id);
    }

    public static TextureMapping b(Block block, Block top) {
        return new TextureMapping().a(TextureSlot.v, TextureMapping.F(block)).a(TextureSlot.w, TextureMapping.a(top, "_top"));
    }

    public static TextureMapping d(TextureSlot key, MinecraftKey id) {
        return new TextureMapping().a(key, id);
    }

    public static TextureMapping k(Block block) {
        return new TextureMapping().a(TextureSlot.i, TextureMapping.a(block, "_side")).a(TextureSlot.d, TextureMapping.a(block, "_top"));
    }

    public static TextureMapping l(Block block) {
        return new TextureMapping().a(TextureSlot.i, TextureMapping.a(block, "_side")).a(TextureSlot.f, TextureMapping.a(block, "_top"));
    }

    public static TextureMapping m(Block block) {
        return new TextureMapping().a(TextureSlot.i, TextureMapping.F(block)).a(TextureSlot.d, TextureMapping.a(block, "_top")).a(TextureSlot.c, TextureMapping.F(block));
    }

    public static TextureMapping a(MinecraftKey side, MinecraftKey end) {
        return new TextureMapping().a(TextureSlot.i, side).a(TextureSlot.d, end);
    }

    public static TextureMapping n(Block block) {
        return new TextureMapping().a(TextureSlot.b, TextureMapping.F(block)).a(TextureSlot.i, TextureMapping.a(block, "_side")).a(TextureSlot.f, TextureMapping.a(block, "_top"));
    }

    public static TextureMapping o(Block block) {
        return new TextureMapping().a(TextureSlot.b, TextureMapping.F(block)).a(TextureSlot.c, TextureMapping.a(block, "_particle"));
    }

    public static TextureMapping p(Block block) {
        return new TextureMapping().a(TextureSlot.i, TextureMapping.a(block, "_side")).a(TextureSlot.f, TextureMapping.a(block, "_top")).a(TextureSlot.e, TextureMapping.a(block, "_bottom"));
    }

    public static TextureMapping q(Block block) {
        MinecraftKey resourceLocation = TextureMapping.F(block);
        return new TextureMapping().a(TextureSlot.r, resourceLocation).a(TextureSlot.i, resourceLocation).a(TextureSlot.f, TextureMapping.a(block, "_top")).a(TextureSlot.e, TextureMapping.a(block, "_bottom"));
    }

    public static TextureMapping r(Block block) {
        MinecraftKey resourceLocation = TextureMapping.F(block);
        return new TextureMapping().a(TextureSlot.b, resourceLocation).a(TextureSlot.r, resourceLocation).a(TextureSlot.i, resourceLocation).a(TextureSlot.d, TextureMapping.a(block, "_top"));
    }

    public static TextureMapping b(MinecraftKey top, MinecraftKey bottom) {
        return new TextureMapping().a(TextureSlot.f, top).a(TextureSlot.e, bottom);
    }

    public static TextureMapping s(Block block) {
        return new TextureMapping().a(TextureSlot.f, TextureMapping.a(block, "_top")).a(TextureSlot.e, TextureMapping.a(block, "_bottom"));
    }

    public static TextureMapping t(Block block) {
        return new TextureMapping().a(TextureSlot.c, TextureMapping.F(block));
    }

    public static TextureMapping h(MinecraftKey id) {
        return new TextureMapping().a(TextureSlot.c, id);
    }

    public static TextureMapping u(Block block) {
        return new TextureMapping().a(TextureSlot.C, TextureMapping.a(block, "_0"));
    }

    public static TextureMapping v(Block block) {
        return new TextureMapping().a(TextureSlot.C, TextureMapping.a(block, "_1"));
    }

    public static TextureMapping w(Block block) {
        return new TextureMapping().a(TextureSlot.D, TextureMapping.F(block));
    }

    public static TextureMapping x(Block block) {
        return new TextureMapping().a(TextureSlot.G, TextureMapping.F(block));
    }

    public static TextureMapping i(MinecraftKey id) {
        return new TextureMapping().a(TextureSlot.G, id);
    }

    public static TextureMapping a(Item item) {
        return new TextureMapping().a(TextureSlot.c, TextureMapping.c(item));
    }

    public static TextureMapping y(Block block) {
        return new TextureMapping().a(TextureSlot.i, TextureMapping.a(block, "_side")).a(TextureSlot.g, TextureMapping.a(block, "_front")).a(TextureSlot.h, TextureMapping.a(block, "_back"));
    }

    public static TextureMapping z(Block block) {
        return new TextureMapping().a(TextureSlot.i, TextureMapping.a(block, "_side")).a(TextureSlot.g, TextureMapping.a(block, "_front")).a(TextureSlot.f, TextureMapping.a(block, "_top")).a(TextureSlot.e, TextureMapping.a(block, "_bottom"));
    }

    public static TextureMapping A(Block block) {
        return new TextureMapping().a(TextureSlot.i, TextureMapping.a(block, "_side")).a(TextureSlot.g, TextureMapping.a(block, "_front")).a(TextureSlot.f, TextureMapping.a(block, "_top"));
    }

    public static TextureMapping B(Block block) {
        return new TextureMapping().a(TextureSlot.i, TextureMapping.a(block, "_side")).a(TextureSlot.g, TextureMapping.a(block, "_front")).a(TextureSlot.d, TextureMapping.a(block, "_end"));
    }

    public static TextureMapping C(Block top) {
        return new TextureMapping().a(TextureSlot.f, TextureMapping.a(top, "_top"));
    }

    public static TextureMapping c(Block block, Block bottom) {
        return new TextureMapping().a(TextureSlot.c, TextureMapping.a(block, "_front")).a(TextureSlot.o, TextureMapping.F(bottom)).a(TextureSlot.n, TextureMapping.a(block, "_top")).a(TextureSlot.j, TextureMapping.a(block, "_front")).a(TextureSlot.l, TextureMapping.a(block, "_side")).a(TextureSlot.k, TextureMapping.a(block, "_side")).a(TextureSlot.m, TextureMapping.a(block, "_front"));
    }

    public static TextureMapping d(Block frontTopSideBlock, Block downBlock) {
        return new TextureMapping().a(TextureSlot.c, TextureMapping.a(frontTopSideBlock, "_front")).a(TextureSlot.o, TextureMapping.F(downBlock)).a(TextureSlot.n, TextureMapping.a(frontTopSideBlock, "_top")).a(TextureSlot.j, TextureMapping.a(frontTopSideBlock, "_front")).a(TextureSlot.k, TextureMapping.a(frontTopSideBlock, "_front")).a(TextureSlot.l, TextureMapping.a(frontTopSideBlock, "_side")).a(TextureSlot.m, TextureMapping.a(frontTopSideBlock, "_side"));
    }

    public static TextureMapping D(Block block) {
        return new TextureMapping().a(TextureSlot.K, TextureMapping.a(block, "_log_lit")).a(TextureSlot.C, TextureMapping.a(block, "_fire"));
    }

    public static TextureMapping a(Block block, boolean lit) {
        return new TextureMapping().a(TextureSlot.c, TextureMapping.a(Blocks.eg, "_side")).a(TextureSlot.e, TextureMapping.a(Blocks.eg, "_bottom")).a(TextureSlot.f, TextureMapping.a(Blocks.eg, "_top")).a(TextureSlot.i, TextureMapping.a(Blocks.eg, "_side")).a(TextureSlot.L, TextureMapping.a(block, lit ? "_lit" : ""));
    }

    public static TextureMapping j(MinecraftKey content) {
        return new TextureMapping().a(TextureSlot.c, TextureMapping.a(Blocks.fs, "_side")).a(TextureSlot.i, TextureMapping.a(Blocks.fs, "_side")).a(TextureSlot.f, TextureMapping.a(Blocks.fs, "_top")).a(TextureSlot.e, TextureMapping.a(Blocks.fs, "_bottom")).a(TextureSlot.M, TextureMapping.a(Blocks.fs, "_inner")).a(TextureSlot.N, content);
    }

    public static TextureMapping a(boolean canSummon) {
        String string = canSummon ? "_can_summon" : "";
        return new TextureMapping().a(TextureSlot.c, TextureMapping.a(Blocks.qD, "_bottom")).a(TextureSlot.i, TextureMapping.a(Blocks.qD, "_side")).a(TextureSlot.f, TextureMapping.a(Blocks.qD, "_top")).a(TextureSlot.O, TextureMapping.a(Blocks.qD, string + "_inner_top")).a(TextureSlot.e, TextureMapping.a(Blocks.qD, "_bottom"));
    }

    public static TextureMapping b(Item item) {
        return new TextureMapping().a(TextureSlot.H, TextureMapping.c(item));
    }

    public static TextureMapping E(Block block) {
        return new TextureMapping().a(TextureSlot.H, TextureMapping.F(block));
    }

    public static TextureMapping k(MinecraftKey id) {
        return new TextureMapping().a(TextureSlot.H, id);
    }

    public static TextureMapping c(MinecraftKey layer0, MinecraftKey layer1) {
        return new TextureMapping().a(TextureSlot.H, layer0).a(TextureSlot.I, layer1);
    }

    public static TextureMapping a(MinecraftKey layer0, MinecraftKey layer1, MinecraftKey layer2) {
        return new TextureMapping().a(TextureSlot.H, layer0).a(TextureSlot.I, layer1).a(TextureSlot.J, layer2);
    }

    public static MinecraftKey F(Block block) {
        MinecraftKey resourceLocation = BuiltInRegistries.f.b(block);
        return resourceLocation.d("block/");
    }

    public static MinecraftKey a(Block block, String suffix) {
        MinecraftKey resourceLocation = BuiltInRegistries.f.b(block);
        return resourceLocation.a(path -> "block/" + path + suffix);
    }

    public static MinecraftKey c(Item item) {
        MinecraftKey resourceLocation = BuiltInRegistries.i.b(item);
        return resourceLocation.d("item/");
    }

    public static MinecraftKey a(Item item, String suffix) {
        MinecraftKey resourceLocation = BuiltInRegistries.i.b(item);
        return resourceLocation.a(path -> "item/" + path + suffix);
    }
}

