/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.structures.DebugReportNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class SnbtToNbt
implements DebugReportProvider {
    @Nullable
    private static final Path d = null;
    private static final Logger e = LogUtils.getLogger();
    private final PackOutput f;
    private final Iterable<Path> g;
    private final List<a> h = Lists.newArrayList();

    public SnbtToNbt(PackOutput output, Iterable<Path> paths) {
        this.f = output;
        this.g = paths;
    }

    public SnbtToNbt a(a tweaker) {
        this.h.add(tweaker);
        return this;
    }

    private NBTTagCompound a(String key, NBTTagCompound compound) {
        NBTTagCompound compoundTag = compound;
        for (a filter : this.h) {
            compoundTag = filter.apply(key, compoundTag);
        }
        return compoundTag;
    }

    @Override
    @Override
    public CompletableFuture<?> a(CachedOutput writer) {
        Path path = this.f.a();
        ArrayList list = Lists.newArrayList();
        for (Path path2 : this.g) {
            list.add(CompletableFuture.supplyAsync(() -> {
                CompletableFuture<Void> completableFuture;
                block8: {
                    Stream<Path> stream = Files.walk(path2, new FileVisitOption[0]);
                    try {
                        completableFuture = CompletableFuture.allOf((CompletableFuture[])stream.filter(path -> path.toString().endsWith(".snbt")).map(path -> CompletableFuture.runAsync(() -> {
                            c taskResult = this.a((Path)path, this.a(path2, (Path)path));
                            this.a(writer, taskResult, path);
                        }, SystemUtils.f())).toArray(CompletableFuture[]::new));
                        if (stream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            throw new RuntimeException("Failed to read structure input directory, aborting", exception);
                        }
                    }
                    stream.close();
                }
                return completableFuture;
            }, SystemUtils.f()).thenCompose(future -> future));
        }
        return SystemUtils.c(list);
    }

    @Override
    @Override
    public final String a() {
        return "SNBT -> NBT";
    }

    private String a(Path root, Path file) {
        String string = root.relativize(file).toString().replaceAll("\\\\", "/");
        return string.substring(0, string.length() - ".snbt".length());
    }

    private c a(Path path, String name) {
        c c2;
        block10: {
            BufferedReader bufferedReader = Files.newBufferedReader(path);
            try {
                String string3;
                String string = IOUtils.toString((Reader)bufferedReader);
                NBTTagCompound compoundTag = this.a(name, GameProfileSerializer.a(string));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteArrayOutputStream);
                NBTCompressedStreamTools.a(compoundTag, (OutputStream)hashingOutputStream);
                byte[] bs = byteArrayOutputStream.toByteArray();
                HashCode hashCode = hashingOutputStream.hash();
                if (d != null) {
                    String string2 = GameProfileSerializer.c(compoundTag);
                } else {
                    string3 = null;
                }
                c2 = new c(name, bs, string3, hashCode);
                if (bufferedReader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    throw new b(path, throwable3);
                }
            }
            bufferedReader.close();
        }
        return c2;
    }

    private void a(CachedOutput cache, c data, Path root) {
        if (data.c != null) {
            Path path = d.resolve(data.a + ".snbt");
            try {
                DebugReportNBT.a(CachedOutput.a, path, data.c);
            }
            catch (IOException iOException) {
                e.error("Couldn't write structure SNBT {} at {}", new Object[]{data.a, path, iOException});
            }
        }
        Path path2 = root.resolve(data.a + ".nbt");
        try {
            cache.writeIfNeeded(path2, data.b, data.d);
        }
        catch (IOException iOException2) {
            e.error("Couldn't write structure {} at {}", new Object[]{data.a, path2, iOException2});
        }
    }

    @FunctionalInterface
    public static interface a {
        public NBTTagCompound apply(String var1, NBTTagCompound var2);
    }

    record c(String a, byte[] b, @Nullable String c, HashCode d) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "name;payload;snbtPayload;hash", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "name;payload;snbtPayload;hash", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "name;payload;snbtPayload;hash", "a", "b", "c", "d"}, this, object);
        }
    }

    static class b
    extends RuntimeException {
        public b(Path path, Throwable cause) {
            super(path.toAbsolutePath().toString(), cause);
        }
    }
}

