/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public abstract class ItemTagsProvider
extends IntrinsicHolderTagsProvider<Item> {
    private final CompletableFuture<TagsProvider.c<Block>> d;
    private final Map<TagKey<Block>, TagKey<Item>> g = new HashMap<TagKey<Block>, TagKey<Item>>();

    public ItemTagsProvider(PackOutput output, CompletableFuture<HolderLookup.b> registryLookupFuture, CompletableFuture<TagsProvider.c<Block>> blockTagLookupFuture) {
        super(output, Registries.C, registryLookupFuture, (T item) -> item.j().g());
        this.d = blockTagLookupFuture;
    }

    public ItemTagsProvider(PackOutput output, CompletableFuture<HolderLookup.b> registryLookupFuture, CompletableFuture<TagsProvider.c<Item>> parentTagLookupFuture, CompletableFuture<TagsProvider.c<Block>> blockTagLookupFuture) {
        super(output, Registries.C, registryLookupFuture, parentTagLookupFuture, item -> item.j().g());
        this.d = blockTagLookupFuture;
    }

    protected void a(TagKey<Block> blockTag, TagKey<Item> itemTag) {
        this.g.put(blockTag, itemTag);
    }

    @Override
    @Override
    protected CompletableFuture<HolderLookup.b> b() {
        return super.b().thenCombineAsync(this.d, (lookup, blockTags) -> {
            this.g.forEach((blockTag, itemTag) -> {
                TagBuilder tagBuilder = this.c(itemTag);
                Optional optional = (Optional)blockTags.apply(blockTag);
                ((TagBuilder)optional.orElseThrow(() -> new IllegalStateException("Missing block tag " + itemTag.b()))).b().forEach(tagBuilder::a);
            });
            return lookup;
        });
    }
}

