/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen.placement;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.data.worldgen.placement.EndPlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.NetherPlacements;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.data.worldgen.placement.VillagePlacements;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.HeightmapPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class PlacementUtils {
    public static final PlacementModifier a = HeightmapPlacement.a(HeightMap.Type.e);
    public static final PlacementModifier b = HeightmapPlacement.a(HeightMap.Type.c);
    public static final PlacementModifier c = HeightmapPlacement.a(HeightMap.Type.a);
    public static final PlacementModifier d = HeightmapPlacement.a(HeightMap.Type.d);
    public static final PlacementModifier e = HeightRangePlacement.a(VerticalAnchor.a(), VerticalAnchor.b());
    public static final PlacementModifier f = HeightRangePlacement.a(VerticalAnchor.b(10), VerticalAnchor.c(10));
    public static final PlacementModifier g = HeightRangePlacement.a(VerticalAnchor.b(8), VerticalAnchor.c(8));
    public static final PlacementModifier h = HeightRangePlacement.a(VerticalAnchor.b(4), VerticalAnchor.c(4));
    public static final PlacementModifier i = HeightRangePlacement.a(VerticalAnchor.a(), VerticalAnchor.a(256));

    public static void a(BootstapContext<PlacedFeature> featureRegisterable) {
        AquaticPlacements.a(featureRegisterable);
        CavePlacements.a(featureRegisterable);
        EndPlacements.a(featureRegisterable);
        MiscOverworldPlacements.a(featureRegisterable);
        NetherPlacements.a(featureRegisterable);
        OrePlacements.a(featureRegisterable);
        TreePlacements.a(featureRegisterable);
        VegetationPlacements.a(featureRegisterable);
        VillagePlacements.a(featureRegisterable);
    }

    public static ResourceKey<PlacedFeature> a(String id) {
        return ResourceKey.a(Registries.aw, new MinecraftKey(id));
    }

    public static void a(BootstapContext<PlacedFeature> featureRegisterable, ResourceKey<PlacedFeature> key, Holder<WorldGenFeatureConfigured<?, ?>> feature, List<PlacementModifier> modifiers) {
        featureRegisterable.a(key, new PlacedFeature(feature, List.copyOf(modifiers)));
    }

    public static void a(BootstapContext<PlacedFeature> featureRegisterable, ResourceKey<PlacedFeature> key, Holder<WorldGenFeatureConfigured<?, ?>> feature, PlacementModifier ... modifiers) {
        PlacementUtils.a(featureRegisterable, key, feature, List.of(modifiers));
    }

    public static PlacementModifier a(int count, float extraChance, int extraCount) {
        float f2 = 1.0f / extraChance;
        if (Math.abs(f2 - (float)((int)f2)) > 1.0E-5f) {
            throw new IllegalStateException("Chance data cannot be represented as list weight");
        }
        SimpleWeightedRandomList<IntProvider> simpleWeightedRandomList = SimpleWeightedRandomList.a().a(ConstantInt.a(count), (int)f2 - 1).a(ConstantInt.a(count + extraCount), 1).a();
        return CountPlacement.a(new WeightedListInt(simpleWeightedRandomList));
    }

    public static PlacementFilter a() {
        return BlockPredicateFilter.a(BlockPredicate.c);
    }

    public static BlockPredicateFilter a(Block block) {
        return BlockPredicateFilter.a(BlockPredicate.a(block.o(), BlockPosition.b));
    }

    public static Holder<PlacedFeature> a(Holder<WorldGenFeatureConfigured<?, ?>> feature, PlacementModifier ... modifiers) {
        return Holder.a(new PlacedFeature(feature, List.of(modifiers)));
    }

    public static <FC extends WorldGenFeatureConfiguration, F extends WorldGenerator<FC>> Holder<PlacedFeature> a(F feature, FC featureConfig, PlacementModifier ... modifiers) {
        return PlacementUtils.a(Holder.a(new WorldGenFeatureConfigured<FC, F>(feature, featureConfig)), modifiers);
    }

    public static <FC extends WorldGenFeatureConfiguration, F extends WorldGenerator<FC>> Holder<PlacedFeature> a(F feature, FC featureConfig) {
        return PlacementUtils.a(feature, featureConfig, BlockPredicate.c);
    }

    public static <FC extends WorldGenFeatureConfiguration, F extends WorldGenerator<FC>> Holder<PlacedFeature> a(F feature, FC featureConfig, BlockPredicate predicate) {
        return PlacementUtils.a(feature, featureConfig, BlockPredicateFilter.a(predicate));
    }
}

