/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.gametest.framework.GameTestHarnessAssertion;
import net.minecraft.gametest.framework.GameTestHarnessAssertionPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessSequence;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockButtonAbstract;
import net.minecraft.world.level.block.BlockLever;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class GameTestHarnessHelper {
    private final GameTestHarnessInfo a;
    private boolean b;

    public GameTestHarnessHelper(GameTestHarnessInfo test) {
        this.a = test;
    }

    public WorldServer a() {
        return this.a.g();
    }

    public IBlockData a(BlockPosition pos) {
        return this.a().a_(this.i(pos));
    }

    @Nullable
    public TileEntity b(BlockPosition pos) {
        return this.a().c_(this.i(pos));
    }

    public void b() {
        AxisAlignedBB aABB = this.j();
        List<Entity> list = this.a().a(Entity.class, aABB.g(1.0), (? super T entity) -> !(entity instanceof EntityHuman));
        list.forEach(Entity::ah);
    }

    public EntityItem a(Item item, float x2, float y2, float z2) {
        WorldServer serverLevel = this.a();
        Vec3D vec3 = this.a(new Vec3D(x2, y2, z2));
        EntityItem itemEntity = new EntityItem(serverLevel, vec3.c, vec3.d, vec3.e, new ItemStack(item, 1));
        itemEntity.o(0.0, 0.0, 0.0);
        serverLevel.b(itemEntity);
        return itemEntity;
    }

    public EntityItem a(Item item, BlockPosition pos) {
        return this.a(item, (float)pos.u(), (float)pos.v(), (float)pos.w());
    }

    public <E extends Entity> E a(EntityTypes<E> type, BlockPosition pos) {
        return this.a(type, Vec3D.c(pos));
    }

    public <E extends Entity> E a(EntityTypes<E> type, Vec3D pos) {
        WorldServer serverLevel = this.a();
        E entity = type.a(serverLevel);
        if (entity == null) {
            throw new NullPointerException("Failed to create entity " + type.r().g().a());
        }
        if (entity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)entity;
            mob.fz();
        }
        Vec3D vec3 = this.a(pos);
        ((Entity)entity).b(vec3.c, vec3.d, vec3.e, ((Entity)entity).dw(), ((Entity)entity).dy());
        serverLevel.b((Entity)entity);
        return entity;
    }

    public <E extends Entity> E a(EntityTypes<E> type, int x2, int y2, int z2) {
        return this.a(type, new BlockPosition(x2, y2, z2));
    }

    public <E extends Entity> E a(EntityTypes<E> type, float x2, float y2, float z2) {
        return this.a(type, new Vec3D(x2, y2, z2));
    }

    public <E extends EntityInsentient> E b(EntityTypes<E> type, BlockPosition pos) {
        EntityInsentient mob = (EntityInsentient)this.a(type, pos);
        mob.fO();
        return (E)mob;
    }

    public <E extends EntityInsentient> E b(EntityTypes<E> type, int x2, int y2, int z2) {
        return this.b(type, new BlockPosition(x2, y2, z2));
    }

    public <E extends EntityInsentient> E b(EntityTypes<E> type, Vec3D pos) {
        EntityInsentient mob = (EntityInsentient)this.a(type, pos);
        mob.fO();
        return (E)mob;
    }

    public <E extends EntityInsentient> E b(EntityTypes<E> type, float x2, float y2, float z2) {
        return this.b(type, new Vec3D(x2, y2, z2));
    }

    public GameTestHarnessSequence a(EntityInsentient entity, BlockPosition pos, float speed) {
        return this.g().a(2, () -> {
            PathEntity path = entity.G().a(this.i(pos), 0);
            entity.G().a(path, (double)speed);
        });
    }

    public void a(int x2, int y2, int z2) {
        this.c(new BlockPosition(x2, y2, z2));
    }

    public void c(BlockPosition pos) {
        this.b(pos, (IBlockData state) -> state.a(TagsBlock.e), () -> "Expected button");
        BlockPosition blockPos = this.i(pos);
        IBlockData blockState = this.a().a_(blockPos);
        BlockButtonAbstract buttonBlock = (BlockButtonAbstract)blockState.b();
        buttonBlock.d(blockState, this.a(), blockPos);
    }

    public void d(BlockPosition pos) {
        this.a(pos, this.d());
    }

    public void a(BlockPosition pos, EntityHuman player) {
        BlockPosition blockPos = this.i(pos);
        this.a(pos, player, new MovingObjectPositionBlock(Vec3D.b(blockPos), EnumDirection.c, blockPos, true));
    }

    public void a(BlockPosition pos, EntityHuman player, MovingObjectPositionBlock result) {
        BlockPosition blockPos = this.i(pos);
        IBlockData blockState = this.a().a_(blockPos);
        EnumInteractionResult interactionResult = blockState.a((World)this.a(), player, EnumHand.a, result);
        if (!interactionResult.a()) {
            ItemActionContext useOnContext = new ItemActionContext(player, EnumHand.a, result);
            player.b(EnumHand.a).useOn(useOnContext);
        }
    }

    public void b(BlockPosition pos, EntityHuman player, MovingObjectPositionBlock result) {
        BlockPosition blockPos = this.i(pos);
        IBlockData blockState = this.a().a_(blockPos);
        EnumInteractionResult interactionResult = blockState.a((World)this.a(), player, EnumHand.a, result);
        if (!interactionResult.a()) {
            ItemActionContext useOnContext = new ItemActionContext(player, EnumHand.a, result);
            ItemStack itemStack = player.b(EnumHand.a);
            if (player.fe()) {
                itemStack.b(this.a(), player, player.fh());
            } else {
                itemStack.useOn(useOnContext);
            }
        }
    }

    public EntityLiving a(EntityLiving entity) {
        entity.i(0);
        entity.c(0.25f);
        return entity;
    }

    public EntityHuman c() {
        return new EntityHuman(this.a(), BlockPosition.b, 0.0f, new GameProfile(UUID.randomUUID(), "test-mock-player")){

            @Override
            @Override
            public boolean F_() {
                return false;
            }

            @Override
            @Override
            public boolean f() {
                return false;
            }
        };
    }

    public EntityHuman d() {
        return new EntityHuman(this.a(), BlockPosition.b, 0.0f, new GameProfile(UUID.randomUUID(), "test-mock-player")){

            @Override
            @Override
            public boolean F_() {
                return false;
            }

            @Override
            @Override
            public boolean f() {
                return true;
            }

            @Override
            @Override
            public boolean g() {
                return true;
            }
        };
    }

    public void b(int x2, int y2, int z2) {
        this.e(new BlockPosition(x2, y2, z2));
    }

    public void e(BlockPosition pos) {
        this.a(Blocks.dv, pos);
        BlockPosition blockPos = this.i(pos);
        IBlockData blockState = this.a().a_(blockPos);
        BlockLever leverBlock = (BlockLever)blockState.b();
        leverBlock.d(blockState, this.a(), blockPos);
    }

    public void a(BlockPosition pos, long delay) {
        this.a(pos, Blocks.gZ);
        this.b(delay, () -> this.a(pos, Blocks.a));
    }

    public void f(BlockPosition pos) {
        this.a().a(this.i(pos), false, null);
    }

    public void a(int x2, int y2, int z2, Block block) {
        this.a(new BlockPosition(x2, y2, z2), block);
    }

    public void a(int x2, int y2, int z2, IBlockData state) {
        this.a(new BlockPosition(x2, y2, z2), state);
    }

    public void a(BlockPosition pos, Block block) {
        this.a(pos, block.o());
    }

    public void a(BlockPosition pos, IBlockData state) {
        this.a().a(this.i(pos), state, 3);
    }

    public void e() {
        this.a(13000);
    }

    public void a(int timeOfDay) {
        this.a().b((long)timeOfDay);
    }

    public void a(Block block, int x2, int y2, int z2) {
        this.a(block, new BlockPosition(x2, y2, z2));
    }

    public void a(Block block, BlockPosition pos) {
        IBlockData blockState = this.a(pos);
        this.a((Entity)((Object)pos), (Predicate)block1 -> blockState.a(block), "Expected " + block.f().getString() + ", got " + blockState.b().f().getString());
    }

    public void b(Block block, int x2, int y2, int z2) {
        this.b(block, new BlockPosition(x2, y2, z2));
    }

    public void b(Block block, BlockPosition pos) {
        this.a((Entity)((Object)pos), (Predicate)block1 -> !this.a(pos).a(block), "Did not expect " + block.f().getString());
    }

    public void c(Block block, int x2, int y2, int z2) {
        this.c(block, new BlockPosition(x2, y2, z2));
    }

    public void c(Block block, BlockPosition pos) {
        this.b(() -> this.a(block, pos));
    }

    public void a(BlockPosition pos, Predicate<Block> predicate, String errorMessage) {
        this.a(pos, predicate, () -> errorMessage);
    }

    public void a(BlockPosition pos, Predicate<Block> predicate, Supplier<String> errorMessageSupplier) {
        this.b(pos, (IBlockData state) -> predicate.test(state.b()), errorMessageSupplier);
    }

    public <T extends Comparable<T>> void a(BlockPosition pos, IBlockState<T> property, T value) {
        IBlockData blockState = this.a(pos);
        boolean bl = blockState.b(property);
        if (!bl || !blockState.c(property).equals(value)) {
            String string = bl ? "was " + blockState.c(property) : "property " + property.f() + " is missing";
            String string2 = String.format(Locale.ROOT, "Expected property %s to be %s, %s", property.f(), value, string);
            throw new GameTestHarnessAssertionPosition(string2, this.i(pos), pos, this.a.p());
        }
    }

    public <T extends Comparable<T>> void a(BlockPosition pos, IBlockState<T> property, Predicate<T> predicate, String errorMessage) {
        this.b(pos, (IBlockData state) -> predicate.test(state.c(property)), () -> errorMessage);
    }

    public void b(BlockPosition pos, Predicate<IBlockData> predicate, Supplier<String> errorMessageSupplier) {
        IBlockData blockState = this.a(pos);
        if (!predicate.test(blockState)) {
            throw new GameTestHarnessAssertionPosition(errorMessageSupplier.get(), this.i(pos), pos, this.a.p());
        }
    }

    public void a(EntityTypes<?> type) {
        List<Entity> list = this.a().a(type, this.j(), Entity::bq);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertion("Expected " + type.i() + " to exist");
        }
    }

    public void c(EntityTypes<?> type, int x2, int y2, int z2) {
        this.c(type, new BlockPosition(x2, y2, z2));
    }

    public void c(EntityTypes<?> type, BlockPosition pos) {
        BlockPosition blockPos = this.i(pos);
        List<Entity> list = this.a().a(type, new AxisAlignedBB(blockPos), Entity::bq);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected " + type.i(), blockPos, pos, this.a.p());
        }
    }

    public void a(EntityTypes<?> type, Vec3D pos1, Vec3D pos2) {
        List<Entity> list = this.a().a(type, new AxisAlignedBB(pos1, pos2), Entity::bq);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected " + type.i() + " between ", BlockPosition.a(pos1), BlockPosition.a(pos2), this.a.p());
        }
    }

    public void a(EntityTypes<?> type, BlockPosition pos, int amount, double radius) {
        BlockPosition blockPos = this.i(pos);
        List<?> list = this.b(type, pos, radius);
        if (list.size() != amount) {
            throw new GameTestHarnessAssertionPosition("Expected " + amount + " entities of type " + type.i() + ", actual number of entities found=" + list.size(), blockPos, pos, this.a.p());
        }
    }

    public void a(EntityTypes<?> type, BlockPosition pos, double radius) {
        List<?> list = this.b(type, pos, radius);
        if (list.isEmpty()) {
            BlockPosition blockPos = this.i(pos);
            throw new GameTestHarnessAssertionPosition("Expected " + type.i(), blockPos, pos, this.a.p());
        }
    }

    public <T extends Entity> List<T> b(EntityTypes<T> type, BlockPosition pos, double radius) {
        BlockPosition blockPos = this.i(pos);
        return this.a().a(type, new AxisAlignedBB(blockPos).g(radius), Entity::bq);
    }

    public void a(Entity entity, int x2, int y2, int z2) {
        this.a(entity, new BlockPosition(x2, y2, z2));
    }

    public void a(Entity entity, BlockPosition pos) {
        BlockPosition blockPos = this.i(pos);
        List<Entity> list = this.a().a(entity.ae(), new AxisAlignedBB(blockPos), Entity::bq);
        list.stream().filter(e2 -> e2 == entity).findFirst().orElseThrow(() -> new GameTestHarnessAssertionPosition("Expected " + entity.ae().i(), blockPos, pos, this.a.p()));
    }

    public void a(Item item, BlockPosition pos, double radius, int amount) {
        BlockPosition blockPos = this.i(pos);
        List<EntityItem> list = this.a().a(EntityTypes.ad, new AxisAlignedBB(blockPos).g(radius), Entity::bq);
        int i2 = 0;
        for (Entity entity : list) {
            EntityItem itemEntity = (EntityItem)entity;
            if (!itemEntity.i().c().equals(item)) continue;
            i2 += itemEntity.i().K();
        }
        if (i2 != amount) {
            throw new GameTestHarnessAssertionPosition("Expected " + amount + " " + item.p().getString() + " items to exist (found " + i2 + ")", blockPos, pos, this.a.p());
        }
    }

    public void a(Item item, BlockPosition pos, double radius) {
        BlockPosition blockPos = this.i(pos);
        List<EntityItem> list = this.a().a(EntityTypes.ad, new AxisAlignedBB(blockPos).g(radius), Entity::bq);
        for (Entity entity : list) {
            EntityItem itemEntity = (EntityItem)entity;
            if (!itemEntity.i().c().equals(item)) continue;
            return;
        }
        throw new GameTestHarnessAssertionPosition("Expected " + item.p().getString() + " item", blockPos, pos, this.a.p());
    }

    public void b(Item item, BlockPosition pos, double radius) {
        BlockPosition blockPos = this.i(pos);
        List<EntityItem> list = this.a().a(EntityTypes.ad, new AxisAlignedBB(blockPos).g(radius), Entity::bq);
        for (Entity entity : list) {
            EntityItem itemEntity = (EntityItem)entity;
            if (!itemEntity.i().c().equals(item)) continue;
            throw new GameTestHarnessAssertionPosition("Did not expect " + item.p().getString() + " item", blockPos, pos, this.a.p());
        }
    }

    public void b(EntityTypes<?> type) {
        List<Entity> list = this.a().a(type, this.j(), Entity::bq);
        if (!list.isEmpty()) {
            throw new GameTestHarnessAssertion("Did not expect " + type.i() + " to exist");
        }
    }

    public void d(EntityTypes<?> type, int x2, int y2, int z2) {
        this.d(type, new BlockPosition(x2, y2, z2));
    }

    public void d(EntityTypes<?> type, BlockPosition pos) {
        BlockPosition blockPos = this.i(pos);
        List<Entity> list = this.a().a(type, new AxisAlignedBB(blockPos), Entity::bq);
        if (!list.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Did not expect " + type.i(), blockPos, pos, this.a.p());
        }
    }

    public void a(EntityTypes<?> type, double x2, double y2, double z2) {
        Vec3D vec3 = new Vec3D(x2, y2, z2);
        Vec3D vec32 = this.a(vec3);
        Predicate<Entity> predicate = entity -> entity.cD().a(vec32, vec32);
        List<Entity> list = this.a().a(type, this.j(), predicate);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertion("Expected " + type.i() + " to touch " + vec32 + " (relative " + vec3 + ")");
        }
    }

    public void b(EntityTypes<?> type, double x2, double y2, double z2) {
        Vec3D vec3 = new Vec3D(x2, y2, z2);
        Vec3D vec32 = this.a(vec3);
        Predicate<Entity> predicate = entity -> !entity.cD().a(vec32, vec32);
        List<Entity> list = this.a().a(type, this.j(), predicate);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertion("Did not expect " + type.i() + " to touch " + vec32 + " (relative " + vec3 + ")");
        }
    }

    public <E extends Entity, T> void a(BlockPosition pos, EntityTypes<E> type, Function<? super E, T> entityDataGetter, @Nullable T data) {
        BlockPosition blockPos = this.i(pos);
        List<Entity> list = this.a().a(type, new AxisAlignedBB(blockPos), Entity::bq);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected " + type.i(), blockPos, pos, this.a.p());
        }
        for (Entity entity : list) {
            T object = entityDataGetter.apply(entity);
            if (!(object == null ? data != null : !object.equals(data))) continue;
            throw new GameTestHarnessAssertion("Expected entity data to be: " + data + ", but was: " + object);
        }
    }

    public <E extends EntityLiving> void a(BlockPosition pos, EntityTypes<E> entityType, Item item) {
        BlockPosition blockPos = this.i(pos);
        List<EntityLiving> list = this.a().a(entityType, new AxisAlignedBB(blockPos), Entity::bq);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected entity of type: " + entityType, blockPos, pos, this.h());
        }
        for (EntityLiving livingEntity : list) {
            if (!livingEntity.b(item)) continue;
            return;
        }
        throw new GameTestHarnessAssertionPosition("Entity should be holding: " + item, blockPos, pos, this.h());
    }

    public <E extends Entity> void b(BlockPosition pos, EntityTypes<E> entityType, Item item) {
        BlockPosition blockPos = this.i(pos);
        List<Entity> list = this.a().a(entityType, new AxisAlignedBB(blockPos), (? super T entity) -> ((Entity)entity).bq());
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected " + entityType.i() + " to exist", blockPos, pos, this.h());
        }
        for (Entity entity2 : list) {
            if (!((InventoryCarrier)((Object)entity2)).w().a_(stack -> stack.a(item))) continue;
            return;
        }
        throw new GameTestHarnessAssertionPosition("Entity inventory should contain: " + item, blockPos, pos, this.h());
    }

    public void g(BlockPosition pos) {
        BlockPosition blockPos = this.i(pos);
        TileEntity blockEntity = this.a().c_(blockPos);
        if (blockEntity instanceof TileEntityContainer && !((TileEntityContainer)blockEntity).aa_()) {
            throw new GameTestHarnessAssertion("Container should be empty");
        }
    }

    public void a(BlockPosition pos, Item item) {
        BlockPosition blockPos = this.i(pos);
        TileEntity blockEntity = this.a().c_(blockPos);
        if (!(blockEntity instanceof TileEntityContainer)) {
            throw new GameTestHarnessAssertion("Expected a container at " + pos + ", found " + BuiltInRegistries.l.b(blockEntity.u()));
        }
        if (((TileEntityContainer)blockEntity).a_(item) != 1) {
            throw new GameTestHarnessAssertion("Container should contain: " + item);
        }
    }

    public void a(StructureBoundingBox checkedBlockBox, BlockPosition correctStatePos) {
        BlockPosition.a(checkedBlockBox).forEach(checkedPos -> {
            BlockPosition blockPos2 = correctStatePos.b(checkedPos.u() - checkedBlockBox.g(), checkedPos.v() - checkedBlockBox.h(), checkedPos.w() - checkedBlockBox.i());
            this.a((BlockPosition)checkedPos, blockPos2);
        });
    }

    public void a(BlockPosition checkedPos, BlockPosition correctStatePos) {
        IBlockData blockState2;
        IBlockData blockState = this.a(checkedPos);
        if (blockState != (blockState2 = this.a(correctStatePos))) {
            this.a("Incorrect state. Expected " + blockState2 + ", got " + blockState, checkedPos);
        }
    }

    public void a(long delay, BlockPosition pos, Item item) {
        this.a(delay, () -> this.a(pos, item));
    }

    public void a(long delay, BlockPosition pos) {
        this.a(delay, () -> this.g(pos));
    }

    public <E extends Entity, T> void b(BlockPosition pos, EntityTypes<E> type, Function<E, T> entityDataGetter, T data) {
        this.b(() -> this.a(pos, type, entityDataGetter, data));
    }

    public <E extends Entity> void a(E entity, Predicate<E> predicate, String testName) {
        if (!predicate.test(entity)) {
            throw new GameTestHarnessAssertion("Entity " + entity + " failed " + testName + " test");
        }
    }

    public <E extends Entity, T> void a(E entity, Function<E, T> propertyGetter, String propertyName, T expectedValue) {
        T object = propertyGetter.apply(entity);
        if (!object.equals(expectedValue)) {
            throw new GameTestHarnessAssertion("Entity " + entity + " value " + propertyName + "=" + object + " is not equal to expected " + expectedValue);
        }
    }

    public void e(EntityTypes<?> type, int x2, int y2, int z2) {
        this.e(type, new BlockPosition(x2, y2, z2));
    }

    public void e(EntityTypes<?> type, BlockPosition pos) {
        this.b(() -> this.c(type, pos));
    }

    public void f(EntityTypes<?> type, int x2, int y2, int z2) {
        this.f(type, new BlockPosition(x2, y2, z2));
    }

    public void f(EntityTypes<?> type, BlockPosition pos) {
        this.b(() -> this.d(type, pos));
    }

    public void f() {
        this.a.m();
    }

    private void i() {
        if (this.b) {
            throw new IllegalStateException("This test already has final clause");
        }
        this.b = true;
    }

    public void a(Runnable runnable) {
        this.i();
        this.a.q().a(0L, runnable).a();
    }

    public void b(Runnable runnable) {
        this.i();
        this.a.q().a(runnable).a();
    }

    public void a(int duration, Runnable runnable) {
        this.i();
        this.a.q().a((long)duration, runnable).a();
    }

    public void a(long tick, Runnable runnable) {
        this.a.a(tick, runnable);
    }

    public void b(long ticks, Runnable runnable) {
        this.a(this.a.p() + ticks, runnable);
    }

    public void h(BlockPosition pos) {
        BlockPosition blockPos = this.i(pos);
        WorldServer serverLevel = this.a();
        serverLevel.a_(blockPos).b(serverLevel, blockPos, serverLevel.z);
    }

    public int a(HeightMap.Type heightmap, int x2, int z2) {
        BlockPosition blockPos = this.i(new BlockPosition(x2, 0, z2));
        return this.j(this.a().a(heightmap, blockPos)).v();
    }

    public void a(String message, BlockPosition pos) {
        throw new GameTestHarnessAssertionPosition(message, this.i(pos), pos, this.h());
    }

    public void a(String message, Entity entity) {
        throw new GameTestHarnessAssertionPosition(message, entity.dg(), this.j(entity.dg()), this.h());
    }

    public void a(String message) {
        throw new GameTestHarnessAssertion(message);
    }

    public void c(Runnable task) {
        this.a.q().a(task).a(() -> new GameTestHarnessAssertion("Fail conditions met"));
    }

    public void d(Runnable task) {
        LongStream.range(this.a.p(), this.a.w()).forEach(tick -> this.a.a(tick, task::run));
    }

    public GameTestHarnessSequence g() {
        return this.a.q();
    }

    public BlockPosition i(BlockPosition pos) {
        BlockPosition blockPos = this.a.d();
        BlockPosition blockPos2 = blockPos.a(pos);
        return DefinedStructure.a(blockPos2, EnumBlockMirror.a, this.a.u(), blockPos);
    }

    public BlockPosition j(BlockPosition pos) {
        BlockPosition blockPos = this.a.d();
        EnumBlockRotation rotation = this.a.u().a(EnumBlockRotation.c);
        BlockPosition blockPos2 = DefinedStructure.a(pos, EnumBlockMirror.a, rotation, blockPos);
        return blockPos2.b(blockPos);
    }

    public Vec3D a(Vec3D pos) {
        Vec3D vec3 = Vec3D.a(this.a.d());
        return DefinedStructure.a(vec3.e(pos), EnumBlockMirror.a, this.a.u(), this.a.d());
    }

    public Vec3D b(Vec3D pos) {
        Vec3D vec3 = Vec3D.a(this.a.d());
        return DefinedStructure.a(pos.d(vec3), EnumBlockMirror.a, this.a.u(), this.a.d());
    }

    public void a(boolean condition, String message) {
        if (!condition) {
            throw new GameTestHarnessAssertion(message);
        }
    }

    public long h() {
        return this.a.p();
    }

    private AxisAlignedBB j() {
        return this.a.f();
    }

    private AxisAlignedBB k() {
        AxisAlignedBB aABB = this.a.f();
        return aABB.a(BlockPosition.b.b(this.i(BlockPosition.b)));
    }

    public void a(Consumer<BlockPosition> posConsumer) {
        AxisAlignedBB aABB = this.k();
        BlockPosition.MutableBlockPosition.a(aABB.d(0.0, 1.0, 0.0)).forEach(posConsumer);
    }

    public void e(Runnable runnable) {
        LongStream.range(this.a.p(), this.a.w()).forEach(tick -> this.a.a(tick, runnable::run));
    }

    public void a(EntityHuman player, ItemStack stack, BlockPosition pos, EnumDirection direction) {
        BlockPosition blockPos = this.i(pos.a(direction));
        MovingObjectPositionBlock blockHitResult = new MovingObjectPositionBlock(Vec3D.b(blockPos), direction, blockPos, false);
        ItemActionContext useOnContext = new ItemActionContext(player, EnumHand.a, blockHitResult);
        stack.useOn(useOnContext);
    }
}

