/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.TagVisitor;

public class SnbtPrinterTagVisitor
implements TagVisitor {
    private static final Map<String, List<String>> a = SystemUtils.a(Maps.newHashMap(), map -> {
        map.put("{}", Lists.newArrayList((Object[])new String[]{"DataVersion", "author", "size", "data", "entities", "palette", "palettes"}));
        map.put("{}.data.[].{}", Lists.newArrayList((Object[])new String[]{"pos", "state", "nbt"}));
        map.put("{}.entities.[].{}", Lists.newArrayList((Object[])new String[]{"blockPos", "pos"}));
    });
    private static final Set<String> b = Sets.newHashSet((Object[])new String[]{"{}.size.[]", "{}.data.[].{}", "{}.palette.[].{}", "{}.entities.[].{}"});
    private static final Pattern c = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String d = String.valueOf(':');
    private static final String e = String.valueOf(',');
    private static final String f = "[";
    private static final String g = "]";
    private static final String h = ";";
    private static final String i = " ";
    private static final String j = "{";
    private static final String k = "}";
    private static final String l = "\n";
    private final String m;
    private final int n;
    private final List<String> o;
    private String p = "";

    public SnbtPrinterTagVisitor() {
        this("    ", 0, Lists.newArrayList());
    }

    public SnbtPrinterTagVisitor(String prefix, int indentationLevel, List<String> pathParts) {
        this.m = prefix;
        this.n = indentationLevel;
        this.o = pathParts;
    }

    public String a(NBTBase element) {
        element.a(this);
        return this.p;
    }

    @Override
    @Override
    public void a(NBTTagString element) {
        this.p = NBTTagString.b(element.f_());
    }

    @Override
    @Override
    public void a(NBTTagByte element) {
        this.p = element.l() + "b";
    }

    @Override
    @Override
    public void a(NBTTagShort element) {
        this.p = element.l() + "s";
    }

    @Override
    @Override
    public void a(NBTTagInt element) {
        this.p = String.valueOf(element.l());
    }

    @Override
    @Override
    public void a(NBTTagLong element) {
        this.p = element.l() + "L";
    }

    @Override
    @Override
    public void a(NBTTagFloat element) {
        this.p = element.k() + "f";
    }

    @Override
    @Override
    public void a(NBTTagDouble element) {
        this.p = element.j() + "d";
    }

    @Override
    @Override
    public void a(NBTTagByteArray element) {
        StringBuilder stringBuilder = new StringBuilder(f).append("B").append(h);
        byte[] bs = element.e();
        for (int i2 = 0; i2 < bs.length; ++i2) {
            stringBuilder.append(i).append(bs[i2]).append("B");
            if (i2 == bs.length - 1) continue;
            stringBuilder.append(e);
        }
        stringBuilder.append(g);
        this.p = stringBuilder.toString();
    }

    @Override
    @Override
    public void a(NBTTagIntArray element) {
        StringBuilder stringBuilder = new StringBuilder(f).append("I").append(h);
        int[] is = element.g();
        for (int i2 = 0; i2 < is.length; ++i2) {
            stringBuilder.append(i).append(is[i2]);
            if (i2 == is.length - 1) continue;
            stringBuilder.append(e);
        }
        stringBuilder.append(g);
        this.p = stringBuilder.toString();
    }

    @Override
    @Override
    public void a(NBTTagLongArray element) {
        String string = "L";
        StringBuilder stringBuilder = new StringBuilder(f).append("L").append(h);
        long[] ls = element.g();
        for (int i2 = 0; i2 < ls.length; ++i2) {
            stringBuilder.append(i).append(ls[i2]).append("L");
            if (i2 == ls.length - 1) continue;
            stringBuilder.append(e);
        }
        stringBuilder.append(g);
        this.p = stringBuilder.toString();
    }

    @Override
    @Override
    public void a(NBTTagList element) {
        String string;
        if (element.isEmpty()) {
            this.p = "[]";
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(f);
        this.b("[]");
        String string2 = string = b.contains(this.a()) ? "" : this.m;
        if (!string.isEmpty()) {
            stringBuilder.append(l);
        }
        for (int i2 = 0; i2 < element.size(); ++i2) {
            stringBuilder.append(Strings.repeat((String)string, (int)(this.n + 1)));
            stringBuilder.append(new SnbtPrinterTagVisitor(string, this.n + 1, this.o).a(element.k(i2)));
            if (i2 == element.size() - 1) continue;
            stringBuilder.append(e).append(string.isEmpty() ? i : l);
        }
        if (!string.isEmpty()) {
            stringBuilder.append(l).append(Strings.repeat((String)string, (int)this.n));
        }
        stringBuilder.append(g);
        this.p = stringBuilder.toString();
        this.b();
    }

    @Override
    @Override
    public void a(NBTTagCompound compound) {
        String string;
        if (compound.g()) {
            this.p = "{}";
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(j);
        this.b("{}");
        String string2 = string = b.contains(this.a()) ? "" : this.m;
        if (!string.isEmpty()) {
            stringBuilder.append(l);
        }
        List<String> collection = this.b(compound);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string22 = (String)iterator.next();
            NBTBase tag = compound.c(string22);
            this.b(string22);
            stringBuilder.append(Strings.repeat((String)string, (int)(this.n + 1))).append(SnbtPrinterTagVisitor.a(string22)).append(d).append(i).append(new SnbtPrinterTagVisitor(string, this.n + 1, this.o).a(tag));
            this.b();
            if (!iterator.hasNext()) continue;
            stringBuilder.append(e).append(string.isEmpty() ? i : l);
        }
        if (!string.isEmpty()) {
            stringBuilder.append(l).append(Strings.repeat((String)string, (int)this.n));
        }
        stringBuilder.append(k);
        this.p = stringBuilder.toString();
        this.b();
    }

    private void b() {
        this.o.remove(this.o.size() - 1);
    }

    private void b(String part) {
        this.o.add(part);
    }

    protected List<String> b(NBTTagCompound compound) {
        HashSet set = Sets.newHashSet(compound.e());
        ArrayList list = Lists.newArrayList();
        List<String> list2 = a.get(this.a());
        if (list2 != null) {
            for (String string : list2) {
                if (!set.remove(string)) continue;
                list.add(string);
            }
            if (!set.isEmpty()) {
                set.stream().sorted().forEach(list::add);
            }
        } else {
            list.addAll(set);
            Collections.sort(list);
        }
        return list;
    }

    public String a() {
        return String.join((CharSequence)".", this.o);
    }

    protected static String a(String name) {
        if (c.matcher(name).matches()) {
            return name;
        }
        return NBTTagString.b(name);
    }

    @Override
    @Override
    public void a(NBTTagEnd element) {
    }
}

