/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.status;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.ExtraCodecs;

public final class ServerPing
extends Record {
    private final IChatBaseComponent b;
    private final Optional<ServerPingPlayerSample> c;
    private final Optional<ServerData> d;
    private final Optional<a> e;
    private final boolean f;
    public static final Codec<ServerPing> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.b.optionalFieldOf("description", (Object)CommonComponents.a).forGetter(ServerPing::a), (App)ServerPingPlayerSample.a.optionalFieldOf("players").forGetter(ServerPing::b), (App)ServerData.a.optionalFieldOf("version").forGetter(ServerPing::c), (App)net.minecraft.network.protocol.status.ServerPing$a.c.optionalFieldOf("favicon").forGetter(ServerPing::d), (App)Codec.BOOL.optionalFieldOf("enforcesSecureChat", (Object)false).forGetter(ServerPing::e)).apply((Applicative)instance, ServerPing::new));

    public ServerPing(IChatBaseComponent component, Optional<ServerPingPlayerSample> optional, Optional<ServerData> optional2, Optional<a> optional3, boolean bl) {
        this.b = component;
        this.c = optional;
        this.d = optional2;
        this.e = optional3;
        this.f = bl;
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ServerPing.class, "description;players;version;favicon;enforcesSecureChat", "b", "c", "d", "e", "f"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ServerPing.class, "description;players;version;favicon;enforcesSecureChat", "b", "c", "d", "e", "f"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ServerPing.class, "description;players;version;favicon;enforcesSecureChat", "b", "c", "d", "e", "f"}, this, object);
    }

    public IChatBaseComponent a() {
        return this.b;
    }

    public Optional<ServerPingPlayerSample> b() {
        return this.c;
    }

    public Optional<ServerData> c() {
        return this.d;
    }

    public Optional<a> d() {
        return this.e;
    }

    public boolean e() {
        return this.f;
    }

    public static final class ServerPingPlayerSample
    extends Record {
        private final int b;
        private final int c;
        private final List<GameProfile> d;
        private static final Codec<GameProfile> e = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.b.fieldOf("id").forGetter(GameProfile::getId), (App)Codec.STRING.fieldOf("name").forGetter(GameProfile::getName)).apply((Applicative)instance, GameProfile::new));
        public static final Codec<ServerPingPlayerSample> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("max").forGetter(ServerPingPlayerSample::a), (App)Codec.INT.fieldOf("online").forGetter(ServerPingPlayerSample::b), (App)e.listOf().optionalFieldOf("sample", List.of()).forGetter(ServerPingPlayerSample::c)).apply((Applicative)instance, ServerPingPlayerSample::new));

        public ServerPingPlayerSample(int max, int online, List<GameProfile> list) {
            this.b = max;
            this.c = online;
            this.d = list;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ServerPingPlayerSample.class, "max;online;sample", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ServerPingPlayerSample.class, "max;online;sample", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ServerPingPlayerSample.class, "max;online;sample", "b", "c", "d"}, this, object);
        }

        public int a() {
            return this.b;
        }

        public int b() {
            return this.c;
        }

        public List<GameProfile> c() {
            return this.d;
        }
    }

    public record ServerData(String b, int c) {
        public static final Codec<ServerData> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(ServerData::b), (App)Codec.INT.fieldOf("protocol").forGetter(ServerData::c)).apply((Applicative)instance, ServerData::new));

        public static ServerData a() {
            WorldVersion worldVersion = SharedConstants.b();
            return new ServerData(worldVersion.c(), worldVersion.e());
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ServerData.class, "name;protocol", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ServerData.class, "name;protocol", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ServerData.class, "name;protocol", "b", "c"}, this, object);
        }
    }

    public static final class a
    extends Record {
        private final byte[] d;
        public static final int a = 64;
        public static final int b = 64;
        private static final String e = "data:image/png;base64,";
        public static final Codec<a> c = Codec.STRING.comapFlatMap(uri -> {
            if (!uri.startsWith(e)) {
                return DataResult.error(() -> "Unknown format");
            }
            try {
                String string = uri.substring(e.length()).replaceAll("\n", "");
                byte[] bs = Base64.getDecoder().decode(string.getBytes(StandardCharsets.UTF_8));
                return DataResult.success((Object)new a(bs));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return DataResult.error(() -> "Malformed base64 server icon");
            }
        }, iconBytes -> e + new String(Base64.getEncoder().encode(iconBytes.d), StandardCharsets.UTF_8));

        public a(byte[] bs) {
            this.d = bs;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "iconBytes", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "iconBytes", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "iconBytes", "d"}, this, object);
        }

        public byte[] a() {
            return this.d;
        }
    }
}

