/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import com.mojang.logging.LogUtils;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;

public class DataWatcher {
    private static final Logger a = LogUtils.getLogger();
    private static final Object2IntMap<Class<? extends Entity>> b = new Object2IntOpenHashMap();
    private static final int c = 254;
    private final Entity d;
    private final Int2ObjectMap<Item<?>> e = new Int2ObjectOpenHashMap();
    private boolean g;
    public boolean registrationLocked;

    public DataWatcher(Entity trackedEntity) {
        this.d = trackedEntity;
    }

    public static <T> DataWatcherObject<T> a(Class<? extends Entity> entityClass, DataWatcherSerializer<T> dataHandler) {
        int i2;
        if (a.isDebugEnabled()) {
            try {
                Class<?> oclass1 = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!oclass1.equals(entityClass)) {
                    a.debug("defineId called for: {} from {}", new Object[]{entityClass, oclass1, new RuntimeException()});
                }
            }
            catch (ClassNotFoundException oclass1) {
                // empty catch block
            }
        }
        if (b.containsKey(entityClass)) {
            i2 = b.getInt(entityClass) + 1;
        } else {
            int j2 = 0;
            Class<? extends Entity> oclass2 = entityClass;
            while (oclass2 != Entity.class) {
                if (!b.containsKey(oclass2 = oclass2.getSuperclass())) continue;
                j2 = b.getInt(oclass2) + 1;
                break;
            }
            i2 = j2;
        }
        if (i2 > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + i2 + "! (Max is 254)");
        }
        b.put(entityClass, i2);
        return dataHandler.a(i2);
    }

    public <T> void a(DataWatcherObject<T> key, T initialValue) {
        if (this.registrationLocked) {
            throw new IllegalStateException("Registering datawatcher object after entity initialization");
        }
        int i2 = key.a();
        if (i2 > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + i2 + "! (Max is 254)");
        }
        if (this.e.containsKey(i2)) {
            throw new IllegalArgumentException("Duplicate id value for " + i2 + "!");
        }
        if (DataWatcherRegistry.b(key.b()) < 0) {
            DataWatcherSerializer<T> datawatcherserializer = key.b();
            throw new IllegalArgumentException("Unregistered serializer " + datawatcherserializer + " for " + i2 + "!");
        }
        this.c(key, initialValue);
    }

    private <T> void c(DataWatcherObject<T> key, T value) {
        Item<T> datawatcher_item = new Item<T>(key, value);
        this.e.put(key.a(), datawatcher_item);
    }

    private <T> Item<T> b(DataWatcherObject<T> key) {
        return (Item)this.e.get(key.a());
    }

    public <T> T a(DataWatcherObject<T> data) {
        return this.b(data).b();
    }

    public <T> void b(DataWatcherObject<T> key, T value) {
        this.a(key, value, false);
    }

    public <T> void a(DataWatcherObject<T> key, T value, boolean force) {
        Item<T> datawatcher_item = this.b(key);
        if (force || ObjectUtils.notEqual(value, datawatcher_item.b())) {
            datawatcher_item.a(value);
            this.d.a(key);
            datawatcher_item.a(true);
            this.g = true;
        }
    }

    public <T> void markDirty(DataWatcherObject<T> datawatcherobject) {
        this.b(datawatcherobject).a(true);
        this.g = true;
    }

    public boolean a() {
        return this.g;
    }

    @Nullable
    public List<b<?>> b() {
        ArrayList list = null;
        if (this.g) {
            for (Item datawatcher_item : this.e.values()) {
                if (!datawatcher_item.c()) continue;
                datawatcher_item.a(false);
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(datawatcher_item.e());
            }
        }
        this.g = false;
        return list;
    }

    @Nullable
    public List<b<?>> c() {
        ArrayList list = null;
        for (Item datawatcher_item : this.e.values()) {
            if (datawatcher_item.d()) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(datawatcher_item.e());
        }
        return list;
    }

    public void a(List<b<?>> entries) {
        for (b<?> datawatcher_b : entries) {
            Item datawatcher_item = (Item)this.e.get(datawatcher_b.a);
            if (datawatcher_item == null) continue;
            this.a(datawatcher_item, datawatcher_b);
            this.d.a(datawatcher_item.a());
        }
        this.d.a(entries);
    }

    private <T> void a(Item<T> to, b<?> from) {
        if (!Objects.equals(from.b(), to.a.b())) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Invalid entity data item type for field %d on entity %s: old=%s(%s), new=%s(%s)", to.a.a(), this.d, to.b, to.b.getClass(), from.c, from.c.getClass()));
        }
        to.a(from.c);
    }

    public boolean d() {
        return this.e.isEmpty();
    }

    public void refresh(EntityPlayer to) {
        List<b<?>> list;
        if (!this.d() && (list = this.packAll()) != null && to.getBukkitEntity().canSee(this.d.getBukkitEntity())) {
            to.b.a(new PacketPlayOutEntityMetadata(this.d.af(), list));
        }
    }

    @Nullable
    private List<b<?>> packAll() {
        if (this.d()) {
            return null;
        }
        ArrayList list = new ArrayList();
        for (Item dataItem : this.e.values()) {
            list.add(dataItem.e());
        }
        return list;
    }

    public void resendPossiblyDesyncedEntity(EntityPlayer player) {
        if (this.d.tracker == null) {
            return;
        }
        EntityTrackerEntry serverEntity = this.d.tracker.b;
        if (player.getBukkitEntity().canSee(this.d.getBukkitEntity())) {
            serverEntity.sendPairingData(player.b::a, player);
        }
    }

    public static class Item<T> {
        final DataWatcherObject<T> a;
        T b;
        private final T c;
        private boolean d;

        public Item(DataWatcherObject<T> data, T value) {
            this.a = data;
            this.c = value;
            this.b = value;
        }

        public DataWatcherObject<T> a() {
            return this.a;
        }

        public void a(T value) {
            this.b = value;
        }

        public T b() {
            return this.b;
        }

        public boolean c() {
            return this.d;
        }

        public void a(boolean dirty) {
            this.d = dirty;
        }

        public boolean d() {
            return this.c.equals(this.b);
        }

        public b<T> e() {
            return net.minecraft.network.syncher.DataWatcher$b.a(this.a, this.b);
        }
    }

    public record b<T>(int a, DataWatcherSerializer<T> b, T c) {
        public static <T> b<T> a(DataWatcherObject<T> data, T value) {
            DataWatcherSerializer<T> datawatcherserializer = data.b();
            return new b<T>(data.a(), datawatcherserializer, datawatcherserializer.a(value));
        }

        public void a(PacketDataSerializer buf) {
            int i2 = DataWatcherRegistry.b(this.b);
            if (i2 < 0) {
                throw new EncoderException("Unknown serializer type " + this.b);
            }
            buf.writeByte(this.a);
            buf.d(i2);
            this.b.a(buf, this.c);
        }

        public static b<?> a(PacketDataSerializer buf, int id) {
            int j2 = buf.m();
            DataWatcherSerializer<?> datawatcherserializer = DataWatcherRegistry.a(j2);
            if (datawatcherserializer == null) {
                throw new DecoderException("Unknown serializer type " + j2);
            }
            return net.minecraft.network.syncher.DataWatcher$b.a(buf, id, datawatcherserializer);
        }

        private static <T> b<T> a(PacketDataSerializer buf, int id, DataWatcherSerializer<T> handler) {
            return new b<PacketDataSerializer>(id, handler, handler.a(buf));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "id;serializer;value", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "id;serializer;value", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "id;serializer;value", "a", "b", "c"}, this, o2);
        }
    }
}

