/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatDecoration;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.slf4j.Logger;

public class RegistryDataLoader {
    private static final Logger c = LogUtils.getLogger();
    public static final List<b<?>> a = List.of(new b<DimensionManager>(Registries.as, DimensionManager.h), new b<BiomeBase>(Registries.an, BiomeBase.a), new b<ChatMessageType>(Registries.ao, ChatMessageType.a), new b(Registries.ap, WorldGenCarverWrapper.a), new b(Registries.aq, WorldGenFeatureConfigured.a), new b<PlacedFeature>(Registries.aw, PlacedFeature.a), new b<Structure>(Registries.ax, Structure.a), new b<StructureSet>(Registries.az, StructureSet.a), new b<ProcessorList>(Registries.ay, DefinedStructureStructureProcessorType.m), new b<WorldGenFeatureDefinedStructurePoolTemplate>(Registries.aA, WorldGenFeatureDefinedStructurePoolTemplate.a), new b<GeneratorSettingBase>(Registries.au, GeneratorSettingBase.a), new b<NoiseGeneratorNormal.a>(Registries.av, NoiseGeneratorNormal.a.a), new b<DensityFunction>(Registries.ar, DensityFunction.b), new b<WorldPreset>(Registries.aD, WorldPreset.a), new b<FlatLevelGeneratorPreset>(Registries.at, FlatLevelGeneratorPreset.a), new b<TrimPattern>(Registries.aC, TrimPattern.a), new b<TrimMaterial>(Registries.aB, TrimMaterial.a), new b<DamageType>(Registries.o, DamageType.a), new b<MultiNoiseBiomeSourceParameterList>(Registries.aE, MultiNoiseBiomeSourceParameterList.a));
    public static final List<b<?>> b = List.of(new b<WorldDimension>(Registries.aG, WorldDimension.a));

    public static IRegistryCustom.Dimension a(IResourceManager resourceManager, IRegistryCustom baseRegistryManager, List<b<?>> entries) {
        HashMap map = new HashMap();
        List<Pair<IRegistryWritable<?>, a>> list = entries.stream().map(entry -> entry.a(Lifecycle.stable(), map)).toList();
        RegistryOps.b registryInfoLookup = RegistryDataLoader.a(baseRegistryManager, list);
        list.forEach(loader -> {
            ((a)loader.getSecond()).load(resourceManager, registryInfoLookup);
            if (((IRegistryWritable)loader.getFirst()).c() == Registries.ao) {
                IRegistry.a((IRegistry)loader.getFirst(), ChatMessageType.RAW, new ChatMessageType(new ChatDecoration("%s", List.of(ChatDecoration.a.c), ChatModifier.a), new ChatDecoration("%s", List.of(ChatDecoration.a.c), ChatModifier.a)));
            }
        });
        list.forEach(loader -> {
            IRegistry registry = (IRegistry)loader.getFirst();
            try {
                registry.l();
            }
            catch (Exception var4) {
                map.put(registry.c(), var4);
            }
        });
        if (!map.isEmpty()) {
            RegistryDataLoader.a(map);
            throw new IllegalStateException("Failed to load registries due to above errors");
        }
        return new IRegistryCustom.c(list.stream().map(Pair::getFirst).toList()).c();
    }

    private static RegistryOps.b a(IRegistryCustom baseRegistryManager, List<Pair<IRegistryWritable<?>, a>> additionalRegistries) {
        final HashMap map = new HashMap();
        baseRegistryManager.b().forEach(entry -> map.put(entry.a(), RegistryDataLoader.a(entry.b())));
        additionalRegistries.forEach(pair -> map.put(((IRegistryWritable)pair.getFirst()).c(), RegistryDataLoader.a((IRegistryWritable)pair.getFirst())));
        return new RegistryOps.b(){

            @Override
            public <T> Optional<RegistryOps.a<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryRef) {
                return Optional.ofNullable((RegistryOps.a)map.get(registryRef));
            }
        };
    }

    private static <T> RegistryOps.a<T> a(IRegistryWritable<T> registry) {
        return new RegistryOps.a(registry.p(), registry.n(), registry.d());
    }

    private static <T> RegistryOps.a<T> a(IRegistry<T> registry) {
        return new RegistryOps.a<T>(registry.p(), registry.u(), registry.d());
    }

    private static void a(Map<ResourceKey<?>, Exception> exceptions) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Map<MinecraftKey, Map<MinecraftKey, Exception>> map = exceptions.entrySet().stream().collect(Collectors.groupingBy(entry -> ((ResourceKey)entry.getKey()).b(), Collectors.toMap(entry -> ((ResourceKey)entry.getKey()).a(), Map.Entry::getValue)));
        map.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            printWriter.printf("> Errors in registry %s:%n", entry.getKey());
            ((Map)entry.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(elementEntry -> {
                printWriter.printf(">> Errors in element %s:%n", elementEntry.getKey());
                ((Exception)elementEntry.getValue()).printStackTrace(printWriter);
            });
        });
        printWriter.flush();
        c.error("Registry loading errors:\n{}", (Object)stringWriter);
    }

    private static String a(MinecraftKey id) {
        return id.a();
    }

    static <E> void a(RegistryOps.b registryInfoGetter, IResourceManager resourceManager, ResourceKey<? extends IRegistry<E>> registryRef, IRegistryWritable<E> newRegistry, Decoder<E> decoder, Map<ResourceKey<?>, Exception> exceptions) {
        String string = RegistryDataLoader.a(registryRef.a());
        FileToIdConverter fileToIdConverter = FileToIdConverter.a(string);
        RegistryOps registryOps = RegistryOps.a(JsonOps.INSTANCE, registryInfoGetter);
        for (Map.Entry<MinecraftKey, IResource> entry : fileToIdConverter.a(resourceManager).entrySet()) {
            MinecraftKey resourceLocation = entry.getKey();
            ResourceKey resourceKey = ResourceKey.a(registryRef, fileToIdConverter.b(resourceLocation));
            IResource resource = entry.getValue();
            try {
                BufferedReader reader = resource.e();
                try {
                    JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                    DataResult dataResult = decoder.parse(registryOps, (Object)jsonElement);
                    Object object = dataResult.getOrThrow(false, error -> {});
                    newRegistry.a(resourceKey, object, resource.c() ? Lifecycle.stable() : dataResult.lifecycle());
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception var20) {
                exceptions.put(resourceKey, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse %s from pack %s", resourceLocation, resource.b()), var20));
            }
        }
    }

    static interface a {
        public void load(IResourceManager var1, RegistryOps.b var2);
    }

    public record b<T>(ResourceKey<? extends IRegistry<T>> a, Codec<T> b) {
        Pair<IRegistryWritable<?>, a> a(Lifecycle lifecycle, Map<ResourceKey<?>, Exception> exceptions) {
            RegistryMaterials writableRegistry = new RegistryMaterials(this.a, lifecycle);
            a loader = (resourceManager, registryInfoGetter) -> RegistryDataLoader.a(registryInfoGetter, resourceManager, this.a, writableRegistry, this.b, exceptions);
            return Pair.of(writableRegistry, (Object)loader);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "key;elementCodec", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "key;elementCodec", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "key;elementCodec", "a", "b"}, this, o2);
        }
    }
}

