/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.chase;

import com.google.common.base.Charsets;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.Socket;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Scanner;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.ChaseCommand;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class ChaseClient {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 5;
    private final String c;
    private final int d;
    private final MinecraftServer e;
    private volatile boolean f;
    @Nullable
    private Socket g;
    @Nullable
    private Thread h;

    public ChaseClient(String ip, int port, MinecraftServer minecraftServer) {
        this.c = ip;
        this.d = port;
        this.e = minecraftServer;
    }

    public void a() {
        if (this.h != null && this.h.isAlive()) {
            a.warn("Remote control client was asked to start, but it is already running. Will ignore.");
        }
        this.f = true;
        this.h = new Thread(this::c, "chase-client");
        this.h.setDaemon(true);
        this.h.start();
    }

    public void b() {
        this.f = false;
        IOUtils.closeQuietly((Socket)this.g);
        this.g = null;
        this.h = null;
    }

    public void c() {
        String string = this.c + ":" + this.d;
        while (this.f) {
            try {
                a.info("Connecting to remote control server {}", (Object)string);
                this.g = new Socket(this.c, this.d);
                a.info("Connected to remote control server! Will continuously execute the command broadcasted by that server.");
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.g.getInputStream(), Charsets.US_ASCII));){
                    while (this.f) {
                        String string2 = bufferedReader.readLine();
                        if (string2 == null) {
                            a.warn("Lost connection to remote control server {}. Will retry in {}s.", (Object)string, (Object)5);
                            break;
                        }
                        this.a(string2);
                    }
                }
                catch (IOException iOException) {
                    a.warn("Lost connection to remote control server {}. Will retry in {}s.", (Object)string, (Object)5);
                }
            }
            catch (IOException iOException2) {
                a.warn("Failed to connect to remote control server {}. Will retry in {}s.", (Object)string, (Object)5);
            }
            if (!this.f) continue;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void a(String message) {
        try (Scanner scanner = new Scanner(new StringReader(message));){
            scanner.useLocale(Locale.ROOT);
            String string = scanner.next();
            if ("t".equals(string)) {
                this.a(scanner);
            } else {
                a.warn("Unknown message type '{}'", (Object)string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            a.warn("Could not parse message '{}', ignoring", (Object)message);
        }
    }

    private void a(Scanner scanner) {
        this.b(scanner).ifPresent(pos -> this.b(String.format(Locale.ROOT, "execute in %s run tp @s %.3f %.3f %.3f %.3f %.3f", pos.a.a(), pos.b.c, pos.b.d, pos.b.e, Float.valueOf(pos.c.j), Float.valueOf(pos.c.i))));
    }

    private Optional<a> b(Scanner scanner) {
        ResourceKey resourceKey = (ResourceKey)ChaseCommand.a.get((Object)scanner.next());
        if (resourceKey == null) {
            return Optional.empty();
        }
        float f2 = scanner.nextFloat();
        float g2 = scanner.nextFloat();
        float h2 = scanner.nextFloat();
        float i2 = scanner.nextFloat();
        float j2 = scanner.nextFloat();
        return Optional.of(new a(resourceKey, new Vec3D(f2, g2, h2), new Vec2F(j2, i2)));
    }

    private void b(String command) {
        this.e.execute(() -> {
            List<EntityPlayer> list = this.e.ac().t();
            if (list.isEmpty()) {
                return;
            }
            EntityPlayer serverPlayer = list.get(0);
            WorldServer serverLevel = this.e.D();
            CommandListenerWrapper commandSourceStack = new CommandListenerWrapper(serverPlayer, Vec3D.a(serverLevel.Q()), Vec2F.a, serverLevel, 4, "", CommonComponents.a, this.e, serverPlayer);
            CommandDispatcher commands = this.e.aC();
            commands.a(commandSourceStack, command);
        });
    }

    record a(ResourceKey<World> a, Vec3D b, Vec2F c) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "level;pos;rot", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "level;pos;rot", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "level;pos;rot", "a", "b", "c"}, this, object);
        }
    }
}

