/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentMathOperation;
import net.minecraft.commands.arguments.ArgumentScoreboardCriteria;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreboardSlot;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;

public class CommandScoreboard {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.scoreboard.objectives.add.duplicate"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.scoreboard.objectives.display.alreadyEmpty"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.scoreboard.objectives.display.alreadySet"));
    private static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.scoreboard.players.enable.failed"));
    private static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.scoreboard.players.enable.invalid"));
    private static final Dynamic2CommandExceptionType f = new Dynamic2CommandExceptionType((objective, target) -> IChatBaseComponent.a("commands.scoreboard.players.get.null", objective, target));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("scoreboard").requires(source -> source.c(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("objectives").then(net.minecraft.commands.CommandDispatcher.a("list").executes(context -> CommandScoreboard.b((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("add").then(net.minecraft.commands.CommandDispatcher.a("objective", StringArgumentType.word()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("criteria", ArgumentScoreboardCriteria.a()).executes(context -> CommandScoreboard.a((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"objective"), ArgumentScoreboardCriteria.a((CommandContext<CommandListenerWrapper>)context, "criteria"), IChatBaseComponent.b(StringArgumentType.getString((CommandContext)context, (String)"objective"))))).then(net.minecraft.commands.CommandDispatcher.a("displayName", ArgumentChatComponent.a()).executes(context -> CommandScoreboard.a((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"objective"), ArgumentScoreboardCriteria.a((CommandContext<CommandListenerWrapper>)context, "criteria"), ArgumentChatComponent.a((CommandContext<CommandListenerWrapper>)context, "displayName")))))))).then(net.minecraft.commands.CommandDispatcher.a("modify").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).then(net.minecraft.commands.CommandDispatcher.a("displayname").then(net.minecraft.commands.CommandDispatcher.a("displayName", ArgumentChatComponent.a()).executes(context -> CommandScoreboard.a((CommandListenerWrapper)context.getSource(), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context, "objective"), ArgumentChatComponent.a((CommandContext<CommandListenerWrapper>)context, "displayName")))))).then(CommandScoreboard.a())))).then(net.minecraft.commands.CommandDispatcher.a("remove").then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).executes(context -> CommandScoreboard.a((CommandListenerWrapper)context.getSource(), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context, "objective")))))).then(net.minecraft.commands.CommandDispatcher.a("setdisplay").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("slot", ArgumentScoreboardSlot.a()).executes(context -> CommandScoreboard.a((CommandListenerWrapper)context.getSource(), ArgumentScoreboardSlot.a((CommandContext<CommandListenerWrapper>)context, "slot")))).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).executes(context -> CommandScoreboard.a((CommandListenerWrapper)context.getSource(), ArgumentScoreboardSlot.a((CommandContext<CommandListenerWrapper>)context, "slot"), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context, "objective")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("players").then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("list").executes(context -> CommandScoreboard.a((CommandListenerWrapper)context.getSource()))).then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).executes(context -> CommandScoreboard.a((CommandListenerWrapper)context.getSource(), ArgumentScoreholder.a((CommandContext<CommandListenerWrapper>)context, "target")))))).then(net.minecraft.commands.CommandDispatcher.a("set").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).then(net.minecraft.commands.CommandDispatcher.a("score", IntegerArgumentType.integer()).executes(context -> CommandScoreboard.a((CommandListenerWrapper)context.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentScoreboardObjective.b((CommandContext<CommandListenerWrapper>)context, "objective"), IntegerArgumentType.getInteger((CommandContext)context, (String)"score")))))))).then(net.minecraft.commands.CommandDispatcher.a("get").then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentScoreholder.a()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).executes(context -> CommandScoreboard.a((CommandListenerWrapper)context.getSource(), ArgumentScoreholder.a((CommandContext<CommandListenerWrapper>)context, "target"), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context, "objective"))))))).then(net.minecraft.commands.CommandDispatcher.a("add").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).then(net.minecraft.commands.CommandDispatcher.a("score", IntegerArgumentType.integer((int)0)).executes(context -> CommandScoreboard.b((CommandListenerWrapper)context.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentScoreboardObjective.b((CommandContext<CommandListenerWrapper>)context, "objective"), IntegerArgumentType.getInteger((CommandContext)context, (String)"score")))))))).then(net.minecraft.commands.CommandDispatcher.a("remove").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).then(net.minecraft.commands.CommandDispatcher.a("score", IntegerArgumentType.integer((int)0)).executes(context -> CommandScoreboard.c((CommandListenerWrapper)context.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentScoreboardObjective.b((CommandContext<CommandListenerWrapper>)context, "objective"), IntegerArgumentType.getInteger((CommandContext)context, (String)"score")))))))).then(net.minecraft.commands.CommandDispatcher.a("reset").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).executes(context -> CommandScoreboard.a((CommandListenerWrapper)context.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)context, "targets")))).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).executes(context -> CommandScoreboard.b((CommandListenerWrapper)context.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context, "objective"))))))).then(net.minecraft.commands.CommandDispatcher.a("enable").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("objective", ArgumentScoreboardObjective.a()).suggests((context, builder) -> CommandScoreboard.a((CommandListenerWrapper)context.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)context, "targets"), builder)).executes(context -> CommandScoreboard.a((CommandListenerWrapper)context.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context, "objective"))))))).then(net.minecraft.commands.CommandDispatcher.a("operation").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("targetObjective", ArgumentScoreboardObjective.a()).then(net.minecraft.commands.CommandDispatcher.a("operation", ArgumentMathOperation.a()).then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentScoreholder.b()).suggests(ArgumentScoreholder.a).then(net.minecraft.commands.CommandDispatcher.a("sourceObjective", ArgumentScoreboardObjective.a()).executes(context -> CommandScoreboard.a((CommandListenerWrapper)context.getSource(), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)context, "targets"), ArgumentScoreboardObjective.b((CommandContext<CommandListenerWrapper>)context, "targetObjective"), ArgumentMathOperation.a((CommandContext<CommandListenerWrapper>)context, "operation"), ArgumentScoreholder.c((CommandContext<CommandListenerWrapper>)context, "source"), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context, "sourceObjective"))))))))))));
    }

    private static LiteralArgumentBuilder<CommandListenerWrapper> a() {
        LiteralArgumentBuilder<CommandListenerWrapper> literalArgumentBuilder = net.minecraft.commands.CommandDispatcher.a("rendertype");
        for (IScoreboardCriteria.EnumScoreboardHealthDisplay renderType : IScoreboardCriteria.EnumScoreboardHealthDisplay.values()) {
            literalArgumentBuilder.then(net.minecraft.commands.CommandDispatcher.a(renderType.a()).executes(context -> CommandScoreboard.a((CommandListenerWrapper)context.getSource(), ArgumentScoreboardObjective.a((CommandContext<CommandListenerWrapper>)context, "objective"), renderType)));
        }
        return literalArgumentBuilder;
    }

    private static CompletableFuture<Suggestions> a(CommandListenerWrapper source, Collection<String> targets, SuggestionsBuilder builder) {
        ArrayList list = Lists.newArrayList();
        ScoreboardServer scoreboard = source.l().aF();
        for (ScoreboardObjective objective : scoreboard.c()) {
            if (objective.c() != IScoreboardCriteria.b) continue;
            boolean bl = false;
            for (String string : targets) {
                if (scoreboard.b(string, objective) && !scoreboard.c(string, objective).g()) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            list.add(objective.b());
        }
        return ICompletionProvider.b(list, builder);
    }

    private static int a(CommandListenerWrapper source, String target, ScoreboardObjective objective) throws CommandSyntaxException {
        ScoreboardServer scoreboard = source.l().aF();
        if (!scoreboard.b(target, objective)) {
            throw f.create((Object)objective.b(), (Object)target);
        }
        ScoreboardScore score = scoreboard.c(target, objective);
        source.a(IChatBaseComponent.a("commands.scoreboard.players.get.success", new Object[]{target, score.b(), objective.e()}), false);
        return score.b();
    }

    private static int a(CommandListenerWrapper source, Collection<String> targets, ScoreboardObjective targetObjective, ArgumentMathOperation.a operation, Collection<String> sources, ScoreboardObjective sourceObjectives) throws CommandSyntaxException {
        ScoreboardServer scoreboard = source.l().aF();
        int i2 = 0;
        for (String string : targets) {
            ScoreboardScore score = scoreboard.c(string, targetObjective);
            for (String string2 : sources) {
                ScoreboardScore score2 = scoreboard.c(string2, sourceObjectives);
                operation.apply(score, score2);
            }
            i2 += score.b();
        }
        if (targets.size() == 1) {
            source.a(IChatBaseComponent.a("commands.scoreboard.players.operation.success.single", targetObjective.e(), targets.iterator().next(), i2), true);
        } else {
            source.a(IChatBaseComponent.a("commands.scoreboard.players.operation.success.multiple", targetObjective.e(), targets.size()), true);
        }
        return i2;
    }

    private static int a(CommandListenerWrapper source, Collection<String> targets, ScoreboardObjective objective) throws CommandSyntaxException {
        if (objective.c() != IScoreboardCriteria.b) {
            throw e.create();
        }
        ScoreboardServer scoreboard = source.l().aF();
        int i2 = 0;
        for (String string : targets) {
            ScoreboardScore score = scoreboard.c(string, objective);
            if (!score.g()) continue;
            score.a(false);
            ++i2;
        }
        if (i2 == 0) {
            throw d.create();
        }
        if (targets.size() == 1) {
            source.a(IChatBaseComponent.a("commands.scoreboard.players.enable.success.single", objective.e(), targets.iterator().next()), true);
        } else {
            source.a(IChatBaseComponent.a("commands.scoreboard.players.enable.success.multiple", objective.e(), targets.size()), true);
        }
        return i2;
    }

    private static int a(CommandListenerWrapper source, Collection<String> targets) {
        ScoreboardServer scoreboard = source.l().aF();
        for (String string : targets) {
            scoreboard.d(string, null);
        }
        if (targets.size() == 1) {
            source.a(IChatBaseComponent.a("commands.scoreboard.players.reset.all.single", new Object[]{targets.iterator().next()}), true);
        } else {
            source.a(IChatBaseComponent.a("commands.scoreboard.players.reset.all.multiple", targets.size()), true);
        }
        return targets.size();
    }

    private static int b(CommandListenerWrapper source, Collection<String> targets, ScoreboardObjective objective) {
        ScoreboardServer scoreboard = source.l().aF();
        for (String string : targets) {
            scoreboard.d(string, objective);
        }
        if (targets.size() == 1) {
            source.a(IChatBaseComponent.a("commands.scoreboard.players.reset.specific.single", objective.e(), targets.iterator().next()), true);
        } else {
            source.a(IChatBaseComponent.a("commands.scoreboard.players.reset.specific.multiple", objective.e(), targets.size()), true);
        }
        return targets.size();
    }

    private static int a(CommandListenerWrapper source, Collection<String> targets, ScoreboardObjective objective, int score) {
        ScoreboardServer scoreboard = source.l().aF();
        for (String string : targets) {
            ScoreboardScore score2 = scoreboard.c(string, objective);
            score2.b(score);
        }
        if (targets.size() == 1) {
            source.a(IChatBaseComponent.a("commands.scoreboard.players.set.success.single", objective.e(), targets.iterator().next(), score), true);
        } else {
            source.a(IChatBaseComponent.a("commands.scoreboard.players.set.success.multiple", objective.e(), targets.size(), score), true);
        }
        return score * targets.size();
    }

    private static int b(CommandListenerWrapper source, Collection<String> targets, ScoreboardObjective objective, int score) {
        ScoreboardServer scoreboard = source.l().aF();
        int i2 = 0;
        for (String string : targets) {
            ScoreboardScore score2 = scoreboard.c(string, objective);
            score2.b(score2.b() + score);
            i2 += score2.b();
        }
        if (targets.size() == 1) {
            source.a(IChatBaseComponent.a("commands.scoreboard.players.add.success.single", score, objective.e(), targets.iterator().next(), i2), true);
        } else {
            source.a(IChatBaseComponent.a("commands.scoreboard.players.add.success.multiple", score, objective.e(), targets.size()), true);
        }
        return i2;
    }

    private static int c(CommandListenerWrapper source, Collection<String> targets, ScoreboardObjective objective, int score) {
        ScoreboardServer scoreboard = source.l().aF();
        int i2 = 0;
        for (String string : targets) {
            ScoreboardScore score2 = scoreboard.c(string, objective);
            score2.b(score2.b() - score);
            i2 += score2.b();
        }
        if (targets.size() == 1) {
            source.a(IChatBaseComponent.a("commands.scoreboard.players.remove.success.single", score, objective.e(), targets.iterator().next(), i2), true);
        } else {
            source.a(IChatBaseComponent.a("commands.scoreboard.players.remove.success.multiple", score, objective.e(), targets.size()), true);
        }
        return i2;
    }

    private static int a(CommandListenerWrapper source) {
        Collection<String> collection = source.l().aF().e();
        if (collection.isEmpty()) {
            source.a(IChatBaseComponent.c("commands.scoreboard.players.list.empty"), false);
        } else {
            source.a(IChatBaseComponent.a("commands.scoreboard.players.list.success", collection.size(), ChatComponentUtils.a(collection)), false);
        }
        return collection.size();
    }

    private static int a(CommandListenerWrapper source, String target) {
        Map<ScoreboardObjective, ScoreboardScore> map = source.l().aF().e(target);
        if (map.isEmpty()) {
            source.a(IChatBaseComponent.a("commands.scoreboard.players.list.entity.empty", new Object[]{target}), false);
        } else {
            source.a(IChatBaseComponent.a("commands.scoreboard.players.list.entity.success", new Object[]{target, map.size()}), false);
            for (Map.Entry<ScoreboardObjective, ScoreboardScore> entry : map.entrySet()) {
                source.a(IChatBaseComponent.a("commands.scoreboard.players.list.entity.entry", entry.getKey().e(), entry.getValue().b()), false);
            }
        }
        return map.size();
    }

    private static int a(CommandListenerWrapper source, int slot) throws CommandSyntaxException {
        ScoreboardServer scoreboard = source.l().aF();
        if (scoreboard.a(slot) == null) {
            throw b.create();
        }
        ((Scoreboard)scoreboard).a(slot, null);
        source.a(IChatBaseComponent.a("commands.scoreboard.objectives.display.cleared", new Object[]{Scoreboard.h()[slot]}), true);
        return 0;
    }

    private static int a(CommandListenerWrapper source, int slot, ScoreboardObjective objective) throws CommandSyntaxException {
        ScoreboardServer scoreboard = source.l().aF();
        if (scoreboard.a(slot) == objective) {
            throw c.create();
        }
        ((Scoreboard)scoreboard).a(slot, objective);
        source.a(IChatBaseComponent.a("commands.scoreboard.objectives.display.set", new Object[]{Scoreboard.h()[slot], objective.d()}), true);
        return 0;
    }

    private static int a(CommandListenerWrapper source, ScoreboardObjective objective, IChatBaseComponent displayName) {
        if (!objective.d().equals(displayName)) {
            objective.a(displayName);
            source.a(IChatBaseComponent.a("commands.scoreboard.objectives.modify.displayname", new Object[]{objective.b(), objective.e()}), true);
        }
        return 0;
    }

    private static int a(CommandListenerWrapper source, ScoreboardObjective objective, IScoreboardCriteria.EnumScoreboardHealthDisplay type) {
        if (objective.f() != type) {
            objective.a(type);
            source.a(IChatBaseComponent.a("commands.scoreboard.objectives.modify.rendertype", objective.e()), true);
        }
        return 0;
    }

    private static int a(CommandListenerWrapper source, ScoreboardObjective objective) {
        ScoreboardServer scoreboard = source.l().aF();
        scoreboard.j(objective);
        source.a(IChatBaseComponent.a("commands.scoreboard.objectives.remove.success", objective.e()), true);
        return scoreboard.c().size();
    }

    private static int a(CommandListenerWrapper source, String objective, IScoreboardCriteria criteria, IChatBaseComponent displayName) throws CommandSyntaxException {
        ScoreboardServer scoreboard = source.l().aF();
        if (scoreboard.d(objective) != null) {
            throw a.create();
        }
        scoreboard.a(objective, criteria, displayName, criteria.f());
        ScoreboardObjective objective2 = scoreboard.d(objective);
        source.a(IChatBaseComponent.a("commands.scoreboard.objectives.add.success", objective2.e()), true);
        return scoreboard.c().size();
    }

    private static int b(CommandListenerWrapper source) {
        Collection<ScoreboardObjective> collection = source.l().aF().c();
        if (collection.isEmpty()) {
            source.a(IChatBaseComponent.c("commands.scoreboard.objectives.list.empty"), false);
        } else {
            source.a(IChatBaseComponent.a("commands.scoreboard.objectives.list.success", collection.size(), ChatComponentUtils.b(collection, ScoreboardObjective::e)), false);
        }
        return collection.size();
    }
}

