/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentNBTBase;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.data.CommandDataAccessor;
import net.minecraft.server.commands.data.CommandDataAccessorEntity;
import net.minecraft.server.commands.data.CommandDataAccessorTile;
import net.minecraft.server.commands.data.CommandDataStorage;
import net.minecraft.util.MathHelper;

public class CommandData {
    private static final SimpleCommandExceptionType d = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.data.merge.failed"));
    private static final DynamicCommandExceptionType e = new DynamicCommandExceptionType(path -> IChatBaseComponent.a("commands.data.get.invalid", path));
    private static final DynamicCommandExceptionType f = new DynamicCommandExceptionType(path -> IChatBaseComponent.a("commands.data.get.unknown", path));
    private static final SimpleCommandExceptionType g = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.data.get.multiple"));
    private static final DynamicCommandExceptionType h = new DynamicCommandExceptionType(nbt -> IChatBaseComponent.a("commands.data.modify.expected_object", nbt));
    private static final DynamicCommandExceptionType i = new DynamicCommandExceptionType(nbt -> IChatBaseComponent.a("commands.data.modify.expected_value", nbt));
    public static final List<Function<String, c>> a = ImmutableList.of(CommandDataAccessorEntity.a, CommandDataAccessorTile.a, CommandDataStorage.a);
    public static final List<c> b = (List)a.stream().map(factory -> (c)factory.apply("target")).collect(ImmutableList.toImmutableList());
    public static final List<c> c = (List)a.stream().map(factory -> (c)factory.apply("source")).collect(ImmutableList.toImmutableList());

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("data").requires(source -> source.c(2));
        for (c dataProvider : b) {
            ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalArgumentBuilder.then(dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("merge"), builder -> builder.then(net.minecraft.commands.CommandDispatcher.a("nbt", ArgumentNBTTag.a()).executes(context -> CommandData.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTTag.a(context, "nbt"))))))).then(dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("get"), builder -> ((ArgumentBuilder)builder.executes(context -> CommandData.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context)))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("path", ArgumentNBTKey.a()).executes(context -> CommandData.b((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path")))).then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).executes(context -> CommandData.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"), DoubleArgumentType.getDouble((CommandContext)context, (String)"scale")))))))).then(dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("remove"), builder -> builder.then(net.minecraft.commands.CommandDispatcher.a("path", ArgumentNBTKey.a()).executes(context -> CommandData.a((CommandListenerWrapper)context.getSource(), dataProvider.a((CommandContext<CommandListenerWrapper>)context), ArgumentNBTKey.a((CommandContext<CommandListenerWrapper>)context, "path"))))))).then(CommandData.a((ArgumentBuilder<CommandListenerWrapper, ?> builder, b modifier) -> ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)builder.then(net.minecraft.commands.CommandDispatcher.a("insert").then(net.minecraft.commands.CommandDispatcher.a("index", IntegerArgumentType.integer()).then(modifier.create((context, sourceNbt, path, elements) -> path.a(IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), sourceNbt, elements)))))).then(net.minecraft.commands.CommandDispatcher.a("prepend").then(modifier.create((context, compoundTag, path, elements) -> path.a(0, compoundTag, elements))))).then(net.minecraft.commands.CommandDispatcher.a("append").then(modifier.create((context, compoundTag, path, elements) -> path.a(-1, compoundTag, elements))))).then(net.minecraft.commands.CommandDispatcher.a("set").then(modifier.create((context, sourceNbt, path, elements) -> path.a((NBTBase)sourceNbt, (NBTBase)Iterables.getLast((Iterable)elements)))))).then(net.minecraft.commands.CommandDispatcher.a("merge").then(modifier.create((context, element, path, elements) -> {
                NBTTagCompound compoundTag = new NBTTagCompound();
                for (NBTBase tag : elements) {
                    if (ArgumentNBTKey.g.a(tag, 0)) {
                        throw ArgumentNBTKey.b.create();
                    }
                    if (tag instanceof NBTTagCompound) {
                        NBTTagCompound compoundTag2 = (NBTTagCompound)tag;
                        compoundTag.a(compoundTag2);
                        continue;
                    }
                    throw h.create((Object)tag);
                }
                List<NBTBase> collection = path.a((NBTBase)element, NBTTagCompound::new);
                int i2 = 0;
                for (NBTBase tag2 : collection) {
                    void compoundTag4;
                    if (!(tag2 instanceof NBTTagCompound)) {
                        throw h.create((Object)tag2);
                    }
                    NBTTagCompound compoundTag3 = (NBTTagCompound)tag2;
                    NBTTagCompound compoundTag5 = compoundTag4.h();
                    compoundTag4.a(compoundTag);
                    i2 += compoundTag5.equals(compoundTag4) ? 0 : 1;
                }
                return i2;
            })))));
        }
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)literalArgumentBuilder);
    }

    private static String a(NBTBase nbt) throws CommandSyntaxException {
        if (nbt.c().d()) {
            return nbt.f_();
        }
        throw i.create((Object)nbt);
    }

    private static List<NBTBase> a(List<NBTBase> list, Function<String, String> function) throws CommandSyntaxException {
        ArrayList<NBTBase> list2 = new ArrayList<NBTBase>(list.size());
        for (NBTBase tag : list) {
            String string = CommandData.a(tag);
            list2.add(NBTTagString.a(function.apply(string)));
        }
        return list2;
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(BiConsumer<ArgumentBuilder<CommandListenerWrapper, ?>, b> subArgumentAdder) {
        LiteralArgumentBuilder<CommandListenerWrapper> literalArgumentBuilder = net.minecraft.commands.CommandDispatcher.a("modify");
        for (c dataProvider : b) {
            dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)literalArgumentBuilder, builder -> {
                RequiredArgumentBuilder<CommandListenerWrapper, ArgumentNBTKey.g> argumentBuilder = net.minecraft.commands.CommandDispatcher.a("targetPath", ArgumentNBTKey.a());
                for (c dataProvider2 : c) {
                    subArgumentAdder.accept((ArgumentBuilder<CommandListenerWrapper, ?>)argumentBuilder, operation -> dataProvider2.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("from"), builder -> ((ArgumentBuilder)builder.executes(context -> CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider, operation, CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider2)))).then(net.minecraft.commands.CommandDispatcher.a("sourcePath", ArgumentNBTKey.a()).executes(context -> CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider, operation, CommandData.b((CommandContext<CommandListenerWrapper>)context, dataProvider2))))));
                    subArgumentAdder.accept((ArgumentBuilder<CommandListenerWrapper, ?>)argumentBuilder, operation -> dataProvider2.a((ArgumentBuilder<CommandListenerWrapper, ?>)net.minecraft.commands.CommandDispatcher.a("string"), builder -> ((ArgumentBuilder)builder.executes(context -> CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider, operation, CommandData.a(CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider2), (String value) -> value)))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sourcePath", ArgumentNBTKey.a()).executes(context -> CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider, operation, CommandData.a(CommandData.b((CommandContext<CommandListenerWrapper>)context, dataProvider2), (String value) -> value)))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("start", IntegerArgumentType.integer((int)0)).executes(context -> CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider, operation, CommandData.a(CommandData.b((CommandContext<CommandListenerWrapper>)context, dataProvider2), (String value) -> value.substring(IntegerArgumentType.getInteger((CommandContext)context, (String)"start")))))).then(net.minecraft.commands.CommandDispatcher.a("end", IntegerArgumentType.integer((int)0)).executes(context -> CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider, operation, CommandData.a(CommandData.b((CommandContext<CommandListenerWrapper>)context, dataProvider2), (String value) -> value.substring(IntegerArgumentType.getInteger((CommandContext)context, (String)"start"), IntegerArgumentType.getInteger((CommandContext)context, (String)"end"))))))))));
                }
                subArgumentAdder.accept((ArgumentBuilder<CommandListenerWrapper, ?>)argumentBuilder, modifier -> net.minecraft.commands.CommandDispatcher.a("value").then(net.minecraft.commands.CommandDispatcher.a("value", ArgumentNBTBase.a()).executes(context -> {
                    List<NBTBase> list = Collections.singletonList(ArgumentNBTBase.a(context, "value"));
                    return CommandData.a((CommandContext<CommandListenerWrapper>)context, dataProvider, modifier, list);
                })));
                return builder.then(argumentBuilder);
            });
        }
        return literalArgumentBuilder;
    }

    private static List<NBTBase> a(CommandContext<CommandListenerWrapper> context, c objectType) throws CommandSyntaxException {
        CommandDataAccessor dataAccessor = objectType.a(context);
        return Collections.singletonList(dataAccessor.a());
    }

    private static List<NBTBase> b(CommandContext<CommandListenerWrapper> context, c objectType) throws CommandSyntaxException {
        CommandDataAccessor dataAccessor = objectType.a(context);
        ArgumentNBTKey.g nbtPath = ArgumentNBTKey.a(context, "sourcePath");
        return nbtPath.a(dataAccessor.a());
    }

    private static int a(CommandContext<CommandListenerWrapper> context, c objectType, a modifier, List<NBTBase> elements) throws CommandSyntaxException {
        CommandDataAccessor dataAccessor = objectType.a(context);
        ArgumentNBTKey.g nbtPath = ArgumentNBTKey.a(context, "targetPath");
        NBTTagCompound compoundTag = dataAccessor.a();
        int i2 = modifier.modify(context, compoundTag, nbtPath, elements);
        if (i2 == 0) {
            throw d.create();
        }
        dataAccessor.a(compoundTag);
        ((CommandListenerWrapper)context.getSource()).a(dataAccessor.b(), true);
        return i2;
    }

    private static int a(CommandListenerWrapper source, CommandDataAccessor object, ArgumentNBTKey.g path) throws CommandSyntaxException {
        NBTTagCompound compoundTag = object.a();
        int i2 = path.c(compoundTag);
        if (i2 == 0) {
            throw d.create();
        }
        object.a(compoundTag);
        source.a(object.b(), true);
        return i2;
    }

    private static NBTBase a(ArgumentNBTKey.g path, CommandDataAccessor object) throws CommandSyntaxException {
        List<NBTBase> collection = path.a(object.a());
        Iterator iterator = collection.iterator();
        NBTBase tag = (NBTBase)iterator.next();
        if (iterator.hasNext()) {
            throw g.create();
        }
        return tag;
    }

    /*
     * WARNING - void declaration
     */
    private static int b(CommandListenerWrapper source, CommandDataAccessor object, ArgumentNBTKey.g path) throws CommandSyntaxException {
        void m2;
        NBTBase tag = CommandData.a(path, object);
        if (tag instanceof NBTNumber) {
            int i2 = MathHelper.a(((NBTNumber)tag).j());
        } else if (tag instanceof NBTList) {
            int j2 = ((NBTList)tag).size();
        } else if (tag instanceof NBTTagCompound) {
            int k2 = ((NBTTagCompound)tag).f();
        } else if (tag instanceof NBTTagString) {
            int l2 = tag.f_().length();
        } else {
            throw f.create((Object)path.toString());
        }
        source.a(object.a(tag), false);
        return (int)m2;
    }

    private static int a(CommandListenerWrapper source, CommandDataAccessor object, ArgumentNBTKey.g path, double scale) throws CommandSyntaxException {
        NBTBase tag = CommandData.a(path, object);
        if (!(tag instanceof NBTNumber)) {
            throw e.create((Object)path.toString());
        }
        int i2 = MathHelper.a(((NBTNumber)tag).j() * scale);
        source.a(object.a(path, scale, i2), false);
        return i2;
    }

    private static int a(CommandListenerWrapper source, CommandDataAccessor object) throws CommandSyntaxException {
        source.a(object.a((NBTBase)object.a()), false);
        return 1;
    }

    private static int a(CommandListenerWrapper source, CommandDataAccessor object, NBTTagCompound nbt) throws CommandSyntaxException {
        NBTTagCompound compoundTag = object.a();
        if (ArgumentNBTKey.g.a(nbt, 0)) {
            throw ArgumentNBTKey.b.create();
        }
        NBTTagCompound compoundTag2 = compoundTag.h().a(nbt);
        if (compoundTag.equals(compoundTag2)) {
            throw d.create();
        }
        object.a(compoundTag2);
        source.a(object.b(), true);
        return 1;
    }

    public static interface c {
        public CommandDataAccessor a(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;

        public ArgumentBuilder<CommandListenerWrapper, ?> a(ArgumentBuilder<CommandListenerWrapper, ?> var1, Function<ArgumentBuilder<CommandListenerWrapper, ?>, ArgumentBuilder<CommandListenerWrapper, ?>> var2);
    }

    static interface a {
        public int modify(CommandContext<CommandListenerWrapper> var1, NBTTagCompound var2, ArgumentNBTKey.g var3, List<NBTBase> var4) throws CommandSyntaxException;
    }

    static interface b {
        public ArgumentBuilder<CommandListenerWrapper, ?> create(a var1);
    }
}

