/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import co.aikar.timings.Timing;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.io.SyncLoadFinder;
import com.destroystokyo.paper.util.concurrent.WeakSeqLock;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.ChunkSystem;
import io.papermc.paper.chunk.system.scheduling.ChunkTaskScheduler;
import io.papermc.paper.chunk.system.scheduling.NewChunkHolder;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.maplist.IteratorSafeOrderedReferenceSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.slf4j.Logger;
import top.leavesmc.leaves.LeavesConfig;

public class ChunkProviderServer
extends IChunkProvider {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final List<ChunkStatus> b = ChunkStatus.a();
    private final ChunkMapDistance c;
    final WorldServer d;
    public final Thread e;
    final LightEngineThreaded f;
    public final b g;
    public final PlayerChunkMap a;
    private final WorldPersistentData h;
    private long i;
    public boolean j = true;
    public boolean k = true;
    private static final int l = 4;
    private final long[] m = new long[4];
    private final ChunkStatus[] n = new ChunkStatus[4];
    private final IChunkAccess[] o = new IChunkAccess[4];
    @Nullable
    @VisibleForDebug
    private SpawnerCreature.d p;
    final WeakSeqLock loadedChunkMapSeqLock = new WeakSeqLock();
    final Long2ObjectOpenHashMap<Chunk> loadedChunkMap = new Long2ObjectOpenHashMap(8192, 0.5f);
    private final Chunk[] lastLoadedChunks = new Chunk[16];
    long chunkFutureAwaitCounter;
    public final IteratorSafeOrderedReferenceSet<Chunk> tickingChunks = new IteratorSafeOrderedReferenceSet(4096, 0.75f, 4096, 0.15, true);
    public final IteratorSafeOrderedReferenceSet<Chunk> entityTickingChunks = new IteratorSafeOrderedReferenceSet(4096, 0.75f, 4096, 0.15, true);

    private static int getChunkCacheKey(int x2, int z2) {
        return x2 & 3 | (z2 & 3) << 2;
    }

    public void addLoadedChunk(Chunk chunk) {
        this.loadedChunkMapSeqLock.acquireWrite();
        try {
            this.loadedChunkMap.put(chunk.coordinateKey, (Object)chunk);
        }
        finally {
            this.loadedChunkMapSeqLock.releaseWrite();
        }
        int cacheKey = ChunkProviderServer.getChunkCacheKey(chunk.locX, chunk.locZ);
        this.lastLoadedChunks[cacheKey] = chunk;
    }

    public void removeLoadedChunk(Chunk chunk) {
        this.loadedChunkMapSeqLock.acquireWrite();
        try {
            this.loadedChunkMap.remove(chunk.coordinateKey);
        }
        finally {
            this.loadedChunkMapSeqLock.releaseWrite();
        }
        int cacheKey = ChunkProviderServer.getChunkCacheKey(chunk.locX, chunk.locZ);
        Chunk cachedChunk = this.lastLoadedChunks[cacheKey];
        if (cachedChunk != null && cachedChunk.coordinateKey == chunk.coordinateKey) {
            this.lastLoadedChunks[cacheKey] = null;
        }
    }

    public final Chunk getChunkAtIfLoadedMainThread(int x2, int z2) {
        int cacheKey = ChunkProviderServer.getChunkCacheKey(x2, z2);
        Chunk cachedChunk = this.lastLoadedChunks[cacheKey];
        if (cachedChunk != null && cachedChunk.locX == x2 & cachedChunk.locZ == z2) {
            return cachedChunk;
        }
        long chunkKey = ChunkCoordIntPair.c(x2, z2);
        this.lastLoadedChunks[cacheKey] = cachedChunk = (Chunk)this.loadedChunkMap.get(chunkKey);
        return cachedChunk;
    }

    public final Chunk getChunkAtIfLoadedMainThreadNoCache(int x2, int z2) {
        return (Chunk)this.loadedChunkMap.get(ChunkCoordIntPair.c(x2, z2));
    }

    public final Chunk getChunkAtMainThread(int x2, int z2) {
        Chunk ret = this.getChunkAtIfLoadedMainThread(x2, z2);
        if (ret != null) {
            return ret;
        }
        return (Chunk)this.a(x2, z2, ChunkStatus.o, true);
    }

    public void getEntityTickingChunkAsync(int x2, int z2, Consumer<Chunk> onLoad) {
        ChunkSystem.scheduleTickingState(this.d, x2, z2, PlayerChunk.State.d, true, PrioritisedExecutor.Priority.NORMAL, onLoad);
    }

    public void getTickingChunkAsync(int x2, int z2, Consumer<Chunk> onLoad) {
        ChunkSystem.scheduleTickingState(this.d, x2, z2, PlayerChunk.State.c, true, PrioritisedExecutor.Priority.NORMAL, onLoad);
    }

    public void getFullChunkAsync(int x2, int z2, Consumer<Chunk> onLoad) {
        ChunkSystem.scheduleTickingState(this.d, x2, z2, PlayerChunk.State.b, true, PrioritisedExecutor.Priority.NORMAL, onLoad);
    }

    void chunkLoadAccept(int chunkX, int chunkZ, IChunkAccess chunk, Consumer<IChunkAccess> consumer) {
        try {
            consumer.accept(chunk);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            LOGGER.error("Load callback for chunk " + chunkX + "," + chunkZ + " in world '" + this.d.getWorld().getName() + "' threw an exception", throwable);
        }
    }

    void getChunkAtAsynchronously(int chunkX, int chunkZ, int ticketLevel, Consumer<IChunkAccess> consumer) {
        if (ticketLevel <= 33) {
            this.getFullChunkAsync(chunkX, chunkZ, consumer);
            return;
        }
        ChunkSystem.scheduleChunkLoad(this.d, chunkX, chunkZ, PlayerChunk.b(ticketLevel), true, PrioritisedExecutor.Priority.NORMAL, consumer);
    }

    public final void getChunkAtAsynchronously(int chunkX, int chunkZ, ChunkStatus status, boolean gen, boolean allowSubTicketLevel, Consumer<IChunkAccess> onLoad) {
        int chunkStatusTicketLevel = 33 + ChunkStatus.a(status);
        PlayerChunk playerChunk = this.a.a(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (playerChunk != null) {
            ChunkStatus holderStatus = playerChunk.getChunkHolderStatus();
            IChunkAccess immediate = playerChunk.getAvailableChunkNow();
            if (immediate != null) {
                if (allowSubTicketLevel ? immediate.j().b(status) : playerChunk.k() <= chunkStatusTicketLevel && holderStatus != null && holderStatus.b(status)) {
                    this.chunkLoadAccept(chunkX, chunkZ, immediate, onLoad);
                    return;
                }
                if (gen || !allowSubTicketLevel && immediate.j().b(status)) {
                    this.getChunkAtAsynchronously(chunkX, chunkZ, chunkStatusTicketLevel, onLoad);
                    return;
                }
                this.chunkLoadAccept(chunkX, chunkZ, null, onLoad);
                return;
            }
        }
        if (gen && !allowSubTicketLevel) {
            this.getChunkAtAsynchronously(chunkX, chunkZ, chunkStatusTicketLevel, onLoad);
            return;
        }
        this.getChunkAtAsynchronously(chunkX, chunkZ, MCUtil.getTicketLevelFor(ChunkStatus.c), chunk -> {
            if (chunk == null) {
                throw new IllegalStateException("Chunk cannot be null");
            }
            if (!chunk.j().b(status)) {
                if (gen) {
                    this.getChunkAtAsynchronously(chunkX, chunkZ, chunkStatusTicketLevel, onLoad);
                    return;
                }
                this.chunkLoadAccept(chunkX, chunkZ, null, onLoad);
                return;
            }
            if (allowSubTicketLevel) {
                this.chunkLoadAccept(chunkX, chunkZ, (IChunkAccess)chunk, onLoad);
                return;
            }
            this.getChunkAtAsynchronously(chunkX, chunkZ, chunkStatusTicketLevel, onLoad);
        });
    }

    @Nullable
    public IChunkAccess getChunkAtImmediately(int x2, int z2) {
        PlayerChunk holder = this.a.b(ChunkCoordIntPair.c(x2, z2));
        if (holder == null) {
            return null;
        }
        return holder.g();
    }

    public final IChunkAccess getFullStatusChunkAt(int chunkX, int chunkZ) {
        Chunk ifLoaded = this.getChunkAtIfLoadedImmediately(chunkX, chunkZ);
        if (ifLoaded != null) {
            return ifLoaded;
        }
        IChunkAccess empty = this.a(chunkX, chunkZ, ChunkStatus.c, true);
        if (empty != null && empty.j().b(ChunkStatus.o)) {
            return empty;
        }
        return this.a(chunkX, chunkZ, ChunkStatus.o, true);
    }

    public final IChunkAccess getFullStatusChunkAtIfLoaded(int chunkX, int chunkZ) {
        Chunk ifLoaded = this.getChunkAtIfLoadedImmediately(chunkX, chunkZ);
        if (ifLoaded != null) {
            return ifLoaded;
        }
        IChunkAccess ret = this.getChunkAtImmediately(chunkX, chunkZ);
        if (ret != null && ret.j().b(ChunkStatus.o)) {
            return ret;
        }
        return null;
    }

    public <T> void addTicketAtLevel(TicketType<T> ticketType, ChunkCoordIntPair chunkPos, int ticketLevel, T identifier) {
        this.c.a(ticketType, chunkPos, ticketLevel, identifier);
    }

    public <T> void removeTicketAtLevel(TicketType<T> ticketType, ChunkCoordIntPair chunkPos, int ticketLevel, T identifier) {
        this.c.b(ticketType, chunkPos, ticketLevel, identifier);
    }

    public ChunkProviderServer(WorldServer world, Convertable.ConversionSession session, DataFixer dataFixer, StructureTemplateManager structureTemplateManager, Executor workerExecutor, ChunkGenerator chunkGenerator, int viewDistance, int simulationDistance, boolean dsync, WorldLoadListener worldGenerationProgressListener, ChunkStatusUpdateListener chunkStatusChangeListener, Supplier<WorldPersistentData> persistentStateManagerFactory) {
        this.d = world;
        this.g = new b(world);
        this.e = Thread.currentThread();
        File file = session.a(world.ab()).resolve("data").toFile();
        file.mkdirs();
        this.h = new WorldPersistentData(file, dataFixer);
        this.a = new PlayerChunkMap(world, session, dataFixer, structureTemplateManager, workerExecutor, this.g, this, chunkGenerator, worldGenerationProgressListener, chunkStatusChangeListener, persistentStateManagerFactory, viewDistance, dsync);
        this.f = this.a.e();
        this.c = this.a.j();
        this.c.b(simulationDistance);
        this.r();
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        PlayerChunk chunk = this.a.a(ChunkCoordIntPair.c(chunkX, chunkZ));
        if (chunk == null) {
            return false;
        }
        return chunk.getFullChunkNow() != null;
    }

    public LightEngineThreaded a() {
        return this.f;
    }

    @Nullable
    private PlayerChunk b(long pos) {
        return this.a.b(pos);
    }

    public int b() {
        return this.a.h();
    }

    private void a(long pos, IChunkAccess chunk, ChunkStatus status) {
        for (int j2 = 3; j2 > 0; --j2) {
            this.m[j2] = this.m[j2 - 1];
            this.n[j2] = this.n[j2 - 1];
            this.o[j2] = this.o[j2 - 1];
        }
        this.m[0] = pos;
        this.n[0] = status;
        this.o[0] = chunk;
    }

    @Nullable
    public Chunk getChunkAtIfCachedImmediately(int x2, int z2) {
        long k2 = ChunkCoordIntPair.c(x2, z2);
        PlayerChunk playerChunk = this.b(k2);
        if (playerChunk == null) {
            return null;
        }
        return playerChunk.getFullChunkNowUnchecked();
    }

    @Nullable
    public Chunk getChunkAtIfLoadedImmediately(int x2, int z2) {
        long readlock;
        long k2 = ChunkCoordIntPair.c(x2, z2);
        if (TickThread.isTickThread()) {
            return this.getChunkAtIfLoadedMainThread(x2, z2);
        }
        Chunk ret = null;
        do {
            readlock = this.loadedChunkMapSeqLock.acquireRead();
            try {
                ret = (Chunk)this.loadedChunkMap.get(k2);
            }
            catch (Throwable thr) {
                if (!(thr instanceof ThreadDeath)) continue;
                throw (ThreadDeath)thr;
            }
        } while (!this.loadedChunkMapSeqLock.tryReleaseRead(readlock));
        return ret;
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> getChunkAtAsynchronously(int x2, int z2, boolean gen, boolean isUrgent) {
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> ret = new CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>();
        PrioritisedExecutor.Priority priority = isUrgent ? PrioritisedExecutor.Priority.HIGHER : PrioritisedExecutor.Priority.NORMAL;
        ChunkSystem.scheduleChunkLoad(this.d, x2, z2, gen, ChunkStatus.o, true, priority, chunk -> {
            if (chunk == null) {
                ret.complete(PlayerChunk.a);
            } else {
                ret.complete(Either.left(chunk));
            }
        });
        return ret;
    }

    @Override
    @Nullable
    public IChunkAccess a(int x2, int z2, ChunkStatus leastStatus, boolean create) {
        int x1 = x2;
        int z1 = z2;
        if (!TickThread.isTickThread()) {
            return CompletableFuture.supplyAsync(() -> this.a(x2, z2, leastStatus, create), this.g).join();
        }
        Chunk ifLoaded = this.getChunkAtIfLoadedMainThread(x2, z2);
        if (ifLoaded != null) {
            return ifLoaded;
        }
        GameProfilerFiller gameprofilerfiller = this.d.ac();
        gameprofilerfiller.d("getChunk");
        long k2 = ChunkCoordIntPair.c(x2, z2);
        gameprofilerfiller.d("getChunkCacheMiss");
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture = this.getChunkFutureMainThread(x2, z2, leastStatus, create, true);
        b chunkproviderserver_b = this.g;
        Objects.requireNonNull(completablefuture);
        if (!completablefuture.isDone()) {
            ChunkTaskScheduler.pushChunkWait(this.d, x1, z1);
            SyncLoadFinder.logSyncLoad(this.d, x1, z1);
            this.d.timings.syncChunkLoad.startTiming();
            chunkproviderserver_b.c(completablefuture::isDone);
            ChunkTaskScheduler.popChunkWait();
            this.d.timings.syncChunkLoad.stopTiming();
        }
        IChunkAccess ichunkaccess = (IChunkAccess)completablefuture.join().map(ichunkaccess1 -> ichunkaccess1, playerchunk_failure -> {
            if (create) {
                throw SystemUtils.b(new IllegalStateException("Chunk not there when requested: " + playerchunk_failure));
            }
            return null;
        });
        this.a(k2, ichunkaccess, leastStatus);
        return ichunkaccess;
    }

    @Override
    @Nullable
    public Chunk a(int chunkX, int chunkZ) {
        if (!TickThread.isTickThread()) {
            return null;
        }
        return this.getChunkAtIfLoadedMainThread(chunkX, chunkZ);
    }

    private void r() {
        Arrays.fill(this.m, ChunkCoordIntPair.a);
        Arrays.fill(this.n, null);
        Arrays.fill(this.o, null);
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> b(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        CompletionStage<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture;
        boolean flag1 = TickThread.isTickThread();
        if (flag1) {
            completablefuture = this.c(chunkX, chunkZ, leastStatus, create);
            b chunkproviderserver_b = this.g;
            Objects.requireNonNull(completablefuture);
            chunkproviderserver_b.c(() -> completablefuture.isDone());
        } else {
            completablefuture = CompletableFuture.supplyAsync(() -> this.c(chunkX, chunkZ, leastStatus, create), this.g).thenCompose(completablefuture1 -> completablefuture1);
        }
        return completablefuture;
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> c(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        return this.getChunkFutureMainThread(chunkX, chunkZ, leastStatus, create, false);
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> getChunkFutureMainThread(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create, boolean isUrgent) {
        NewChunkHolder.ChunkCompletion chunkCompletion;
        boolean needsFullScheduling;
        TickThread.ensureTickThread(this.d, chunkX, chunkZ, "Scheduling chunk load off-main");
        int minLevel = 33 + ChunkStatus.a(leastStatus);
        NewChunkHolder chunkHolder = this.d.chunkTaskScheduler.chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        boolean bl = needsFullScheduling = leastStatus == ChunkStatus.o && (chunkHolder == null || !chunkHolder.getChunkStatus().a(PlayerChunk.State.b));
        if ((chunkHolder == null || chunkHolder.getTicketLevel() > minLevel || needsFullScheduling) && !create) {
            return PlayerChunk.b;
        }
        NewChunkHolder.ChunkCompletion chunkCompletion2 = chunkCompletion = chunkHolder == null ? null : chunkHolder.getLastChunkCompletion();
        if (needsFullScheduling || chunkCompletion == null || !chunkCompletion.genStatus().b(leastStatus)) {
            CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> ret = new CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>();
            Consumer<IChunkAccess> complete = chunk -> {
                if (chunk == null) {
                    ret.complete(Either.right(PlayerChunk.Failure.b));
                } else {
                    ret.complete(Either.left(chunk));
                }
            };
            this.d.chunkTaskScheduler.scheduleChunkLoad(chunkX, chunkZ, leastStatus, true, isUrgent ? PrioritisedExecutor.Priority.BLOCKING : PrioritisedExecutor.Priority.NORMAL, complete);
            return ret;
        }
        return CompletableFuture.completedFuture(Either.left(chunkCompletion.chunk()));
    }

    @Override
    public boolean b(int x2, int z2) {
        return this.getChunkAtIfLoadedImmediately(x2, z2) != null;
    }

    @Override
    public IBlockAccess c(int chunkX, int chunkZ) {
        long k2 = ChunkCoordIntPair.c(chunkX, chunkZ);
        PlayerChunk playerchunk = this.b(k2);
        if (playerchunk == null) {
            return null;
        }
        ChunkStatus status = playerchunk.getChunkHolderStatus();
        if (status != null && !status.b(ChunkStatus.l.e())) {
            return null;
        }
        return playerchunk.getAvailableChunkNow();
    }

    public World c() {
        return this.d;
    }

    public boolean d() {
        return this.g.x();
    }

    boolean s() {
        return this.d.chunkTaskScheduler.chunkHolderManager.processTicketUpdates();
    }

    public boolean isPositionTicking(Entity entity) {
        return this.a(ChunkCoordIntPair.c(MathHelper.a(entity.dl()) >> 4, MathHelper.a(entity.dr()) >> 4));
    }

    public boolean a(long pos) {
        PlayerChunk holder = this.a.b(pos);
        return holder != null && holder.isTickingReady();
    }

    public void a(boolean flush) {
        this.s();
        try (Timing timed = this.d.timings.chunkSaveData.startTiming();){
            this.a.a(flush);
        }
    }

    public void saveIncrementally() {
        this.s();
        try (Timing timed = this.d.timings.chunkSaveData.startTiming();){
            this.a.saveIncrementally();
        }
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) {
        this.d.chunkTaskScheduler.chunkHolderManager.close(save, true);
    }

    public void purgeUnload() {
    }

    @Override
    public void a(BooleanSupplier shouldKeepTicking, boolean tickChunks) {
        this.d.ac().a("purge");
        this.d.timings.doChunkMap.startTiming();
        this.c.a();
        this.s();
        this.d.timings.doChunkMap.stopTiming();
        this.d.ac().b("chunks");
        if (tickChunks) {
            this.d.timings.chunks.startTiming();
            this.a.playerChunkManager.tick();
            this.t();
            this.d.timings.chunks.stopTiming();
        }
        this.d.timings.doChunkUnload.startTiming();
        this.d.ac().b("unload");
        this.a.a(shouldKeepTicking);
        this.d.timings.doChunkUnload.stopTiming();
        this.d.ac().c();
        this.r();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void t() {
        long i2 = this.d.U();
        long j2 = i2 - this.i;
        this.i = i2;
        boolean flag = this.d.ae();
        if (flag) {
            this.a.l();
        } else {
            Iterator<Chunk> iterator1;
            boolean flag2;
            SpawnerCreature.d spawnercreature_d;
            PlayerChunkMap playerChunkMap = this.a;
            for (EntityPlayer player : this.d.G) {
                if (!player.affectsSpawning || player.F_()) {
                    playerChunkMap.playerMobSpawnMap.remove(player);
                    continue;
                }
                int chunkRange = this.d.spigotConfig.mobSpawnRange;
                int viewDistance = this.a.getEffectiveViewDistance();
                chunkRange = chunkRange > viewDistance ? (int)viewDistance : chunkRange;
                chunkRange = chunkRange > 8 ? 8 : (int)chunkRange;
                PlayerNaturallySpawnCreaturesEvent event = new PlayerNaturallySpawnCreaturesEvent((Player)player.getBukkitEntity(), (byte)chunkRange);
                event.callEvent();
                if (event.isCancelled() || event.getSpawnRadius() < 0 || playerChunkMap.playerChunkTickRangeMap.getLastViewDistance(player) == -1) {
                    playerChunkMap.playerMobSpawnMap.remove(player);
                    continue;
                }
                int range = Math.min(event.getSpawnRadius(), 32);
                int chunkX = MCUtil.getChunkCoordinate(player.dl());
                int chunkZ = MCUtil.getChunkCoordinate(player.dr());
                playerChunkMap.playerMobSpawnMap.addOrUpdate(player, chunkX, chunkZ, range);
                player.lastEntitySpawnRadiusSquared = (range << 4) * (range << 4);
                player.playerNaturallySpawnedEvent = event;
            }
            WorldData worlddata = this.d.n_();
            GameProfilerFiller gameprofilerfiller = this.d.ac();
            gameprofilerfiller.a("pollingChunks");
            if (LeavesConfig.optimizeChunkTicking) {
                this.d.resetIceAndSnowTick();
            }
            int k2 = this.d.W().c(GameRules.n);
            boolean flag1 = this.d.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) != 0L && worlddata.e() % this.d.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) == 0L;
            gameprofilerfiller.a("naturalSpawnCount");
            this.d.timings.countNaturalMobs.startTiming();
            int l2 = this.c.b();
            if ((this.k || this.j) && this.a.playerMobDistanceMap != null) {
                for (EntityPlayer player : this.d.G) {
                    Arrays.fill(player.mobCounts, 0);
                }
                spawnercreature_d = SpawnerCreature.createState(l2, this.d.y(), this::a, null, true);
            } else {
                spawnercreature_d = SpawnerCreature.createState(l2, this.d.y(), this::a, this.a.playerMobDistanceMap == null ? new LocalMobCapCalculator(this.a) : null, false);
            }
            this.d.timings.countNaturalMobs.stopTiming();
            this.p = spawnercreature_d;
            gameprofilerfiller.b("filteringLoadedChunks");
            this.d.timings.chunkTicks.startTiming();
            gameprofilerfiller.b("spawnAndTick");
            boolean bl = flag2 = this.d.W().b(GameRules.e) && !this.d.v().isEmpty();
            if (this.d.paperConfig().entities.spawning.perPlayerMobSpawns) {
                iterator1 = this.entityTickingChunks.iterator();
            } else {
                iterator1 = this.entityTickingChunks.unsafeIterator();
                ArrayList shuffled = Lists.newArrayListWithCapacity((int)this.entityTickingChunks.size());
                while (iterator1.hasNext()) {
                    shuffled.add(iterator1.next());
                }
                Collections.shuffle(shuffled);
                iterator1 = shuffled.iterator();
            }
            int chunksTicked = 0;
            try {
                while (iterator1.hasNext()) {
                    ChunkCoordIntPair chunkcoordintpair;
                    Chunk chunk1 = iterator1.next();
                    PlayerChunk holder = chunk1.playerChunk;
                    if (holder == null || !this.a.anyPlayerCloseEnoughForSpawning(holder, chunkcoordintpair = chunk1.f(), false)) continue;
                    chunk1.a(j2);
                    if (flag2 && (this.j || this.k) && this.d.p_().a(chunkcoordintpair) && this.a.anyPlayerCloseEnoughForSpawning(holder, chunkcoordintpair, true)) {
                        SpawnerCreature.a(this.d, chunk1, spawnercreature_d, this.k, this.j, flag1);
                    }
                    this.d.a(chunk1, k2);
                    if ((chunksTicked++ & 1) != 0) continue;
                    MinecraftServer.getServer().executeMidTickTasks();
                }
            }
            finally {
                if (iterator1 instanceof IteratorSafeOrderedReferenceSet.Iterator) {
                    IteratorSafeOrderedReferenceSet.Iterator safeIterator = iterator1;
                    safeIterator.finishedIterating();
                }
            }
            this.d.timings.chunkTicks.stopTiming();
            gameprofilerfiller.b("customSpawners");
            if (flag2) {
                try (Timing ignored = this.d.timings.miscMobSpawning.startTiming();){
                    this.d.a(this.j, this.k);
                }
            }
            gameprofilerfiller.c();
            gameprofilerfiller.b("broadcast");
            this.d.timings.broadcastChunkUpdates.startTiming();
            if (!this.a.needsChangeBroadcasting.isEmpty()) {
                ReferenceOpenHashSet copy = this.a.needsChangeBroadcasting.clone();
                this.a.needsChangeBroadcasting.clear();
                for (PlayerChunk holder : copy) {
                    holder.a(holder.getFullChunkNowUnchecked());
                    if (!holder.needsBroadcastChanges()) continue;
                    this.a.needsChangeBroadcasting.add((Object)holder);
                }
            }
            this.d.timings.broadcastChunkUpdates.stopTiming();
            gameprofilerfiller.c();
            ArrayList<NetworkManager> disabledFlushes = new ArrayList<NetworkManager>(this.d.G.size());
            for (EntityPlayer player : this.d.G) {
                PlayerConnection connection = player.b;
                if (connection == null) continue;
                connection.h.disableAutomaticFlush();
                disabledFlushes.add(connection.h);
            }
            try {
                this.a.l();
            }
            finally {
                for (NetworkManager networkManager : disabledFlushes) {
                    networkManager.enableAutomaticFlush();
                }
            }
        }
    }

    private void a(long pos, Consumer<Chunk> chunkConsumer) {
        Chunk chunk;
        PlayerChunk playerchunk = this.b(pos);
        if (playerchunk != null && (chunk = playerchunk.e()) != null) {
            chunkConsumer.accept(chunk);
        }
    }

    @Override
    public String e() {
        return Integer.toString(this.j());
    }

    @VisibleForTesting
    public int f() {
        return this.g.bo();
    }

    public ChunkGenerator g() {
        return this.a.a();
    }

    public ChunkGeneratorStructureState h() {
        return this.a.b();
    }

    public RandomState i() {
        return this.a.c();
    }

    @Override
    public int j() {
        return this.a.i();
    }

    public void a(BlockPosition pos) {
        int j2;
        int i2 = SectionPosition.a(pos.u());
        PlayerChunk playerchunk = this.b(ChunkCoordIntPair.c(i2, j2 = SectionPosition.a(pos.w())));
        if (playerchunk != null) {
            playerchunk.a(pos);
        }
    }

    @Override
    public void a(EnumSkyBlock type, SectionPosition pos) {
        this.g.execute(() -> {
            PlayerChunk playerchunk = this.b(pos.r().a());
            if (playerchunk != null) {
                playerchunk.a(type, pos.b());
            }
        });
    }

    public <T> void a(TicketType<T> ticketType, ChunkCoordIntPair pos, int radius, T argument) {
        this.c.c(ticketType, pos, radius, argument);
    }

    public <T> void b(TicketType<T> ticketType, ChunkCoordIntPair pos, int radius, T argument) {
        this.c.d(ticketType, pos, radius, argument);
    }

    @Override
    public void a(ChunkCoordIntPair pos, boolean forced) {
        this.c.a(pos, forced);
    }

    public void a(EntityPlayer player) {
        if (!player.dB()) {
            this.a.a(player);
        }
    }

    public void a(Entity entity) {
        this.a.b(entity);
    }

    public void b(Entity entity) {
        this.a.a(entity);
    }

    public void a(Entity entity, Packet<?> packet) {
        this.a.b(entity, packet);
    }

    public void b(Entity entity, Packet<?> packet) {
        this.a.a(entity, packet);
    }

    public void a(int watchDistance) {
        this.a.a(watchDistance);
    }

    public void b(int simulationDistance) {
        this.c.b(simulationDistance);
    }

    @Override
    public void a(boolean spawnMonsters, boolean spawnAnimals) {
        this.j = spawnMonsters;
        this.k = spawnAnimals;
    }

    public String a(ChunkCoordIntPair pos) {
        return this.a.a(pos);
    }

    public WorldPersistentData k() {
        return this.h;
    }

    public VillagePlace l() {
        return this.a.m();
    }

    public ChunkScanAccess m() {
        return this.a.p();
    }

    @Nullable
    @VisibleForDebug
    public SpawnerCreature.d n() {
        return this.p;
    }

    public void o() {
        this.c.e();
    }

    private static /* synthetic */ boolean lambda$purgeUnload$8() {
        return true;
    }

    public final class b
    extends IAsyncTaskHandler<Runnable> {
        b(World world) {
            super("Chunk source main thread executor for " + world.ab().a());
        }

        @Override
        protected Runnable f(Runnable runnable) {
            return runnable;
        }

        @Override
        protected boolean e(Runnable task) {
            return true;
        }

        @Override
        protected boolean at() {
            return true;
        }

        @Override
        protected Thread au() {
            return ChunkProviderServer.this.e;
        }

        @Override
        protected void d(Runnable task) {
            ChunkProviderServer.this.d.ac().d("runTask");
            super.d(task);
        }

        @Override
        public boolean x() {
            ChunkProviderServer.this.a.playerChunkManager.tickMidTick();
            if (ChunkProviderServer.this.s()) {
                return true;
            }
            return super.x() | ChunkProviderServer.this.d.chunkTaskScheduler.executeMainThreadTask();
        }
    }

    private record a(Chunk a, PlayerChunk b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "chunk;holder", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "chunk;holder", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "chunk;holder", "a", "b"}, this, o2);
        }
    }
}

