/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.event.player.PlayerClientOptionsChangeEvent;
import com.destroystokyo.paper.event.player.PlayerLocaleChangeEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.player.PlayerStartSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerStopSpectatingEntityEvent;
import com.destroystokyo.paper.util.PooledHashSets;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.packet.PlayerChunkLoadEvent;
import io.papermc.paper.event.packet.PlayerChunkUnloadEvent;
import io.papermc.paper.event.player.PlayerInventorySlotChangeEvent;
import io.papermc.paper.util.MCUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.translation.Translator;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayInSettings;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutResourcePackSend;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUnloadChunk;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMapBase;
import net.minecraft.world.item.ItemWrittenBook;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.ShapeDetectorShape;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.inventory.MainHand;
import org.slf4j.Logger;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.bot.ServerBot;
import top.leavesmc.leaves.util.ReturnPortalManager;

public class EntityPlayer
extends EntityHuman {
    private static final Logger cj = LogUtils.getLogger();
    public long lastSave = MinecraftServer.currentTick;
    private static final int ck = 32;
    private static final int cl = 10;
    public PlayerConnection b;
    public final MinecraftServer c;
    public final PlayerInteractManager d;
    private final AdvancementDataPlayer cm;
    private final ServerStatisticManager cn;
    private float co = Float.MIN_VALUE;
    private int cp = Integer.MIN_VALUE;
    private int cq = Integer.MIN_VALUE;
    private int cr = Integer.MIN_VALUE;
    private int cs = Integer.MIN_VALUE;
    private int ct = Integer.MIN_VALUE;
    private float cu = -1.0E8f;
    private int cv = -99999999;
    private boolean cw = true;
    public int cx = -99999999;
    public int cy = 60;
    private EnumChatVisibility cz;
    private boolean cA = true;
    private long cB;
    @Nullable
    private net.minecraft.world.entity.Entity cC;
    public boolean cD;
    public boolean cE;
    private final RecipeBookServer cF;
    @Nullable
    private Vec3D cG;
    private int cH;
    private boolean cI;
    @Nullable
    private Vec3D cJ;
    @Nullable
    private Vec3D cK;
    @Nullable
    private Vec3D cL;
    private SectionPosition cM;
    private ResourceKey<net.minecraft.world.level.World> cN;
    @Nullable
    private BlockPosition cO;
    private boolean cP;
    private float cQ;
    private final ITextFilter cR;
    private boolean cS;
    private boolean cT = false;
    public WardenSpawnTracker cU;
    public final ContainerSynchronizer cV;
    private final ICrafting cW;
    @Nullable
    private RemoteChatSession cX;
    private int cY;
    public int e;
    public boolean f;
    private int containerUpdateDelay;
    public long loginTime;
    public int patrolSpawnDelay;
    public boolean queueHealthUpdatePacket = false;
    public PacketPlayOutUpdateHealth queuedHealthUpdatePacket;
    public static final int MOBCATEGORY_TOTAL_ENUMS = EnumCreatureType.values().length;
    public final int[] mobCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public final PooledHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> cachedSingleMobDistanceMap;
    public String displayName;
    public Component adventure$displayName;
    public IChatBaseComponent listName;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public boolean supressTrackerForLogin = false;
    public Integer clientViewDistance;
    public boolean isRealPlayer;
    public double lastEntitySpawnRadiusSquared;
    public final PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> cachedSingleHashSet;
    public PlayerNaturallySpawnCreaturesEvent playerNaturallySpawnedEvent;
    public PlayerQuitEvent.QuitReason quitReason = null;
    private int instaBreakCountPerTick = 0;
    private int placeBlockCountPerTick = 0;
    public String locale = null;
    public Locale adventure$locale = Locale.US;
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    public EntityPlayer(MinecraftServer server, WorldServer world, GameProfile profile) {
        super(world, world.Q(), world.R(), profile);
        this.cz = EnumChatVisibility.a;
        this.cB = SystemUtils.b();
        this.cF = new RecipeBookServer();
        this.cM = SectionPosition.a(0, 0, 0);
        this.cN = net.minecraft.world.level.World.h;
        this.cU = new WardenSpawnTracker(0, 0, 0);
        this.cV = new ContainerSynchronizer(){

            @Override
            public void a(Container handler, NonNullList<ItemStack> stacks, ItemStack cursorStack, int[] properties) {
                EntityPlayer.this.b.a(new PacketPlayOutWindowItems(handler.j, handler.k(), stacks, cursorStack));
                for (int i2 = 0; i2 < properties.length; ++i2) {
                    this.b(handler, i2, properties[i2]);
                }
            }

            @Override
            public void sendOffHandSlotChange() {
                EntityPlayer.this.b.a(new PacketPlayOutSetSlot(EntityPlayer.this.bO.j, EntityPlayer.this.bO.k(), 45, EntityPlayer.this.bO.b(45).e().o()));
            }

            @Override
            public void a(Container handler, int slot, ItemStack stack) {
                EntityPlayer.this.b.a(new PacketPlayOutSetSlot(handler.j, handler.k(), slot, stack));
            }

            @Override
            public void a(Container handler, ItemStack stack) {
                EntityPlayer.this.b.a(new PacketPlayOutSetSlot(-1, handler.k(), -1, stack));
            }

            @Override
            public void a(Container handler, int property, int value) {
                this.b(handler, property, value);
            }

            private void b(Container handler, int property, int value) {
                EntityPlayer.this.b.a(new PacketPlayOutWindowData(handler.j, property, value));
            }
        };
        this.cW = new ICrafting(){

            @Override
            public void a(Container handler, int slotId, ItemStack stack) {
                Slot slot = handler.b(slotId);
                if (!(slot instanceof SlotResult) && slot.d == EntityPlayer.this.fJ()) {
                    CriterionTriggers.e.a(EntityPlayer.this, EntityPlayer.this.fJ(), stack);
                }
            }

            @Override
            public void slotChanged(Container handler, int slotId, ItemStack oldStack, ItemStack stack) {
                Slot slot = handler.b(slotId);
                if (!(slot instanceof SlotResult) && slot.d == EntityPlayer.this.fJ()) {
                    if (PlayerInventorySlotChangeEvent.getHandlerList().getRegisteredListeners().length == 0) {
                        CriterionTriggers.e.a(EntityPlayer.this, EntityPlayer.this.fJ(), stack);
                        return;
                    }
                    PlayerInventorySlotChangeEvent event = new PlayerInventorySlotChangeEvent((Player)EntityPlayer.this.getBukkitEntity(), slotId, CraftItemStack.asBukkitCopy(oldStack), CraftItemStack.asBukkitCopy(stack));
                    event.callEvent();
                    if (event.shouldTriggerAdvancements()) {
                        CriterionTriggers.e.a(EntityPlayer.this, EntityPlayer.this.fJ(), stack);
                    }
                }
            }

            @Override
            public void a(Container handler, int property, int value) {
            }
        };
        this.cR = server.a(this);
        this.d = server.b(this);
        this.c = server;
        this.cn = server.ac().getPlayerStats(this);
        this.cm = server.ac().f(this);
        this.v(1.0f);
        this.cachedSingleHashSet = new PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer>(this);
        this.displayName = this.cu();
        this.adventure$displayName = Component.text((String)this.cu());
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.eE();
        this.cachedSingleMobDistanceMap = new PooledHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer>(this);
    }

    public final BlockPosition getSpawnPoint(WorldServer worldserver) {
        BlockPosition blockposition = worldserver.Q();
        if (worldserver.q_().g() && worldserver.J.m() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.c.a(worldserver));
            int j2 = MathHelper.a(worldserver.p_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.t(i1);
            int k1 = RandomSource.a().a(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                BlockPosition blockposition1 = WorldProviderNormal.a(worldserver, blockposition.u() + j22 - i2, blockposition.w() + k22 - i2);
                if (blockposition1 == null) continue;
                return blockposition1;
            }
        }
        return blockposition;
    }

    public void d(WorldServer world) {
        BlockPosition blockposition = world.Q();
        if (world.q_().g() && world.J.m() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.c.a(world));
            int j2 = MathHelper.a(world.p_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.t(i1);
            int k1 = RandomSource.a().a(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                BlockPosition blockposition1 = WorldProviderNormal.a(world, blockposition.u() + j22 - i2, blockposition.w() + k22 - i2);
                if (blockposition1 == null) continue;
                this.a(blockposition1, 0.0f, 0.0f);
                if (!world.noCollision(this, this.cD(), true)) {
                    continue;
                }
                break;
            }
        } else {
            this.a(blockposition, 0.0f, 0.0f);
            while (!world.noCollision(this, this.cD(), true) && this.dn() < (double)(world.ai() - 1)) {
                this.e(this.dl(), this.dn() + 1.0, this.dr());
            }
        }
    }

    private int t(int horizontalSpawnArea) {
        return horizontalSpawnArea <= 16 ? horizontalSpawnArea - 1 : 17;
    }

    @Override
    public void a(NBTTagCompound nbt) {
        String spawnWorld;
        CraftWorld oldWorld;
        super.a(nbt);
        if (nbt.b("warden_spawn_tracker", 10)) {
            DataResult dataresult = WardenSpawnTracker.a.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("warden_spawn_tracker")));
            Logger logger = cj;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(wardenspawntracker -> {
                this.cU = wardenspawntracker;
            });
        }
        if (nbt.b("enteredNetherPosition", 10)) {
            NBTTagCompound nbttagcompound1 = nbt.p("enteredNetherPosition");
            this.cK = new Vec3D(nbttagcompound1.k("x"), nbttagcompound1.k("y"), nbttagcompound1.k("z"));
        }
        this.cE = nbt.q("seenCredits");
        if (nbt.b("recipeBook", 10)) {
            this.cF.a(nbt.p("recipeBook"), this.c.aE());
        }
        this.getBukkitEntity().readExtraData(nbt);
        if (this.fu()) {
            this.fv();
        }
        if ((oldWorld = (CraftWorld)Bukkit.getWorld((String)(spawnWorld = nbt.l("SpawnWorld")))) != null) {
            this.cN = oldWorld.getHandle().ab();
        }
        if (nbt.b("SpawnX", 99) && nbt.b("SpawnY", 99) && nbt.b("SpawnZ", 99)) {
            this.cO = new BlockPosition(nbt.h("SpawnX"), nbt.h("SpawnY"), nbt.h("SpawnZ"));
            this.cP = nbt.q("SpawnForced");
            this.cQ = nbt.j("SpawnAngle");
            if (nbt.e("SpawnDimension")) {
                DataResult dataresult1 = net.minecraft.world.level.World.g.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("SpawnDimension"));
                Logger logger1 = cj;
                Objects.requireNonNull(logger1);
                this.cN = dataresult1.resultOrPartial(arg_0 -> ((Logger)logger1).error(arg_0)).orElse(net.minecraft.world.level.World.h);
            }
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = WardenSpawnTracker.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cU);
        Logger logger = cj;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("warden_spawn_tracker", (NBTBase)nbtbase));
        this.k(nbt);
        nbt.a("seenCredits", this.cE);
        if (this.cK != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.a("x", this.cK.c);
            nbttagcompound1.a("y", this.cK.d);
            nbttagcompound1.a("z", this.cK.e);
            nbt.a("enteredNetherPosition", nbttagcompound1);
        }
        net.minecraft.world.entity.Entity entity = this.cS();
        net.minecraft.world.entity.Entity entity1 = this.cV();
        boolean persistVehicle = true;
        if (entity1 != null) {
            for (net.minecraft.world.entity.Entity vehicle = entity1; vehicle != null; vehicle = vehicle.cV()) {
                if (vehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && entity1 != null && entity != this && entity.cR() && !entity.dB()) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            NBTTagCompound nbttagcompound3 = new NBTTagCompound();
            entity.e(nbttagcompound3);
            nbttagcompound2.a("Attach", entity1.cs());
            nbttagcompound2.a("Entity", nbttagcompound3);
            nbt.a("RootVehicle", nbttagcompound2);
        }
        nbt.a("recipeBook", this.cF.b());
        nbt.a("Dimension", this.H.ab().a().toString());
        if (this.cO != null) {
            nbt.a("SpawnX", this.cO.u());
            nbt.a("SpawnY", this.cO.v());
            nbt.a("SpawnZ", this.cO.w());
            nbt.a("SpawnForced", this.cP);
            nbt.a("SpawnAngle", this.cQ);
            dataresult = MinecraftKey.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cN.a());
            logger = cj;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("SpawnDimension", (NBTBase)nbtbase));
        }
        this.getBukkitEntity().setExtraData(nbt);
    }

    public void spawnIn(net.minecraft.world.level.World world) {
        this.H = world;
        if (world == null) {
            this.dD();
            Vec3D position = null;
            if (this.cN != null && (world = this.c.a(this.cN)) != null && this.N() != null) {
                position = EntityHuman.a((WorldServer)world, this.N(), this.O(), false, false).orElse(null);
            }
            if (world == null || position == null) {
                world = ((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle();
                position = Vec3D.b(world.Q());
            }
            this.H = world;
            this.p(position.a(), position.b(), position.c());
        }
        this.d.a((WorldServer)world);
    }

    public void a(int points) {
        float f2 = this.fS();
        float f1 = (f2 - 1.0f) / f2;
        this.ce = MathHelper.a((float)points / f2, 0.0f, f1);
        this.cx = -1;
    }

    public void b(int level) {
        this.cc = level;
        this.cx = -1;
    }

    @Override
    public void c(int levels) {
        super.c(levels);
        this.cx = -1;
    }

    @Override
    public void a(ItemStack enchantedItem, int experienceLevels) {
        super.a(enchantedItem, experienceLevels);
        this.cx = -1;
    }

    public void a(Container screenHandler) {
        screenHandler.a(this.cW);
        screenHandler.a(this.cV);
    }

    public void h() {
        this.a(this.bO);
    }

    @Override
    public void E_() {
        super.E_();
        this.b.a(new ClientboundPlayerCombatEnterPacket());
    }

    @Override
    public void j() {
        super.j();
        this.b.a(new ClientboundPlayerCombatEndPacket(this.eC()));
    }

    @Override
    protected void a(IBlockData state) {
        CriterionTriggers.d.a(this, state);
    }

    @Override
    protected ItemCooldown k() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void l() {
        net.minecraft.world.entity.Entity entity;
        if (this.joining) {
            this.joining = false;
        }
        this.resetOperationCountPerTick();
        this.d.a();
        this.cU.a();
        --this.cy;
        if (this.ak > 0) {
            --this.ak;
        }
        if (--this.containerUpdateDelay <= 0) {
            this.bP.d();
            this.containerUpdateDelay = this.H.paperConfig().tickRates.containerUpdate;
        }
        if (!(this.H.B || this.bP == this.bO || !this.eP() && this.bP.a(this))) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.bP = this.bO;
        }
        if ((entity = this.G()) != this) {
            if (entity.bq()) {
                this.a(entity.dl(), entity.dn(), entity.dr(), entity.dw(), entity.dy());
                this.x().k().a(this);
                if (this.fA()) {
                    this.c((net.minecraft.world.entity.Entity)this);
                }
            } else {
                this.c((net.minecraft.world.entity.Entity)this);
            }
        }
        CriterionTriggers.w.a(this);
        if (this.cG != null) {
            CriterionTriggers.u.a(this, this.cG, this.ag - this.cH);
        }
        this.o();
        this.p();
        this.cm.b(this);
    }

    public void m() {
        try {
            if (this.valid && !this.F_() || !this.da()) {
                super.l();
            }
            for (int i2 = 0; i2 < this.fJ().b(); ++i2) {
                Packet<?> packet;
                ItemStack itemstack = this.fJ().a(i2);
                if (!itemstack.c().ac_() || (packet = ((ItemWorldMapBase)itemstack.c()).a(itemstack, this.H, this)) == null) continue;
                this.b.a(packet);
            }
            if (this.eo() != this.cu || this.cv != this.bQ.a() || this.bQ.e() == 0.0f != this.cw) {
                this.b.a(new PacketPlayOutUpdateHealth(this.getBukkitEntity().getScaledHealth(), this.bQ.a(), this.bQ.e()));
                this.cu = this.eo();
                this.cv = this.bQ.a();
                boolean bl = this.cw = this.bQ.e() == 0.0f;
            }
            if (this.eo() + this.fb() != this.co) {
                this.co = this.eo() + this.fb();
                this.a(IScoreboardCriteria.f, MathHelper.f(this.co));
            }
            if (this.bQ.a() != this.cp) {
                this.cp = this.bQ.a();
                this.a(IScoreboardCriteria.g, MathHelper.f((float)this.cp));
            }
            if (this.cd() != this.cq) {
                this.cq = this.cd();
                this.a(IScoreboardCriteria.h, MathHelper.f((float)this.cq));
            }
            if (this.eB() != this.cr) {
                this.cr = this.eB();
                this.a(IScoreboardCriteria.i, MathHelper.f((float)this.cr));
            }
            if (this.cd != this.ct) {
                this.ct = this.cd;
                this.a(IScoreboardCriteria.j, MathHelper.f((float)this.ct));
            }
            if (this.maxHealthCache != (double)this.eE()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.cc != this.cs) {
                this.cs = this.cc;
                this.a(IScoreboardCriteria.k, MathHelper.f((float)this.cs));
            }
            if (this.cd != this.cx) {
                this.cx = this.cd;
                this.b.a(new PacketPlayOutExperience(this.ce, this.cd, this.cc));
            }
            if (this.ag % 20 == 0) {
                CriterionTriggers.p.a(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.cc;
            }
            if (this.oldLevel != this.cc) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.cc);
                this.oldLevel = this.cc;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().s();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Ticking player");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Player being ticked");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public void n() {
        if (this.eo() > 0.0f && this.cJ != null) {
            CriterionTriggers.U.a(this, this.cJ);
        }
        this.cJ = null;
        super.n();
    }

    public void o() {
        if (this.aa > 0.0f && this.cJ == null) {
            this.cJ = this.de();
        }
    }

    public void p() {
        if (this.cV() != null && this.cV().bg()) {
            if (this.cL == null) {
                this.cL = this.de();
            } else {
                CriterionTriggers.V.a(this, this.cL);
            }
        }
        if (!(this.cL == null || this.cV() != null && this.cV().bg())) {
            this.cL = null;
        }
    }

    private void a(IScoreboardCriteria criterion, int score) {
        this.H.getCraftServer().getScoreboardManager().getScoreboardScores(criterion, this.cu(), scoreboardscore -> scoreboardscore.b(score));
    }

    private static void processKeep(PlayerDeathEvent event, NonNullList<ItemStack> inv) {
        List itemsToKeep = event.getItemsToKeep();
        if (inv == null) {
            if (!itemsToKeep.isEmpty()) {
                for (org.bukkit.inventory.ItemStack itemStack : itemsToKeep) {
                    event.getEntity().getInventory().addItem(new org.bukkit.inventory.ItemStack[]{itemStack});
                }
            }
            return;
        }
        for (int i2 = 0; i2 < inv.size(); ++i2) {
            ItemStack item = inv.get(i2);
            if (EnchantmentManager.e(item) || itemsToKeep.isEmpty() || item.b()) {
                inv.set(i2, ItemStack.b);
                continue;
            }
            org.bukkit.inventory.ItemStack bukkitStack = item.getBukkitStack();
            boolean keep = false;
            Iterator iterator = itemsToKeep.iterator();
            while (iterator.hasNext()) {
                org.bukkit.inventory.ItemStack itemStack = (org.bukkit.inventory.ItemStack)iterator.next();
                if (!bukkitStack.equals((Object)itemStack)) continue;
                iterator.remove();
                keep = true;
                break;
            }
            if (keep) continue;
            inv.set(i2, ItemStack.b);
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        TextComponent deathMessage;
        boolean keepInventory;
        this.a(GameEvent.q);
        boolean flag = this.H.W().b(GameRules.m);
        if (this.dB()) {
            return;
        }
        ArrayList<org.bukkit.inventory.ItemStack> loot = new ArrayList<org.bukkit.inventory.ItemStack>(this.fJ().b());
        boolean bl = keepInventory = this.H.W().b(GameRules.d) || this.F_();
        if (!keepInventory) {
            for (ItemStack itemStack : this.fJ().getContents()) {
                if (itemStack.b() || EnchantmentManager.e(itemStack)) continue;
                loot.add(CraftItemStack.asCraftMirror(itemStack));
            }
        }
        if (this.dW() && this.H.W().b(GameRules.f)) {
            this.a(damageSource, this.aY > 0);
            for (org.bukkit.inventory.ItemStack itemStack : this.drops) {
                loot.add(itemStack);
            }
            this.drops.clear();
        }
        IChatBaseComponent defaultMessage = this.eC().b();
        String string = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, loot, PaperAdventure.asAdventure(defaultMessage), defaultMessage.getString(), keepInventory);
        if (event.isCancelled()) {
            if (this.eo() <= 0.0f) {
                this.c((float)event.getReviveHealth());
            }
            return;
        }
        if (this.bP != this.bO) {
            this.closeContainer(InventoryCloseEvent.Reason.DEATH);
        }
        Object object = deathMessage = event.deathMessage() != null ? event.deathMessage() : Component.empty();
        if (deathMessage != null && deathMessage != Component.empty() && flag) {
            IChatBaseComponent ichatbasecomponent = PaperAdventure.asVanilla((Component)deathMessage);
            this.b.a(new ClientboundPlayerCombatKillPacket(this.eC(), ichatbasecomponent), PacketSendListener.a(() -> {
                boolean flag1 = true;
                String s2 = ichatbasecomponent.a(256);
                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("death.attack.message_too_long", IChatBaseComponent.b(s2).a(EnumChatFormat.o));
                IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.a("death.attack.even_more_magic", this.G_()).a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, ichatmutablecomponent)));
                return new ClientboundPlayerCombatKillPacket(this.eC(), ichatmutablecomponent1);
            }));
            ScoreboardTeamBase scoreboardTeamBase = this.cb();
            if (scoreboardTeamBase != null && scoreboardTeamBase.k() != ScoreboardTeamBase.EnumNameTagVisibility.a) {
                if (scoreboardTeamBase.k() == ScoreboardTeamBase.EnumNameTagVisibility.c) {
                    this.c.ac().a((EntityHuman)this, ichatbasecomponent);
                } else if (scoreboardTeamBase.k() == ScoreboardTeamBase.EnumNameTagVisibility.d) {
                    this.c.ac().b(this, ichatbasecomponent);
                }
            } else {
                this.c.ac().a(ichatbasecomponent, false);
            }
        } else {
            this.b.a(new ClientboundPlayerCombatKillPacket(this.eC(), CommonComponents.a));
        }
        this.fX();
        if (this.H.W().b(GameRules.J)) {
            this.gj();
        }
        if (event.shouldDropExperience()) {
            this.es();
        }
        if (!event.getKeepInventory()) {
            for (NonNullList nonNullList : this.fJ().o) {
                EntityPlayer.processKeep(event, nonNullList);
            }
            EntityPlayer.processKeep(event, null);
        }
        this.c((net.minecraft.world.entity.Entity)this);
        this.H.getCraftServer().getScoreboardManager().getScoreboardScores(IScoreboardCriteria.c, this.cu(), ScoreboardScore::a);
        EntityLiving entityliving = this.eD();
        if (entityliving != null) {
            this.b(StatisticList.h.b(entityliving.ae()));
            entityliving.a((net.minecraft.world.entity.Entity)this, this.bg, damageSource);
            this.f(entityliving);
        }
        this.H.a((net.minecraft.world.entity.Entity)this, (byte)3);
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.av();
        this.j(0);
        this.a_(false);
        this.eC().g();
        ((EntityHuman)this).a(Optional.of(GlobalPos.a(this.H.ab(), this.dg())));
    }

    private void gj() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.dg()).c(32.0, 10.0, 32.0);
        this.H.a(EntityInsentient.class, axisalignedbb, IEntitySelector.f).stream().filter(entityinsentient -> entityinsentient instanceof IEntityAngerable).forEach(entityinsentient -> ((IEntityAngerable)((Object)entityinsentient)).a_(this));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entityKilled, int score, DamageSource damageSource) {
        if (entityKilled != this) {
            super.a(entityKilled, score, damageSource);
            this.r(score);
            String s2 = this.cu();
            String s1 = entityKilled.cu();
            this.H.getCraftServer().getScoreboardManager().getScoreboardScores(IScoreboardCriteria.e, s2, ScoreboardScore::a);
            if (entityKilled instanceof EntityHuman) {
                this.a(StatisticList.Q);
                this.H.getCraftServer().getScoreboardManager().getScoreboardScores(IScoreboardCriteria.d, s2, ScoreboardScore::a);
            } else {
                this.a(StatisticList.O);
            }
            this.a(s2, s1, IScoreboardCriteria.l);
            this.a(s1, s2, IScoreboardCriteria.m);
            CriterionTriggers.b.a(this, entityKilled, damageSource);
        }
    }

    private void a(String playerName, String team, IScoreboardCriteria[] criterions) {
        int i2;
        ScoreboardTeam scoreboardteam = this.fY().i(team);
        if (scoreboardteam != null && (i2 = scoreboardteam.n().b()) >= 0 && i2 < criterions.length) {
            this.H.getCraftServer().getScoreboardManager().getScoreboardScores(criterions[i2], playerName, ScoreboardScore::a);
        }
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        EntityHuman entityhuman1;
        EntityArrow entityarrow;
        net.minecraft.world.entity.Entity entity1;
        EntityHuman entityhuman;
        boolean flag;
        if (this.b(source)) {
            return false;
        }
        boolean bl = flag = this.c.l() && this.gk() && source.a(DamageTypeTags.m);
        if (!flag && this.cy > 0 && !source.a(DamageTypeTags.d)) {
            return false;
        }
        net.minecraft.world.entity.Entity entity = source.d();
        if (entity instanceof EntityHuman && !this.a(entityhuman = (EntityHuman)entity)) {
            return false;
        }
        if (entity instanceof EntityArrow && (entity1 = (entityarrow = (EntityArrow)entity).v()) instanceof EntityHuman && !this.a(entityhuman1 = (EntityHuman)entity1)) {
            return false;
        }
        this.queueHealthUpdatePacket = true;
        boolean damaged = super.a(source, amount);
        this.queueHealthUpdatePacket = false;
        if (this.queuedHealthUpdatePacket != null) {
            this.b.a(this.queuedHealthUpdatePacket);
            this.queuedHealthUpdatePacket = null;
        }
        return damaged;
    }

    @Override
    public boolean a(EntityHuman player) {
        return !this.gk() ? false : super.a(player);
    }

    private boolean gk() {
        return this.H.pvpMode;
    }

    @Override
    @Nullable
    protected ShapeDetectorShape a(WorldServer destination) {
        ShapeDetectorShape shapedetectorshape = super.a(destination);
        WorldServer worldServer = destination = shapedetectorshape == null ? destination : shapedetectorshape.world;
        if (shapedetectorshape != null && this.H.getTypeKey() == WorldDimension.b && destination != null && destination.getTypeKey() == WorldDimension.d) {
            Vec3D vec3d = shapedetectorshape.a.b(0.0, -1.0, 0.0);
            return new ShapeDetectorShape(vec3d, Vec3D.b, 90.0f, 0.0f, destination, shapedetectorshape.portalEventInfo);
        }
        return shapedetectorshape;
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity b(WorldServer destination) {
        return this.changeDimension(destination, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    @Nullable
    public net.minecraft.world.entity.Entity changeDimension(WorldServer worldserver, PlayerTeleportEvent.TeleportCause cause) {
        if (this.fu()) {
            return this;
        }
        WorldServer worldserver1 = this.x();
        ResourceKey<WorldDimension> resourcekey = worldserver1.getTypeKey();
        if (resourcekey == WorldDimension.d && worldserver != null && worldserver.getTypeKey() == WorldDimension.b) {
            this.cD = true;
            this.ac();
            this.x().a(this, Entity.RemovalReason.e);
            if (!this.f) {
                if (this.H.paperConfig().misc.disableEndCredits) {
                    this.cE = true;
                }
                this.f = true;
                this.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, this.cE ? 0.0f : 1.0f));
                this.cE = true;
            }
            return this;
        }
        ShapeDetectorShape shapedetectorshape = this.a(worldserver);
        if (shapedetectorshape != null) {
            worldserver1.ac().a("moving");
            worldserver = shapedetectorshape.world;
            if (worldserver != null) {
                if (resourcekey == WorldDimension.b && worldserver.getTypeKey() == WorldDimension.c) {
                    this.cK = this.de();
                } else if (worldserver.getTypeKey() == WorldDimension.d && shapedetectorshape.portalEventInfo != null && shapedetectorshape.portalEventInfo.getCanCreatePortal()) {
                    this.a(worldserver, BlockPosition.a(shapedetectorshape.a));
                }
            }
        } else {
            return null;
        }
        Location enter = this.getBukkitEntity().getLocation();
        Location exit = worldserver == null ? null : CraftLocation.toBukkit(shapedetectorshape.a, (World)worldserver.getWorld(), shapedetectorshape.c, shapedetectorshape.d);
        PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((Player)this.getBukkitEntity(), enter, exit, cause);
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        if (tpEvent.isCancelled() || tpEvent.getTo() == null) {
            return null;
        }
        exit = tpEvent.getTo();
        worldserver = ((CraftWorld)exit.getWorld()).getHandle();
        worldserver1.ac().c();
        worldserver1.ac().a("placing");
        this.cD = true;
        this.b.a(new PacketPlayOutRespawn(worldserver.Z(), worldserver.ab(), BiomeManager.a(worldserver.A()), this.d.b(), this.d.c(), worldserver.ae(), worldserver.z(), 3, this.gi()));
        this.b.a(new PacketPlayOutServerDifficulty(worldserver.ah(), this.H.n_().t()));
        PlayerList playerlist = this.c.ac();
        playerlist.d(this);
        worldserver1.a(this, Entity.RemovalReason.e);
        this.dD();
        this.c(worldserver);
        this.b(exit.getX(), exit.getY(), exit.getZ(), exit.getYaw(), exit.getPitch());
        this.b.teleport(exit);
        this.b.d();
        worldserver.b(this);
        worldserver1.ac().c();
        this.e(worldserver1);
        this.b.a(new PacketPlayOutAbilities(this.fK()));
        playerlist.a(this, worldserver);
        playerlist.e(this);
        for (MobEffect mobeffect : this.el()) {
            this.b.a(new PacketPlayOutEntityEffect(this.af(), mobeffect));
        }
        this.b.a(new PacketPlayOutWorldEvent(1032, BlockPosition.b, 0, false));
        this.cx = -1;
        this.cu = -1.0f;
        this.cv = -1;
        if (LeavesConfig.fakeplayerSupport) {
            ServerBot.getBots().forEach(bot1 -> bot1.render(this.b, true, this.getBukkitEntity().getWorld() == bot1.getBukkitEntity().getWorld()));
        }
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.getBukkitEntity(), (World)worldserver1.getWorld());
        this.H.getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        if (LeavesConfig.netherPortalFix) {
            BlockPosition lastPos;
            ResourceKey<net.minecraft.world.level.World> fromDim = worldserver1.ab();
            ResourceKey<net.minecraft.world.level.World> toDim = this.x().ab();
            ResourceKey<net.minecraft.world.level.World> OVERWORLD = net.minecraft.world.level.World.h;
            ResourceKey<net.minecraft.world.level.World> THE_NETHER = net.minecraft.world.level.World.i;
            if ((fromDim == OVERWORLD && toDim == THE_NETHER || fromDim == THE_NETHER && toDim == OVERWORLD) && (lastPos = ((EntityLiving)this).ca) != null) {
                BlockUtil.Rectangle fromPortal = ReturnPortalManager.findPortalAt(this, fromDim, lastPos);
                BlockPosition toPos = this.dg();
                if (fromPortal != null) {
                    ReturnPortalManager.storeReturnPortal(this, toDim, toPos, fromPortal);
                }
            }
        }
        if (this.fl()) {
            this.fk();
        }
        return this;
    }

    @Override
    protected CraftPortalEvent callPortalEvent(net.minecraft.world.entity.Entity entity, WorldServer exitWorldServer, Position exitPosition, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        Location exit = CraftLocation.toBukkit(exitPosition, (World)exitWorldServer.getWorld(), this.dw(), this.dy());
        PlayerPortalEvent event = new PlayerPortalEvent((Player)this.getBukkitEntity(), enter, exit, cause, searchRadius, true, creationRadius);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    private void a(WorldServer world, BlockPosition centerPos) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = centerPos.j();
        BlockStateListPopulator blockList = new BlockStateListPopulator(world);
        for (int i2 = -2; i2 <= 2; ++i2) {
            for (int j2 = -2; j2 <= 2; ++j2) {
                for (int k2 = -1; k2 < 3; ++k2) {
                    IBlockData iblockdata = k2 == -1 ? Blocks.cn.o() : Blocks.a.o();
                    blockList.a((BlockPosition)blockposition_mutableblockposition.g(centerPos).e(j2, k2, i2), iblockdata, 3);
                }
            }
        }
        PortalCreateEvent portalEvent = new PortalCreateEvent(blockList.getList(), (World)world.getWorld(), (Entity)this.getBukkitEntity(), PortalCreateEvent.CreateReason.END_PLATFORM);
        world.getCraftServer().getPluginManager().callEvent((Event)portalEvent);
        if (!portalEvent.isCancelled()) {
            blockList.updateList();
        }
    }

    @Override
    protected Optional<BlockUtil.Rectangle> getExitPortal(WorldServer worldserver, BlockPosition blockposition, boolean flag, WorldBorder worldborder, int searchRadius, boolean canCreatePortal, int createRadius) {
        Optional<BlockUtil.Rectangle> optional = super.getExitPortal(worldserver, blockposition, flag, worldborder, searchRadius, canCreatePortal, createRadius);
        if (LeavesConfig.netherPortalFix) {
            WorldServer toLevel;
            MinecraftServer server;
            ReturnPortalManager.ReturnPortal returnPortal;
            boolean isTeleportBetweenNetherAndOverworld;
            BlockPosition fromPos = this.dg();
            ResourceKey<net.minecraft.world.level.World> fromDim = this.H.ab();
            ResourceKey<net.minecraft.world.level.World> toDim = this.H.ab();
            ResourceKey<net.minecraft.world.level.World> OVERWORLD = net.minecraft.world.level.World.h;
            ResourceKey<net.minecraft.world.level.World> THE_NETHER = net.minecraft.world.level.World.i;
            boolean bl = isTeleportBetweenNetherAndOverworld = fromDim == OVERWORLD && toDim == THE_NETHER || fromDim == THE_NETHER && toDim == OVERWORLD;
            if (this.au && isTeleportBetweenNetherAndOverworld && (returnPortal = ReturnPortalManager.findReturnPortal(this, fromDim, fromPos)) != null && (server = this.cH()) != null && (toLevel = server.a(toDim)) != null) {
                return Optional.of(returnPortal.rectangle());
            }
        }
        if (optional.isPresent() || !canCreatePortal) {
            return optional;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis = this.H.a_(this.aw).d(BlockPortal.a).orElse(EnumDirection.EnumAxis.a);
        Optional<BlockUtil.Rectangle> optional1 = worldserver.o().createPortal(blockposition, enumdirection_enumaxis, this, createRadius);
        if (!optional1.isPresent()) {
            // empty if block
        }
        return optional1;
    }

    public void e(WorldServer origin) {
        ResourceKey<net.minecraft.world.level.World> resourcekey = origin.ab();
        ResourceKey<net.minecraft.world.level.World> resourcekey1 = this.H.ab();
        ResourceKey<net.minecraft.world.level.World> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(origin);
        ResourceKey<net.minecraft.world.level.World> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.H);
        if (GlobalConfiguration.get().misc.strictAdvancementDimensionCheck) {
            maindimensionkey = resourcekey;
            maindimensionkey1 = resourcekey1;
        }
        CriterionTriggers.v.a(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourcekey || maindimensionkey1 != resourcekey1) {
            CriterionTriggers.v.a(this, resourcekey, resourcekey1);
        }
        if (maindimensionkey == net.minecraft.world.level.World.i && maindimensionkey1 == net.minecraft.world.level.World.h && this.cK != null) {
            CriterionTriggers.C.a(this, this.cK);
        }
        if (maindimensionkey1 != net.minecraft.world.level.World.i) {
            this.cK = null;
        }
    }

    @Override
    public boolean a(EntityPlayer spectator) {
        return spectator.F_() ? this.G() == this : (this.F_() ? false : super.a(spectator));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity item, int count) {
        super.a(item, count);
        this.bP.d();
    }

    private Either<EntityHuman.EnumBedResult, Unit> getBedResult(BlockPosition blockposition, EnumDirection enumdirection) {
        if (!this.fu() && this.bq()) {
            if (!this.H.q_().j() || !this.H.q_().l()) {
                return Either.left(EntityHuman.EnumBedResult.a);
            }
            if (!this.a(blockposition, enumdirection)) {
                return Either.left(EntityHuman.EnumBedResult.c);
            }
            if (this.b(blockposition, enumdirection)) {
                return Either.left(EntityHuman.EnumBedResult.d);
            }
            this.setRespawnPosition(this.H.ab(), blockposition, this.dw(), false, true, PlayerSetSpawnEvent.Cause.BED);
            if (this.H.M()) {
                return Either.left(EntityHuman.EnumBedResult.b);
            }
            if (!this.f()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3D vec3d = Vec3D.c(blockposition);
                List<EntityMonster> list = this.H.a(EntityMonster.class, new AxisAlignedBB(vec3d.a() - 8.0, vec3d.b() - 5.0, vec3d.c() - 8.0, vec3d.a() + 8.0, vec3d.b() + 5.0, vec3d.c() + 8.0), (? super T entitymonster) -> entitymonster.e(this));
                if (!list.isEmpty()) {
                    return Either.left(EntityHuman.EnumBedResult.f);
                }
            }
            return Either.right(Unit.a);
        }
        return Either.left(EntityHuman.EnumBedResult.e);
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        EnumDirection enumdirection = this.H.a_(blockposition).c(BlockFacingHorizontal.aD);
        Either<EntityHuman.EnumBedResult, Unit> bedResult = this.getBedResult(blockposition, enumdirection);
        if (bedResult.left().orElse(null) == EntityHuman.EnumBedResult.e) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right(Unit.a);
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, blockposition, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either<EntityHuman.EnumBedResult, Unit> either = super.startSleepInBed(blockposition, force).ifRight(unit -> {
            this.a(StatisticList.ap);
            CriterionTriggers.q.a(this);
        });
        if (!this.x().d()) {
            this.a(IChatBaseComponent.c("sleep.not_possible"), true);
        }
        ((WorldServer)this.H).e();
        return either;
    }

    @Override
    public void b(BlockPosition pos) {
        this.a(StatisticList.i.b(StatisticList.n));
        super.b(pos);
    }

    private boolean a(BlockPosition pos, EnumDirection direction) {
        return this.g(pos) || this.g(pos.a(direction.g()));
    }

    private boolean g(BlockPosition pos) {
        Vec3D vec3d = Vec3D.c(pos);
        return Math.abs(this.dl() - vec3d.a()) <= 3.0 && Math.abs(this.dn() - vec3d.b()) <= 2.0 && Math.abs(this.dr() - vec3d.c()) <= 3.0;
    }

    private boolean b(BlockPosition pos, EnumDirection direction) {
        BlockPosition blockposition1 = pos.c();
        return !this.f(blockposition1) || !this.f(blockposition1.a(direction.g()));
    }

    @Override
    public void a(boolean skipSleepTimer, boolean updateSleepingPlayers) {
        if (!this.fu()) {
            return;
        }
        CraftPlayer player = this.getBukkitEntity();
        BlockPosition bedPosition = this.fs().orElse(null);
        Block bed = bedPosition != null ? this.H.getWorld().getBlockAt(bedPosition.u(), bedPosition.v(), bedPosition.w()) : this.H.getWorld().getBlockAt(player.getLocation());
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((Player)player, bed, true);
        this.H.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.fu()) {
            this.x().k().a(this, new PacketPlayOutAnimation(this, 2));
        }
        super.a(skipSleepTimer, updateSleepingPlayers);
        if (this.b != null) {
            this.b.a(this.dl(), this.dn(), this.dr(), this.dw(), this.dy());
        }
    }

    @Override
    public void a(double destX, double destY, double destZ) {
        this.by();
        this.e(destX, destY, destZ);
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return super.b(damageSource) || this.K() || !this.H.paperConfig().collisions.allowPlayerCrammingDamage && damageSource == this.dG().g();
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
    }

    @Override
    protected void c(BlockPosition pos) {
        if (!this.F_()) {
            super.c(pos);
        }
    }

    public void a(double heightDifference, boolean onGround) {
        if (!this.da()) {
            BlockPosition blockposition = this.aC();
            super.a(heightDifference, onGround, this.H.a_(blockposition), blockposition);
        }
    }

    @Override
    public void a(TileEntitySign sign) {
        sign.a(this.cs());
        this.b.a(new PacketPlayOutBlockChange(this.H, sign.p()));
        this.b.a(new PacketPlayOutOpenSignEditor(sign.p()));
    }

    public int nextContainerCounter() {
        this.cY = this.cY % 100 + 1;
        return this.cY;
    }

    @Override
    public OptionalInt a(@Nullable ITileInventory factory) {
        if (factory == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        Container container = factory.createMenu(this.cY, this.fJ(), this);
        if (container != null) {
            container.setTitle(factory.G_());
            boolean cancelled = false;
            container = CraftEventFactory.callInventoryOpenEvent(this, container, cancelled);
            if (container == null && !cancelled) {
                if (factory instanceof IInventory) {
                    ((IInventory)((Object)factory)).c(this);
                } else if (factory instanceof BlockChest.DoubleInventory) {
                    ((BlockChest.DoubleInventory)factory).inventorylargechest.c(this);
                }
                return OptionalInt.empty();
            }
        }
        if (container == null) {
            if (this.F_()) {
                this.a(IChatBaseComponent.c("container.spectatorCantOpen").a(EnumChatFormat.m), true);
            }
            return OptionalInt.empty();
        }
        this.bP = container;
        if (!this.eP()) {
            this.b.a(new PacketPlayOutOpenWindow(container.j, container.a(), container.getTitle()));
        }
        this.a(container);
        return OptionalInt.of(this.cY);
    }

    @Override
    public void a(int syncId, MerchantRecipeList offers, int levelProgress, int experience, boolean leveled, boolean refreshable) {
        this.b.a(new PacketPlayOutOpenWindowMerchant(syncId, offers, levelProgress, experience, leveled, refreshable));
    }

    @Override
    public void a(EntityHorseAbstract horse, IInventory inventory) {
        this.nextContainerCounter();
        Container container = new ContainerHorse(this.cY, this.fJ(), inventory, horse);
        container.setTitle(horse.G_());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            inventory.c(this);
            return;
        }
        if (this.bP != this.bO) {
            this.closeContainer(InventoryCloseEvent.Reason.OPEN_NEW);
        }
        this.b.a(new PacketPlayOutOpenWindowHorse(this.cY, inventory.b(), horse.af()));
        this.bP = container;
        this.a(this.bP);
    }

    @Override
    public void a(ItemStack book, EnumHand hand) {
        if (book.a(Items.td)) {
            if (ItemWrittenBook.a(book, this.cZ(), this)) {
                this.bP.d();
            }
            this.b.a(new PacketPlayOutOpenBook(hand));
        }
    }

    @Override
    public void a(TileEntityCommand commandBlock) {
        this.b.a(PacketPlayOutTileEntityData.a(commandBlock, TileEntity::o));
    }

    @Override
    public void q() {
        this.closeContainer(InventoryCloseEvent.Reason.UNKNOWN);
    }

    @Override
    public void closeContainer(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.b.a(new PacketPlayOutCloseWindow(this.bP.j));
        this.r();
    }

    @Override
    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.b.a(new PacketPlayOutCloseWindow(this.bP.j));
        this.bP = this.bO;
    }

    @Override
    public void r() {
        this.bP.b(this);
        this.bO.a(this.bP);
        this.bP = this.bO;
    }

    public void a(float sidewaysSpeed, float forwardSpeed, boolean jumping, boolean sneaking) {
        if (this.bL()) {
            if (sidewaysSpeed >= -1.0f && sidewaysSpeed <= 1.0f) {
                this.bj = sidewaysSpeed;
            }
            if (forwardSpeed >= -1.0f && forwardSpeed <= 1.0f) {
                this.bl = forwardSpeed;
            }
            this.bi = jumping;
            if (sneaking != this.bO()) {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getBukkitEntity(), sneaking);
                this.c.server.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            this.f(sneaking);
        }
    }

    @Override
    public void a(Statistic<?> stat, int amount) {
        this.cn.b(this, stat, amount);
        this.H.getCraftServer().getScoreboardManager().getScoreboardScores(stat, this.cu(), scoreboardscore -> scoreboardscore.a(amount));
    }

    @Override
    public void a(Statistic<?> stat) {
        this.cn.a(this, stat, 0);
        this.H.getCraftServer().getScoreboardManager().getScoreboardScores(stat, this.cu(), ScoreboardScore::c);
    }

    @Override
    public int a(Collection<IRecipe<?>> recipes) {
        return this.cF.a(recipes, this);
    }

    @Override
    public void a(MinecraftKey[] ids) {
        ArrayList list = Lists.newArrayList();
        MinecraftKey[] aminecraftkey1 = ids;
        int i2 = ids.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            MinecraftKey minecraftkey = aminecraftkey1[j2];
            Optional<IRecipe<?>> optional = this.c.aE().a(minecraftkey);
            Objects.requireNonNull(list);
            optional.ifPresent(list::add);
        }
        this.a(list);
    }

    @Override
    public int b(Collection<IRecipe<?>> recipes) {
        return this.cF.b(recipes, this);
    }

    @Override
    public void d(int experience) {
        super.d(experience);
        this.cx = -1;
    }

    public void s() {
        this.cI = true;
        this.bx();
        if (this.bL() && this.cV() instanceof EntityPlayer) {
            this.bz();
        }
        if (this.fu()) {
            this.a(true, false);
        }
    }

    public boolean t() {
        return this.cI;
    }

    public void u() {
        this.cu = -1.0E8f;
        this.cx = -1;
    }

    @Override
    public void a(IChatBaseComponent message, boolean overlay) {
        this.b(message, overlay);
    }

    @Override
    protected void Y_() {
        if (!this.bu.b() && this.fe()) {
            this.b.a(new PacketPlayOutEntityStatus(this, 9));
            super.Y_();
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchorPoint, Vec3D target) {
        super.a(anchorPoint, target);
        this.b.a(new PacketPlayOutLookAt(anchorPoint, target.c, target.d, target.e));
    }

    public void a(ArgumentAnchor.Anchor anchorPoint, net.minecraft.world.entity.Entity targetEntity, ArgumentAnchor.Anchor targetAnchor) {
        Vec3D vec3d = targetAnchor.a(targetEntity);
        super.a(anchorPoint, vec3d);
        this.b.a(new PacketPlayOutLookAt(anchorPoint, targetEntity, targetAnchor));
    }

    public void a(EntityPlayer oldPlayer, boolean alive) {
        this.cU = oldPlayer.cU;
        this.cS = oldPlayer.cS;
        this.cX = oldPlayer.cX;
        this.d.a(oldPlayer.d.b(), oldPlayer.d.c());
        this.w();
        if (alive) {
            this.fJ().a(oldPlayer.fJ());
            this.c(oldPlayer.eo());
            this.bQ = oldPlayer.bQ;
            this.cc = oldPlayer.cc;
            this.cd = oldPlayer.cd;
            this.ce = oldPlayer.ce;
            this.q(oldPlayer.fE());
            this.aw = oldPlayer.aw;
        } else if (this.H.W().b(GameRules.d) || oldPlayer.F_()) {
            this.fJ().a(oldPlayer.fJ());
            this.cc = oldPlayer.cc;
            this.cd = oldPlayer.cd;
            this.ce = oldPlayer.ce;
            this.q(oldPlayer.fE());
        }
        this.cf = oldPlayer.cf;
        this.bN = oldPlayer.bN;
        this.aj().b(EntityHuman.bJ, oldPlayer.aj().a(EntityHuman.bJ));
        this.cx = -1;
        this.cu = -1.0f;
        this.cv = -1;
        this.cE = oldPlayer.cE;
        this.cK = oldPlayer.cK;
        this.i(oldPlayer.ga());
        this.j(oldPlayer.gb());
        ((EntityHuman)this).a(oldPlayer.gi());
    }

    @Override
    protected void a(MobEffect effect, @Nullable net.minecraft.world.entity.Entity source) {
        super.a(effect, source);
        this.b.a(new PacketPlayOutEntityEffect(this.af(), effect));
        if (effect.c() == MobEffects.y) {
            this.cH = this.ag;
            this.cG = this.de();
        }
        CriterionTriggers.A.a(this, source);
    }

    @Override
    protected void a(MobEffect effect, boolean reapplyEffect, @Nullable net.minecraft.world.entity.Entity source) {
        super.a(effect, reapplyEffect, source);
        this.b.a(new PacketPlayOutEntityEffect(this.af(), effect));
        CriterionTriggers.A.a(this, source);
    }

    @Override
    protected void a(MobEffect effect) {
        super.a(effect);
        this.b.a(new PacketPlayOutRemoveEntityEffect(this.af(), effect.c()));
        if (effect.c() == MobEffects.y) {
            this.cG = null;
        }
        CriterionTriggers.A.a(this, (net.minecraft.world.entity.Entity)null);
    }

    @Override
    public void b(double destX, double destY, double destZ) {
        this.b.a(destX, destY, destZ, this.dw(), this.dy(), RelativeMovement.g);
    }

    @Override
    public void c(double offsetX, double offsetY, double offsetZ) {
        this.b.a(this.dl() + offsetX, this.dn() + offsetY, this.dr() + offsetZ, this.dw(), this.dy(), RelativeMovement.f);
    }

    @Override
    public boolean a(WorldServer world, double destX, double destY, double destZ, Set<RelativeMovement> flags, float yaw, float pitch) {
        return this.teleportTo(world, destX, destY, destZ, flags, yaw, pitch, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    @Override
    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(BlockPosition.a(d0, d1, d2));
        worldserver.k().a(TicketType.g, chunkcoordintpair, 1, this.af());
        this.bz();
        if (this.fu()) {
            this.a(true, true);
        }
        if (worldserver == this.H) {
            this.b.teleport(d0, d1, d2, f2, f1, set, cause);
        } else {
            this.teleportTo(worldserver, d0, d1, d2, f2, f1, cause);
        }
        this.r(f2);
        return true;
    }

    @Override
    public void d(double x2, double y2, double z2) {
        this.b(x2, y2, z2);
        this.b.d();
    }

    @Override
    public void a(net.minecraft.world.entity.Entity target) {
        this.x().k().a(this, new PacketPlayOutAnimation(target, 4));
    }

    @Override
    public void b(net.minecraft.world.entity.Entity target) {
        this.x().k().a(this, new PacketPlayOutAnimation(target, 5));
    }

    @Override
    public void w() {
        if (this.b != null) {
            this.b.a(new PacketPlayOutAbilities(this.fK()));
            this.F();
        }
    }

    public WorldServer x() {
        return (WorldServer)this.H;
    }

    public boolean a(EnumGamemode gameMode) {
        PlayerGameModeChangeEvent event = this.setGameMode(gameMode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event == null ? false : event.isCancelled();
    }

    public PlayerGameModeChangeEvent setGameMode(EnumGamemode gameMode, PlayerGameModeChangeEvent.Cause cause, Component message) {
        PlayerGameModeChangeEvent event = this.d.changeGameModeForPlayer(gameMode, cause, message);
        if (event == null || event.isCancelled()) {
            return null;
        }
        this.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.d, gameMode.a()));
        if (gameMode == EnumGamemode.d) {
            this.fX();
            this.bz();
        } else {
            this.c((net.minecraft.world.entity.Entity)this);
        }
        this.w();
        this.fc();
        return event;
    }

    @Override
    public boolean F_() {
        return this.d.b() == EnumGamemode.d;
    }

    @Override
    public boolean f() {
        return this.d.b() == EnumGamemode.b;
    }

    @Override
    public void a(IChatBaseComponent message) {
        this.b(message, false);
    }

    public void b(IChatBaseComponent message, boolean overlay) {
        if (this.v(overlay)) {
            this.b.a(new ClientboundSystemChatPacket(PaperAdventure.asAdventure(message), overlay), PacketSendListener.a(() -> {
                if (this.v(false)) {
                    boolean flag1 = true;
                    String s2 = message.a(256);
                    IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.b(s2).a(EnumChatFormat.o);
                    return new ClientboundSystemChatPacket(PaperAdventure.asAdventure(IChatBaseComponent.a("multiplayer.message_not_delivered", ichatmutablecomponent).a(EnumChatFormat.m)), false);
                }
                return null;
            }));
        }
    }

    public void a(OutgoingChatMessage message, boolean filterMaskEnabled, ChatMessageType.a params) {
        this.sendChatMessage(message, filterMaskEnabled, params, null);
    }

    public void sendChatMessage(OutgoingChatMessage message, boolean filterMaskEnabled, ChatMessageType.a params, @Nullable IChatBaseComponent unsigned) {
        if (this.gm()) {
            message.sendToPlayer(this, filterMaskEnabled, params, unsigned);
        }
    }

    public String y() {
        SocketAddress socketaddress = this.b.e();
        if (socketaddress instanceof InetSocketAddress) {
            InetSocketAddress inetsocketaddress = (InetSocketAddress)socketaddress;
            return InetAddresses.toAddrString((InetAddress)inetsocketaddress.getAddress());
        }
        return "<unknown>";
    }

    private Map<ClientOption<?>, ?> getClientOptionMap(String locale, int viewDistance, ClientOption.ChatVisibility chatVisibility, boolean chatColors, PaperSkinParts skinParts, MainHand mainHand, boolean allowsServerListing, boolean textFilteringEnabled) {
        HashMap<ClientOption, Object> map = new HashMap<ClientOption, Object>();
        map.put(ClientOption.LOCALE, locale);
        map.put(ClientOption.VIEW_DISTANCE, viewDistance);
        map.put(ClientOption.CHAT_VISIBILITY, chatVisibility);
        map.put(ClientOption.CHAT_COLORS_ENABLED, chatColors);
        map.put(ClientOption.SKIN_PARTS, skinParts);
        map.put(ClientOption.MAIN_HAND, mainHand);
        map.put(ClientOption.ALLOW_SERVER_LISTINGS, allowsServerListing);
        map.put(ClientOption.TEXT_FILTERING_ENABLED, textFilteringEnabled);
        return map;
    }

    public void a(PacketPlayInSettings packet) {
        PlayerChangedMainHandEvent event;
        new PlayerClientOptionsChangeEvent((Player)this.getBukkitEntity(), this.getClientOptionMap(packet.b, packet.c, ClientOption.ChatVisibility.valueOf((String)packet.d().name()), packet.e(), new PaperSkinParts(packet.f()), packet.g() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT, packet.i(), packet.h())).callEvent();
        if (this.fd() != packet.g()) {
            event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), this.fd() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            this.c.server.getPluginManager().callEvent((Event)event);
        }
        if (this.locale == null || !this.locale.equals(packet.b)) {
            event = new org.bukkit.event.player.PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), packet.b);
            this.c.server.getPluginManager().callEvent((Event)event);
            this.c.server.getPluginManager().callEvent((Event)new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), this.locale, packet.b));
        }
        this.locale = packet.b;
        this.adventure$locale = Translator.parseLocale((String)this.locale);
        this.b.h.m.attr(PaperAdventure.LOCALE_ATTRIBUTE).set((Object)this.adventure$locale);
        this.clientViewDistance = packet.c;
        this.cz = packet.d();
        this.cA = packet.e();
        this.cS = packet.h();
        this.cT = packet.i();
        this.aj().b(EntityHuman.bJ, (byte)packet.f());
        this.aj().b(EntityHuman.bK, (byte)(packet.g() != EnumMainHand.a ? 1 : 0));
    }

    public boolean z() {
        return this.cA;
    }

    public EnumChatVisibility A() {
        return this.cz;
    }

    private boolean v(boolean overlay) {
        return this.cz == EnumChatVisibility.c ? overlay : true;
    }

    private boolean gm() {
        return this.cz == EnumChatVisibility.a;
    }

    public void a(String url, String hash, boolean required, @Nullable IChatBaseComponent resourcePackPrompt) {
        this.b.a(new PacketPlayOutResourcePackSend(url, hash, required, resourcePackPrompt));
    }

    public void a(ServerPing metadata) {
        this.b.a(new ClientboundServerDataPacket(metadata.a(), metadata.d().map(ServerPing.a::a), metadata.e()));
    }

    @Override
    protected int B() {
        return this.c.c(this.fI());
    }

    public void C() {
        this.cB = SystemUtils.b();
    }

    public ServerStatisticManager D() {
        return this.cn;
    }

    public RecipeBookServer E() {
        return this.cF;
    }

    @Override
    protected void F() {
        if (this.F_()) {
            this.ej();
            this.j(true);
        } else {
            super.F();
        }
    }

    public net.minecraft.world.entity.Entity G() {
        return this.cC == null ? this : this.cC;
    }

    public void c(@Nullable net.minecraft.world.entity.Entity entity) {
        net.minecraft.world.entity.Entity entity1 = this.G();
        net.minecraft.world.entity.Entity entity2 = this.cC = entity == null ? this : entity;
        if (entity1 != this.cC) {
            PlayerStartSpectatingEntityEvent playerStartSpectatingEntityEvent;
            PlayerStopSpectatingEntityEvent playerStopSpectatingEntityEvent;
            if (this.cC == this ? !(playerStopSpectatingEntityEvent = new PlayerStopSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)entity1.getBukkitEntity())).callEvent() : !(playerStartSpectatingEntityEvent = new PlayerStartSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)entity1.getBukkitEntity(), (Entity)entity.getBukkitEntity())).callEvent()) {
                return;
            }
            net.minecraft.world.level.World world = this.cC.Y();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                this.teleportTo(worldserver, this.cC.dl(), this.cC.dn(), this.cC.dr(), Set.of(), this.dw(), this.dy(), PlayerTeleportEvent.TeleportCause.SPECTATE);
            }
            if (entity != null) {
                this.x().k().a(this);
            }
            this.b.a(new PacketPlayOutCamera(this.cC));
            this.b.d();
        }
    }

    @Override
    protected void H() {
        if (!this.cD) {
            super.H();
        }
    }

    @Override
    public void d(net.minecraft.world.entity.Entity target) {
        if (this.d.b() == EnumGamemode.d) {
            this.c(target);
        } else {
            super.d(target);
        }
    }

    public long I() {
        return this.cB;
    }

    @Nullable
    public IChatBaseComponent J() {
        return this.listName;
    }

    @Override
    public void a(EnumHand hand) {
        super.a(hand);
        this.gd();
    }

    public boolean K() {
        return this.cD;
    }

    public void L() {
        this.cD = false;
    }

    public AdvancementDataPlayer M() {
        return this.cm;
    }

    public void a(WorldServer targetWorld, double x2, double y2, double z2, float yaw, float pitch) {
        this.teleportTo(targetWorld, x2, y2, z2, yaw, pitch, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void teleportTo(WorldServer worldserver, double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.c((net.minecraft.world.entity.Entity)this);
        this.bz();
        this.getBukkitEntity().teleport(new Location((World)worldserver.getWorld(), d0, d1, d2, f2, f1), cause);
    }

    @Nullable
    public BlockPosition N() {
        return this.cO;
    }

    public float O() {
        return this.cQ;
    }

    public ResourceKey<net.minecraft.world.level.World> P() {
        return this.cN;
    }

    public boolean Q() {
        return this.cP;
    }

    @Deprecated
    public void a(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage) {
        this.setRespawnPosition(dimension, pos, angle, forced, sendMessage, PlayerSetSpawnEvent.Cause.UNKNOWN);
    }

    @Deprecated
    public boolean setRespawnPosition(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage, PlayerSpawnChangeEvent.Cause cause) {
        return this.setRespawnPosition(dimension, pos, angle, forced, sendMessage, cause == PlayerSpawnChangeEvent.Cause.RESET ? PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN : PlayerSetSpawnEvent.Cause.valueOf((String)cause.name()));
    }

    public boolean setRespawnPosition(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage, PlayerSetSpawnEvent.Cause cause) {
        Location spawnLoc = null;
        boolean willNotify = false;
        if (pos != null) {
            boolean flag2 = pos.equals(this.cO) && dimension.equals(this.cN);
            spawnLoc = MCUtil.toLocation(this.cH().a(dimension), pos);
            spawnLoc.setYaw(angle);
            willNotify = sendMessage && !flag2;
        }
        PlayerSpawnChangeEvent dumbEvent = new PlayerSpawnChangeEvent((Player)this.getBukkitEntity(), spawnLoc, forced, cause == PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN ? PlayerSpawnChangeEvent.Cause.RESET : PlayerSpawnChangeEvent.Cause.valueOf((String)cause.name()));
        dumbEvent.callEvent();
        PlayerSetSpawnEvent event = new PlayerSetSpawnEvent((Player)this.getBukkitEntity(), cause, dumbEvent.getNewSpawn(), dumbEvent.isForced(), willNotify, (Component)(willNotify ? Component.translatable((String)"block.minecraft.set_spawn") : null));
        event.setCancelled(dumbEvent.isCancelled());
        if (!event.callEvent()) {
            return false;
        }
        if (event.getLocation() != null) {
            dimension = event.getLocation().getWorld() != null ? ((CraftWorld)event.getLocation().getWorld()).getHandle().ab() : dimension;
            pos = MCUtil.toBlockPosition(event.getLocation());
            angle = event.getLocation().getYaw();
            forced = event.isForced();
            if (event.willNotifyPlayer() && event.getNotification() != null) {
                this.a(PaperAdventure.asVanilla(event.getNotification()));
            }
            this.cO = pos;
            this.cN = dimension;
            this.cQ = angle;
            this.cP = forced;
        } else {
            this.cO = null;
            this.cN = net.minecraft.world.level.World.h;
            this.cQ = 0.0f;
            this.cP = false;
        }
        return true;
    }

    public void a(ChunkCoordIntPair chunkPos, Packet<?> chunkDataPacket) {
        this.b.a(chunkDataPacket);
        if (PlayerChunkLoadEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new PlayerChunkLoadEvent(this.getBukkitEntity().getWorld().getChunkAt(chunkPos.longKey), (Player)this.getBukkitEntity()).callEvent();
        }
    }

    public void a(ChunkCoordIntPair chunkPos) {
        if (this.bq()) {
            this.b.a(new PacketPlayOutUnloadChunk(chunkPos.e, chunkPos.f));
            if (PlayerChunkUnloadEvent.getHandlerList().getRegisteredListeners().length > 0) {
                new PlayerChunkUnloadEvent(this.getBukkitEntity().getWorld().getChunkAt(chunkPos.longKey), (Player)this.getBukkitEntity()).callEvent();
            }
        }
    }

    public SectionPosition R() {
        return this.cM;
    }

    public void a(SectionPosition section) {
        this.cM = section;
    }

    @Override
    public void a(SoundEffect event, SoundCategory category, float volume, float pitch) {
        this.b.a(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.c.d(event), category, this.dl(), this.dn(), this.dr(), volume, pitch, this.af.g()));
    }

    @Override
    public Packet<PacketListenerPlayOut> S() {
        return new PacketPlayOutNamedEntitySpawn(this);
    }

    @Override
    public EntityItem a(ItemStack stack, boolean throwRandomly, boolean retainOwnership) {
        EntityItem entityitem = super.a(stack, throwRandomly, retainOwnership);
        if (entityitem == null) {
            return null;
        }
        this.H.b(entityitem);
        ItemStack itemstack1 = entityitem.i();
        if (retainOwnership) {
            if (!itemstack1.b()) {
                this.a(StatisticList.f.b(itemstack1.c()), itemstack1.K());
            }
            this.a(StatisticList.F);
        }
        return entityitem;
    }

    public ITextFilter T() {
        return this.cR;
    }

    public void c(WorldServer world) {
        this.H = world;
        this.d.a(world);
    }

    @Nullable
    private static EnumGamemode a(@Nullable NBTTagCompound nbt, String key) {
        return nbt != null && nbt.b(key, 99) ? EnumGamemode.a(nbt.h(key)) : null;
    }

    private EnumGamemode b(@Nullable EnumGamemode backupGameMode) {
        EnumGamemode enumgamemode1 = this.c.aZ();
        return enumgamemode1 != null ? enumgamemode1 : (backupGameMode != null ? backupGameMode : this.c.h_());
    }

    public void c(@Nullable NBTTagCompound nbt) {
        if (this.c.aZ() != null && this.c.aZ() != EntityPlayer.a(nbt, "playerGameType")) {
            if (new PlayerGameModeChangeEvent((Player)this.getBukkitEntity(), GameMode.getByValue((int)this.c.h_().a()), PlayerGameModeChangeEvent.Cause.DEFAULT_GAMEMODE, null).callEvent()) {
                this.d.a(this.c.aZ(), EnumGamemode.e);
            } else {
                this.d.a(EntityPlayer.a(nbt, "playerGameType"), EntityPlayer.a(nbt, "previousPlayerGameType"));
            }
            return;
        }
        this.d.a(this.b(EntityPlayer.a(nbt, "playerGameType")), EntityPlayer.a(nbt, "previousPlayerGameType"));
    }

    private void k(NBTTagCompound nbt) {
        nbt.a("playerGameType", this.d.b().a());
        EnumGamemode enumgamemode = this.d.c();
        if (enumgamemode != null) {
            nbt.a("previousPlayerGameType", enumgamemode.a());
        }
    }

    @Override
    public boolean U() {
        return this.cS;
    }

    public boolean b(EntityPlayer player) {
        return player == this ? false : this.cS || player.cS;
    }

    @Override
    public boolean a(net.minecraft.world.level.World world, BlockPosition pos) {
        return super.a(world, pos) && world.a(this, pos);
    }

    @Override
    protected void a(ItemStack stack) {
        CriterionTriggers.T.a(this, stack);
        super.a(stack);
    }

    public boolean a(boolean entireStack) {
        PlayerInventory playerinventory = this.fJ();
        ItemStack itemstack = playerinventory.a(entireStack);
        this.bP.b(playerinventory, playerinventory.l).ifPresent(i2 -> this.bP.a(i2, playerinventory.f()));
        return this.a(itemstack, false, true) != null;
    }

    public boolean V() {
        return this.cT;
    }

    @Override
    public Optional<WardenSpawnTracker> W() {
        return Optional.of(this.cU);
    }

    @Override
    public void a(EntityItem item) {
        super.a(item);
        net.minecraft.world.entity.Entity entity = item.v();
        if (entity != null) {
            CriterionTriggers.P.a(this, item.i(), entity);
        }
    }

    public void a(RemoteChatSession session) {
        this.cX = session;
    }

    @Nullable
    public RemoteChatSession X() {
        return this.cX;
    }

    @Override
    public void a(double deltaX, double deltaZ) {
        this.ci = (float)(MathHelper.d(deltaZ, deltaX) * 57.2957763671875 - (double)this.dw());
        this.b.a(new ClientboundHurtAnimationPacket(this));
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.H.V() + this.timeOffset;
        }
        return this.H.V() - this.H.V() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f));
        } else {
            this.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.h, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, newThunder));
            } else {
                this.b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (float)((double)this.pluginRainPosition + 0.01) : (float)((double)this.pluginRainPosition - 0.01);
        this.pluginRainPosition = MathHelper.a(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.H.n_().k() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.cu() + " at " + this.dl() + "," + this.dn() + "," + this.dr() + ")";
    }

    public void forceSetPositionRotation(double x2, double y2, double z2, float yaw, float pitch) {
        this.b(x2, y2, z2, yaw, pitch);
        this.b.d();
    }

    @Override
    public boolean eP() {
        return super.eP() || this.b != null && this.b.isDisconnected();
    }

    @Override
    public Scoreboard fY() {
        return this.getBukkitEntity().getScoreboard().getHandle();
    }

    public void reset() {
        float exp = 0.0f;
        boolean keepInventory = this.H.W().b(GameRules.d);
        if (this.keepLevel) {
            exp = this.ce;
            this.newTotalExp = this.cd;
            this.newLevel = this.cc;
        }
        this.c(this.eE());
        this.fk();
        this.i(this.cc());
        ((net.minecraft.world.entity.Entity)this).aK = 0;
        this.aa = 0.0f;
        this.bQ = new FoodMetaData(this);
        this.cc = this.newLevel;
        this.cd = this.newTotalExp;
        this.ce = 0.0f;
        this.aL = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        ((EntityLiving)this).bS = true;
        this.bP = this.bO;
        this.aX = null;
        ((EntityLiving)this).bT = null;
        ((EntityLiving)this).bN = new CombatTracker(this);
        this.cx = -1;
        if (this.keepLevel) {
            this.ce = exp;
        } else {
            this.d(this.newExp);
        }
        this.keepLevel = false;
        this.o(0.0, 0.0, 0.0);
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }

    private void resetOperationCountPerTick() {
        this.instaBreakCountPerTick = 0;
        this.placeBlockCountPerTick = 0;
    }

    public int getInstaBreakCountPerTick() {
        return this.instaBreakCountPerTick;
    }

    public int getPlaceBlockCountPerTick() {
        return this.placeBlockCountPerTick;
    }

    public void addInstaBreakCountPerTick() {
        ++this.instaBreakCountPerTick;
    }

    public void addPlaceBlockCountPerTick() {
        ++this.placeBlockCountPerTick;
    }

    public boolean allowOperation() {
        return (this.instaBreakCountPerTick == 0 || this.placeBlockCountPerTick == 0) && this.instaBreakCountPerTick <= 1 && this.placeBlockCountPerTick <= 2;
    }
}

