/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.starlight.common.light.StarLightEngine;
import ca.spottedleaf.starlight.common.light.StarLightInterface;
import com.mojang.logging.LogUtils;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.server.level.ChunkTaskQueueSorter;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.LightEngineLayerEventListener;
import org.bukkit.Bukkit;
import org.slf4j.Logger;

public class LightEngineThreaded
extends LightEngine
implements AutoCloseable {
    private static final Logger d = LogUtils.getLogger();
    private final PlayerChunkMap g;
    private volatile int i = 5;
    public final StarLightInterface theLightEngine;
    public final boolean hasBlockLight;
    public final boolean hasSkyLight;
    protected long relightCounter;
    private final Long2IntOpenHashMap chunksBeingWorkedOn = new Long2IntOpenHashMap();

    public LightEngineThreaded(ILightAccess chunkProvider, PlayerChunkMap chunkStorage, boolean hasBlockLight, ThreadedMailbox<Runnable> processor, Mailbox<ChunkTaskQueueSorter.a<Runnable>> executor) {
        super(chunkProvider, false, false);
        this.g = chunkStorage;
        this.hasBlockLight = true;
        this.hasSkyLight = hasBlockLight;
        this.theLightEngine = new StarLightInterface(chunkProvider, this.hasSkyLight, this.hasBlockLight, this);
    }

    protected final IChunkAccess getChunk(int chunkX, int chunkZ) {
        return ((WorldServer)this.theLightEngine.getWorld()).k().getChunkAtImmediately(chunkX, chunkZ);
    }

    public int relight(Set<ChunkCoordIntPair> chunks_param, Consumer<ChunkCoordIntPair> chunkLightCallback, IntConsumer onComplete) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Must only be called on the main thread");
        }
        LinkedHashSet<ChunkCoordIntPair> chunks = new LinkedHashSet<ChunkCoordIntPair>(chunks_param);
        HashMap<ChunkCoordIntPair, Long> ticketIds = new HashMap<ChunkCoordIntPair, Long>();
        int totalChunks = 0;
        Iterator iterator = chunks.iterator();
        while (iterator.hasNext()) {
            ChunkCoordIntPair chunkPos = (ChunkCoordIntPair)iterator.next();
            IChunkAccess chunk = (IChunkAccess)((WorldServer)this.theLightEngine.getWorld()).k().c(chunkPos.e, chunkPos.f);
            if (chunk == null || !chunk.v() || !chunk.j().b(ChunkStatus.l)) {
                iterator.remove();
                continue;
            }
            Long id = this.relightCounter++;
            ((WorldServer)this.theLightEngine.getWorld()).k().addTicketAtLevel(TicketType.CHUNK_RELIGHT, chunkPos, MCUtil.getTicketLevelFor(ChunkStatus.l), id);
            ticketIds.put(chunkPos, id);
            ++totalChunks;
        }
        this.g.r.chunkTaskScheduler.lightExecutor.queueRunnable(() -> this.theLightEngine.relightChunks(chunks, chunkPos -> {
            chunkLightCallback.accept((ChunkCoordIntPair)chunkPos);
            ((WorldServer)this.theLightEngine.getWorld()).k().g.execute(() -> {
                ((WorldServer)this.theLightEngine.getWorld()).k().a.a(chunkPos.a()).a(new PacketPlayOutLightUpdate((ChunkCoordIntPair)chunkPos, this, null, null, true), false);
                ((WorldServer)this.theLightEngine.getWorld()).k().removeTicketAtLevel(TicketType.CHUNK_RELIGHT, (ChunkCoordIntPair)chunkPos, MCUtil.getTicketLevelFor(ChunkStatus.l), (Long)ticketIds.get(chunkPos));
            });
        }, onComplete));
        this.a();
        return totalChunks;
    }

    private void queueTaskForSection(int chunkX, int chunkY, int chunkZ, Supplier<CompletableFuture<Void>> runnable) {
        WorldServer world = (WorldServer)this.theLightEngine.getWorld();
        IChunkAccess center = this.theLightEngine.getAnyChunkNow(chunkX, chunkZ);
        if (center == null || !center.j().b(ChunkStatus.l)) {
            return;
        }
        if (center.j() != ChunkStatus.o) {
            runnable.get();
            return;
        }
        if (!world.k().a.t.bn()) {
            world.k().a.t.execute(() -> this.queueTaskForSection(chunkX, chunkY, chunkZ, runnable));
            return;
        }
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        CompletableFuture<Void> updateFuture = runnable.get();
        if (updateFuture == null) {
            return;
        }
        int references = this.chunksBeingWorkedOn.addTo(key, 1);
        if (references == 0) {
            ChunkCoordIntPair pos = new ChunkCoordIntPair(chunkX, chunkZ);
            world.k().a(StarLightInterface.CHUNK_WORK_TICKET, pos, 0, pos);
        }
        ((CompletableFuture)updateFuture.thenAcceptAsync(ignore -> {
            int newReferences = this.chunksBeingWorkedOn.get(key);
            if (newReferences == 1) {
                this.chunksBeingWorkedOn.remove(key);
                ChunkCoordIntPair pos = new ChunkCoordIntPair(chunkX, chunkZ);
                world.k().b(StarLightInterface.CHUNK_WORK_TICKET, pos, 0, pos);
            } else {
                this.chunksBeingWorkedOn.put(key, newReferences - 1);
            }
        }, (Executor)world.k().a.t)).whenComplete((ignore, thr) -> {
            if (thr != null) {
                d.error("Failed to remove ticket level for post chunk task " + new ChunkCoordIntPair(chunkX, chunkZ), thr);
            }
        });
    }

    @Override
    public boolean D_() {
        return this.theLightEngine.hasUpdates();
    }

    @Override
    public LightEngineLayerEventListener a(EnumSkyBlock lightType) {
        return lightType == EnumSkyBlock.b ? this.theLightEngine.getBlockReader() : this.theLightEngine.getSkyReader();
    }

    @Override
    public int b(BlockPosition pos, int ambientDarkness) {
        int sky = this.theLightEngine.getSkyReader().b(pos) - ambientDarkness;
        if (sky == 15) {
            return 15;
        }
        int block = this.theLightEngine.getBlockReader().b(pos);
        return Math.max(sky, block);
    }

    @Override
    public void close() {
    }

    @Override
    public int a(int i2, boolean doSkylight, boolean skipEdgeLightPropagation) {
        throw SystemUtils.b(new UnsupportedOperationException("Ran automatically on a different thread!"));
    }

    @Override
    public void a(BlockPosition pos, int level) {
        throw SystemUtils.b(new UnsupportedOperationException("Ran automatically on a different thread!"));
    }

    @Override
    public void a(BlockPosition pos) {
        BlockPosition posCopy = pos.i();
        this.queueTaskForSection(posCopy.u() >> 4, posCopy.v() >> 4, posCopy.w() >> 4, () -> this.theLightEngine.blockChange(posCopy));
    }

    protected void a(ChunkCoordIntPair pos) {
    }

    @Override
    public void a(SectionPosition pos, boolean notReady) {
        this.queueTaskForSection(pos.u(), pos.v(), pos.w(), () -> this.theLightEngine.sectionChange(pos, notReady));
    }

    @Override
    public void a(ChunkCoordIntPair pos, boolean retainData) {
    }

    @Override
    public void a(EnumSkyBlock lightType, SectionPosition pos, @Nullable NibbleArray nibbles, boolean nonEdge) {
    }

    private void a(int x2, int z2, Update stage, Runnable task) {
        throw new UnsupportedOperationException();
    }

    private void a(int x2, int z2, IntSupplier completedLevelSupplier, Update stage, Runnable task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void b(ChunkCoordIntPair pos, boolean retainData) {
    }

    public CompletableFuture<IChunkAccess> a(IChunkAccess chunk) {
        ChunkCoordIntPair chunkPos = chunk.f();
        return CompletableFuture.supplyAsync(SystemUtils.a(() -> {
            super.b(chunkPos, true);
            return chunk;
        }, () -> "retainData: " + chunkPos), task -> this.a(chunkPos.e, chunkPos.f, Update.a, task));
    }

    public CompletableFuture<IChunkAccess> a(IChunkAccess chunk, boolean excludeBlocks) {
        boolean lit = excludeBlocks;
        ChunkCoordIntPair chunkPos = chunk.f();
        return CompletableFuture.supplyAsync(() -> {
            Boolean[] emptySections = StarLightEngine.getEmptySectionsForChunk(chunk);
            if (!lit) {
                chunk.b(false);
                this.theLightEngine.lightChunk(chunk, emptySections);
                chunk.b(true);
            } else {
                this.theLightEngine.forceLoadInChunk(chunk, emptySections);
                this.theLightEngine.checkChunkEdges(chunkPos.e, chunkPos.f);
            }
            this.g.c(chunkPos);
            return chunk;
        }, runnable -> {
            this.theLightEngine.scheduleChunkLight(chunkPos, runnable);
            this.a();
        }).whenComplete((c2, throwable) -> {
            if (throwable != null) {
                d.error("Failed to light chunk " + chunkPos, throwable);
            }
        });
    }

    public void a() {
    }

    private void e() {
        throw new UnsupportedOperationException();
    }

    public void a(int taskBatchSize) {
        this.i = taskBatchSize;
    }

    private static /* synthetic */ String b(ChunkCoordIntPair pos) {
        return "retainData " + pos;
    }

    private /* synthetic */ void lambda$retainData$17(ChunkCoordIntPair pos, boolean retainData) {
        super.b(pos, retainData);
    }

    private static /* synthetic */ int lambda$retainData$16() {
        return 0;
    }

    private static /* synthetic */ String lambda$queueSectionData$15(SectionPosition pos) {
        return "queueData " + pos;
    }

    private /* synthetic */ void lambda$queueSectionData$14(EnumSkyBlock lightType, SectionPosition pos, NibbleArray nibbles, boolean nonEdge) {
        super.a(lightType, pos, nibbles, nonEdge);
    }

    private static /* synthetic */ int lambda$queueSectionData$13() {
        return 0;
    }

    private static /* synthetic */ String lambda$enableLightSources$12(ChunkCoordIntPair pos, boolean retainData) {
        return "enableLight " + pos + " " + retainData;
    }

    private /* synthetic */ void lambda$enableLightSources$11(ChunkCoordIntPair pos, boolean retainData) {
        super.a(pos, retainData);
    }

    private static /* synthetic */ String lambda$updateChunkStatus$9(ChunkCoordIntPair pos) {
        return "updateChunkStatus " + pos + " true";
    }

    private /* synthetic */ void lambda$updateChunkStatus$8(ChunkCoordIntPair pos) {
        super.b(pos, false);
        super.a(pos, false);
        for (int i2 = this.c(); i2 < this.d(); ++i2) {
            super.a(EnumSkyBlock.b, SectionPosition.a(pos, i2), null, true);
            super.a(EnumSkyBlock.a, SectionPosition.a(pos, i2), null, true);
        }
        for (int j2 = this.c.ak(); j2 < this.c.al(); ++j2) {
            super.a(SectionPosition.a(pos, j2), true);
        }
    }

    private static /* synthetic */ int lambda$updateChunkStatus$7() {
        return 0;
    }

    static final class Update
    extends Enum<Update> {
        public static final /* enum */ Update a = new Update();
        public static final /* enum */ Update b = new Update();
        private static final /* synthetic */ Update[] c;

        public static Update[] values() {
            return (Update[])c.clone();
        }

        public static Update valueOf(String name) {
            return Enum.valueOf(Update.class, name);
        }

        private static /* synthetic */ Update[] a() {
            return new Update[]{a, b};
        }

        static {
            c = Update.a();
        }
    }
}

