/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.destroystokyo.paper.util.misc.PlayerAreaMap;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.chunk.system.scheduling.NewChunkHolder;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.util.DebugBuffer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.lighting.LightEngine;
import org.spigotmc.AsyncCatcher;

public class PlayerChunk {
    public static final Either<IChunkAccess, Failure> a = Either.right(Failure.b);
    public static final CompletableFuture<Either<IChunkAccess, Failure>> b = CompletableFuture.completedFuture(a);
    public static final Either<Chunk, Failure> c = Either.right(Failure.b);
    private static final Either<IChunkAccess, Failure> d = Either.right(Failure.b);
    private static final CompletableFuture<Either<Chunk, Failure>> e = CompletableFuture.completedFuture(c);
    private static final List<ChunkStatus> f = ChunkStatus.a();
    private static final State[] g = State.values();
    private static final int h = 64;
    private final LevelHeightAccessor j;
    @Nullable
    private final DebugBuffer<b> o;
    public final ChunkCoordIntPair s;
    private boolean t;
    private final ShortSet[] u;
    private final BitSet v;
    private final BitSet w;
    private final LightEngine x;
    private final d y;
    public final e z;
    private boolean B;
    private final PlayerChunkMap chunkMap;
    public final NewChunkHolder newChunkHolder;
    PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> playersInMobSpawnRange;
    PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> playersInChunkTickRange;

    public final Chunk getSendingChunk() {
        Chunk ret = this.chunkMap.r.k().getChunkAtIfLoadedImmediately(this.s.e, this.s.f);
        if (ret != null && ret.areNeighboursLoaded(1)) {
            return ret;
        }
        return null;
    }

    public void onChunkAdd() {
        Chunk chunk;
        long key = MCUtil.getCoordinateKey(this.s);
        this.playersInMobSpawnRange = this.chunkMap.playerMobSpawnMap.getObjectsInRange(key);
        this.playersInChunkTickRange = this.chunkMap.playerChunkTickRangeMap.getObjectsInRange(key);
        if (this.needsBroadcastChanges()) {
            this.chunkMap.needsChangeBroadcasting.add((Object)this);
        }
        if ((chunk = this.getFullChunkNowUnchecked()) != null) {
            chunk.updateGeneralAreaCache();
        }
    }

    public void onChunkRemove() {
        Chunk chunk;
        this.playersInMobSpawnRange = null;
        this.playersInChunkTickRange = null;
        if (this.needsBroadcastChanges()) {
            this.chunkMap.needsChangeBroadcasting.remove((Object)this);
        }
        if ((chunk = this.getFullChunkNowUnchecked()) != null) {
            chunk.removeGeneralAreaCache();
        }
    }

    public PlayerChunk(ChunkCoordIntPair pos, LevelHeightAccessor world, LightEngine lightingProvider, e playersWatchingChunkProvider, NewChunkHolder newChunkHolder) {
        this.newChunkHolder = newChunkHolder;
        this.o = null;
        this.v = new BitSet();
        this.w = new BitSet();
        this.s = pos;
        this.j = world;
        this.x = lightingProvider;
        this.y = null;
        this.z = playersWatchingChunkProvider;
        this.u = new ShortSet[world.aj()];
        this.chunkMap = (PlayerChunkMap)playersWatchingChunkProvider;
    }

    @Nullable
    public IChunkAccess getAvailableChunkNow() {
        return this.newChunkHolder.getCurrentChunk();
    }

    public Chunk getFullChunkNow() {
        IChunkAccess chunk = this.getAvailableChunkNow();
        if (!this.isFullChunkReady() || !(chunk instanceof Chunk)) {
            return null;
        }
        return (Chunk)chunk;
    }

    public Chunk getFullChunkNowUnchecked() {
        IChunkAccess chunk = this.getAvailableChunkNow();
        return chunk instanceof Chunk ? (Chunk)chunk : null;
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> a(ChunkStatus leastStatus) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Either<IChunkAccess, Failure>> b(ChunkStatus leastStatus) {
        throw new UnsupportedOperationException();
    }

    public final CompletableFuture<Either<Chunk, Failure>> a() {
        throw new UnsupportedOperationException();
    }

    public final CompletableFuture<Either<Chunk, Failure>> b() {
        throw new UnsupportedOperationException();
    }

    public final CompletableFuture<Either<Chunk, Failure>> c() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public final Chunk d() {
        if (!this.isTickingReady()) {
            return null;
        }
        return (Chunk)this.getAvailableChunkNow();
    }

    @Nullable
    public final Chunk e() {
        if (!this.isFullChunkReady()) {
            return null;
        }
        return (Chunk)this.getAvailableChunkNow();
    }

    @Nullable
    public ChunkStatus f() {
        return this.newChunkHolder.getCurrentGenStatus();
    }

    public ChunkStatus getChunkHolderStatus() {
        return this.newChunkHolder.getCurrentGenStatus();
    }

    @Nullable
    public IChunkAccess g() {
        return this.newChunkHolder.getCurrentChunk();
    }

    public void a(BlockPosition pos) {
        Chunk chunk = this.getSendingChunk();
        if (chunk != null) {
            int i2 = this.j.e(pos.v());
            if (i2 < 0 || i2 >= this.u.length) {
                return;
            }
            if (this.u[i2] == null) {
                this.t = true;
                this.addToBroadcastMap();
                this.u[i2] = new ShortOpenHashSet();
            }
            this.u[i2].add(SectionPosition.b(pos));
        }
    }

    public void a(EnumSkyBlock lightType, int y2) {
        IChunkAccess ichunkaccess = this.getAvailableChunkNow();
        if (ichunkaccess != null) {
            ichunkaccess.a(true);
            Chunk chunk = this.getSendingChunk();
            if (chunk != null) {
                int j2 = this.x.c();
                int k2 = this.x.d();
                if (y2 >= j2 && y2 <= k2) {
                    this.addToBroadcastMap();
                    int l2 = y2 - j2;
                    if (lightType == EnumSkyBlock.a) {
                        this.w.set(l2);
                    } else {
                        this.v.set(l2);
                    }
                }
            }
        }
    }

    public final boolean needsBroadcastChanges() {
        return this.t || !this.w.isEmpty() || !this.v.isEmpty();
    }

    private void addToBroadcastMap() {
        AsyncCatcher.catchOp("ChunkHolder update");
        this.chunkMap.needsChangeBroadcasting.add((Object)this);
    }

    public void a(Chunk chunk) {
        if (this.needsBroadcastChanges()) {
            int j2;
            World world = chunk.D();
            int i2 = 0;
            for (j2 = 0; j2 < this.u.length; ++j2) {
                i2 += this.u[j2] != null ? this.u[j2].size() : 0;
            }
            this.B |= i2 >= 64;
            if (!this.w.isEmpty() || !this.v.isEmpty()) {
                this.a(new PacketPlayOutLightUpdate(chunk.f(), this.x, this.w, this.v, true), !this.B);
                this.w.clear();
                this.v.clear();
            }
            for (j2 = 0; j2 < this.u.length; ++j2) {
                ShortSet shortset = this.u[j2];
                if (shortset == null) continue;
                int k2 = this.j.g(j2);
                SectionPosition sectionposition = SectionPosition.a(chunk.f(), k2);
                if (shortset.size() == 1) {
                    BlockPosition blockposition = sectionposition.g(shortset.iterator().nextShort());
                    IBlockData iblockdata = world.a_(blockposition);
                    this.a(new PacketPlayOutBlockChange(blockposition, iblockdata), false);
                    this.a(world, blockposition, iblockdata);
                } else {
                    ChunkSection chunksection = chunk.b(j2);
                    PacketPlayOutMultiBlockChange packetplayoutmultiblockchange = new PacketPlayOutMultiBlockChange(sectionposition, shortset, chunksection, this.B);
                    this.a(packetplayoutmultiblockchange, false);
                    packetplayoutmultiblockchange.a((BlockPosition blockposition1, IBlockData iblockdata1) -> this.a(world, (BlockPosition)blockposition1, (IBlockData)iblockdata1));
                }
                this.u[j2] = null;
            }
            this.t = false;
        }
    }

    private void a(World world, BlockPosition pos, IBlockData state) {
        if (state.q()) {
            this.a(world, pos);
        }
    }

    private void a(World world, BlockPosition pos) {
        Packet<PacketListenerPlayOut> packet;
        TileEntity tileentity = world.c_(pos);
        if (tileentity != null && (packet = tileentity.h()) != null) {
            this.a(packet, false);
        }
    }

    public void a(Packet<?> packet, boolean onlyOnWatchDistanceEdge) {
        PlayerAreaMap viewDistanceMap = this.chunkMap.playerChunkManager.broadcastMap;
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet players = viewDistanceMap.getObjectsInRange(this.s);
        if (players == null) {
            return;
        }
        for (Object e2 : players.getBackingSet()) {
            EntityPlayer player;
            if (!(e2 instanceof EntityPlayer) || !this.chunkMap.playerChunkManager.isChunkSent(player = (EntityPlayer)e2, this.s.e, this.s.f, onlyOnWatchDistanceEdge)) continue;
            player.b.a(packet);
        }
    }

    public State i() {
        return this.newChunkHolder.getChunkStatus();
    }

    public final ChunkCoordIntPair j() {
        return this.s;
    }

    public final int k() {
        return this.newChunkHolder.getTicketLevel();
    }

    public static ChunkStatus b(int level) {
        return level < 33 ? ChunkStatus.o : ChunkStatus.a(level - 33);
    }

    public static State c(int distance) {
        return g[MathHelper.a(33 - distance + 1, 0, g.length - 1)];
    }

    public void a(ProtoChunkExtension chunk) {
        throw new UnsupportedOperationException();
    }

    public List<Pair<ChunkStatus, CompletableFuture<Either<IChunkAccess, Failure>>>> o() {
        throw new UnsupportedOperationException();
    }

    public final boolean isEntityTickingReady() {
        return this.newChunkHolder.isEntityTickingReady();
    }

    public final boolean isTickingReady() {
        return this.newChunkHolder.isTickingReady();
    }

    public final boolean isFullChunkReady() {
        return this.newChunkHolder.isFullChunkReady();
    }

    @FunctionalInterface
    public static interface d {
        public void onLevelChange(ChunkCoordIntPair var1, IntSupplier var2, int var3, IntConsumer var4);
    }

    public static interface e {
        public List<EntityPlayer> a(ChunkCoordIntPair var1, boolean var2);
    }

    public static enum State {
        a,
        b,
        c,
        d;


        public boolean a(State levelType) {
            return this.ordinal() >= levelType.ordinal();
        }
    }

    public static interface Failure {
        public static final Failure b = new Failure(){

            public String toString() {
                return "UNLOADED";
            }
        };
    }

    private static final class b {
        private final Thread a;
        private final CompletableFuture<?> b;
        private final String c;

        b(Thread thread, CompletableFuture<?> action, String actionDesc) {
            this.a = thread;
            this.b = action;
            this.c = actionDesc;
        }
    }
}

