/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import com.destroystokyo.paper.network.PaperLegacyStatusClient;
import com.destroystokyo.paper.network.PaperNetworkClient;
import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerConnection;
import org.slf4j.Logger;

public class LegacyPingHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger b = LogUtils.getLogger();
    public static final int a = 127;
    private final ServerConnection c;
    private ByteBuf buf;

    public LegacyPingHandler(ServerConnection networkIo) {
        this.c = networkIo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext channelhandlercontext, Object object) {
        ByteBuf bytebuf = (ByteBuf)object;
        if (this.buf != null) {
            try {
                this.readLegacy1_6(channelhandlercontext, bytebuf);
            }
            finally {
                bytebuf.release();
            }
            return;
        }
        bytebuf.markReaderIndex();
        boolean flag = true;
        try {
            if (bytebuf.readUnsignedByte() != 254) {
                return;
            }
            InetSocketAddress inetsocketaddress = (InetSocketAddress)channelhandlercontext.channel().remoteAddress();
            MinecraftServer minecraftserver = this.c.d();
            int i2 = bytebuf.readableBytes();
            switch (i2) {
                case 0: {
                    b.debug("Ping: (<1.3.x) from {}:{}", (Object)inetsocketaddress.getAddress(), (Object)inetsocketaddress.getPort());
                    PaperServerListPingEvent event = PaperLegacyStatusClient.processRequest(minecraftserver, inetsocketaddress, 39, null);
                    if (event == null) {
                        channelhandlercontext.close();
                        break;
                    }
                    String s2 = String.format(Locale.ROOT, "%s\u00a7%d\u00a7%d", PaperLegacyStatusClient.getUnformattedMotd(event), event.getNumPlayers(), event.getMaxPlayers());
                    this.a(channelhandlercontext, this.a(s2));
                    break;
                }
                case 1: {
                    if (bytebuf.readUnsignedByte() != 1) {
                        return;
                    }
                    b.debug("Ping: (1.4-1.5.x) from {}:{}", (Object)inetsocketaddress.getAddress(), (Object)inetsocketaddress.getPort());
                    PaperServerListPingEvent event = PaperLegacyStatusClient.processRequest(minecraftserver, inetsocketaddress, 127, null);
                    if (event == null) {
                        channelhandlercontext.close();
                        break;
                    }
                    String s3 = String.format(Locale.ROOT, "\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", event.getProtocolVersion(), minecraftserver.G(), event.getMotd(), event.getNumPlayers(), event.getMaxPlayers());
                    this.a(channelhandlercontext, this.a(s3));
                    break;
                }
                default: {
                    if (bytebuf.readUnsignedByte() != 1 || bytebuf.readUnsignedByte() != 250) {
                        return;
                    }
                    this.readLegacy1_6(channelhandlercontext, bytebuf);
                }
            }
            bytebuf.release();
            flag = false;
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            if (flag) {
                bytebuf.resetReaderIndex();
                channelhandlercontext.channel().pipeline().remove("legacy_query");
                channelhandlercontext.fireChannelRead(object);
            }
        }
    }

    private static String readLegacyString(ByteBuf buf) {
        int size = buf.readShort() * 2;
        if (!buf.isReadable(size)) {
            return null;
        }
        String result = buf.toString(buf.readerIndex(), size, StandardCharsets.UTF_16BE);
        buf.skipBytes(size);
        return result;
    }

    private void readLegacy1_6(ChannelHandlerContext ctx, ByteBuf part) {
        ByteBuf buf = this.buf;
        if (buf == null) {
            this.buf = buf = ctx.alloc().buffer();
            buf.markReaderIndex();
        } else {
            buf.resetReaderIndex();
        }
        buf.writeBytes(part);
        if (!buf.isReadable(11)) {
            return;
        }
        String s2 = LegacyPingHandler.readLegacyString(buf);
        if (s2 == null) {
            return;
        }
        if (!s2.equals("MC|PingHost")) {
            this.removeHandler(ctx);
            return;
        }
        if (!buf.isReadable(2) || !buf.isReadable((int)buf.readShort())) {
            return;
        }
        MinecraftServer server = this.c.d();
        byte protocolVersion = buf.readByte();
        String host = LegacyPingHandler.readLegacyString(buf);
        if (host == null) {
            this.removeHandler(ctx);
            return;
        }
        int port = buf.readInt();
        if (buf.isReadable()) {
            this.removeHandler(ctx);
            return;
        }
        buf.release();
        this.buf = null;
        b.debug("Ping: (1.6) from {}", GlobalConfiguration.get().logging.logPlayerIpAddresses ? ctx.channel().remoteAddress() : "<ip address withheld>");
        InetSocketAddress virtualHost = PaperNetworkClient.prepareVirtualHost(host, port);
        PaperServerListPingEvent event = PaperLegacyStatusClient.processRequest(server, (InetSocketAddress)ctx.channel().remoteAddress(), protocolVersion, virtualHost);
        if (event == null) {
            ctx.close();
            return;
        }
        String response = String.format("\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", event.getProtocolVersion(), event.getVersion(), PaperLegacyStatusClient.getMotd(event), event.getNumPlayers(), event.getMaxPlayers());
        this.a(ctx, this.a(response));
    }

    private void removeHandler(ChannelHandlerContext ctx) {
        ByteBuf buf = this.buf;
        this.buf = null;
        buf.resetReaderIndex();
        ctx.pipeline().remove((ChannelHandler)this);
        ctx.fireChannelRead((Object)buf);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.buf != null) {
            this.buf.release();
            this.buf = null;
        }
    }

    private void a(ChannelHandlerContext ctx, ByteBuf buf) {
        ctx.pipeline().firstContext().writeAndFlush((Object)buf).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private ByteBuf a(String s2) {
        ByteBuf bytebuf = Unpooled.buffer();
        bytebuf.writeByte(255);
        char[] achar = s2.toCharArray();
        bytebuf.writeShort(achar.length);
        char[] achar1 = achar;
        int i2 = achar.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            char c0 = achar1[j2];
            bytebuf.writeChar((int)c0);
        }
        return bytebuf;
    }
}

