/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.proxy.VelocityProxy;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.properties.Property;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.TraceUtil;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.network.protocol.login.PacketLoginInCustomPayload;
import net.minecraft.network.protocol.login.PacketLoginInEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginInListener;
import net.minecraft.network.protocol.login.PacketLoginInStart;
import net.minecraft.network.protocol.login.PacketLoginOutCustomPayload;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginOutSetCompression;
import net.minecraft.network.protocol.login.PacketLoginOutSuccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.HandshakeListener;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.RandomSource;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_19_R3.util.RandomSourceWrapper;
import org.bukkit.craftbukkit.v1_19_R3.util.Waitable;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class LoginListener
implements PacketLoginInListener,
TickablePacketListener {
    private static final AtomicInteger a = new AtomicInteger(0);
    static final Logger b = LogUtils.getLogger();
    private static final int c = 600;
    private static final RandomSource d = new RandomSourceWrapper(new Random());
    private final byte[] e;
    final MinecraftServer f;
    public final NetworkManager g;
    public EnumProtocolState h = EnumProtocolState.a;
    private int i;
    @Nullable
    public GameProfile j;
    private final String k;
    @Nullable
    private EntityPlayer l;
    public boolean iKnowThisMayNotBeTheBestIdeaButPleaseDisableUsernameValidation = false;
    private int velocityLoginMessageId = -1;
    private static final ExecutorService authenticatorPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("User Authenticator #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(b)).build());

    public LoginListener(MinecraftServer server, NetworkManager connection) {
        this.k = "";
        this.f = server;
        this.g = connection;
        this.e = Ints.toByteArray((int)d.f());
    }

    @Override
    public void c() {
        EntityPlayer entityplayer;
        if (!MinecraftServer.getServer().v()) {
            this.b(CraftChatMessage.fromString(SpigotConfig.restartMessage)[0]);
            return;
        }
        if (this.h == EnumProtocolState.e) {
            if (this.g.h()) {
                this.d();
            }
        } else if (this.h == EnumProtocolState.f && (entityplayer = this.f.ac().a(this.j.getId())) == null) {
            this.h = EnumProtocolState.e;
            this.a(this.l);
            this.l = null;
        }
        if (this.i++ == 600) {
            this.b(IChatBaseComponent.c("multiplayer.disconnect.slow_login"));
        }
    }

    @Deprecated
    public void disconnect(String s2) {
        this.b(CraftChatMessage.fromString(s2, true)[0]);
    }

    @Override
    public boolean a() {
        return this.g.h();
    }

    public void b(IChatBaseComponent reason) {
        try {
            b.info("Disconnecting {}: {}", (Object)this.e(), (Object)reason.getString());
            this.g.a(new PacketLoginOutDisconnect(reason));
            this.g.a(reason);
        }
        catch (Exception exception) {
            b.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    public void initUUID() {
        UUID uuid = this.g.spoofedUUID != null ? this.g.spoofedUUID : UUIDUtil.a(this.j.getName());
        this.j = new GameProfile(uuid, this.j.getName());
        if (this.g.spoofedProfile != null) {
            for (Property property : this.g.spoofedProfile) {
                if (!HandshakeListener.PROP_PATTERN.matcher(property.getName()).matches()) continue;
                this.j.getProperties().put((Object)property.getName(), (Object)property);
            }
        }
    }

    public void d() {
        EntityPlayer s2;
        if (!this.f.U()) {
            // empty if block
        }
        if ((s2 = this.f.ac().canPlayerLogin(this, this.j)) != null) {
            this.h = EnumProtocolState.g;
            if (this.f.av() >= 0 && !this.g.d()) {
                this.g.a(new PacketLoginOutSetCompression(this.f.av()), PacketSendListener.a(() -> this.g.a(this.f.av(), true)));
            }
            this.g.a(new PacketLoginOutSuccess(this.j));
            EntityPlayer entityplayer = this.f.ac().a(this.j.getId());
            try {
                EntityPlayer entityplayer1 = this.f.ac().getPlayerForLogin(this.j, s2);
                if (entityplayer != null) {
                    this.h = EnumProtocolState.f;
                    this.l = entityplayer1;
                } else {
                    this.a(entityplayer1);
                }
            }
            catch (Exception exception) {
                b.error("Couldn't place player in world", (Throwable)exception);
                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.c("multiplayer.disconnect.invalid_player_data");
                if (MinecraftServer.getServer().isDebugging()) {
                    TraceUtil.printStackTrace(exception);
                }
                this.g.a(new PacketPlayOutKickDisconnect(ichatmutablecomponent));
                this.g.a(ichatmutablecomponent);
            }
        }
    }

    private void a(EntityPlayer player) {
        this.f.ac().a(this.g, player);
    }

    @Override
    public void a(IChatBaseComponent reason) {
        b.info("{} lost connection: {}", (Object)this.e(), (Object)reason.getString());
    }

    public String e() {
        String ip = GlobalConfiguration.get().logging.logPlayerIpAddresses ? String.valueOf(this.g.c()) : "<ip address withheld>";
        return this.j != null ? this.j + " (" + ip + ")" : String.valueOf(ip);
    }

    public static boolean validateUsername(String in) {
        if (in == null || in.isEmpty() || in.length() > 16) {
            return false;
        }
        int len = in.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = in.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '_' || c2 == '.') continue;
            return false;
        }
        return true;
    }

    @Override
    public void a(PacketLoginInStart packet) {
        Validate.validState((this.h == EnumProtocolState.a ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        Validate.validState((boolean)LoginListener.a(packet.a()), (String)"Invalid characters in username", (Object[])new Object[0]);
        if (GlobalConfiguration.get().proxies.isProxyOnlineMode() && GlobalConfiguration.get().unsupportedSettings.performUsernameValidation && !this.iKnowThisMayNotBeTheBestIdeaButPleaseDisableUsernameValidation && !LoginListener.validateUsername(packet.a())) {
            this.disconnect("Failed to verify username!");
            return;
        }
        GameProfile gameprofile = this.f.N();
        if (gameprofile != null && packet.a().equalsIgnoreCase(gameprofile.getName())) {
            this.j = gameprofile;
            this.h = EnumProtocolState.e;
        } else {
            this.j = new GameProfile((UUID)null, packet.a());
            if (this.f.U() && !this.g.d()) {
                this.h = EnumProtocolState.b;
                this.g.a(new PacketLoginOutEncryptionBegin("", this.f.L().getPublic().getEncoded(), this.e));
            } else {
                if (GlobalConfiguration.get().proxies.velocity.enabled) {
                    this.velocityLoginMessageId = ThreadLocalRandom.current().nextInt();
                    PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
                    buf.writeByte(4);
                    PacketLoginOutCustomPayload packet1 = new PacketLoginOutCustomPayload(this.velocityLoginMessageId, VelocityProxy.PLAYER_INFO_CHANNEL, buf);
                    this.g.a(packet1);
                    return;
                }
                authenticatorPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LoginListener.this.initUUID();
                            new LoginHandler().fireEvents();
                        }
                        catch (Exception ex) {
                            LoginListener.this.disconnect("Failed to verify username!");
                            LoginListener.this.f.server.getLogger().log(Level.WARNING, "Exception verifying " + LoginListener.this.j.getName(), ex);
                        }
                    }
                });
            }
        }
    }

    public static boolean a(String name) {
        return name.chars().filter(i2 -> i2 <= 32 || i2 >= 127).findAny().isEmpty();
    }

    @Override
    public void a(PacketLoginInEncryptionBegin packet) {
        String s2;
        Validate.validState((this.h == EnumProtocolState.b ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey privatekey = this.f.L().getPrivate();
            if (!packet.a(this.e, privatekey)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey secretkey = packet.a(privatekey);
            s2 = new BigInteger(MinecraftEncryption.a("", this.f.L().getPublic(), secretkey)).toString(16);
            this.h = EnumProtocolState.c;
            this.g.setupEncryption(secretkey);
        }
        catch (CryptographyException cryptographyexception) {
            throw new IllegalStateException("Protocol error", cryptographyexception);
        }
        authenticatorPool.execute(new Runnable(){

            @Override
            public void run() {
                GameProfile gameprofile = LoginListener.this.j;
                try {
                    LoginListener.this.j = LoginListener.this.f.am().hasJoinedServer(new GameProfile((UUID)null, gameprofile.getName()), s2, this.getAddress());
                    if (LoginListener.this.j != null) {
                        if (!LoginListener.this.g.h()) {
                            return;
                        }
                        new LoginHandler().fireEvents();
                    } else if (LoginListener.this.f.O()) {
                        b.warn("Failed to verify username but will let them in anyway!");
                        LoginListener.this.j = gameprofile;
                        LoginListener.this.h = EnumProtocolState.e;
                    } else {
                        LoginListener.this.b(IChatBaseComponent.c("multiplayer.disconnect.unverified_username"));
                        b.error("Username '{}' tried to join with an invalid session", (Object)gameprofile.getName());
                    }
                }
                catch (AuthenticationUnavailableException authenticationunavailableexception) {
                    if (LoginListener.this.f.O()) {
                        b.warn("Authentication servers are down but will let them in anyway!");
                        LoginListener.this.j = gameprofile;
                        LoginListener.this.h = EnumProtocolState.e;
                    } else {
                        LoginListener.this.b(PaperAdventure.asVanilla(GlobalConfiguration.get().messages.kick.authenticationServersDown));
                        b.error("Couldn't verify username because servers are unavailable");
                    }
                }
                catch (Exception exception) {
                    LoginListener.this.disconnect("Failed to verify username!");
                    LoginListener.this.f.server.getLogger().log(Level.WARNING, "Exception verifying " + gameprofile.getName(), exception);
                }
            }

            @Nullable
            private InetAddress getAddress() {
                SocketAddress socketaddress = LoginListener.this.g.c();
                return LoginListener.this.f.V() && socketaddress instanceof InetSocketAddress ? ((InetSocketAddress)socketaddress).getAddress() : null;
            }
        });
    }

    @Override
    public void a(PacketLoginInCustomPayload packet) {
        if (GlobalConfiguration.get().proxies.velocity.enabled && packet.a() == this.velocityLoginMessageId) {
            PacketDataSerializer buf = packet.c();
            if (buf == null) {
                this.disconnect("This server requires you to connect with Velocity.");
                return;
            }
            if (!VelocityProxy.checkIntegrity(buf)) {
                this.disconnect("Unable to verify player details");
                return;
            }
            int version = buf.m();
            if (version > 4) {
                throw new IllegalStateException("Unsupported forwarding version " + version + ", wanted upto 4");
            }
            SocketAddress listening = this.g.c();
            int port = 0;
            if (listening instanceof InetSocketAddress) {
                port = ((InetSocketAddress)listening).getPort();
            }
            this.g.n = new InetSocketAddress(VelocityProxy.readAddress(buf), port);
            this.j = VelocityProxy.createProfile(buf);
            authenticatorPool.execute(() -> {
                try {
                    new LoginHandler().fireEvents();
                }
                catch (Exception ex) {
                    this.disconnect("Failed to verify username!");
                    this.f.server.getLogger().log(Level.WARNING, "Exception verifying " + this.j.getName(), ex);
                }
            });
            return;
        }
        this.b(IChatBaseComponent.c("multiplayer.disconnect.unexpected_query_response"));
    }

    protected GameProfile a(GameProfile profile) {
        UUID uuid = UUIDUtil.a(profile.getName());
        return new GameProfile(uuid, profile.getName());
    }

    public static enum EnumProtocolState {
        a,
        b,
        c,
        d,
        e,
        f,
        g;

    }

    public class LoginHandler {
        public void fireEvents() throws Exception {
            if (LoginListener.this.velocityLoginMessageId == -1 && GlobalConfiguration.get().proxies.velocity.enabled) {
                LoginListener.this.disconnect("This server requires you to connect with Velocity.");
                return;
            }
            String playerName = LoginListener.this.j.getName();
            InetAddress address = ((InetSocketAddress)LoginListener.this.g.c()).getAddress();
            InetAddress rawAddress = ((InetSocketAddress)LoginListener.this.g.m.remoteAddress()).getAddress();
            UUID uniqueId = LoginListener.this.j.getId();
            CraftServer server = LoginListener.this.f.server;
            PlayerProfile profile = CraftPlayerProfile.asBukkitMirror(LoginListener.this.j);
            AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, rawAddress, uniqueId, profile, LoginListener.this.g.hostname);
            server.getPluginManager().callEvent((Event)asyncEvent);
            profile = asyncEvent.getPlayerProfile();
            profile.complete(true);
            LoginListener.this.j = CraftPlayerProfile.asAuthlibCopy(profile);
            playerName = LoginListener.this.j.getName();
            uniqueId = LoginListener.this.j.getId();
            if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
                PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address, uniqueId);
                if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                    event.disallow(asyncEvent.getResult(), asyncEvent.kickMessage());
                }
                Waitable<PlayerPreLoginEvent.Result> waitable = new Waitable<PlayerPreLoginEvent.Result>(this, server, event){
                    final /* synthetic */ CraftServer val$server;
                    final /* synthetic */ PlayerPreLoginEvent val$event;
                    final /* synthetic */ LoginHandler this$1;
                    {
                        this.this$1 = this$1;
                        this.val$server = craftServer;
                        this.val$event = playerPreLoginEvent;
                    }

                    protected PlayerPreLoginEvent.Result evaluate() {
                        this.val$server.getPluginManager().callEvent((Event)this.val$event);
                        return this.val$event.getResult();
                    }
                };
                LoginListener.this.f.processQueue.add(waitable);
                if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                    LoginListener.this.b(PaperAdventure.asVanilla(event.kickMessage()));
                    return;
                }
            } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
                LoginListener.this.b(PaperAdventure.asVanilla(asyncEvent.kickMessage()));
                return;
            }
            b.info("UUID of player {} is {}", (Object)LoginListener.this.j.getName(), (Object)LoginListener.this.j.getId());
            LoginListener.this.h = EnumProtocolState.e;
        }
    }
}

