/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.SystemUtils;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.ResourcePackVanilla;
import org.slf4j.Logger;

public class VanillaPackResourcesBuilder {
    private static final Logger b = LogUtils.getLogger();
    public static Consumer<VanillaPackResourcesBuilder> a = builder -> {};
    private static final Map<EnumResourcePackType, Path> c = (Map)SystemUtils.a(() -> {
        Class<ResourcePackVanilla> clazz = ResourcePackVanilla.class;
        synchronized (ResourcePackVanilla.class) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (EnumResourcePackType packType : EnumResourcePackType.values()) {
                String string = "/" + packType.a() + "/.mcassetsroot";
                URL uRL = ResourcePackVanilla.class.getResource(string);
                if (uRL == null) {
                    b.error("File {} does not exist in classpath", (Object)string);
                    continue;
                }
                try {
                    URI uRI = uRL.toURI();
                    String string2 = uRI.getScheme();
                    if (!"jar".equals(string2) && !"file".equals(string2)) {
                        b.warn("Assets URL '{}' uses unexpected schema", (Object)uRI);
                    }
                    Path path = VanillaPackResourcesBuilder.a(uRI);
                    builder.put((Object)packType, (Object)path.getParent());
                }
                catch (Exception exception) {
                    b.error("Couldn't resolve path to vanilla assets", (Throwable)exception);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return builder.build();
        }
    });
    private final Set<Path> d = new LinkedHashSet<Path>();
    private final Map<EnumResourcePackType, Set<Path>> e = new EnumMap<EnumResourcePackType, Set<Path>>(EnumResourcePackType.class);
    private BuiltInMetadata f = BuiltInMetadata.a();
    private final Set<String> g = new HashSet<String>();

    private static Path a(URI uri) throws IOException {
        try {
            return Paths.get(uri);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
        }
        catch (Throwable throwable) {
            b.warn("Unable to get path for: {}", (Object)uri, (Object)throwable);
        }
        try {
            FileSystems.newFileSystem(uri, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        return Paths.get(uri);
    }

    private boolean b(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Path " + path.toAbsolutePath() + " is not directory");
        }
        return true;
    }

    private void c(Path path) {
        if (this.b(path)) {
            this.d.add(path);
        }
    }

    private void b(EnumResourcePackType type, Path path) {
        if (this.b(path)) {
            this.e.computeIfAbsent(type, type2 -> new LinkedHashSet()).add(path);
        }
    }

    public VanillaPackResourcesBuilder a() {
        c.forEach((type, path) -> {
            this.c(path.getParent());
            this.b((EnumResourcePackType)((Object)type), (Path)path);
        });
        return this;
    }

    public VanillaPackResourcesBuilder a(EnumResourcePackType type, Class<?> clazz) {
        Enumeration<URL> enumeration = null;
        try {
            enumeration = clazz.getClassLoader().getResources(type.a() + "/");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (enumeration != null && enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            try {
                URI uRI = uRL.toURI();
                if (!"file".equals(uRI.getScheme())) continue;
                Path path = Paths.get(uRI);
                this.c(path.getParent());
                this.b(type, path);
            }
            catch (Exception exception) {
                b.error("Failed to extract path from {}", (Object)uRL, (Object)exception);
            }
        }
        return this;
    }

    public VanillaPackResourcesBuilder b() {
        a.accept(this);
        return this;
    }

    public VanillaPackResourcesBuilder a(Path root) {
        this.c(root);
        for (EnumResourcePackType packType : EnumResourcePackType.values()) {
            this.b(packType, root.resolve(packType.a()));
        }
        return this;
    }

    public VanillaPackResourcesBuilder a(EnumResourcePackType type, Path path) {
        this.c(path);
        this.b(type, path);
        return this;
    }

    public VanillaPackResourcesBuilder a(BuiltInMetadata metadataMap) {
        this.f = metadataMap;
        return this;
    }

    public VanillaPackResourcesBuilder a(String ... namespaces) {
        this.g.addAll(Arrays.asList(namespaces));
        return this;
    }

    public ResourcePackVanilla c() {
        EnumMap<EnumResourcePackType, List<Path>> map = new EnumMap<EnumResourcePackType, List<Path>>(EnumResourcePackType.class);
        for (EnumResourcePackType packType : EnumResourcePackType.values()) {
            List<Path> list = VanillaPackResourcesBuilder.a(this.e.getOrDefault((Object)packType, Set.of()));
            map.put(packType, list);
        }
        return new ResourcePackVanilla(this.f, Set.copyOf(this.g), VanillaPackResourcesBuilder.a(this.d), map);
    }

    private static List<Path> a(Collection<Path> paths) {
        ArrayList<Path> list = new ArrayList<Path>(paths);
        Collections.reverse(list);
        return List.copyOf(list);
    }
}

