/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.sounds;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;

public class SoundEffect {
    public static final Codec<SoundEffect> a = RecordCodecBuilder.create(instance -> instance.group((App)MinecraftKey.a.fieldOf("sound_id").forGetter(SoundEffect::a), (App)Codec.FLOAT.optionalFieldOf("range").forGetter(SoundEffect::b)).apply((Applicative)instance, SoundEffect::a));
    public static final Codec<Holder<SoundEffect>> b = RegistryFileCodec.a(Registries.ab, a);
    private static final float c = 16.0f;
    private final MinecraftKey d;
    private final float e;
    private final boolean f;

    private static SoundEffect a(MinecraftKey id, Optional<Float> distanceToTravel) {
        return distanceToTravel.map(float_ -> SoundEffect.a(id, float_.floatValue())).orElseGet(() -> SoundEffect.a(id));
    }

    public static SoundEffect a(MinecraftKey id) {
        return new SoundEffect(id, 16.0f, false);
    }

    public static SoundEffect a(MinecraftKey id, float distanceToTravel) {
        return new SoundEffect(id, distanceToTravel, true);
    }

    private SoundEffect(MinecraftKey id, float distanceToTravel, boolean useStaticDistance) {
        this.d = id;
        this.e = distanceToTravel;
        this.f = useStaticDistance;
    }

    public MinecraftKey a() {
        return this.d;
    }

    public float a(float volume) {
        if (this.f) {
            return this.e;
        }
        return volume > 1.0f ? 16.0f * volume : 16.0f;
    }

    private Optional<Float> b() {
        return this.f ? Optional.of(Float.valueOf(this.e)) : Optional.empty();
    }

    public void a(PacketDataSerializer buf) {
        buf.a(this.d);
        buf.a(this.b(), PacketDataSerializer::writeFloat);
    }

    public static SoundEffect b(PacketDataSerializer buf) {
        MinecraftKey resourceLocation = buf.t();
        Optional<Float> optional = buf.b(PacketDataSerializer::readFloat);
        return SoundEffect.a(resourceLocation, optional);
    }
}

